#define FALSE 0
#define TRUE 1


#define UINT8 unsigned char
#define UINT16 unsigned short
#define UINT32 unsigned long


#define LOADONLY 0
#define LOADANDEXECUTE 1

#define MOTORSTOP 0
#define MOTORON 1

#define CMTREADMODE 0
#define CMTWRITEMODE 1

#define MZT 0
#define MZF 1


#define COLDSTART 0
#define WARMSTART 1


/*
 *   PIO8255
 */

 #define KEYPA 0xE000
 #define KEYPB 0xE001
 #define KEYPC 0xE002
 #define KEYPF 0xE003

 #define CSTR 0xE002
 #define CSTPT 0xE003


/*
 *   8253
 */

 #define CONT0 0xE004
 #define CONT1 0xE005
 #define CONT2 0xE006
 #define CONTF 0xE007


/*
 *   Misc
 */

 #define SUNDG 0xE008
 #define TEMP 0xE008



/*
 *   Z80PIO
 */

 #define PORTACTRL 0xFC
 #define PORTBCTRL 0xFD
 #define PORTADATA 0xFE
 #define PORTBDATA 0xFF


/*
 *   MemoryStates
 */

 #define RAM 0
 #define VRAM 1
 #define CGRAM 2
 #define ROM 3
 #define CGROM 4
 #define PROTECTED 5
 #define PROHIBITED 5
 #define FREE 6



 struct CMTHeader
 {
  unsigned char Attribute;
  char Name[17];
  unsigned short Size;
  unsigned short LoadAddress;
  unsigned short ExecAddress;
  char Comment[104];
 };


/*
 *  Memory Read/Write
 */

UINT8 MZRAM01Read(UINT32);
UINT8 MZRAM12Read(UINT32);
UINT8 MZRAMCDRead(UINT32);
UINT8 MZRAMDFRead(UINT32);

void MZRAMWrite01(UINT32, UINT8);
void MZRAMWrite12(UINT32, UINT8);
void MZRAMWriteCD(UINT32, UINT8);
void MZRAMWriteDE(UINT32, UINT8);
void MZRAMWriteEF(UINT32, UINT8);


/*
 *  Device I/O
 */

UINT16 MZMemoryBank_Read(UINT16);
void MZMemoryBank_Write(UINT16, UINT8);

UINT16 MZPIO_Read(UINT16);
void MZPIO_Write(UINT16, UINT8);



unsigned char OpenCMTReadFile(unsigned char);
void OpenCMTWriteFile(void);

void UpdateIni(char *);
