#include <stdio.h>
#include <stdlib.h>
#include <dpmi.h>
#include <go32.h>
#include <sys/movedata.h>

#include "MZ-1E05.h"




unsigned char MZ1E05 = FALSE;
unsigned char MZ1E05Command;
unsigned char MZ1E05Cylinder;
unsigned char MZ1E05Sector;
unsigned char MZ1E05Data;
unsigned char MZ1E05Motor;
unsigned char MZ1E05Status;
unsigned char MZ1E05Head = 1;
unsigned char MZ1E05Drive = 0;
//unsigned char MZ1E05SectorBuffer[256];
unsigned char MZ1E05SectorBuffer[4096];
unsigned short MZ1E05Ptr;
unsigned char MZ1E05StepDirection = FD_STEPIN;
unsigned char MZ1E05BusyCounter;
unsigned char MZ1E05MultipleSectorFlag = FALSE;
unsigned char MZ1E05FD[4] = {0, 0, 0, 0};
unsigned char MZ1E05DataRegister;


extern unsigned char MZExtROM[0x10000 - 0xE000];

extern void ReInitVGA(void);



UINT16 MZ1E05_Read(UINT16 Address)
{
 UINT16 Result;
// int Counter;
// int Help;
// __dpmi_regs Register;



 Result = 0xFF;

 switch(Address)
 {
  case STR:                         // status
        if(MZ1E05BusyCounter != 0)
        {
         MZ1E05BusyCounter--;
         Result = FD_BUSY;
        }
        else
        {
         Result = MZ1E05Status;
//         MZ1E05Status = 0;
        }
        break;
  case TR:                          // track
        Result = MZ1E05Cylinder;
        break;
  case SR:
        Result = MZ1E05Sector;
        break;
  case DR:
        if(MZ1E05Sector > 16) MZ1E05Status = FD_RNF;
        else
        {  
         Result = MZ1E05SectorBuffer[MZ1E05Ptr++];

         if(MZ1E05MultipleSectorFlag)
         {
          if(MZ1E05Ptr % 256 == 0) MZ1E05Sector++;
          if(MZ1E05Sector < 17) MZ1E05Status = FD_DRQ | FD_BUSY;
         }
         else
         {
          if(MZ1E05Ptr < 256) MZ1E05Status = FD_DRQ | FD_BUSY;
         }
        }
        break;
 }

 Result = ~Result;

 return(Result);
}




void MZ1E05_Write(UINT16 Address, UINT8 Data)
{
 __dpmi_regs Register;
int Counter, Help;


 Data = ~Data;
 switch(Address)
 {
  case CR:
        MZ1E05BusyCounter = 1;
        MZ1E05Status = 0;
        if((Data & 0xF0) == 0x00)   // Restore (seek track 0)
        {
         MZ1E05Cylinder = 0;
         MZ1E05Status = FD_TRACK0;
        }
        if((Data & 0xF0) == 0x10)   // Seek
        {
         MZ1E05Cylinder = MZ1E05DataRegister;
        }
        if((Data & 0xE0) == 0x20)   // Step
        {
         if(Data & FD_U_FLAG)
         {
          if(MZ1E05StepDirection == FD_STEPIN) MZ1E05Cylinder++;
          else MZ1E05Cylinder--;
         }
         if(MZ1E05Cylinder == 0) MZ1E05Status = FD_TRACK0;
        }
        if((Data & 0xE0) == 0x40)   // Step In
        {
         if(Data & 0x10) MZ1E05Cylinder++;
         MZ1E05StepDirection = FD_STEPIN;
        }
        if((Data & 0xE0) == 0x60)   // Step Out
        {
         if(Data & FD_U_FLAG) MZ1E05Cylinder--;
         if(MZ1E05Cylinder == 0) MZ1E05Status = FD_TRACK0;
         MZ1E05StepDirection = FD_STEPOUT;
        }
        if((Data & 0xE1) == 0x80)   // Read Sector
        {




         Register.h.ah = 2;
         Counter = 3;
         while((Register.h.ah != 0) && (Counter != 0))
         {
          if(Data & 0x10)
          {
           MZ1E05MultipleSectorFlag = TRUE;
           Register.h.al = 17 - MZ1E05Sector;
          }
          else
          {
           MZ1E05MultipleSectorFlag = FALSE;
           Register.h.al = 1;
          }
          Register.h.ah = 2;
          Register.h.ch = MZ1E05Cylinder;
          Register.h.cl = MZ1E05Sector;
          if(MZ1E05Head == 0) Register.h.dh = 1;
          else Register.h.dh = 0;
          Register.h.dl = MZ1E05FD[MZ1E05Drive];
          Register.x.es = __tb >> 4;
          Register.x.bx = __tb & 0x0F;
          Help = __dpmi_int(0x13, &Register);
          if(Help == -1) Register.h.ah = 1;
          Counter--;
         }

        if(MZ1E05MultipleSectorFlag) dosmemget(__tb, 256 * (17 - MZ1E05Sector), &MZ1E05SectorBuffer[0]);
        else dosmemget(__tb, 256, &MZ1E05SectorBuffer[0]);


         MZ1E05Ptr = 0;
         MZ1E05Status = FD_DRQ | FD_BUSY;
        }
        if((Data & 0xE0) == 0xA0)   // Write Sector
        {
         if(Data & 0x10) MZ1E05MultipleSectorFlag = 2;
         else MZ1E05MultipleSectorFlag = 1;

         dosmemput(&MZ1E05SectorBuffer[0], 256, __tb);

         Register.h.ah = 3;
         Register.h.al = 1;
         Register.h.ch = MZ1E05Cylinder;
         Register.h.cl = MZ1E05Sector;
         if(MZ1E05Head == 0) Register.h.dh = 1;
         else Register.h.dh = 0;
         Register.h.dl = MZ1E05FD[MZ1E05Drive];
         Register.x.es = __tb >> 4;
         Register.x.bx = __tb & 0x0F;
//         __dpmi_int(0x13, &Register);

         MZ1E05Ptr = 0;
         MZ1E05Status = FD_DRQ | FD_BUSY;
        }
        if((Data & 0xFB) == 0xC0)   // Read Address
        {
        }
        if((Data & 0xFB) == 0xE0)   // Read Track
        {
        }
        if((Data & 0xFB) == 0xF0)   // Write Track
        {
        }
        if((Data & 0xF0) == 0xD0)   // Force Interrupt
        {
         MZ1E05MultipleSectorFlag = FALSE;
        }
        break;
  case TR:                          // track register
        MZ1E05Cylinder = Data;
        break;
  case SR:                          // sector register
        MZ1E05Sector = Data;
        break;
  case DR:                          // data register
        MZ1E05DataRegister = Data;
        MZ1E05SectorBuffer[MZ1E05Ptr++] = Data;
        if(MZ1E05Ptr != 0) MZ1E05Status = FD_DRQ | FD_BUSY;
        break;
  case DM:                          // disk motor
        MZ1E05Drive = ~Data & 0x03;
        if((~Data & 0x80) == 0x80)  // Motor on
        {
/*
         Register.h.ah = 0;            // Reset
         Register.h.dl = MZ1E05FD[MZ1E05Drive];
         __dpmi_int(0x13, &Register);
*/
        }
        else // Motor off
        {
        }
        break;
  case HS:                          // head select
        MZ1E05Head = Data & 0x01;
        break;
  case DE:                          // density ???
        if((Data & 0x01) == 0);
        else;
        break;
 }
}




void LoadMZ1E05ROM(void)
{
 FILE *pROM;

 
 if((pROM = fopen("MZ-1E05.ROM", "rb")) != NULL)
 {
  fread(MZExtROM + 0x1000, sizeof(char), 0x10000 - 0xF000, pROM);
  fclose(pROM);
 }
 else
 {
  ReInitVGA();
  printf("Can not open MZ-1E05.ROM !\n");
  exit(1);
 }
}
