#include <stdio.h>
#include <string.h>

#define VERSION "2.0"

#define CHECKSUMM 0
#define DATA 1


FILE *MZF;
FILE *MZT;

unsigned char MZTBitMask = 0x80;
unsigned char MZTByte = 0;
unsigned int CheckSumm;



void Short(void)
{
 MZTByte = MZTByte & ~MZTBitMask;
 MZTBitMask = MZTBitMask >> 1;
 if(MZTBitMask == 0)
 {
  MZTBitMask = 0x80;
  fputc(MZTByte, MZT);
 }
}



void Long(void)
{
 MZTByte = MZTByte | MZTBitMask;
 MZTBitMask = MZTBitMask >> 1;
 if(MZTBitMask == 0)
 {
  MZTBitMask = 0x80;
  fputc(MZTByte, MZT);
 }
}


void WriteByte(unsigned char Data, unsigned char Flag)
{
 unsigned char BitMask;


 Long();
 BitMask = 0x80;
 while(BitMask)
 {
  if(Data & BitMask)
  {
   Long();
   if(Flag == DATA) CheckSumm++;
  }
  else Short();
  BitMask = BitMask >> 1;
 }
}


int main(int argc, char *argv[])
{
 char MZFFileName[80] = "";
 char MZTFileName[80] = "";
 unsigned char Data;
 unsigned int ProgSize;
 unsigned int Counter;
 unsigned int FileCounter;
 unsigned char InformationBlock[128];
 unsigned short InformationBlockChecksumm;
 unsigned char DataBlock[0x10000];
 unsigned short DataBlockChecksumm;


 printf("\nMZFToMZT V %s    (c) 2002 by BKK\n\n", VERSION);

 if(argc == 1)
 {
  puts("usage: mzftomzt filename");
  puts("");
  puts("example: mzftomzt test.mzf");
  puts("         mzftomzt a*.mzf");
  puts("         mzftomzt *.mzf");
  puts("");
  exit(1);
 }

 for(FileCounter = 1; FileCounter < argc; FileCounter++)
 {
  strcpy(MZFFileName, argv[FileCounter]);

  printf("convert %s ", MZFFileName);

  if((MZF = fopen(MZFFileName, "rb")) == NULL)
  {
   printf("File %s open error!\n", MZFFileName);
   exit(1);
  }

  strcpy(MZTFileName, MZFFileName);
  MZTFileName[strrchr(MZFFileName, '.') - MZFFileName] = '\0';
  strcat(MZTFileName, ".MZT");

  if((MZT = fopen(MZTFileName, "wb")) == NULL)
  {
   printf("File %s open error!\n", MZTFileName);
   fclose(MZF);
   exit(1);
  }

  for(Counter = 0; Counter < 22000; Counter++) Short();
  for(Counter = 0; Counter < 40; Counter++) Long();
  for(Counter = 0; Counter < 40; Counter++) Short();

  Long();

  CheckSumm = 0;

  for(Counter = 0; Counter < 128; Counter++)
  {
   InformationBlock[Counter] = fgetc(MZF);
   Data = InformationBlock[Counter];
   if(Counter == 18) ProgSize = Data;
   if(Counter == 19) ProgSize = ProgSize | (Data << 8);
   WriteByte(Data, DATA);
  }

  printf("size: %u\n", ProgSize);

  InformationBlockChecksumm = CheckSumm;

  WriteByte((unsigned char) (InformationBlockChecksumm >> 8), CHECKSUMM);
  WriteByte((unsigned char) InformationBlockChecksumm, CHECKSUMM);

  Long();

  for(Counter = 0; Counter < 256; Counter++)
   Short();

  for(Counter = 0; Counter < 128; Counter++)
  {
   Data = InformationBlock[Counter];
   if(Counter == 18) ProgSize = Data;
   if(Counter == 19) ProgSize = ProgSize | (Data << 8);
   WriteByte(Data, DATA);
  }
  
  WriteByte((unsigned char) (InformationBlockChecksumm >> 8), CHECKSUMM);
  WriteByte((unsigned char) InformationBlockChecksumm, CHECKSUMM);

  Long();

  for(Counter = 0; Counter < 11000; Counter++) Short();
  for(Counter = 0; Counter < 20; Counter++) Long();
  for(Counter = 0; Counter < 20; Counter++) Short();
  Long();

  CheckSumm = 0;

  for(Counter = 0; Counter < ProgSize; Counter++)
  {
   DataBlock[Counter] = fgetc(MZF);
   WriteByte(DataBlock[Counter], DATA);
  }

  DataBlockChecksumm = CheckSumm;

  WriteByte((unsigned char) (DataBlockChecksumm >> 8), CHECKSUMM);
  WriteByte((unsigned char) DataBlockChecksumm, CHECKSUMM);

  Long();

  for(Counter = 0; Counter < 256; Counter++)
   Short();  

  for(Counter = 0; Counter < ProgSize; Counter++)
  {
   WriteByte(DataBlock[Counter], DATA);
  }

  WriteByte((unsigned char) (DataBlockChecksumm >> 8), CHECKSUMM);
  WriteByte((unsigned char) DataBlockChecksumm, CHECKSUMM);

  Long();

  fputc(MZTByte, MZT);

  fclose(MZT);
  fclose(MZF);
 }

 return(0);
}
