@echo off
echo.
echo fbForthBinPack (by Lee Stewart, 13APR2016 & 22FEB2021)...
echo.
if "%2" == "" goto help
if "%1" == "" goto help
if "%2" == "32" goto type
if "%2" == "64" goto type
if "%2" == "128" goto type
if "%2" == "256" goto type
if "%2" NEQ "512" goto help
:type
if /i "%1" == "N" goto normal
if /i "%1" NEQ "I" goto help
:inverted
copy /Y /B fbForth200_b0.bin /B + fbForth200_b1.bin /B + fbForth200_b2.bin /B + fbForth200_b3.bin /B fbForthDST.tmp /B
goto size%2
:normal
copy /Y /B fbForth200_b3.bin /B + fbForth200_b2.bin /B + fbForth200_b1.bin /B + fbForth200_b0.bin /B fbForthDST.tmp /B
goto size%2
:size512
ren fbForthDST.tmp fbForthSRC.tmp
copy /Y /B fbForthSRC.tmp /B + fbForthSRC.tmp /B fbForthDST.tmp /B
del fbForthSRC.tmp
:size256
ren fbForthDST.tmp fbForthSRC.tmp
copy /Y /B fbForthSRC.tmp /B + fbForthSRC.tmp /B fbForthDST.tmp /B
del fbForthSRC.tmp
:size128
ren fbForthDST.tmp fbForthSRC.tmp
copy /Y /B fbForthSRC.tmp /B + fbForthSRC.tmp /B fbForthDST.tmp /B
del fbForthSRC.tmp
:size64
ren fbForthDST.tmp fbForthSRC.tmp
copy /Y /B fbForthSRC.tmp /B + fbForthSRC.tmp /B fbForthDST.tmp /B
del fbForthSRC.tmp
:size32
ren fbForthDST.tmp fbForth200_%2%1.bin
echo.
echo ...DONE
goto end
:help
echo.
echo This batch script packs the 4 8KiB fbForth 2.0 ROM binaries into inverted
echo or normal (non-inverted) banks in a single 32KiB binary file that is then
echo replicated as needed to fill any desired larger-sized binary.
echo.
echo     Usage:  fbForthBinPack  I^|N  32^|64^|128^|256^|512
echo.
echo I = Inverted bank selection for 74LS379 Guidry/BLACK(Fetzner) boards.
echo N = Normal bank selection for 74LS377/378 BLUE/RED(Fetzner) boards.
echo Numeric parameter = Finished size of image file in KiB.
echo.
echo     Example:  fbForthBinPack N 512
echo.
echo The above will produce a 512KiB ROM image file for a BLUE/RED(Fetzner) board
echo with normal bank selection.  The file will be named fbForth200_512N.bin.
echo.
:end
