/*
 * Decompiled with CFR 0.152.
 */
package sorcererII;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.AbstractBorder;

class ColorBorder
extends AbstractBorder {
    private static final long serialVersionUID = 1045129269595712805L;
    protected int _thickness;
    protected Color _lineColor;

    public ColorBorder(Color color) {
        this(color, 1);
    }

    public ColorBorder(int thickness) {
        this(null, thickness);
    }

    public ColorBorder(Color color, int thickness) {
        this._lineColor = color;
        this._thickness = thickness;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        if (this._lineColor != null) {
            Color oldColor = g.getColor();
            g.setColor(this._lineColor);
            int i = 0;
            while (i < this._thickness) {
                g.drawRect(x + i, y + i, width - i - i - 1, height - i - i - 1);
                ++i;
            }
            g.setColor(oldColor);
        }
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return new Insets(this._thickness, this._thickness, this._thickness, this._thickness);
    }

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        insets.right = insets.bottom = this._thickness;
        insets.top = insets.bottom;
        insets.left = insets.bottom;
        return insets;
    }

    public void setColor(Color color) {
        this._lineColor = color;
    }

    public Color getLineColor() {
        return this._lineColor;
    }

    public int getThickness() {
        return this._thickness;
    }
}

