/*
 * Decompiled with CFR 0.152.
 */
package sorcererII;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import sorcererII.SorcererTape;

public class FileSorcererTape
implements SorcererTape {
    private InputStream inputStream = null;
    private OutputStream outputStream = null;
    private File _file;
    private boolean _readOnly = false;

    public FileSorcererTape(File file, boolean readOnly) {
        this(file);
        this._readOnly = readOnly;
    }

    public FileSorcererTape(File file) {
        this._file = file;
    }

    public FileSorcererTape(String name) {
        this._file = new File(name);
    }

    private void record() throws IOException {
        if (!this._readOnly && this.outputStream == null) {
            this.outputStream = new FileOutputStream(this._file, false);
        }
    }

    private void play() throws IOException {
        if (this.inputStream == null) {
            this.inputStream = new FileInputStream(this._file);
        }
    }

    @Override
    public void rewind() {
    }

    @Override
    public void motorOn(float baudRate) {
    }

    @Override
    public void motorOff() {
        try {
            if (this.outputStream != null) {
                this.outputStream.close();
                this.outputStream = null;
            }
            if (this.inputStream != null) {
                this.inputStream.close();
                this.inputStream = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.rewind();
    }

    @Override
    public byte getByte() throws IOException {
        int b;
        if (this.inputStream == null) {
            this.play();
        }
        if ((b = this.inputStream.read()) == -1) {
            this.inputStream.close();
            this.inputStream = null;
            return 26;
        }
        return (byte)(b & 0xFF);
    }

    @Override
    public void writeByte(byte b) throws IOException {
        if (!this._readOnly) {
            if (this.outputStream == null) {
                this.record();
            }
            this.outputStream.write(0xFF & b);
        }
    }
}

