/*
 * Decompiled with CFR 0.152.
 */
package sorcererII;

import java.awt.Color;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JCheckBox;
import javax.swing.filechooser.FileFilter;
import sorcererII.JFileChooserWithImage;
import sorcererII.SorcererDisk;
import sorcererII.SorcererDiskDrive;
import sorcererII.SorcererFileDisk;

public class JSorcererDiskDrive
extends JFileChooserWithImage {
    private static final long serialVersionUID = -3695105504141235512L;
    private final SorcererDiskProxy _sorcererDiskProxy = new SorcererDiskProxy();
    private final SorcererDiskDrive _drive;
    final JCheckBox _readOnlyCheckBox = new JCheckBox("Read only");

    public JSorcererDiskDrive(SorcererDiskDrive drive, char driveLetter) throws IOException {
        super(ImageIO.read(new File("images/icon-disk-out.png")), ImageIO.read(new File("images/icon-disk-in.png")), new File("disks/"), "Disk " + driveLetter);
        this._drive = drive;
        this._drive.insertDisk(this._sorcererDiskProxy);
        this.setAccessory(this._readOnlyCheckBox);
        this.setFileFilter(new FileFilter(){

            @Override
            public String getDescription() {
                return "Disk files";
            }

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                String lowerFileName = f.getName().toLowerCase();
                return lowerFileName.endsWith(".dsk");
            }
        });
    }

    @Override
    public void load(File file) throws IOException {
        this._sorcererDiskProxy.setDelegate(new SorcererFileDisk(file, this._readOnlyCheckBox.isSelected()));
    }

    @Override
    public void eject() {
        try {
            this._sorcererDiskProxy.deactivate();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this._sorcererDiskProxy.setDelegate(null);
    }

    private class SorcererDiskProxy
    implements SorcererDisk {
        private SorcererDisk _delegate = null;

        private SorcererDiskProxy() {
        }

        @Override
        public void activate() throws IOException {
            JSorcererDiskDrive.this.setBorderColor(Color.red);
            if (this._delegate == null) {
                return;
            }
            this._delegate.activate();
        }

        @Override
        public void deactivate() throws IOException {
            JSorcererDiskDrive.this.setBorderColor(null);
            if (this._delegate == null) {
                return;
            }
            this._delegate.deactivate();
        }

        @Override
        public byte read(int track, int sector, int offset) {
            if (this._delegate == null) {
                return 0;
            }
            return this._delegate.read(track, sector, offset);
        }

        @Override
        public void write(int track, int sector, int offset, byte data) {
            if (this._delegate == null) {
                return;
            }
            this._delegate.write(track, sector, offset, data);
        }

        public void setDelegate(SorcererDisk delegate) {
            this._delegate = delegate;
        }
    }
}

