/*
 * Decompiled with CFR 0.152.
 */
package sorcererII;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import javax.imageio.ImageIO;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import sorcererII.JMonostableImageButton;
import sorcererII.Sorcerer;

public class JSorcererFileOpener
extends JMonostableImageButton {
    private static final long serialVersionUID = 5184346364731454400L;
    private final Sorcerer _sorcerer;
    private File _file = new File("snaps/");
    final JFileChooser _fileChooser = new JFileChooser(this._file);
    final JCheckBox _autorunCheckBox = new JCheckBox("Autorun");

    public JSorcererFileOpener(Sorcerer sorcerer) throws IOException {
        super(ImageIO.read(new File("images/icon-open-faint.png")), ImageIO.read(new File("images/icon-open.png")), "Load a file");
        this._sorcerer = sorcerer;
        this._fileChooser.setFileFilter(new FileFilter(){

            @Override
            public String getDescription() {
                return "Quick Load";
            }

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                String lowerFileName = f.getName().toLowerCase();
                return lowerFileName.endsWith(".snp") || lowerFileName.endsWith(".snap") || lowerFileName.endsWith(".bin") || lowerFileName.endsWith(".com");
            }
        });
        this._autorunCheckBox.setSelected(true);
        this._fileChooser.setAccessory(this._autorunCheckBox);
    }

    @Override
    public void gotoState1() {
    }

    @Override
    public void gotoState2() {
        int returnVal = this._fileChooser.showOpenDialog(this);
        if (returnVal == 0) {
            try {
                this._file = this._fileChooser.getSelectedFile();
                String lowerFileName = this._file.getName().toLowerCase();
                if (lowerFileName.endsWith(".snp") || lowerFileName.endsWith(".snap")) {
                    this.loadSnap(this._file);
                } else if (lowerFileName.endsWith(".bin")) {
                    this.loadBin(this._file, this._autorunCheckBox.isSelected());
                } else if (lowerFileName.endsWith(".com")) {
                    this.loadCom(this._file, this._autorunCheckBox.isSelected());
                } else {
                    Sorcerer.LOGGER.log(Level.SEVERE, "Do not know how to load a file of this type");
                }
            }
            catch (IOException ex) {
                Sorcerer.LOGGER.log(Level.SEVERE, "Could not read file to load into memory");
            }
        }
    }

    private void loadSnap(File file) throws IOException {
        this._sorcerer.stop();
        try {
            FileInputStream is = new FileInputStream(file);
            try {
                this._sorcerer.loadSNP(new FileInputStream(this._file));
            }
            finally {
                ((InputStream)is).close();
            }
        }
        finally {
            this._sorcerer.start();
        }
    }

    private void loadBin(File file, boolean autorun) throws IOException {
        this._sorcerer.stop();
        try {
            FileInputStream is = new FileInputStream(file);
            try {
                this._sorcerer.loadBin(new FileInputStream(this._file), autorun);
            }
            finally {
                ((InputStream)is).close();
            }
        }
        finally {
            this._sorcerer.start();
        }
    }

    private void loadCom(File file, boolean autorun) throws IOException {
        this._sorcerer.stop();
        try {
            FileInputStream is = new FileInputStream(file);
            try {
                this._sorcerer.loadCom(new FileInputStream(this._file), autorun);
            }
            finally {
                ((InputStream)is).close();
            }
        }
        finally {
            this._sorcerer.start();
        }
    }
}

