/*
 * Decompiled with CFR 0.152.
 */
package sorcererII;

import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import sorcererII.Sorcerer;
import sorcererII.TableCellRendererProxy;

class JSorcererLoggerTable
extends JTable {
    private static final int MAX_ROWS = 50;
    private ImageIcon _infoIcon = new ImageIcon("images/icon_small_info.png");
    private ImageIcon _warningIcon = new ImageIcon("images/icon_small_warning.png");
    private ImageIcon _errorIcon = new ImageIcon("images/icon_small_error.png");
    private TableCellRendererProxy _tableCellRendererProxy = new TableCellRendererProxy();

    private ImageIcon levelToIcon(Level level) {
        if (level.equals(Level.SEVERE)) {
            return this._errorIcon;
        }
        if (level.equals(Level.WARNING)) {
            return this._warningIcon;
        }
        return this._infoIcon;
    }

    @Override
    public TableCellRenderer getDefaultRenderer(Class<?> columnClass) {
        this._tableCellRendererProxy.setDelegate(super.getDefaultRenderer(columnClass));
        return this._tableCellRendererProxy;
    }

    public JSorcererLoggerTable() {
        super(new DefaultTableModel(new Object[]{"Level", "Message"}, 0){

            @Override
            public boolean isCellEditable(int row, int col) {
                return false;
            }

            public Class getColumnClass(int col) {
                if (col == 0) {
                    return ImageIcon.class;
                }
                return Object.class;
            }
        });
        this.setFillsViewportHeight(true);
        this.setPreferredScrollableViewportSize(this.getPreferredSize());
        this.setShowGrid(false);
        this.setOpaque(false);
        this.setTableHeader(null);
        this.setFocusable(false);
        TableColumnModel cm = this.getColumnModel();
        cm.getColumn(0).setPreferredWidth(25);
        cm.getColumn(1).setPreferredWidth(680);
        Sorcerer.LOGGER.addHandler(new Handler(){

            @Override
            public void publish(LogRecord record) {
                if (record.getLevel().intValue() > Level.FINE.intValue()) {
                    DefaultTableModel dm = (DefaultTableModel)JSorcererLoggerTable.this.getModel();
                    dm.insertRow(0, new Object[]{JSorcererLoggerTable.this.levelToIcon(record.getLevel()), record.getMessage()});
                    if (dm.getRowCount() > 50) {
                        dm.removeRow(50);
                    }
                }
            }

            @Override
            public void flush() {
            }

            @Override
            public void close() throws SecurityException {
            }
        });
    }
}

