/*
 * Decompiled with CFR 0.152.
 */
package sorcererII;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.filechooser.FileFilter;
import sorcererII.JFileChooserWithImage;
import sorcererII.Sorcerer;

public class JSorcererRomPack
extends JFileChooserWithImage {
    private static final long serialVersionUID = -3695105504141235512L;
    private final Sorcerer _sorcerer;
    private File _file = null;

    public JSorcererRomPack(Sorcerer sorcerer) throws IOException {
        super(ImageIO.read(new File("images/icon-rom-out.png")), ImageIO.read(new File("images/icon-rom-in.png")), new File("rom-packs/"), "ROM Pack");
        this._sorcerer = sorcerer;
        this.setFileFilter(new FileFilter(){

            @Override
            public String getDescription() {
                return "ROM Pack files";
            }

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                String lowerFileName = f.getName().toLowerCase();
                return lowerFileName.endsWith(".rom");
            }
        });
    }

    @Override
    public void load(File file) throws IOException {
        this._file = file;
        this._sorcerer.stop();
        this._sorcerer.load8kRomPack(new FileInputStream(file));
        this._sorcerer.reset();
        this._sorcerer.start();
    }

    @Override
    public void eject() {
        this._file = null;
        this._sorcerer.stop();
        this._sorcerer.clear8kRomPack();
        this._sorcerer.reset();
        this._sorcerer.start();
    }

    public void reload() throws IOException {
        if (this._file != null) {
            this._sorcerer.load8kRomPack(new FileInputStream(this._file));
        } else {
            this._sorcerer.clear8kRomPack();
        }
    }
}

