/*
 * Decompiled with CFR 0.152.
 */
package sorcererII;

import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import javax.imageio.ImageIO;
import javax.swing.JCheckBox;
import javax.swing.filechooser.FileFilter;
import sorcererII.FileSorcererTape;
import sorcererII.JFileChooserWithImage;
import sorcererII.Sorcerer;
import sorcererII.SorcererAudioFileTape;
import sorcererII.SorcererTape;

public class JSorcererTapeDrive
extends JFileChooserWithImage {
    private static final long serialVersionUID = -3695105504141235512L;
    private final Sorcerer _sorcerer;
    private final int _unit;
    private SorcererTapeProxy _sorcererTapeProxy = new SorcererTapeProxy();
    final JCheckBox _readOnlyCheckBox = new JCheckBox("Read only");

    public JSorcererTapeDrive(Sorcerer sorcerer, int unit) throws IOException {
        super(ImageIO.read(new File("images/icon-cassette-out.png")), ImageIO.read(new File("images/icon-cassette-in.png")), new File("tapes/"), "Cassette Player " + (unit + 1));
        this._sorcerer = sorcerer;
        this._sorcerer.attachTapeUnit(this._sorcererTapeProxy, unit);
        this._unit = unit;
        this.setAccessory(this._readOnlyCheckBox);
        this.setFileFilter(new FileFilter(){

            @Override
            public String getDescription() {
                return "Tape files";
            }

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                String lowerFileName = f.getName().toLowerCase();
                return lowerFileName.endsWith(".wav") || lowerFileName.endsWith(".tape");
            }
        });
    }

    @Override
    public void load(File file) throws IOException {
        if (file.getName().toLowerCase().endsWith(".wav")) {
            this._sorcererTapeProxy.setDelegate(new SorcererAudioFileTape(file, this._readOnlyCheckBox.isSelected()));
        } else {
            this._sorcererTapeProxy.setDelegate(new FileSorcererTape(file, this._readOnlyCheckBox.isSelected()));
        }
        Sorcerer.LOGGER.log(Level.INFO, "Loaded cassette drive " + this._unit + " with file " + file);
    }

    @Override
    public void eject() {
        this._sorcererTapeProxy.setDelegate(null);
        Sorcerer.LOGGER.log(Level.INFO, "Ejected tape from cassette drive " + this._unit);
    }

    private class SorcererTapeProxy
    implements SorcererTape {
        private SorcererTape _delegate = null;

        private SorcererTapeProxy() {
        }

        public void setDelegate(SorcererTape delegate) {
            this._delegate = delegate;
        }

        @Override
        public byte getByte() throws IOException {
            if (this._delegate == null) {
                return 26;
            }
            return this._delegate.getByte();
        }

        @Override
        public void motorOff() {
            JSorcererTapeDrive.this.setBorderColor(null);
            if (this._delegate == null) {
                return;
            }
            this._delegate.motorOff();
        }

        @Override
        public void motorOn(float baudRate) {
            JSorcererTapeDrive.this.setBorderColor(Color.red);
            if (this._delegate == null) {
                return;
            }
            this._delegate.motorOn(baudRate);
        }

        @Override
        public void rewind() {
            if (this._delegate == null) {
                return;
            }
            this._delegate.rewind();
        }

        @Override
        public void writeByte(byte b) throws IOException {
            if (this._delegate == null) {
                return;
            }
            this._delegate.writeByte(b);
        }
    }
}

