/*
 * Decompiled with CFR 0.152.
 */
package sorcererII;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import sorcererII.Sorcerer;
import sorcererII.SorcererAudioInputStream;
import sorcererII.SorcererAudioOutputStream;
import sorcererII.SorcererTape;

public class SorcererAudioFileTape
implements SorcererTape {
    private InputStream inputStream = null;
    private OutputStream outputStream = null;
    private File _file;
    private float _baudRate = 0.0f;
    private boolean _endOfFile = false;
    private boolean _readOnly = false;

    public SorcererAudioFileTape(File file, boolean readOnly) {
        this(file);
        this._readOnly = readOnly;
    }

    public SorcererAudioFileTape(File file) {
        this._file = file;
    }

    public SorcererAudioFileTape(String name) {
        this(new File(name));
    }

    public void record() throws IOException {
        if (!this._readOnly && this.outputStream == null) {
            this.outputStream = new SorcererAudioOutputStream(this._file, this._baudRate);
        }
    }

    public void play() throws IOException {
        if (this.inputStream == null) {
            this.inputStream = new SorcererAudioInputStream(this._file, this._baudRate, Sorcerer.LOGGER);
        }
    }

    @Override
    public void rewind() {
    }

    @Override
    public void motorOn(float baudRate) {
        this._baudRate = baudRate;
    }

    @Override
    public void motorOff() {
        this._endOfFile = false;
        try {
            if (this.outputStream != null) {
                this.outputStream.close();
                this.outputStream = null;
            }
            if (this.inputStream != null) {
                this._endOfFile = false;
                this.inputStream.close();
                this.inputStream = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.rewind();
    }

    @Override
    public byte getByte() throws IOException {
        int b;
        if (this._endOfFile) {
            return 26;
        }
        if (this.inputStream == null) {
            this.play();
        }
        if ((b = this.inputStream.read()) == -1) {
            Sorcerer.LOGGER.log(Level.INFO, "Reached end of cassette");
            this._endOfFile = true;
            this.inputStream.close();
            this.inputStream = null;
            return 26;
        }
        return (byte)(b & 0xFF);
    }

    @Override
    public void writeByte(byte b) throws IOException {
        if (!this._readOnly) {
            if (this.outputStream == null) {
                this.record();
            }
            this.outputStream.write(0xFF & b);
        }
    }
}

