/*
 * Decompiled with CFR 0.152.
 */
package sorcererII;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;

public class SorcererAudioInputStream
extends InputStream {
    private AudioInputStream _audioInputStream;
    private double _sampleFrequency;
    private int _bytesPerFrame;
    private int _channels;
    private int _numBytes;
    private byte[] _audioBytes;
    private int _numBytesRead = 0;
    private int _currentSample;
    private double _samplesPerBit;
    private boolean _currentState = false;
    private int _upperThreshold = 40;
    private int _lowerThreshold = -40;
    private boolean _trace = false;
    private Logger _logger;

    @Override
    public int read() throws IOException {
        if (this.seekStart() == -1) {
            return -1;
        }
        return this.readByte();
    }

    public SorcererAudioInputStream(File fileIn, double bitFrequency, Logger logger) throws IOException {
        this._logger = logger;
        try {
            this._audioInputStream = AudioSystem.getAudioInputStream(fileIn);
        }
        catch (UnsupportedAudioFileException e) {
            if (this._logger != null) {
                this._logger.log(Level.SEVERE, "Audio file format is not supported", e);
            }
            throw new IOException(e);
        }
        AudioFormat audioFormat = this._audioInputStream.getFormat();
        if (this._trace) {
            System.out.println(audioFormat);
        }
        if (this._logger != null) {
            this._logger.log(Level.INFO, "Reading audio format:" + audioFormat);
        }
        this._sampleFrequency = audioFormat.getFrameRate();
        this._bytesPerFrame = audioFormat.getFrameSize();
        this._channels = audioFormat.getChannels();
        AudioFormat.Encoding encoding = audioFormat.getEncoding();
        int dcOffset = 0;
        if (encoding == AudioFormat.Encoding.PCM_UNSIGNED) {
            dcOffset = 1 << this._bytesPerFrame / this._channels * 8 - 1;
        }
        int f = (1 ^ 8 * (this._bytesPerFrame / this._channels - 1)) * this._channels;
        this._upperThreshold *= f;
        this._lowerThreshold *= f;
        this._upperThreshold += dcOffset;
        this._lowerThreshold += dcOffset;
        if (this._bytesPerFrame > 2 && this._channels != 2) {
            if (this._trace) {
                System.out.println("Sorry cannot support " + this._bytesPerFrame + " bytes per frame ");
            }
            throw new IOException("Sorry cannot support " + this._bytesPerFrame + " bytes per frame ");
        }
        this._numBytes = 1024 * this._bytesPerFrame;
        this._audioBytes = new byte[this._numBytes];
        this._currentSample = this._numBytes;
        this._samplesPerBit = this._sampleFrequency / bitFrequency;
        if (this._trace) {
            System.out.println("Samples Per Bit " + this._samplesPerBit);
        }
    }

    private int readSample() throws IOException {
        int sample;
        if (this._bytesPerFrame == 1) {
            sample = this._audioBytes[this._currentSample++];
        } else if (this._bytesPerFrame == 2) {
            sample = (this._audioBytes[this._currentSample] & 0xFF) + ((this._audioBytes[this._currentSample + 1] & 0xFF) << 8);
            if ((sample & 0x8000) != 0) {
                sample |= 0xFFFF0000;
            }
            this._currentSample += 2;
        } else if (this._bytesPerFrame == 4 && this._channels == 2) {
            int s1 = (this._audioBytes[this._currentSample] & 0xFF) + ((this._audioBytes[this._currentSample + 1] & 0xFF) << 8);
            if ((s1 & 0x8000) != 0) {
                s1 |= 0xFFFF0000;
            }
            this._currentSample += 2;
            int s2 = (this._audioBytes[this._currentSample] & 0xFF) + ((this._audioBytes[this._currentSample + 1] & 0xFF) << 8);
            if ((s2 & 0x8000) != 0) {
                s2 |= 0xFFFF0000;
            }
            this._currentSample += 2;
            sample = s1 + s2;
        } else {
            if (this._logger != null) {
                this._logger.log(Level.SEVERE, "Cannot support " + this._bytesPerFrame + " bytes per frame.");
            }
            throw new IOException("Cannot support " + this._bytesPerFrame + " bytes per frame.");
        }
        return sample;
    }

    private int nextSample() throws IOException {
        int sample;
        if (this._numBytesRead == -1) {
            return 0;
        }
        if (this._currentSample < this._numBytesRead) {
            sample = this.readSample();
        } else {
            this._numBytesRead = this._audioInputStream.read(this._audioBytes);
            this._currentSample = 0;
            if (this._numBytesRead > 0) {
                sample = this.readSample();
            } else {
                return 0;
            }
        }
        return sample;
    }

    private boolean next() throws IOException {
        int sample = this.nextSample();
        if (this._numBytesRead == -1) {
            return false;
        }
        if (this._currentState) {
            if (sample < this._lowerThreshold) {
                this._currentState = false;
            }
        } else if (sample > this._upperThreshold) {
            this._currentState = true;
        }
        return true;
    }

    private int readPeriod() throws IOException {
        boolean thisState = this._currentState;
        int periodLength = 0;
        boolean more = false;
        while (thisState == this._currentState && (more = this.next())) {
            ++periodLength;
        }
        if (more) {
            return periodLength;
        }
        return -1;
    }

    private int readByte() throws IOException {
        int b = 0;
        int i = 0;
        while (i < 8) {
            b >>= 1;
            int bit = this.readBit();
            if (bit == -1) {
                return -1;
            }
            if (bit == 1) {
                b |= 0x80;
            }
            ++i;
        }
        if (this._trace) {
            System.out.println("Data: " + Integer.toHexString(b));
        }
        return b;
    }

    private int readBit() throws IOException {
        double diff;
        double d2;
        int p0 = this.readPeriod();
        if (p0 == -1) {
            return -1;
        }
        double d1 = (double)p0 - this._samplesPerBit;
        if (d1 < 0.0) {
            d1 = -d1;
        }
        if ((d2 = (double)p0 - this._samplesPerBit / 2.0) < 0.0) {
            d2 = -d2;
        }
        if ((diff = d1 - d2) < 0.0) {
            diff = -diff;
        }
        if (diff < 5.0 && this._logger != null) {
            this._logger.log(Level.FINE, "Cannot determine if bit is 1 or 0");
        }
        if (d1 > d2) {
            int p1 = this.readPeriod();
            if (p1 == -1) {
                return -1;
            }
            return 1;
        }
        return 0;
    }

    private int seekStart() throws IOException {
        boolean seeking = true;
        int p1 = this.readPeriod();
        if (p1 == -1) {
            return -1;
        }
        int p2 = this.readPeriod();
        if (p2 == -1) {
            return -1;
        }
        int p3 = this.readPeriod();
        if (p3 == -1) {
            return -1;
        }
        int syncCount = 0;
        int syncLength = 0;
        while (seeking) {
            boolean a4;
            double d1 = (double)p1 - this._samplesPerBit / 2.0;
            double d2 = (double)p2 - this._samplesPerBit / 2.0;
            double d3 = (double)p3 - this._samplesPerBit;
            double d4 = (double)p3 - this._samplesPerBit / 2.0;
            if (d1 < 0.0) {
                d1 = -d1;
            }
            if (d2 < 0.0) {
                d2 = -d2;
            }
            if (d3 < 0.0) {
                d3 = -d3;
            }
            if (d4 < 0.0) {
                d4 = -d4;
            }
            boolean a1 = d1 <= this._samplesPerBit / 4.0;
            boolean a2 = d2 <= this._samplesPerBit / 4.0;
            boolean a3 = d3 <= this._samplesPerBit / 4.0;
            boolean bl = a4 = d4 <= this._samplesPerBit / 4.0;
            if (a1 && a2 && a3) {
                if (this._trace) {
                    System.out.println("good " + p1 + " " + p2 + " " + p3 + " Samples Per bit " + (p1 + p2 + p3) / 2);
                }
                if (this._trace) {
                    System.out.println("Found Start");
                }
                seeking = false;
                continue;
            }
            if (a1 && a2 && a4) {
                if (this._trace) {
                    System.out.println("sync (" + syncCount + ")" + p1 + " " + p2 + " " + p3);
                }
                ++syncCount;
                syncLength += p1 + p2 + p3;
            } else {
                if (this._trace) {
                    System.out.println("bad " + p1 + " " + p2 + " " + p3);
                }
                syncCount = 0;
                syncLength = 0;
            }
            p1 = p2;
            p2 = p3;
            p3 = this.readPeriod();
            if (p3 != -1) continue;
            return -1;
        }
        if (syncCount > 30) {
            this._samplesPerBit = (double)syncLength * 2.0 / ((double)syncCount * 3.0);
            if (this._trace) {
                System.out.println("Re-calibrating samples-per-bit at " + this._samplesPerBit);
            }
        }
        return 0;
    }
}

