/*
 * Decompiled with CFR 0.152.
 */
package sorcererII;

import java.io.IOException;
import java.util.logging.Level;
import sorcererII.Sorcerer;
import sorcererII.SorcererDisk;

public class SorcererDiskDrive {
    public static final int SECTORS_PER_TRACK = 16;
    public static final int NUMBER_OF_TRACKS = 77;
    public static final int BYTES_PER_SECTOR = 270;
    private int _activeCount = 0;
    private int _sectorNumber = 0;
    private int _trackNumber = 0;
    private boolean _newSector = false;
    private SorcererDisk _disk = null;
    private int _sectorIndex = 0;
    private int _writeIndex = 0;
    private final int _unitNumber;

    public SorcererDiskDrive(int unitNumber) {
        this._unitNumber = unitNumber;
    }

    public char getUnitLetter() {
        return "ABCD".charAt(this._unitNumber);
    }

    public final void insertDisk(SorcererDisk disk) {
        this._disk = disk;
    }

    public SorcererDisk getDisk() {
        return this._disk;
    }

    public final boolean diskIn() {
        return this._disk != null;
    }

    public final boolean dataReady() {
        return true;
    }

    public final boolean home() {
        return this._trackNumber == 0;
    }

    public final void stepForward() {
        if (this._trackNumber < 76) {
            ++this._trackNumber;
        }
    }

    public final void stepBackward() {
        if (this._trackNumber > 0) {
            --this._trackNumber;
        }
    }

    public final boolean active() {
        return this._activeCount > 0;
    }

    public final void activate() {
        if (this._activeCount == 0 && this._disk != null) {
            try {
                this._disk.activate();
            }
            catch (IOException e) {
                Sorcerer.LOGGER.log(Level.SEVERE, "Problem reading disk " + this.getUnitLetter(), e);
            }
        }
        this._activeCount = 400;
    }

    private final void writeReg0(int b) {
        switch (b) {
            case 160: {
                break;
            }
            case 32: 
            case 33: {
                this.activate();
                break;
            }
            case 96: {
                this.stepBackward();
                break;
            }
            case 97: {
                this.stepForward();
            }
        }
    }

    public final void readyWrite() {
        this._writeIndex = 0;
    }

    private final void writeReg1(int b) {
        switch (b) {
            case 160: {
                break;
            }
            case 32: 
            case 33: {
                this.activate();
                break;
            }
            case 96: {
                this.stepBackward();
                break;
            }
            case 97: {
                this.stepForward();
            }
        }
    }

    public final void writeReg2(int b) {
        this._disk.write(this._trackNumber, this._sectorNumber, this._writeIndex++, (byte)b);
    }

    public final int readReg0() {
        int r = this._sectorNumber;
        if (this._newSector) {
            r |= 0x80;
            this._newSector = false;
        }
        return r;
    }

    private final int readReg1() {
        int r = 0;
        if (this.active()) {
            r |= 0x20;
        }
        if (this.home()) {
            r |= 8;
        }
        if (this.dataReady()) {
            r |= 0x80;
        }
        return r;
    }

    public final int readReg2() {
        if (this._disk != null && this._sectorIndex < 270) {
            byte data = this._disk.read(this._trackNumber, this._sectorNumber, this._sectorIndex++);
            return data & 0xFF;
        }
        return 0;
    }

    public final void write(int address, int b) {
        if (this.active()) {
            this.activate();
        }
        switch (address) {
            case 0: {
                this.writeReg0(b);
                break;
            }
            case 1: {
                this.writeReg1(b);
                break;
            }
            case 2: {
                this.writeReg2(b);
            }
        }
    }

    public final int read(int address) {
        if (this.active()) {
            this.activate();
        }
        int r = 0;
        switch (address) {
            case 0: {
                r = this.readReg0();
                break;
            }
            case 1: {
                r = this.readReg1();
                break;
            }
            case 2: {
                r = this.readReg2();
            }
        }
        return r;
    }

    public final void tick() {
        if (this.active()) {
            ++this._sectorNumber;
            this._sectorIndex = 0;
            if (this._sectorNumber >= 16) {
                this._sectorNumber = 0;
            }
            this._newSector = true;
            --this._activeCount;
            if (!this.active() && this._disk != null) {
                try {
                    this._disk.deactivate();
                }
                catch (Exception e) {
                    Sorcerer.LOGGER.log(Level.SEVERE, "Problem writing disk " + this.getUnitLetter(), e);
                }
            }
        }
    }
}

