/*
 * Decompiled with CFR 0.152.
 */
package sorcererII;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import sorcererII.SorcererImageProducer;

public class SorcererScreen {
    public int[] _pixels;
    private Image _image;
    private SorcererImageProducer _producer;
    private ColorModel _cm = new DirectColorModel(32, 0xFF0000, 65280, 255);
    public static final int WIDTH_CHARS = 64;
    public static final int HEIGHT_CHARS = 30;
    public static final int WIDTH_PIXELS = 512;
    public static final int HEIGHT_PIXELS = 480;
    public static final int COLOUR_ON = -1;
    public static final int COLOUR_OFF = -16777216;

    public SorcererScreen() {
        this._pixels = new int[245760];
        this._producer = new SorcererImageProducer(512, 480, this._cm, this._pixels);
        this._image = Toolkit.getDefaultToolkit().createImage(this._producer);
    }

    public Image getImage() {
        this._producer.update();
        return this._image;
    }

    public void drawCharacter(int row, int column, int[] mem, int start) {
        int imageIndex = (row << 13) + (column << 3);
        int i = 0;
        while (i < 8) {
            int s = 0;
            while (s < 2) {
                int c = mem[start + i];
                int p = 0;
                while (p < 8) {
                    this._pixels[imageIndex + p] = (c & 128 >> p) != 0 ? -1 : -16777216;
                    ++p;
                }
                imageIndex += 512;
                ++s;
            }
            ++i;
        }
    }
}

