/*
 * Decompiled with CFR 0.152.
 */
package sorcererII;

import java.io.IOException;
import java.io.InputStream;
import sorcererII.EndOfCassetteException;
import sorcererII.SorcererCrc;
import sorcererII.SorcererCrcException;

class SorcererTapeHeader {
    private byte[] _raw = new byte[16];
    private InputStream _input;

    private final int nextByte() throws IOException, EndOfCassetteException {
        int data = this._input.read();
        return data;
    }

    private void ReadHeader() throws IOException, EndOfCassetteException, SorcererCrcException {
        SorcererCrc crc = new SorcererCrc();
        int i = 0;
        while (i < 16) {
            int data = this.nextByte();
            this._raw[i] = (byte)data;
            crc.data(data);
            ++i;
        }
        crc.data(this.nextByte());
        if (!crc.ok()) {
            throw new SorcererCrcException();
        }
    }

    public SorcererTapeHeader(InputStream input) throws IOException, EndOfCassetteException, SorcererCrcException {
        this._input = input;
        this.ReadHeader();
    }

    public int getLength() {
        return this._raw[7] + this._raw[8] * 256;
    }

    public int getStart() {
        return this._raw[9] + this._raw[10] * 256;
    }
}

