/*
 * Decompiled with CFR 0.152.
 */
package sorcererII;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import sorcererII.EndOfCassetteException;
import sorcererII.SorcererCrcException;
import sorcererII.SorcererTapeBlock;
import sorcererII.SorcererTapeHeader;

public class SorcererTapeReader {
    private FileInputStream _input;
    private SorcererTapeHeader _header;
    private ArrayList _blocks = new ArrayList();

    public static void main(String[] args) {
        if (args.length != 2) {
            System.out.println("usage: java SorcererTapeReader <tapeFileName> <romFileName>");
        } else {
            try {
                System.out.println("Reading from " + args[0] + " and writing to " + args[1]);
                SorcererTapeReader sorcererTapeReader = new SorcererTapeReader(args[0]);
                sorcererTapeReader.writeRom(args[1]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void SeekStart() throws IOException, EndOfCassetteException {
        int data;
        while ((data = this._input.read()) == 0 || data != 1) {
        }
    }

    public SorcererTapeReader(String tapeFileName) throws IOException, SorcererCrcException, EndOfCassetteException {
        this._input = new FileInputStream(tapeFileName);
        this.SeekStart();
        this._header = new SorcererTapeHeader(this._input);
        this.SeekStart();
        int i = this._header.getLength();
        while (i > 0) {
            int blockLength = 256;
            if (i < 256) {
                blockLength = i;
            }
            this._blocks.add(new SorcererTapeBlock(this._input, blockLength));
            i -= 256;
        }
        this._input.close();
    }

    public void writeRom(String romFileName) throws IOException {
        FileOutputStream romOutputStream = new FileOutputStream(romFileName);
        for (SorcererTapeBlock block : this._blocks) {
            block.write(romOutputStream);
        }
        romOutputStream.close();
    }
}

