/*
 * Decompiled with CFR 0.152.
 */
package sorcererII;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Logger;
import sorcererII.SorcererAudioInputStream;

public class WaveToTape {
    public static Logger LOGGER = Logger.getLogger("WaveToTapeLogger");

    public static void convert(double bitFrequency, String wavFileName, String tapeFileName) throws IOException {
        FileOutputStream os = new FileOutputStream(tapeFileName);
        try {
            SorcererAudioInputStream is = new SorcererAudioInputStream(new File(wavFileName), bitFrequency, LOGGER);
            try {
                int b;
                while ((b = ((InputStream)is).read()) != -1) {
                    ((OutputStream)os).write(b);
                }
            }
            finally {
                is.close();
            }
        }
        finally {
            ((OutputStream)os).close();
        }
    }

    public static void main(String[] args) throws IOException {
        if (args.length != 3) {
            System.out.println("Usage: WaveToTape <baud> <wavFile> <tapeFile>");
        } else {
            WaveToTape.convert(Double.parseDouble(args[0]), args[1], args[2]);
        }
    }
}

