/*
 * Decompiled with CFR 0.152.
 */
package sorcererII;

import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

public abstract class JBistableImageButton
extends JLabel {
    private static final long serialVersionUID = 2854321504503168298L;
    private final Image _image1;
    private final Image _image2;
    private final ImageIcon _icon;
    private boolean _pressed = false;

    public JBistableImageButton(Image image1, Image image2, String tooltip) {
        this._image1 = image1;
        this._image2 = image2;
        this._icon = new ImageIcon();
        this._icon.setImage(image1);
        this.setIcon(this._icon);
        this.setToolTipText(tooltip);
        this.setHorizontalTextPosition(2);
        this.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (JBistableImageButton.this._icon.getImage() == JBistableImageButton.this._image1) {
                    JBistableImageButton.this._icon.setImage(JBistableImageButton.this._image2);
                } else {
                    JBistableImageButton.this._icon.setImage(JBistableImageButton.this._image1);
                }
                JBistableImageButton.this.repaint();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (JBistableImageButton.this._pressed) {
                    JBistableImageButton.this._icon.setImage(JBistableImageButton.this._image2);
                } else {
                    JBistableImageButton.this._icon.setImage(JBistableImageButton.this._image1);
                }
                JBistableImageButton.this.repaint();
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (JBistableImageButton.this._pressed) {
                    if (JBistableImageButton.this.gotoState1()) {
                        JBistableImageButton.this._pressed = !JBistableImageButton.this._pressed;
                    }
                } else if (JBistableImageButton.this.gotoState2()) {
                    JBistableImageButton.this._pressed = !JBistableImageButton.this._pressed;
                }
                if (JBistableImageButton.this._pressed) {
                    JBistableImageButton.this._icon.setImage(JBistableImageButton.this._image2);
                } else {
                    JBistableImageButton.this._icon.setImage(JBistableImageButton.this._image1);
                }
                JBistableImageButton.this.repaint();
            }
        });
    }

    public abstract boolean gotoState1();

    public abstract boolean gotoState2();
}

