/*
 * Decompiled with CFR 0.152.
 */
package sorcererII;

import java.applet.Applet;
import java.awt.Graphics;
import java.awt.event.FocusAdapter;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.InputStream;
import java.net.URL;
import java.util.HashSet;
import sorcererII.ArraySorcererDisk;
import sorcererII.ArraySorcererTape;
import sorcererII.Sorcerer;
import sorcererII.UrlSorcererTape;

public class JSorcerer
extends Applet {
    Sorcerer sorcerer = null;
    Thread thread = null;
    int refreshRate = 1;
    int sleepHack = 1;
    int scale = 1;

    @Override
    public String getAppletInfo() {
        return "JSorcerer V1.1";
    }

    @Override
    public String[][] getParameterInfo() {
        String[][] info = new String[][]{{"refreshRate", "Number", "refresh screen every 'X' interrupts (default=1)"}, {"sleepHack", "Number", "sleep per interrupt in ms, for old VMs (default=0)"}, {"scale", "Number", "Screen pixel width per sorcerer pixel width"}, {"rom8k", "URL", "filename of ROM (default=none)"}, {"snapshot", "URL", "filename of snapshot file(default=none)"}, {"diska", "URL", "Disk file for drive A"}, {"diskb", "URL", "Disk file for drive B"}, {"diskc", "URL", "Disk file for drive C"}, {"diskd", "URL", "Disk file for drive D"}, {"tape1", "URL", "Tape file for tape unit 1"}, {"tape2", "URL", "Tape file for tape unit 2"}, {"hardKeyMap", "true/false", "Map keyboard by keys or characters"}};
        return info;
    }

    private void loadDisk(String location, int diskNumber) {
        try {
            URL url = new URL(this.getDocumentBase(), location);
            InputStream is = url.openStream();
            try {
                this.sorcerer.insertDiskIntoDrive(new ArraySorcererDisk(new URL(this.getDocumentBase(), location).openStream()), 0);
            }
            finally {
                is.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void init() {
        this.setLayout(null);
        final HashSet _keyDown = new HashSet();
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (!_keyDown.contains(e.getKeyCode())) {
                    _keyDown.add(e.getKeyCode());
                    if (JSorcerer.this.sorcerer != null) {
                        JSorcerer.this.sorcerer.doKey(true, e);
                    }
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (JSorcerer.this.sorcerer != null) {
                    JSorcerer.this.sorcerer.doKey(false, e);
                }
                _keyDown.remove(e.getKeyCode());
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && JSorcerer.this.sorcerer != null) {
                    JSorcerer.this.sorcerer.toggleSpeed();
                }
            }
        });
        this.addFocusListener(new FocusAdapter(){

            public void focusGained(KeyEvent e) {
                if (JSorcerer.this.sorcerer != null) {
                    JSorcerer.this.sorcerer.resetKeyboard();
                }
            }
        });
        this.requestFocus();
    }

    @Override
    public void start() {
        if (this.sorcerer == null) {
            this.refreshRate = this.getIntParameter("refreshRate", this.refreshRate, 1, 100);
            this.sleepHack = this.getIntParameter("sleepHack", this.sleepHack, 0, 100);
            this.scale = this.getIntParameter("scale", this.scale, 1, 4);
            String rom8k = this.getParameter("rom8k");
            String snapshot = this.getParameter("snapshot");
            String diska = this.getParameter("diska");
            String diskb = this.getParameter("diskb");
            String diskc = this.getParameter("diskc");
            String diskd = this.getParameter("diskd");
            String tape1 = this.getParameter("tape1");
            String tape2 = this.getParameter("tape2");
            String hardKeyMap = this.getParameter("hardKeyMap");
            try {
                this.sorcerer = new Sorcerer(this, this.refreshRate, this.sleepHack, this.scale, 0, 0);
                if (tape1 != null) {
                    this.sorcerer.attachTapeUnit1(new UrlSorcererTape(this.getDocumentBase(), tape1));
                } else {
                    this.sorcerer.attachTapeUnit1(new ArraySorcererTape());
                }
                if (tape2 != null) {
                    this.sorcerer.attachTapeUnit1(new UrlSorcererTape(this.getDocumentBase(), tape2));
                } else {
                    this.sorcerer.attachTapeUnit1(new ArraySorcererTape());
                }
                if (diska != null) {
                    this.loadDisk(diska, 0);
                }
                if (diskb != null) {
                    this.loadDisk(diskb, 1);
                }
                if (diskc != null) {
                    this.loadDisk(diskc, 2);
                }
                if (diskd != null) {
                    this.loadDisk(diskd, 3);
                }
                if (snapshot == null) {
                    this.sorcerer.loadROMs(this.getDocumentBase());
                    if (rom8k != null) {
                        this.sorcerer.load8kRomPack(this.getDocumentBase(), rom8k);
                    }
                } else {
                    this.sorcerer.loadSNP(new URL(this.getDocumentBase(), snapshot));
                }
                if (hardKeyMap != null) {
                    this.sorcerer.useHardKeys(hardKeyMap.equalsIgnoreCase("true"));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.requestFocus();
        this.sorcerer.start();
        this.showStatus(this.getAppletInfo());
    }

    @Override
    public void stop() {
        this.sorcerer.stop();
    }

    public int getIntParameter(String name, int ifUndef, int min, int max) {
        String param = this.getParameter(name);
        if (param == null) {
            return ifUndef;
        }
        try {
            int n = Integer.parseInt(param);
            if (n < min) {
                return min;
            }
            if (n > max) {
                return max;
            }
            return n;
        }
        catch (Exception e) {
            return ifUndef;
        }
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    @Override
    public void paint(Graphics g) {
        if (this.sorcerer != null) {
            this.sorcerer.repaint();
        }
    }
}

