/*
 * Decompiled with CFR 0.152.
 */
package sorcererII;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import sorcererII.JMonostableImageButton;
import sorcererII.Sorcerer;

public class JSorcererSaveScreen
extends JMonostableImageButton {
    private static final long serialVersionUID = 5184346364731454400L;
    private final Sorcerer _sorcerer;
    private File _file = new File("screen-shots/");

    public JSorcererSaveScreen(Sorcerer sorcerer) throws IOException {
        super(ImageIO.read(new File("images/icon-screen-shot-faint.png")), ImageIO.read(new File("images/icon-screen-shot.png")), "Save screen");
        this._sorcerer = sorcerer;
    }

    @Override
    public void gotoState1() {
    }

    @Override
    public void gotoState2() {
        block7: {
            this._sorcerer.stop();
            try {
                JFileChooser fc = new JFileChooser(this._file);
                int returnVal = fc.showSaveDialog(this);
                if (returnVal != 0) break block7;
                try {
                    String suffix;
                    this._file = fc.getSelectedFile();
                    BufferedImage image = new BufferedImage(512, 480, 1);
                    this._sorcerer.refreshWholeScreen();
                    this._sorcerer.writeScreenImage(image.getGraphics());
                    this._sorcerer.refreshWholeScreen();
                    String type = "png";
                    int lastDot = this._file.getName().lastIndexOf(".");
                    if (lastDot > 0 && (suffix = this._file.getName().substring(lastDot + 1)).length() > 0) {
                        type = suffix;
                    }
                    if (!ImageIO.write((RenderedImage)image, type, this._file)) {
                        Sorcerer.LOGGER.log(Level.SEVERE, "Could not write a file of this format");
                    }
                }
                catch (IOException ex) {
                    Sorcerer.LOGGER.log(Level.SEVERE, "Could not save screen image");
                }
            }
            finally {
                this._sorcerer.start();
            }
        }
    }
}

