/*
 * Decompiled with CFR 0.152.
 */
package sorcererII;

import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.KeyEvent;
import java.io.BufferedInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.LinkedList;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import sorcererII.ArraySorcererDisk;
import sorcererII.SorcererDiskDrive;
import sorcererII.SorcererDiskSystem;
import sorcererII.SorcererTape;
import sorcererII.Z80;

public class Sorcerer
extends Z80
implements Runnable {
    public static Logger LOGGER = Logger.getLogger("SorcererLogger");
    public Graphics parentGraphics = null;
    public Container parent = null;
    public int sleepHack = 0;
    public int refreshRate = 1;
    private int interruptCounter = 0;
    private boolean resetAtNextInterrupt = false;
    private boolean refreshNextInterrupt = true;
    private boolean takeSnapshotNextInterrupt = false;
    public long timeOfLastInterrupt = 0L;
    private long timeOfLastSample = 0L;
    private long runningAverage = 40L;
    private int delayPeriod = 10;
    private boolean useHardKeyMap = true;
    private boolean[] romFlags = new boolean[64];
    private boolean[] screenFlags = new boolean[1920];
    private boolean[] characterFlags = new boolean[128];
    private SorcererTape sorcererTape1 = null;
    private SorcererTape sorcererTape2 = null;
    private SorcererTape sorcererSerial = null;
    private boolean tape1Running = false;
    private boolean tape2Running = false;
    private Random rand = new Random();
    private SorcererDiskSystem _diskSystem = new SorcererDiskSystem();
    private int offsetX = 0;
    private int offsetY = 0;
    private Thread thread = null;
    public int pixelScale = 1;
    public static final int nCharsWide = 64;
    public static final int nCharsHigh = 30;
    public static final int nPixelsWide = 512;
    public static final int nPixelsHigh = 240;
    public boolean runAtFullSpeed = false;
    Image characterImages = null;
    private Keyboard _keyboard = new Keyboard();
    private Map<Character, KeyHanlder> _keyCharHandlers = new TreeMap<Character, KeyHanlder>();
    private Map<Integer, KeyHanlder> _keyCodeHandlers = new TreeMap<Integer, KeyHanlder>();

    public Sorcerer(Container _parent, int _refreshRate, int _sleepHack, int _pixelScale, int _offsetX, int _offsetY) {
        super(2.0);
        this.parent = _parent;
        this.offsetX = _offsetX;
        this.offsetY = _offsetY;
        this.sleepHack = _sleepHack;
        this.pixelScale = _pixelScale;
        this.refreshRate = _refreshRate;
        this.setRomFlags();
        int i = 0;
        while (i < this.screenFlags.length) {
            this.screenFlags[i] = true;
            ++i;
        }
        this.resetKeyboard();
    }

    public void attachTapeUnit(SorcererTape tape, int unit) {
        switch (unit) {
            case 0: {
                this.attachTapeUnit1(tape);
            }
            case 1: {
                this.attachTapeUnit2(tape);
            }
        }
    }

    public void attachTapeUnit1(SorcererTape tape) {
        this.sorcererTape1 = tape;
    }

    public void attachTapeUnit2(SorcererTape tape) {
        this.sorcererTape2 = tape;
    }

    public void attachSerial(SorcererTape tape) {
        this.sorcererSerial = tape;
    }

    public void insertDiskIntoDrive(ArraySorcererDisk disk, int drive) {
        this._diskSystem.insertDisk(disk, drive);
    }

    public SorcererDiskDrive getSorcererDiskDrive(int drive) {
        return this._diskSystem.getSorcererDiskDrive(drive);
    }

    public void setPixelScale(int scale) {
        this.pixelScale = scale;
    }

    public void useHardKeys(boolean useHardKeys) {
        this.useHardKeyMap = useHardKeys;
        this.resetKeyboard();
    }

    @Override
    public void abort() {
        super.abort();
        if (this.sorcererSerial != null) {
            this.sorcererSerial.motorOff();
        }
        if (this.sorcererTape1 != null) {
            this.sorcererTape1.motorOff();
        }
        if (this.sorcererTape2 != null) {
            this.sorcererTape2.motorOff();
        }
    }

    void resetNextInterrupt() {
        this.resetAtNextInterrupt = true;
    }

    @Override
    public final int inb(int port) {
        int res;
        block13: {
            res = 255;
            int bport = port & 0xFF;
            if (bport == 254) {
                res = this._keyboard.getKeyBits();
                res |= 0xE0;
            } else if (bport == 252) {
                try {
                    if (this.tape1Running && this.sorcererTape1 != null) {
                        res = this.sorcererTape1.getByte() & 0xFF;
                        break block13;
                    }
                    if (this.tape2Running && this.sorcererTape2 != null) {
                        res = this.sorcererTape2.getByte() & 0xFF;
                        break block13;
                    }
                    if (this.sorcererSerial != null) {
                        res = this.sorcererSerial.getByte();
                        break block13;
                    }
                    res = this.rand.nextInt() & 0xFF;
                }
                catch (IOException e) {
                    res = this.rand.nextInt() & 0xFF;
                }
            } else if (bport == 253) {
                res = 255;
            } else if (bport == 255) {
                res = 255;
            } else {
                System.out.println("unhandled inb " + Z80.toHexWord(port));
            }
        }
        return res;
    }

    @Override
    public final void outb(int port, int outByte, int tstates) {
        int bport = port & 0xFF;
        if (bport == 254) {
            boolean motor2Bit;
            this._keyboard.setScanLine(outByte & 0xF);
            boolean motor1Bit = (outByte & 0x10) != 0;
            boolean bl = motor2Bit = (outByte & 0x20) != 0;
            if (this.tape1Running && !motor1Bit) {
                this.tape1Running = false;
                if (this.sorcererTape1 != null) {
                    this.sorcererTape1.motorOff();
                }
            } else if (!this.tape1Running && motor1Bit) {
                this.tape1Running = true;
                if (this.sorcererTape1 != null) {
                    this.sorcererTape1.motorOn((outByte & 0x40) == 0 ? 300 : 1200);
                }
            }
            if (this.tape2Running && !motor2Bit) {
                this.tape2Running = false;
                if (this.sorcererTape2 != null) {
                    this.sorcererTape2.motorOff();
                }
            } else if (!this.tape2Running && motor2Bit) {
                this.tape2Running = true;
                if (this.sorcererTape2 != null) {
                    this.sorcererTape2.motorOn((outByte & 0x40) == 0 ? 300 : 1200);
                }
            }
        } else if (bport == 252) {
            if (this.tape1Running) {
                try {
                    if (this.sorcererTape1 != null) {
                        this.sorcererTape1.writeByte((byte)(outByte & 0xFF));
                    }
                }
                catch (IOException e) {
                    LOGGER.log(Level.SEVERE, "Error writing to tape unit 1", e);
                    this.sorcererTape1 = null;
                }
            } else if (this.tape2Running) {
                try {
                    if (this.sorcererTape2 != null) {
                        this.sorcererTape2.writeByte((byte)(outByte & 0xFF));
                    }
                }
                catch (IOException e) {
                    LOGGER.log(Level.SEVERE, "Error writing to tape unit 2", e);
                    this.sorcererTape2 = null;
                }
            } else if (this.sorcererSerial != null) {
                try {
                    this.sorcererSerial.writeByte((byte)(outByte & 0xFF));
                }
                catch (IOException e) {
                    LOGGER.log(Level.SEVERE, "Error writing to tape unit 2", e);
                    this.sorcererSerial = null;
                }
            }
        }
    }

    public final void refreshWholeScreen() {
        int i = 61568;
        while (i < 63488) {
            this.screenFlags[i - 61568] = true;
            ++i;
        }
    }

    public final void refreshCharacter(int c) {
        int i = 61568;
        while (i < 63488) {
            if (this.mem[i] == c) {
                this.screenFlags[i - 61568] = true;
            }
            ++i;
        }
    }

    @Override
    public final int peekb(int address) {
        if (this.trace) {
            System.out.println("Reading " + Z80.toHexWord(address) + " " + Z80.toHexByte(this.mem[address]));
        }
        if (address >= 48640 && address <= 48642) {
            return this._diskSystem.read(address - 48640);
        }
        return this.mem[address];
    }

    @Override
    public final void pokeb(int address, int newByte) {
        int memorySegment;
        if (this.trace) {
            System.out.println("Writing " + Z80.toHexByte(newByte) + " to " + Z80.toHexWord(address));
        }
        if (this.romFlags[memorySegment = address / 1024]) {
            if (address >= 48640 && address <= 48642) {
                this._diskSystem.write(address - 48640, newByte);
            }
            return;
        }
        if (address >= 61568 && address < 63488) {
            this.screenFlags[address - 61568] = true;
        } else if (address >= 64512) {
            int characterIndex = (address - 64512 >> 3) + 128;
            int characterRow = address & 7;
            if (this.characterImages == null) {
                this.setupScreenCharacters();
            }
            Graphics g = this.characterImages.getGraphics();
            g.setColor(Color.black);
            g.translate(characterIndex << 3, characterRow);
            g.fillRect(0, 0, 8, 1);
            g.setColor(Color.white);
            int b = newByte;
            int i = 0;
            while (i < 8) {
                if ((b & 0x80) != 0) {
                    g.fillRect(i, 0, 1, 1);
                }
                b <<= 1;
                ++i;
            }
            g.translate(0, 0);
            this.characterFlags[characterIndex - 128] = true;
        }
        this.mem[address] = newByte;
    }

    public void start() {
        this.thread = new Thread((Runnable)this, "JSorcerer");
        this.thread.start();
    }

    public void stop() {
        this.abort();
        try {
            this.thread.join();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.thread = null;
    }

    @Override
    public void run() {
        try {
            this.timeOfLastSample = this.timeOfLastInterrupt = System.currentTimeMillis();
            this.execute();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public final void loadCom(InputStream is, boolean autorun) throws IOException {
        try {
            int b;
            int m = 256;
            while ((b = is.read()) != -1) {
                this.pokeb(m++, b);
            }
            int l = m - 256;
            LOGGER.log(Level.INFO, "Read .COM to 0x100 with length 0x" + Integer.toHexString(l));
            int b2 = l + 255 >> 8;
            LOGGER.log(Level.INFO, "If you are in CP/M you may want to save this file to disk with the following: SAVE " + b2 + " <filename>.COM");
            if (autorun) {
                this.PC(256);
            }
        }
        finally {
            is.close();
        }
    }

    public final void loadBin(InputStream is, boolean autorun) throws IOException {
        byte[] preamble = new byte[7];
        if (is.read(preamble) != preamble.length) {
            throw new IOException("Failed to load BIN file preamble");
        }
        StringBuilder name = new StringBuilder();
        while (true) {
            int b;
            if ((b = is.read()) == -1) {
                throw new IOException("Failed to load BIN file name");
            }
            if (b == 26) break;
            if (b == 0) continue;
            name.append((char)b);
        }
        byte[] args = new byte[6];
        if (is.read(args) != args.length) {
            throw new IOException("Failed to load BIN file args");
        }
        int exec = (args[0] & 0xFF) + ((args[1] & 0xFF) << 8);
        int start = (args[2] & 0xFF) + ((args[3] & 0xFF) << 8);
        int end = (args[4] & 0xFF) + ((args[5] & 0xFF) << 8);
        int size = end - start + 1 & 0xFFFF;
        LOGGER.log(Level.INFO, "Reading " + name + " exec=" + Integer.toHexString(exec) + " start=" + Integer.toHexString(start) + " end=" + Integer.toHexString(end) + " size=" + Integer.toHexString(size));
        try {
            int m = start;
            while (m <= end) {
                int b = is.read();
                if (b == -1) break;
                this.pokeb(m++, b);
            }
            int l = m - start;
            if (start == 469 || exec == 51288) {
                int[] nArray = new int[11];
                nArray[0] = 205;
                nArray[1] = 38;
                nArray[2] = 196;
                nArray[3] = 33;
                nArray[4] = 212;
                nArray[5] = 1;
                nArray[6] = 54;
                nArray[8] = 195;
                nArray[9] = 137;
                nArray[10] = 198;
                int[] fixupData = nArray;
                int i = 0;
                while (i < 11) {
                    this.pokeb(61471 + i, fixupData[i]);
                    ++i;
                }
                if (!autorun) {
                    this.pokew(61480, 50141);
                }
                this.pokeb(439, end & 0xFF);
                this.pokeb(440, end >> 8);
                if (autorun && exec != 51288) {
                    this.pokew(61480, exec);
                }
                this.PC(61471);
            } else if (autorun) {
                this.PC(start);
            }
        }
        finally {
            is.close();
        }
    }

    @Override
    public final int interrupt() {
        if (this.refreshNextInterrupt) {
            this.refreshNextInterrupt = false;
            this.refreshWholeScreen();
        }
        if (this.resetAtNextInterrupt) {
            this.resetAtNextInterrupt = false;
            this.reset();
        }
        if (this.takeSnapshotNextInterrupt) {
            this.takeSnapshotNextInterrupt = false;
            try {
                this.saveSNP(new FileOutputStream("first.snp"));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        ++this.interruptCounter;
        if (this.parentGraphics == null) {
            this.parentGraphics = this.parent.getGraphics();
        }
        this.writeScreenImage(this.parentGraphics);
        if ((this.interruptCounter & 1) == 0) {
            this._diskSystem.tick();
        }
        this.timeOfLastInterrupt = System.currentTimeMillis();
        long durOfLastInterrupt = this.timeOfLastInterrupt - this.timeOfLastSample;
        this.timeOfLastSample = this.timeOfLastInterrupt;
        if (!this.runAtFullSpeed) {
            this.runningAverage -= this.runningAverage / 16L;
            this.runningAverage += durOfLastInterrupt;
            if (this.runningAverage > 320L && this.delayPeriod > 0) {
                --this.delayPeriod;
            }
            if (this.runningAverage < 310L) {
                ++this.delayPeriod;
            }
            if (this.delayPeriod > 0) {
                try {
                    Thread.sleep(this.delayPeriod);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (this.sleepHack > 0) {
            try {
                Thread.sleep(this.sleepHack);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return super.interrupt();
    }

    public void repaint() {
        this.refreshNextInterrupt = true;
    }

    @Override
    public void reset() {
        super.reset();
        this.PC(57344);
    }

    public final void toggleSpeed() {
        this.runAtFullSpeed = !this.runAtFullSpeed;
    }

    public final void runFullSpeed(boolean fullSpeed) {
        this.runAtFullSpeed = fullSpeed;
    }

    public void showMessage(String m) {
        System.out.println(m);
    }

    public void setupScreenCharacters() {
        if (this.characterImages == null) {
            this.characterImages = this.parent.createImage(2048, 8);
        }
        int p = 63488;
        int i = 0;
        while (i < 256) {
            Graphics g = this.characterImages.getGraphics();
            g.translate(i * 8, 0);
            g.setColor(Color.black);
            g.fillRect(0, 0, 8, 8);
            g.setColor(Color.white);
            int j = 0;
            while (j < 8) {
                int b = this.mem[p++];
                int k = 0;
                while (k < 8) {
                    if ((b & 0x80) != 0) {
                        g.fillRect(k, j, 1, 1);
                    }
                    b <<= 1;
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < 128) {
            this.characterFlags[i] = false;
            ++i;
        }
    }

    public void writeScreenImage(Graphics parentGraphics) {
        int i = 0;
        while (i < 128) {
            if (this.characterFlags[i]) {
                this.characterFlags[i] = false;
                this.refreshCharacter(i + 128);
            }
            ++i;
        }
        parentGraphics.translate(this.offsetX, this.offsetY);
        int nChars = 1920;
        int p = 0;
        while (p < nChars) {
            if (this.screenFlags[p]) {
                int row = p >> 6 << 4;
                int col = (p & 0x3F) << 3;
                int c = this.mem[p + 61568] << 3;
                parentGraphics.drawImage(this.characterImages, col, row, col + 8, row + 16, c, 0, c + 8, 8, null);
                this.screenFlags[p] = false;
            }
            ++p;
        }
        parentGraphics.translate(-this.offsetX, -this.offsetY);
    }

    public void resetKeyboard() {
        this._keyCharHandlers = new TreeMap<Character, KeyHanlder>();
        this._keyCodeHandlers = new TreeMap<Integer, KeyHanlder>();
        this._keyboard.reset();
        this.setupKeyHandlers();
        if (this.useHardKeyMap) {
            this.setupKeyCodeHandlers();
        } else {
            this.setupKeyCharHandlers();
        }
    }

    private void setupKeyCharHandlers() {
        this._keyCharHandlers = new TreeMap<Character, KeyHanlder>();
        KeyLineAndBitHandler shiftKeyhandler = new KeyLineAndBitHandler(0, 4, "SHIFT"){

            @Override
            public void doKey(boolean down, int code) {
                super.doKey(down, 16);
            }
        };
        KeyLineAndBitHandler ctrlKeyhandler = new KeyLineAndBitHandler(0, 2, "CTRL"){

            @Override
            public void doKey(boolean down, int code) {
                super.doKey(down, 17);
            }
        };
        this._keyCharHandlers.put(Character.valueOf('\u001b'), new KeyLineAndBitHandler(0, 0, "ESC"));
        this._keyCharHandlers.put(Character.valueOf('\t'), new KeyLineAndBitHandler(1, 3, "Tab"));
        KeyLineAndBitHandler xKeyHandler = new KeyLineAndBitHandler(2, 0, "X");
        this._keyCharHandlers.put(Character.valueOf('X'), new CompoundKeyHandler(shiftKeyhandler, xKeyHandler));
        this._keyCharHandlers.put(Character.valueOf('x'), xKeyHandler);
        this._keyCharHandlers.put(Character.valueOf('\u0018'), new CompoundKeyHandler(ctrlKeyhandler, xKeyHandler));
        KeyLineAndBitHandler zKeyHandler = new KeyLineAndBitHandler(2, 1, "Z");
        this._keyCharHandlers.put(Character.valueOf('Z'), new CompoundKeyHandler(shiftKeyhandler, zKeyHandler));
        this._keyCharHandlers.put(Character.valueOf('z'), zKeyHandler);
        this._keyCharHandlers.put(Character.valueOf('\u001a'), new CompoundKeyHandler(ctrlKeyhandler, zKeyHandler));
        KeyLineAndBitHandler aKeyHandler = new KeyLineAndBitHandler(2, 2, "A");
        this._keyCharHandlers.put(Character.valueOf('A'), new CompoundKeyHandler(shiftKeyhandler, aKeyHandler));
        this._keyCharHandlers.put(Character.valueOf('a'), aKeyHandler);
        this._keyCharHandlers.put(Character.valueOf('\u0001'), new CompoundKeyHandler(ctrlKeyhandler, aKeyHandler));
        KeyLineAndBitHandler qKeyHandler = new KeyLineAndBitHandler(2, 3, "Q");
        this._keyCharHandlers.put(Character.valueOf('Q'), new CompoundKeyHandler(shiftKeyhandler, qKeyHandler));
        this._keyCharHandlers.put(Character.valueOf('q'), qKeyHandler);
        this._keyCharHandlers.put(Character.valueOf('\u0011'), new CompoundKeyHandler(ctrlKeyhandler, qKeyHandler));
        KeyLineAndBitHandler cKeyHandler = new KeyLineAndBitHandler(3, 0, "C");
        this._keyCharHandlers.put(Character.valueOf('C'), new CompoundKeyHandler(shiftKeyhandler, cKeyHandler));
        this._keyCharHandlers.put(Character.valueOf('c'), cKeyHandler);
        this._keyCharHandlers.put(Character.valueOf('\u0003'), new CompoundKeyHandler(ctrlKeyhandler, cKeyHandler));
        KeyLineAndBitHandler dKeyHandler = new KeyLineAndBitHandler(3, 1, "D");
        this._keyCharHandlers.put(Character.valueOf('D'), new CompoundKeyHandler(shiftKeyhandler, dKeyHandler));
        this._keyCharHandlers.put(Character.valueOf('d'), dKeyHandler);
        this._keyCharHandlers.put(Character.valueOf('\u0004'), new CompoundKeyHandler(ctrlKeyhandler, dKeyHandler));
        KeyLineAndBitHandler sKeyHandler = new KeyLineAndBitHandler(3, 2, "S");
        this._keyCharHandlers.put(Character.valueOf('S'), new CompoundKeyHandler(shiftKeyhandler, sKeyHandler));
        this._keyCharHandlers.put(Character.valueOf('s'), sKeyHandler);
        this._keyCharHandlers.put(Character.valueOf('\u0013'), new CompoundKeyHandler(ctrlKeyhandler, sKeyHandler));
        KeyLineAndBitHandler wKeyHandler = new KeyLineAndBitHandler(3, 3, "W");
        this._keyCharHandlers.put(Character.valueOf('W'), new CompoundKeyHandler(shiftKeyhandler, wKeyHandler));
        this._keyCharHandlers.put(Character.valueOf('w'), wKeyHandler);
        this._keyCharHandlers.put(Character.valueOf('\u0017'), new CompoundKeyHandler(ctrlKeyhandler, wKeyHandler));
        KeyLineAndBitHandler fKeyHandler = new KeyLineAndBitHandler(4, 0, "F");
        this._keyCharHandlers.put(Character.valueOf('F'), new CompoundKeyHandler(shiftKeyhandler, fKeyHandler));
        this._keyCharHandlers.put(Character.valueOf('f'), fKeyHandler);
        this._keyCharHandlers.put(Character.valueOf('\u0006'), new CompoundKeyHandler(ctrlKeyhandler, fKeyHandler));
        KeyLineAndBitHandler rKeyHandler = new KeyLineAndBitHandler(4, 1, "R");
        this._keyCharHandlers.put(Character.valueOf('R'), new CompoundKeyHandler(shiftKeyhandler, rKeyHandler));
        this._keyCharHandlers.put(Character.valueOf('r'), rKeyHandler);
        this._keyCharHandlers.put(Character.valueOf('\u0012'), new CompoundKeyHandler(ctrlKeyhandler, rKeyHandler));
        KeyLineAndBitHandler eKeyHandler = new KeyLineAndBitHandler(4, 2, "E");
        this._keyCharHandlers.put(Character.valueOf('E'), new CompoundKeyHandler(shiftKeyhandler, eKeyHandler));
        this._keyCharHandlers.put(Character.valueOf('e'), eKeyHandler);
        this._keyCharHandlers.put(Character.valueOf('\u0005'), new CompoundKeyHandler(ctrlKeyhandler, eKeyHandler));
        KeyLineAndBitHandler bKeyHandler = new KeyLineAndBitHandler(5, 0, "B");
        this._keyCharHandlers.put(Character.valueOf('B'), new CompoundKeyHandler(shiftKeyhandler, bKeyHandler));
        this._keyCharHandlers.put(Character.valueOf('b'), bKeyHandler);
        this._keyCharHandlers.put(Character.valueOf('\u0002'), new CompoundKeyHandler(ctrlKeyhandler, bKeyHandler));
        KeyLineAndBitHandler vKeyHandler = new KeyLineAndBitHandler(5, 1, "V");
        this._keyCharHandlers.put(Character.valueOf('V'), new CompoundKeyHandler(shiftKeyhandler, vKeyHandler));
        this._keyCharHandlers.put(Character.valueOf('v'), vKeyHandler);
        this._keyCharHandlers.put(Character.valueOf('\u0016'), new CompoundKeyHandler(ctrlKeyhandler, vKeyHandler));
        KeyLineAndBitHandler gKeyHandler = new KeyLineAndBitHandler(5, 2, "G");
        this._keyCharHandlers.put(Character.valueOf('G'), new CompoundKeyHandler(shiftKeyhandler, gKeyHandler));
        this._keyCharHandlers.put(Character.valueOf('g'), gKeyHandler);
        this._keyCharHandlers.put(Character.valueOf('\u0007'), new CompoundKeyHandler(ctrlKeyhandler, gKeyHandler));
        KeyLineAndBitHandler tKeyHandler = new KeyLineAndBitHandler(5, 3, "T");
        this._keyCharHandlers.put(Character.valueOf('T'), new CompoundKeyHandler(shiftKeyhandler, tKeyHandler));
        this._keyCharHandlers.put(Character.valueOf('t'), tKeyHandler);
        this._keyCharHandlers.put(Character.valueOf('\u0014'), new CompoundKeyHandler(ctrlKeyhandler, tKeyHandler));
        KeyLineAndBitHandler mKeyHandler = new KeyLineAndBitHandler(6, 0, "M");
        this._keyCharHandlers.put(Character.valueOf('M'), new CompoundKeyHandler(shiftKeyhandler, mKeyHandler));
        this._keyCharHandlers.put(Character.valueOf('m'), mKeyHandler);
        this._keyCharHandlers.put(Character.valueOf('\r'), new CompoundKeyHandler(ctrlKeyhandler, mKeyHandler));
        KeyLineAndBitHandler nKeyHandler = new KeyLineAndBitHandler(6, 1, "N");
        this._keyCharHandlers.put(Character.valueOf('N'), new CompoundKeyHandler(shiftKeyhandler, nKeyHandler));
        this._keyCharHandlers.put(Character.valueOf('n'), nKeyHandler);
        this._keyCharHandlers.put(Character.valueOf('\u000e'), new CompoundKeyHandler(ctrlKeyhandler, nKeyHandler));
        KeyLineAndBitHandler hKeyHandler = new KeyLineAndBitHandler(6, 2, "H");
        this._keyCharHandlers.put(Character.valueOf('H'), new CompoundKeyHandler(shiftKeyhandler, hKeyHandler));
        this._keyCharHandlers.put(Character.valueOf('h'), hKeyHandler);
        KeyLineAndBitHandler yKeyHandler = new KeyLineAndBitHandler(6, 3, "Y");
        this._keyCharHandlers.put(Character.valueOf('Y'), new CompoundKeyHandler(shiftKeyhandler, yKeyHandler));
        this._keyCharHandlers.put(Character.valueOf('y'), yKeyHandler);
        this._keyCharHandlers.put(Character.valueOf('\u0019'), new CompoundKeyHandler(ctrlKeyhandler, yKeyHandler));
        KeyLineAndBitHandler kKeyHandler = new KeyLineAndBitHandler(7, 0, "K");
        this._keyCharHandlers.put(Character.valueOf('K'), new CompoundKeyHandler(shiftKeyhandler, kKeyHandler));
        this._keyCharHandlers.put(Character.valueOf('k'), kKeyHandler);
        this._keyCharHandlers.put(Character.valueOf('\u000b'), new CompoundKeyHandler(ctrlKeyhandler, kKeyHandler));
        KeyLineAndBitHandler iKeyHandler = new KeyLineAndBitHandler(7, 1, "I");
        this._keyCharHandlers.put(Character.valueOf('I'), new CompoundKeyHandler(shiftKeyhandler, iKeyHandler));
        this._keyCharHandlers.put(Character.valueOf('i'), iKeyHandler);
        KeyLineAndBitHandler jKeyHandler = new KeyLineAndBitHandler(7, 2, "J");
        this._keyCharHandlers.put(Character.valueOf('J'), new CompoundKeyHandler(shiftKeyhandler, jKeyHandler));
        this._keyCharHandlers.put(Character.valueOf('j'), jKeyHandler);
        KeyLineAndBitHandler uKeyHandler = new KeyLineAndBitHandler(7, 3, "U");
        this._keyCharHandlers.put(Character.valueOf('U'), new CompoundKeyHandler(shiftKeyhandler, uKeyHandler));
        this._keyCharHandlers.put(Character.valueOf('u'), uKeyHandler);
        this._keyCharHandlers.put(Character.valueOf('\u0015'), new CompoundKeyHandler(ctrlKeyhandler, uKeyHandler));
        this._keyCharHandlers.put(Character.valueOf(','), new KeyLineAndBitHandler(8, 0, ","));
        this._keyCharHandlers.put(Character.valueOf('<'), new CompoundKeyHandler(shiftKeyhandler, new KeyLineAndBitHandler(8, 0, "<")));
        KeyLineAndBitHandler lKeyHandler = new KeyLineAndBitHandler(8, 1, "L");
        this._keyCharHandlers.put(Character.valueOf('L'), new CompoundKeyHandler(shiftKeyhandler, lKeyHandler));
        this._keyCharHandlers.put(Character.valueOf('l'), lKeyHandler);
        this._keyCharHandlers.put(Character.valueOf('\f'), new CompoundKeyHandler(ctrlKeyhandler, lKeyHandler));
        KeyLineAndBitHandler oKeyHandler = new KeyLineAndBitHandler(8, 2, "O");
        this._keyCharHandlers.put(Character.valueOf('O'), new CompoundKeyHandler(shiftKeyhandler, oKeyHandler));
        this._keyCharHandlers.put(Character.valueOf('o'), oKeyHandler);
        this._keyCharHandlers.put(Character.valueOf('\u000f'), new CompoundKeyHandler(ctrlKeyhandler, oKeyHandler));
        this._keyCharHandlers.put(Character.valueOf('1'), new AmbiguousCharKeyHandler(49, new KeyLineAndBitHandler(2, 4, "1"), 97, new KeyLineAndBitHandler(13, 1, "NUMPAD1")));
        this._keyCharHandlers.put(Character.valueOf('!'), new CompoundKeyHandler(shiftKeyhandler, new KeyLineAndBitHandler(2, 4, "!")));
        this._keyCharHandlers.put(Character.valueOf('2'), new AmbiguousCharKeyHandler(50, new KeyLineAndBitHandler(3, 4, "2"), 98, new KeyLineAndBitHandler(14, 1, "NUMPAD2")));
        this._keyCharHandlers.put(Character.valueOf('\"'), new CompoundKeyHandler(shiftKeyhandler, new KeyLineAndBitHandler(3, 4, "\"")));
        this._keyCharHandlers.put(Character.valueOf('3'), new AmbiguousCharKeyHandler(51, new KeyLineAndBitHandler(4, 4, "3"), 99, new KeyLineAndBitHandler(15, 4, "NUMPAD3")));
        this._keyCharHandlers.put(Character.valueOf('#'), new CompoundKeyHandler(shiftKeyhandler, new KeyLineAndBitHandler(4, 4, "#")));
        this._keyCharHandlers.put(Character.valueOf('4'), new AmbiguousCharKeyHandler(52, new KeyLineAndBitHandler(4, 3, "4"), 100, new KeyLineAndBitHandler(13, 2, "NUMPAD4")));
        this._keyCharHandlers.put(Character.valueOf('$'), new CompoundKeyHandler(shiftKeyhandler, new KeyLineAndBitHandler(4, 3, "$")));
        this._keyCharHandlers.put(Character.valueOf('5'), new AmbiguousCharKeyHandler(53, new KeyLineAndBitHandler(5, 4, "5"), 101, new KeyLineAndBitHandler(14, 2, "NUMPAD5")));
        this._keyCharHandlers.put(Character.valueOf('%'), new CompoundKeyHandler(shiftKeyhandler, new KeyLineAndBitHandler(5, 4, "%")));
        this._keyCharHandlers.put(Character.valueOf('6'), new AmbiguousCharKeyHandler(54, new KeyLineAndBitHandler(6, 4, "6"), 102, new KeyLineAndBitHandler(14, 3, "NUMPAD6")));
        this._keyCharHandlers.put(Character.valueOf('&'), new CompoundKeyHandler(shiftKeyhandler, new KeyLineAndBitHandler(6, 4, "&")));
        this._keyCharHandlers.put(Character.valueOf('7'), new AmbiguousCharKeyHandler(55, new KeyLineAndBitHandler(7, 4, "7"), 103, new KeyLineAndBitHandler(13, 4, "NUMPAD7")));
        this._keyCharHandlers.put(Character.valueOf('\''), new CompoundKeyHandler(shiftKeyhandler, new KeyLineAndBitHandler(7, 4, "'")));
        this._keyCharHandlers.put(Character.valueOf('8'), new AmbiguousCharKeyHandler(56, new KeyLineAndBitHandler(8, 4, "8"), 104, new KeyLineAndBitHandler(13, 3, "NUMPAD8")));
        this._keyCharHandlers.put(Character.valueOf('('), new CompoundKeyHandler(shiftKeyhandler, new KeyLineAndBitHandler(8, 4, "(")));
        this._keyCharHandlers.put(Character.valueOf('9'), new AmbiguousCharKeyHandler(57, new KeyLineAndBitHandler(8, 3, "9"), 105, new KeyLineAndBitHandler(14, 4, "NUMPAD9")));
        this._keyCharHandlers.put(Character.valueOf(')'), new CompoundKeyHandler(shiftKeyhandler, new KeyLineAndBitHandler(8, 3, ")")));
        this._keyCharHandlers.put(Character.valueOf('/'), new KeyLineAndBitHandler(9, 0, "/"));
        this._keyCharHandlers.put(Character.valueOf('?'), new CompoundKeyHandler(shiftKeyhandler, new KeyLineAndBitHandler(9, 0, "?")));
        this._keyCharHandlers.put(Character.valueOf('.'), new KeyLineAndBitHandler(9, 1, "."));
        this._keyCharHandlers.put(Character.valueOf('>'), new CompoundKeyHandler(shiftKeyhandler, new KeyLineAndBitHandler(9, 1, ">")));
        this._keyCharHandlers.put(Character.valueOf(';'), new KeyLineAndBitHandler(9, 2, ";"));
        KeyLineAndBitHandler pKeyHandler = new KeyLineAndBitHandler(9, 3, "P");
        this._keyCharHandlers.put(Character.valueOf('P'), new CompoundKeyHandler(shiftKeyhandler, pKeyHandler));
        this._keyCharHandlers.put(Character.valueOf('p'), pKeyHandler);
        this._keyCharHandlers.put(Character.valueOf('\u0010'), new CompoundKeyHandler(ctrlKeyhandler, pKeyHandler));
        this._keyCharHandlers.put(Character.valueOf('0'), new AmbiguousCharKeyHandler(48, new KeyLineAndBitHandler(9, 4, "0"), 96, new KeyLineAndBitHandler(13, 0, "NUMPAD0")));
        this._keyCharHandlers.put(Character.valueOf('\\'), new KeyLineAndBitHandler(10, 0, "\\"));
        this._keyCharHandlers.put(Character.valueOf('|'), new CompoundKeyHandler(shiftKeyhandler, new KeyLineAndBitHandler(10, 0, "|")));
        this._keyCharHandlers.put(Character.valueOf('@'), new KeyLineAndBitHandler(10, 1, "@"));
        this._keyCharHandlers.put(Character.valueOf('`'), new CompoundKeyHandler(shiftKeyhandler, new KeyLineAndBitHandler(10, 1, "`")));
        this._keyCharHandlers.put(Character.valueOf('~'), new CompoundKeyHandler(shiftKeyhandler, new KeyLineAndBitHandler(11, 3, "~")));
        this._keyCharHandlers.put(Character.valueOf(']'), new KeyLineAndBitHandler(10, 2, "]"));
        this._keyCharHandlers.put(Character.valueOf('}'), new CompoundKeyHandler(shiftKeyhandler, new KeyLineAndBitHandler(10, 2, "}")));
        this._keyCharHandlers.put(Character.valueOf('['), new KeyLineAndBitHandler(10, 3, "["));
        this._keyCharHandlers.put(Character.valueOf('{'), new CompoundKeyHandler(shiftKeyhandler, new KeyLineAndBitHandler(10, 3, "{")));
        this._keyCharHandlers.put(Character.valueOf('\b'), new CompoundKeyHandler(ctrlKeyhandler, hKeyHandler));
        this._keyCharHandlers.put(Character.valueOf('_'), new KeyLineAndBitHandler(11, 0, "UNDERSCORE"));
        this._keyCharHandlers.put(Character.valueOf('\n'), new KeyLineAndBitHandler(11, 1, "ENTER"));
        this._keyCharHandlers.put(Character.valueOf('^'), new KeyLineAndBitHandler(11, 3, "^"));
        this._keyCharHandlers.put(Character.valueOf(' '), new KeyLineAndBitHandler(1, 2, " "));
        this._keyCharHandlers.put(Character.valueOf('='), new KeyLineAndBitHandler(15, 3, "="));
        this._keyCharHandlers.put(Character.valueOf('-'), new KeyLineAndBitHandler(11, 4, "-"));
        this._keyCharHandlers.put(Character.valueOf('+'), new KeyLineAndBitHandler(12, 0, "+"));
        this._keyCharHandlers.put(Character.valueOf(':'), new KeyLineAndBitHandler(10, 4, ":"));
        this._keyCharHandlers.put(Character.valueOf('*'), new KeyLineAndBitHandler(12, 1, "*"));
        this._keyCharHandlers.put(Character.valueOf('.'), new KeyLineAndBitHandler(14, 0, "."));
        this._keyCodeHandlers.put(new Integer(112), new KeyLineAndBitHandler(0, 1, "Graphics"));
        this._keyCodeHandlers.put(new Integer(121), new KeyLineAndBitHandler(0, 2, "CTRL"));
    }

    private void setupKeyCodeHandlers() {
        this._keyCodeHandlers.put(new Integer(27), new KeyLineAndBitHandler(0, 0, "ESC"));
        this._keyCodeHandlers.put(new Integer(112), new KeyLineAndBitHandler(0, 1, "Graphics"));
        this._keyCodeHandlers.put(new Integer(17), new KeyLineAndBitHandler(0, 2, "CTRL"));
        this._keyCodeHandlers.put(new Integer(16), new KeyLineAndBitHandler(0, 4, "SHIFT"));
        this._keyCodeHandlers.put(new Integer(117), new KeyLineAndBitHandler(1, 0, "Clear"));
        this._keyCodeHandlers.put(new Integer(118), new KeyLineAndBitHandler(1, 1, "Repeat"));
        this._keyCodeHandlers.put(new Integer(119), new KeyLineAndBitHandler(1, 3, "Tab"));
        this._keyCodeHandlers.put(new Integer(36), new KeyLineAndBitHandler(1, 4, "Unknown"));
        this._keyCodeHandlers.put(new Integer(88), new KeyLineAndBitHandler(2, 0, "X"));
        this._keyCodeHandlers.put(new Integer(90), new KeyLineAndBitHandler(2, 1, "Z"));
        this._keyCodeHandlers.put(new Integer(65), new KeyLineAndBitHandler(2, 2, "A"));
        this._keyCodeHandlers.put(new Integer(81), new KeyLineAndBitHandler(2, 3, "Q"));
        this._keyCodeHandlers.put(new Integer(49), new KeyLineAndBitHandler(2, 4, "1"));
        this._keyCodeHandlers.put(new Integer(67), new KeyLineAndBitHandler(3, 0, "C"));
        this._keyCodeHandlers.put(new Integer(68), new KeyLineAndBitHandler(3, 1, "D"));
        this._keyCodeHandlers.put(new Integer(83), new KeyLineAndBitHandler(3, 2, "S"));
        this._keyCodeHandlers.put(new Integer(87), new KeyLineAndBitHandler(3, 3, "W"));
        this._keyCodeHandlers.put(new Integer(50), new KeyLineAndBitHandler(3, 4, "Z"));
        this._keyCodeHandlers.put(new Integer(70), new KeyLineAndBitHandler(4, 0, "F"));
        this._keyCodeHandlers.put(new Integer(82), new KeyLineAndBitHandler(4, 1, "R"));
        this._keyCodeHandlers.put(new Integer(69), new KeyLineAndBitHandler(4, 2, "E"));
        this._keyCodeHandlers.put(new Integer(52), new KeyLineAndBitHandler(4, 3, "4"));
        this._keyCodeHandlers.put(new Integer(51), new KeyLineAndBitHandler(4, 4, "3"));
        this._keyCodeHandlers.put(new Integer(66), new KeyLineAndBitHandler(5, 0, "B"));
        this._keyCodeHandlers.put(new Integer(86), new KeyLineAndBitHandler(5, 1, "V"));
        this._keyCodeHandlers.put(new Integer(71), new KeyLineAndBitHandler(5, 2, "G"));
        this._keyCodeHandlers.put(new Integer(84), new KeyLineAndBitHandler(5, 3, "T"));
        this._keyCodeHandlers.put(new Integer(53), new KeyLineAndBitHandler(5, 4, "5"));
        this._keyCodeHandlers.put(new Integer(77), new KeyLineAndBitHandler(6, 0, "M"));
        this._keyCodeHandlers.put(new Integer(78), new KeyLineAndBitHandler(6, 1, "N"));
        this._keyCodeHandlers.put(new Integer(72), new KeyLineAndBitHandler(6, 2, "H"));
        this._keyCodeHandlers.put(new Integer(89), new KeyLineAndBitHandler(6, 3, "Y"));
        this._keyCodeHandlers.put(new Integer(54), new KeyLineAndBitHandler(6, 4, "6"));
        this._keyCodeHandlers.put(new Integer(75), new KeyLineAndBitHandler(7, 0, "K"));
        this._keyCodeHandlers.put(new Integer(73), new KeyLineAndBitHandler(7, 1, "I"));
        this._keyCodeHandlers.put(new Integer(74), new KeyLineAndBitHandler(7, 2, "J"));
        this._keyCodeHandlers.put(new Integer(85), new KeyLineAndBitHandler(7, 3, "U"));
        this._keyCodeHandlers.put(new Integer(55), new KeyLineAndBitHandler(7, 4, "7"));
        this._keyCodeHandlers.put(new Integer(188), new KeyLineAndBitHandler(8, 0, ","));
        this._keyCodeHandlers.put(new Integer(44), new KeyLineAndBitHandler(8, 0, ","));
        this._keyCodeHandlers.put(new Integer(76), new KeyLineAndBitHandler(8, 1, "L"));
        this._keyCodeHandlers.put(new Integer(79), new KeyLineAndBitHandler(8, 2, "O"));
        this._keyCodeHandlers.put(new Integer(57), new KeyLineAndBitHandler(8, 3, "9"));
        this._keyCodeHandlers.put(new Integer(56), new KeyLineAndBitHandler(8, 4, "8"));
        this._keyCodeHandlers.put(new Integer(191), new KeyLineAndBitHandler(9, 0, "/"));
        this._keyCodeHandlers.put(new Integer(47), new KeyLineAndBitHandler(9, 0, "/"));
        this._keyCodeHandlers.put(new Integer(190), new KeyLineAndBitHandler(9, 1, "Unknown"));
        this._keyCodeHandlers.put(new Integer(46), new KeyLineAndBitHandler(9, 1, "Unknown"));
        this._keyCodeHandlers.put(new Integer(59), new KeyLineAndBitHandler(9, 2, ";"));
        this._keyCodeHandlers.put(new Integer(80), new KeyLineAndBitHandler(9, 3, "P"));
        this._keyCodeHandlers.put(new Integer(48), new KeyLineAndBitHandler(9, 4, "0"));
        this._keyCodeHandlers.put(new Integer(220), new KeyLineAndBitHandler(10, 0, "\\"));
        this._keyCodeHandlers.put(new Integer(92), new KeyLineAndBitHandler(10, 0, "\\"));
        this._keyCodeHandlers.put(new Integer(520), new KeyLineAndBitHandler(10, 1, "@"));
        this._keyCodeHandlers.put(new Integer(221), new KeyLineAndBitHandler(10, 2, ")"));
        this._keyCodeHandlers.put(new Integer(93), new KeyLineAndBitHandler(10, 2, ")"));
        this._keyCodeHandlers.put(new Integer(162), new KeyLineAndBitHandler(10, 2, ")"));
        this._keyCodeHandlers.put(new Integer(219), new KeyLineAndBitHandler(10, 3, "("));
        this._keyCodeHandlers.put(new Integer(91), new KeyLineAndBitHandler(10, 3, "("));
        this._keyCodeHandlers.put(new Integer(161), new KeyLineAndBitHandler(10, 3, "("));
        this._keyCodeHandlers.put(new Integer(123), new KeyLineAndBitHandler(10, 4, "Quote"));
        this._keyCodeHandlers.put(new Integer(222), new KeyLineAndBitHandler(10, 4, "Quote"));
        this._keyCodeHandlers.put(new Integer(8), new KeyLineAndBitHandler(11, 0, "BACK SPACE"));
        this._keyCodeHandlers.put(new Integer(10), new KeyLineAndBitHandler(11, 1, "ENTER"));
        this._keyCodeHandlers.put(new Integer(192), new KeyLineAndBitHandler(11, 3, "^"));
        this._keyCodeHandlers.put(new Integer(45), new KeyLineAndBitHandler(11, 4, "-"));
        this._keyCodeHandlers.put(new Integer(107), new KeyLineAndBitHandler(12, 0, "+"));
        this._keyCodeHandlers.put(new Integer(521), new KeyLineAndBitHandler(12, 0, "+"));
        this._keyCodeHandlers.put(new Integer(106), new KeyLineAndBitHandler(12, 1, "*"));
        this._keyCodeHandlers.put(new Integer(151), new KeyLineAndBitHandler(12, 1, "*"));
        this._keyCodeHandlers.put(new Integer(111), new KeyLineAndBitHandler(12, 2, "/"));
        this._keyCodeHandlers.put(new Integer(189), new KeyLineAndBitHandler(12, 3, "-"));
        this._keyCodeHandlers.put(new Integer(109), new KeyLineAndBitHandler(12, 3, "-"));
        this._keyCodeHandlers.put(new Integer(32), new KeyLineAndBitHandler(1, 2, "SPACE"));
        this._keyCodeHandlers.put(new Integer(96), new KeyLineAndBitHandler(13, 0, "NUMPAD0"));
        this._keyCodeHandlers.put(new Integer(97), new KeyLineAndBitHandler(13, 1, "NUMPAD1"));
        this._keyCodeHandlers.put(new Integer(100), new KeyLineAndBitHandler(13, 2, "NUMPAD4"));
        this._keyCodeHandlers.put(new Integer(104), new KeyLineAndBitHandler(13, 3, "NUMPAD8"));
        this._keyCodeHandlers.put(new Integer(103), new KeyLineAndBitHandler(13, 4, "NUMPAD7"));
        this._keyCodeHandlers.put(new Integer(65480), new KeyLineAndBitHandler(14, 0, "."));
        this._keyCodeHandlers.put(new Integer(98), new KeyLineAndBitHandler(14, 1, "NUMPAD2"));
        this._keyCodeHandlers.put(new Integer(101), new KeyLineAndBitHandler(14, 2, "NUMPAD5"));
        this._keyCodeHandlers.put(new Integer(102), new KeyLineAndBitHandler(14, 3, "NUMPAD6"));
        this._keyCodeHandlers.put(new Integer(105), new KeyLineAndBitHandler(14, 4, "NUMPAD"));
        this._keyCodeHandlers.put(new Integer(127), new KeyLineAndBitHandler(15, 0, "DELETE"));
        this._keyCodeHandlers.put(new Integer(116), new KeyLineAndBitHandler(15, 2, "Unknown"));
        this._keyCodeHandlers.put(new Integer(187), new KeyLineAndBitHandler(15, 3, "Numpad ="));
        this._keyCodeHandlers.put(new Integer(61), new KeyLineAndBitHandler(15, 3, "Numpad ="));
        this._keyCodeHandlers.put(new Integer(99), new KeyLineAndBitHandler(15, 4, "NUMPAD3"));
        this._keyCodeHandlers.put(new Integer(20), new KeyHanlder(){

            @Override
            public void doKey(boolean down, int keyCode) {
                if (down) {
                    Sorcerer.this._keyboard.toggleCapsLock();
                }
            }
        });
    }

    private void setupKeyHandlers() {
        this._keyCodeHandlers = new TreeMap<Integer, KeyHanlder>();
        this._keyCodeHandlers.put(new Integer(40), new KeyLineAndBitHandler(14, 1, "NUMPAD2"));
        this._keyCodeHandlers.put(new Integer(38), new KeyLineAndBitHandler(13, 3, "NUMPAD8"));
        this._keyCodeHandlers.put(new Integer(37), new KeyLineAndBitHandler(13, 2, "NUMPAD4"));
        this._keyCodeHandlers.put(new Integer(39), new KeyLineAndBitHandler(14, 3, "NUMPAD6"));
        this._keyCodeHandlers.put(new Integer(113), new KeyHanlder(){

            @Override
            public void doKey(boolean down, int keyCode) {
                if (down) {
                    Sorcerer.this.toggleTrace();
                }
            }
        });
        this._keyCodeHandlers.put(new Integer(35), new KeyHanlder(){

            @Override
            public void doKey(boolean down, int keyCode) {
                if (down) {
                    Sorcerer.this.reset();
                    Sorcerer.this.PC(57344);
                }
            }
        });
        this._keyCodeHandlers.put(new Integer(114), new KeyHanlder(){

            @Override
            public void doKey(boolean down, int keyCode) {
                if (down) {
                    Sorcerer.this.takeSnapshotNextInterrupt = true;
                }
            }
        });
    }

    public final boolean doKey(boolean down, KeyEvent e) {
        KeyHanlder handler;
        int code = e.getKeyCode();
        KeyHanlder charHandler = this._keyCharHandlers.get(Character.valueOf(e.getKeyChar()));
        if (charHandler != null) {
            charHandler.doKey(down, e.getKeyCode());
        }
        if ((handler = this._keyCodeHandlers.get(code)) != null) {
            handler.doKey(down, e.getKeyCode());
        }
        if (charHandler != null && handler != null) {
            System.out.println("Rehandled key event " + e);
        }
        return true;
    }

    public void loadROMs(URL baseURL) throws IOException {
        this.readBytes(new URL(baseURL, "roms/exmo1-1.dat"), this.mem, 57344, 2048);
        this.readBytes(new URL(baseURL, "roms/exmo1-2.dat"), this.mem, 59392, 2048);
        this.readBytes(new URL(baseURL, "roms/exchr-1.dat"), this.mem, 63488, 1024);
        this.readBytes(new URL(baseURL, "roms/diskboot.dat"), this.mem, 48128, 256);
        this.setupScreenCharacters();
        this.reset();
        this.PC(57344);
    }

    public void load8kRomPack(URL baseURL, String romFileName) throws IOException {
        URL url = new URL(baseURL, romFileName);
        InputStream is = url.openStream();
        this.load8kRomPack(is);
    }

    public void clear8kRomPack() {
        int i = 0;
        while (i < 8192) {
            this.mem[i + 49152] = 0;
            ++i;
        }
    }

    private void setRomFlags() {
        int i = 0;
        while (i < this.romFlags.length) {
            this.romFlags[i] = false;
            ++i;
        }
        this.romFlags[56] = true;
        this.romFlags[57] = true;
        this.romFlags[58] = true;
        this.romFlags[59] = true;
        this.romFlags[62] = true;
        this.romFlags[47] = true;
        this.romFlags[48] = true;
        this.romFlags[49] = true;
        this.romFlags[50] = true;
        this.romFlags[51] = true;
        this.romFlags[52] = true;
        this.romFlags[53] = true;
        this.romFlags[54] = true;
        this.romFlags[55] = true;
    }

    public void load8kRomPack(InputStream is) throws IOException {
        this.readBytes(is, this.mem, 49152, 8192);
    }

    private int readBytes(URL url, int[] a, int off, int n) throws IOException {
        InputStream is = url.openStream();
        try {
            int n2 = this.readBytes(is, a, off, n);
            return n2;
        }
        finally {
            is.close();
        }
    }

    private int readBytes(InputStream is, int[] a, int off, int n) throws IOException {
        BufferedInputStream bis = new BufferedInputStream(is, n);
        byte[] buff = new byte[n];
        int toRead = n;
        while (toRead > 0) {
            int nRead = bis.read(buff, n - toRead, toRead);
            if (nRead == -1) {
                return -1;
            }
            toRead -= nRead;
        }
        int i = 0;
        while (i < n) {
            a[i + off] = buff[i] + 256 & 0xFF;
            ++i;
        }
        return n;
    }

    private void writeBytes(OutputStream os, int[] a, int off, int n) throws IOException {
        int i = 0;
        while (i < n) {
            os.write(a[off + i]);
            ++i;
        }
    }

    public void saveSNP(OutputStream os) throws IOException {
        byte[] header = new byte[28];
        this.exx();
        this.ex_af_af();
        header[0] = (byte)this.I();
        header[1] = (byte)this.L();
        header[2] = (byte)this.H();
        header[3] = (byte)this.E();
        header[4] = (byte)this.D();
        header[5] = (byte)this.C();
        header[6] = (byte)this.B();
        header[7] = (byte)this.F();
        header[8] = (byte)this.A();
        this.exx();
        this.ex_af_af();
        header[9] = (byte)this.L();
        header[10] = (byte)this.H();
        header[11] = (byte)this.E();
        header[12] = (byte)this.D();
        header[13] = (byte)this.C();
        header[14] = (byte)this.B();
        header[15] = (byte)(this.IY() & 0xFF);
        header[16] = (byte)(this.IY() >> 8 & 0xFF);
        header[17] = (byte)(this.IX() & 0xFF);
        header[18] = (byte)(this.IX() >> 8 & 0xFF);
        header[19] = 0;
        if (this.IFF2()) {
            header[19] = (byte)(header[19] | 4);
        }
        if (this.IFF1()) {
            header[19] = (byte)(header[19] | 1);
        }
        header[20] = (byte)this.R();
        header[21] = (byte)this.F();
        header[22] = (byte)this.A();
        header[23] = (byte)(this.SP() & 0xFF);
        header[24] = (byte)(this.SP() >> 8 & 0xFF);
        header[25] = (byte)this.IM();
        header[26] = (byte)(this.PC() & 0xFF);
        header[27] = (byte)(this.PC() >> 8 & 0xFF);
        os.write(header);
        this.writeBytes(os, this.mem, 0, 65536);
        os.close();
    }

    public void loadSNP(URL url) throws IOException {
        InputStream is = url.openStream();
        try {
            this.loadSNP(is);
        }
        finally {
            is.close();
        }
    }

    public void loadSNP(InputStream is) throws IOException {
        int[] header = new int[28];
        this.readBytes(is, header, 0, 28);
        this.readBytes(is, this.mem, 0, 65536);
        this.I(header[0]);
        this.HL(header[1] | header[2] << 8);
        this.DE(header[3] | header[4] << 8);
        this.BC(header[5] | header[6] << 8);
        this.AF(header[7] | header[8] << 8);
        this.exx();
        this.ex_af_af();
        this.HL(header[9] | header[10] << 8);
        this.DE(header[11] | header[12] << 8);
        this.BC(header[13] | header[14] << 8);
        this.IY(header[15] | header[16] << 8);
        this.IX(header[17] | header[18] << 8);
        if ((header[19] & 4) != 0) {
            this.IFF2(true);
        } else {
            this.IFF2(false);
        }
        if ((header[19] & 2) != 0) {
            this.IFF1(true);
        } else {
            this.IFF1(false);
        }
        this.R(header[20]);
        this.AF(header[21] | header[22] << 8);
        this.SP(header[23] | header[24] << 8);
        switch (header[25]) {
            case 0: {
                this.IM(0);
                break;
            }
            case 1: {
                this.IM(1);
                break;
            }
            default: {
                this.IM(2);
            }
        }
        this.PC(header[26] | header[27] << 8);
        this.setupScreenCharacters();
    }

    private class AmbiguousCharKeyHandler
    implements KeyHanlder {
        private KeyHanlder[] _keyHandlers;
        private int[] _keyCodes;

        public AmbiguousCharKeyHandler(int code1, KeyHanlder kh1, int code2, KeyHanlder kh2) {
            this._keyHandlers = new KeyHanlder[]{kh1, kh2};
            this._keyCodes = new int[]{code1, code2};
        }

        @Override
        public void doKey(boolean down, int keyCode) {
            int i = 0;
            while (i < this._keyHandlers.length) {
                if (this._keyCodes[i] == keyCode) {
                    this._keyHandlers[i].doKey(down, keyCode);
                    return;
                }
                ++i;
            }
            System.out.println("Error  could not disambiguate key " + keyCode);
            this._keyHandlers[0].doKey(down, keyCode);
        }
    }

    private class CompoundKeyHandler
    implements KeyHanlder {
        private KeyHanlder[] _keyHandlers;

        public CompoundKeyHandler(KeyHanlder kh1, KeyHanlder kh2) {
            this._keyHandlers = new KeyHanlder[]{kh1, kh2};
        }

        public CompoundKeyHandler(KeyHanlder kh1, KeyHanlder kh2, KeyHanlder kh3) {
            this._keyHandlers = new KeyHanlder[]{kh1, kh2, kh3};
        }

        public CompoundKeyHandler(KeyHanlder[] keyHandler) {
            this._keyHandlers = keyHandler;
        }

        @Override
        public void doKey(boolean down, int code) {
            if (down) {
                int i = 0;
                while (i < this._keyHandlers.length) {
                    this._keyHandlers[i].doKey(down, code);
                    ++i;
                }
            } else {
                int i = 0;
                while (i < this._keyHandlers.length) {
                    this._keyHandlers[this._keyHandlers.length - i - 1].doKey(down, code);
                    ++i;
                }
            }
        }
    }

    private static interface KeyHanlder {
        public void doKey(boolean var1, int var2);
    }

    private class KeyLineAndBitHandler
    implements KeyHanlder {
        private int _line;
        private int _bit;
        private String _desc;

        public KeyLineAndBitHandler(int line, int bit, String desc) {
            this._line = line;
            this._bit = bit;
            this._desc = desc;
        }

        @Override
        public void doKey(boolean down, int code) {
            Sorcerer.this._keyboard.addKeyEvent(this._line, this._bit, down, code);
        }
    }

    private final class Keyboard {
        private int[][] _keyLines = new int[16][5];
        private int _keyScan = 0;
        boolean capslock = false;
        private LinkedList<SorcererKeyEvent> _fifo = new LinkedList();
        long _last = 0L;

        private Keyboard() {
        }

        public void reset() {
            int i = 0;
            while (i < this._keyLines.length) {
                this._keyLines[i][0] = 0;
                this._keyLines[i][1] = 0;
                this._keyLines[i][2] = 0;
                this._keyLines[i][3] = 0;
                this._keyLines[i][4] = 0;
                ++i;
            }
            this.capslock = false;
        }

        public void setCapsLock() {
            this.capslock = true;
            int[] nArray = this._keyLines[0];
            nArray[3] = nArray[3] + 1;
        }

        public void clearCapsLock() {
            this.capslock = false;
            int[] nArray = this._keyLines[0];
            nArray[3] = nArray[3] - 1;
        }

        public void toggleCapsLock() {
            if (this.capslock) {
                this.clearCapsLock();
            } else {
                this.setCapsLock();
            }
        }

        public final void setScanLine(int line) {
            this._keyScan = line;
        }

        public final synchronized void addKeyEvent(int line, int bit, boolean down, int code) {
            this._fifo.addLast(new SorcererKeyEvent(line, bit, down, code));
        }

        public final synchronized int getKeyBits() {
            SorcererKeyEvent e;
            if (this._fifo.size() > 0 && this._last > 0L && ((e = this._fifo.peekFirst())._line == this._keyScan || this._last > 16L)) {
                this._fifo.removeFirst().apply();
                this._last = e._line == 0 ? -48 : 0;
            }
            ++this._last;
            return (this._keyLines[this._keyScan][0] > 0 ? 0 : 1) + (this._keyLines[this._keyScan][1] > 0 ? 0 : 2) + (this._keyLines[this._keyScan][2] > 0 ? 0 : 4) + (this._keyLines[this._keyScan][3] > 0 ? 0 : 8) + (this._keyLines[this._keyScan][4] > 0 ? 0 : 16);
        }

        private final class SorcererKeyEvent {
            private final int _line;
            private final int _bit;
            private final boolean _pressed;
            private final int _code;

            public SorcererKeyEvent(int line, int bit, boolean pressed, int code) {
                this._line = line;
                this._bit = bit;
                this._pressed = pressed;
                this._code = code;
            }

            public void apply() {
                int[] nArray = Keyboard.this._keyLines[this._line];
                int n = this._bit;
                nArray[n] = nArray[n] + (this._pressed ? 1 : -1);
            }
        }
    }
}

