/*
 * Decompiled with CFR 0.152.
 */
package sorcererII;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;

public class SorcererAudioOutputStream
extends OutputStream {
    private final ByteArrayOutputStream _bos = new ByteArrayOutputStream();
    private final boolean _trace = true;
    private final int _vol = 25600;
    private final float _sampleRate = 44100.0f;
    private final File _fileOut;
    private final int _bitsPerSample = 16;
    private boolean _state = false;
    private double _samplesPerBit;

    public SorcererAudioOutputStream(File fileOut, double bitFrequency) {
        this._fileOut = fileOut;
        this._samplesPerBit = 44100.0 / bitFrequency;
    }

    @Override
    public void write(int arg0) throws IOException {
        this._bos.write(arg0);
    }

    private void writeSample(ByteArrayOutputStream sampleBytes) {
        int s = this._state ? 25600 : -25600;
        sampleBytes.write(s & 0xFF);
        sampleBytes.write(s >> 8 & 0xFF);
    }

    private void writeHalf(ByteArrayOutputStream sampleBytes) {
        int p0 = (int)(this._samplesPerBit * 0.25);
        int p1 = (int)(this._samplesPerBit * 0.5);
        int p2 = (int)(this._samplesPerBit * 0.75);
        int i = 0;
        while ((double)i < this._samplesPerBit) {
            this.writeSample(sampleBytes);
            if (i == p0 || i == p1 || i == p2) {
                this._state = !this._state;
            }
            ++i;
        }
        this._state = !this._state;
    }

    private void writeHalfPadding(ByteArrayOutputStream sampleBytes) {
        int i = 0;
        while (i < 800) {
            this.writeHalf(sampleBytes);
            ++i;
        }
    }

    private void writePadding(ByteArrayOutputStream sampleBytes) {
        int i = 0;
        while (i < 800) {
            this.writeOne(sampleBytes);
            ++i;
        }
    }

    private void writeStart(ByteArrayOutputStream sampleBytes) {
        this.writeOne(sampleBytes);
        this.writeOne(sampleBytes);
        this.writeZero(sampleBytes);
    }

    private void writeOne(ByteArrayOutputStream sampleBytes) {
        int p = (int)(this._samplesPerBit / 2.0);
        int i = 0;
        while ((double)i < this._samplesPerBit) {
            this.writeSample(sampleBytes);
            if (i == p) {
                this._state = !this._state;
            }
            ++i;
        }
        this._state = !this._state;
    }

    private void writeZero(ByteArrayOutputStream sampleBytes) {
        int i = 0;
        while ((double)i < this._samplesPerBit) {
            this.writeSample(sampleBytes);
            ++i;
        }
        this._state = !this._state;
    }

    private void writeByte(byte b, ByteArrayOutputStream sampleBytes) {
        this.writeStart(sampleBytes);
        int v = b & 0xFF;
        System.out.println("Data: " + Integer.toHexString(v));
        int i = 0;
        while (i < 8) {
            if ((v & 1 << i) == 0) {
                this.writeZero(sampleBytes);
            } else {
                this.writeOne(sampleBytes);
            }
            ++i;
        }
    }

    @Override
    public void close() throws IOException {
        ByteArrayOutputStream sampleBytes = new ByteArrayOutputStream();
        byte[] outputButes = this._bos.toByteArray();
        this.writeHalfPadding(sampleBytes);
        this.writePadding(sampleBytes);
        int i = 0;
        while (i < outputButes.length) {
            this.writeByte(outputButes[i], sampleBytes);
            ++i;
        }
        this.writePadding(sampleBytes);
        this.writeHalfPadding(sampleBytes);
        byte[] _audioData = sampleBytes.toByteArray();
        ByteArrayInputStream sampleInputStream = new ByteArrayInputStream(_audioData);
        AudioFormat audioFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 44100.0f, 16, 1, 2, 44100.0f, false);
        AudioInputStream audioInputStream = new AudioInputStream(sampleInputStream, audioFormat, _audioData.length / 2);
        AudioSystem.write(audioInputStream, AudioFileFormat.Type.WAVE, this._fileOut);
    }
}

