/*
 * Decompiled with CFR 0.152.
 */
package sorcererII;

import sorcererII.SorcererDisk;
import sorcererII.SorcererDiskDrive;

public class SorcererDiskSystem {
    private SorcererDiskDrive[] _drives = new SorcererDiskDrive[4];
    private SorcererDiskDrive _activeDrive = null;
    private int _activeDriveNumber = 64;

    public SorcererDiskSystem() {
        int i = 0;
        while (i < this._drives.length) {
            this._drives[i] = new SorcererDiskDrive(i);
            ++i;
        }
    }

    public SorcererDiskDrive getSorcererDiskDrive(int drive) {
        return this._drives[drive];
    }

    public final void insertDisk(SorcererDisk disk, int drive) {
        this._drives[drive].insertDisk(disk);
    }

    private final boolean dataReady() {
        if (this._activeDrive != null) {
            return this._activeDrive.dataReady();
        }
        return false;
    }

    private final boolean home() {
        if (this._activeDrive != null) {
            return this._activeDrive.home();
        }
        return false;
    }

    private final void stepForward() {
        if (this._activeDrive != null) {
            this._activeDrive.stepForward();
        }
    }

    private final void stepBackward() {
        if (this._activeDrive != null) {
            this._activeDrive.stepBackward();
        }
    }

    private final void readyWrite() {
        if (this._activeDrive != null) {
            this._activeDrive.readyWrite();
        }
    }

    private final void activate(int drive) {
        this._activeDriveNumber = drive;
        this._activeDrive = this._drives[drive];
        this._activeDrive.activate();
    }

    private final boolean active() {
        return this._activeDrive != null;
    }

    private final void writeReg0(int b) {
        switch (b) {
            case 160: {
                break;
            }
            case 32: {
                this.activate(0);
                break;
            }
            case 33: {
                this.activate(1);
                break;
            }
            case 34: {
                this.activate(2);
                break;
            }
            case 35: {
                this.activate(3);
                break;
            }
            case 96: {
                this.stepBackward();
                break;
            }
            case 97: {
                this.stepForward();
                break;
            }
            case 128: {
                this.readyWrite();
            }
        }
    }

    private final void writeReg1(int b) {
        switch (b) {
            case 160: {
                break;
            }
            case 32: {
                this.activate(0);
                break;
            }
            case 33: {
                this.activate(1);
                break;
            }
            case 34: {
                this.activate(2);
                break;
            }
            case 35: {
                this.activate(3);
                break;
            }
            case 96: {
                this.stepBackward();
                break;
            }
            case 97: {
                this.stepForward();
                break;
            }
            case 128: {
                this.readyWrite();
            }
        }
    }

    private final void writeReg2(int b) {
        if (this._activeDrive != null) {
            this._activeDrive.writeReg2(b);
        }
    }

    private final int readReg0() {
        if (this._activeDrive != null) {
            return this._activeDrive.readReg0();
        }
        return 0;
    }

    private final int readReg1() {
        int r = this._activeDriveNumber;
        if (this.active()) {
            r |= 0x20;
        }
        if (this.home()) {
            r |= 8;
        }
        if (this.dataReady()) {
            r |= 0x80;
        }
        return r;
    }

    private final int readReg2() {
        if (this._activeDrive != null) {
            return this._activeDrive.readReg2();
        }
        return 0;
    }

    public final void write(int address, int b) {
        if (this._activeDrive != null) {
            this._activeDrive.activate();
        }
        switch (address) {
            case 0: {
                this.writeReg0(b);
                break;
            }
            case 1: {
                this.writeReg1(b);
                break;
            }
            case 2: {
                this.writeReg2(b);
            }
        }
    }

    public final int read(int address) {
        if (this._activeDrive != null) {
            this._activeDrive.activate();
        }
        int r = 0;
        switch (address) {
            case 0: {
                r = this.readReg0();
                break;
            }
            case 1: {
                r = this.readReg1();
                break;
            }
            case 2: {
                r = this.readReg2();
            }
        }
        return r;
    }

    public final void tick() {
        int i = 0;
        while (i < this._drives.length) {
            this._drives[i].tick();
            ++i;
        }
        if (this._activeDrive != null && !this._activeDrive.active()) {
            this._activeDrive = null;
            this._activeDriveNumber = 64;
        }
    }
}

