/*
 * Decompiled with CFR 0.152.
 */
package sorcererII;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.net.URL;
import java.util.HashSet;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;
import sorcererII.JSorcererDiskDrive;
import sorcererII.JSorcererFileOpener;
import sorcererII.JSorcererKeyMapControl;
import sorcererII.JSorcererLoggerPanel;
import sorcererII.JSorcererResetControl;
import sorcererII.JSorcererRomPack;
import sorcererII.JSorcererSaveScreen;
import sorcererII.JSorcererSnapshotControl;
import sorcererII.JSorcererSpeedControl;
import sorcererII.JSorcererTapeDrive;
import sorcererII.Sorcerer;

public class SorcererFrame
extends JFrame {
    private Sorcerer _sorcerer = null;
    private int refreshRate = 1;
    private int sleepHack = 1;
    private int scale = 1;
    private Container _sorcererPanel = null;

    public void SwingSorcererFrame() throws IOException {
    }

    public void init() throws IOException {
        this.setDefaultCloseOperation(3);
        this.setFocusable(true);
        this._sorcererPanel = new SorcererPanel();
        JPanel sorcererBorder = new JPanel();
        sorcererBorder.setLayout(new GridLayout(1, 1));
        sorcererBorder.add((Component)this._sorcererPanel, "Center");
        sorcererBorder.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.white), BorderFactory.createLineBorder(Color.black)));
        this.getContentPane().add((Component)sorcererBorder, "Center");
        this._sorcerer = new Sorcerer(this._sorcererPanel, this.refreshRate, this.sleepHack, this.scale, 0, 0);
        final HashSet _keyDown = new HashSet();
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (!_keyDown.contains(e.getKeyCode())) {
                    _keyDown.add(e.getKeyCode());
                    if (SorcererFrame.this._sorcerer != null) {
                        SorcererFrame.this._sorcerer.doKey(true, e);
                    }
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (SorcererFrame.this._sorcerer != null) {
                    SorcererFrame.this._sorcerer.doKey(false, e);
                }
                _keyDown.remove(e.getKeyCode());
            }
        });
        JSorcererDiskDrive jDiskDriveA = new JSorcererDiskDrive(this._sorcerer.getSorcererDiskDrive(0), 'A');
        JSorcererDiskDrive jDiskDriveB = new JSorcererDiskDrive(this._sorcerer.getSorcererDiskDrive(1), 'B');
        JSorcererDiskDrive jDiskDriveC = new JSorcererDiskDrive(this._sorcerer.getSorcererDiskDrive(2), 'C');
        JSorcererDiskDrive jDiskDriveD = new JSorcererDiskDrive(this._sorcerer.getSorcererDiskDrive(3), 'D');
        JSorcererTapeDrive tape1 = new JSorcererTapeDrive(this._sorcerer, 0);
        JSorcererTapeDrive tape2 = new JSorcererTapeDrive(this._sorcerer, 1);
        final JSorcererRomPack romPack = new JSorcererRomPack(this._sorcerer);
        JPanel mediaPanel = new JPanel();
        mediaPanel.setLayout(new GridLayout(7, 1));
        mediaPanel.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 3));
        mediaPanel.add(jDiskDriveA);
        mediaPanel.add(jDiskDriveB);
        mediaPanel.add(jDiskDriveC);
        mediaPanel.add(jDiskDriveD);
        mediaPanel.add(tape1);
        mediaPanel.add(tape2);
        mediaPanel.add(romPack);
        this.getContentPane().add((Component)mediaPanel, "East");
        JPanel controlPanel = new JPanel();
        controlPanel.setLayout(new GridLayout(7, 1));
        controlPanel.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 2));
        controlPanel.add(new JSorcererSpeedControl(this._sorcerer));
        controlPanel.add(new JSorcererKeyMapControl(this._sorcerer));
        controlPanel.add(new JSorcererFileOpener(this._sorcerer));
        controlPanel.add(new JSorcererSnapshotControl(this._sorcerer));
        controlPanel.add(new JSorcererResetControl(this._sorcerer){

            @Override
            protected void handleReset() {
                try {
                    romPack.reload();
                }
                catch (IOException e) {
                    Sorcerer.LOGGER.log(Level.SEVERE, "Could not read ROM files", e);
                }
            }
        });
        controlPanel.add(new JSorcererSaveScreen(this._sorcerer));
        this.getContentPane().add((Component)controlPanel, "West");
        this.pack();
        JSorcererLoggerPanel logginPanel = new JSorcererLoggerPanel();
        logginPanel.setPreferredSize(new Dimension(this.getWidth(), 65));
        this.getContentPane().add((Component)logginPanel, "South");
    }

    public void start() {
        try {
            this._sorcerer.loadROMs(new URL("file:"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this._sorcerer.start();
    }

    public void stop() {
        this._sorcerer.stop();
    }

    public static void main(String[] args) throws IOException {
        SorcererFrame f = new SorcererFrame();
        f.init();
        f.pack();
        f.setResizable(false);
        f.setVisible(true);
        f.start();
    }

    class SorcererPanel
    extends JPanel {
        public SorcererPanel() {
            this.setPreferredSize(new Dimension(502, 480));
        }

        @Override
        public void update(Graphics g) {
            this.paint(g);
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            if (SorcererFrame.this._sorcerer != null) {
                SorcererFrame.this._sorcerer.repaint();
            }
        }
    }
}

