/*
 * Decompiled with CFR 0.152.
 */
package sorcererII;

public class Z80 {
    protected int tstatesPerInterrupt = 0;
    public static final int IM0 = 0;
    public static final int IM1 = 1;
    public static final int IM2 = 2;
    private static final int F_C = 1;
    private static final int F_N = 2;
    private static final int F_PV = 4;
    private static final int F_3 = 8;
    private static final int F_H = 16;
    private static final int F_5 = 32;
    private static final int F_Z = 64;
    private static final int F_S = 128;
    private static final int PF = 4;
    private static final int p_ = 0;
    protected boolean trace = false;
    private static final char[] hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final boolean[] parity = new boolean[256];
    protected int _A = 0;
    protected int _HL = 0;
    protected int _B = 0;
    protected int _C = 0;
    protected int _DE = 0;
    protected boolean fS = false;
    protected boolean fZ = false;
    protected boolean f5 = false;
    protected boolean fH = false;
    protected boolean f3 = false;
    protected boolean fPV = false;
    protected boolean fN = false;
    protected boolean fC = false;
    protected int _AF_ = 0;
    protected int _HL_ = 0;
    protected int _BC_ = 0;
    protected int _DE_ = 0;
    protected int _IX = 0;
    protected int _IY = 0;
    protected int _ID = 0;
    protected int _SP = 0;
    protected int _PC = 0;
    protected int _I = 0;
    protected int _R = 0;
    protected int _R7 = 0;
    protected boolean _IFF1 = true;
    protected boolean _IFF2 = true;
    protected int _IM = 2;
    public final int[] mem = new int[65536];
    private boolean running;

    static {
        int i = 0;
        while (i < 256) {
            boolean p = true;
            int j = 0;
            while (j < 8) {
                if ((i & 1 << j) != 0) {
                    p = !p;
                }
                ++j;
            }
            Z80.parity[i] = p;
            ++i;
        }
    }

    public Z80(double clockFrequencyInMHz) {
        this.tstatesPerInterrupt = (int)(clockFrequencyInMHz * 1000000.0 / 50.0);
    }

    public static String toHexWord(int i) {
        char c1 = hexChars[i & 0xF];
        char c2 = hexChars[i >> 4 & 0xF];
        char c3 = hexChars[i >> 8 & 0xF];
        char c4 = hexChars[i >> 12 & 0xF];
        return "" + c4 + c3 + c2 + c1;
    }

    public static String toHexByte(int i) {
        char c1 = hexChars[i & 0xF];
        char c2 = hexChars[i >> 4 & 0xF];
        return "" + c2 + c1;
    }

    public void toggleTrace() {
        this.trace = !this.trace;
    }

    public final int AF() {
        return this.A() << 8 | this.F();
    }

    public final void AF(int word) {
        this.A(word >> 8);
        this.F(word & 0xFF);
    }

    public final int BC() {
        return this.B() << 8 | this.C();
    }

    public final void BC(int word) {
        this.B(word >> 8);
        this.C(word & 0xFF);
    }

    public final int DE() {
        return this._DE;
    }

    public final void DE(int word) {
        this._DE = word;
    }

    public final int HL() {
        return this._HL;
    }

    public final void HL(int word) {
        this._HL = word;
    }

    public final int PC() {
        return this._PC;
    }

    public final void PC(int word) {
        this._PC = word;
    }

    public final int SP() {
        return this._SP;
    }

    public final void SP(int word) {
        this._SP = word;
    }

    public final int ID() {
        return this._ID;
    }

    public final void ID(int word) {
        this._ID = word;
    }

    public final int IX() {
        return this._IX;
    }

    public final void IX(int word) {
        this._IX = word;
    }

    public final int IY() {
        return this._IY;
    }

    public final void IY(int word) {
        this._IY = word;
    }

    public final int A() {
        return this._A;
    }

    public final void A(int bite) {
        this._A = bite;
    }

    public final int F() {
        return (this.Sset() ? 128 : 0) | (this.Zset() ? 64 : 0) | (this.f5 ? 32 : 0) | (this.Hset() ? 16 : 0) | (this.f3 ? 8 : 0) | (this.PVset() ? 4 : 0) | (this.Nset() ? 2 : 0) | (this.Cset() ? 1 : 0);
    }

    public final void F(int bite) {
        this.fS = (bite & 0x80) != 0;
        this.fZ = (bite & 0x40) != 0;
        this.f5 = (bite & 0x20) != 0;
        this.fH = (bite & 0x10) != 0;
        this.f3 = (bite & 8) != 0;
        this.fPV = (bite & 4) != 0;
        this.fN = (bite & 2) != 0;
        this.fC = (bite & 1) != 0;
    }

    public final int B() {
        return this._B;
    }

    public final void B(int bite) {
        this._B = bite;
    }

    public final int C() {
        return this._C;
    }

    public final void C(int bite) {
        this._C = bite;
    }

    public final int D() {
        return this._DE >> 8;
    }

    public final void D(int bite) {
        this._DE = bite << 8 | this._DE & 0xFF;
    }

    public final int E() {
        return this._DE & 0xFF;
    }

    public final void E(int bite) {
        this._DE = this._DE & 0xFF00 | bite;
    }

    public final int H() {
        return this._HL >> 8;
    }

    public final void H(int bite) {
        this._HL = bite << 8 | this._HL & 0xFF;
    }

    public final int L() {
        return this._HL & 0xFF;
    }

    public final void L(int bite) {
        this._HL = this._HL & 0xFF00 | bite;
    }

    public final int IDH() {
        return this._ID >> 8;
    }

    public final void IDH(int bite) {
        this._ID = bite << 8 | this._ID & 0xFF;
    }

    public final int IDL() {
        return this._ID & 0xFF;
    }

    public final void IDL(int bite) {
        this._ID = this._ID & 0xFF00 | bite;
    }

    public final int R7() {
        return this._R7;
    }

    public final int R() {
        return this._R & 0x7F | this._R7;
    }

    public final void R(int bite) {
        this._R = bite;
        this._R7 = bite & 0x80;
    }

    public final void REFRESH(int t) {
        this._R += t;
    }

    public final int I() {
        return this._I;
    }

    public final void I(int bite) {
        this._I = bite;
    }

    public final boolean IFF1() {
        return this._IFF1;
    }

    public final void IFF1(boolean iff1) {
        this._IFF1 = iff1;
    }

    public final boolean IFF2() {
        return this._IFF2;
    }

    public final void IFF2(boolean iff2) {
        this._IFF2 = iff2;
    }

    public final int IM() {
        return this._IM;
    }

    public final void IM(int im) {
        this._IM = im;
    }

    public final void setZ(boolean f) {
        this.fZ = f;
    }

    public final void setC(boolean f) {
        this.fC = f;
    }

    public final void setS(boolean f) {
        this.fS = f;
    }

    public final void setH(boolean f) {
        this.fH = f;
    }

    public final void setN(boolean f) {
        this.fN = f;
    }

    public final void setPV(boolean f) {
        this.fPV = f;
    }

    public final void set3(boolean f) {
        this.f3 = f;
    }

    public final void set5(boolean f) {
        this.f5 = f;
    }

    public final boolean Zset() {
        return this.fZ;
    }

    public final boolean Cset() {
        return this.fC;
    }

    public final boolean Sset() {
        return this.fS;
    }

    public final boolean Hset() {
        return this.fH;
    }

    public final boolean Nset() {
        return this.fN;
    }

    public final boolean PVset() {
        return this.fPV;
    }

    public int peekb(int addr) {
        return this.mem[addr];
    }

    public void pokeb(int addr, int newByte) {
        this.mem[addr] = newByte;
    }

    public final void pokew(int addr, int word) {
        this.pokeb(addr, word & 0xFF);
        this.pokeb(++addr & 0xFFFF, word >> 8);
    }

    private final int peekw(int addr) {
        int t = this.peekb(addr);
        return t | this.peekb(++addr & 0xFFFF) << 8;
    }

    private final int ID_d() {
        return this.ID() + (byte)this.nxtpcb() & 0xFFFF;
    }

    public final void pushw(int word) {
        int sp = this.SP() - 2 & 0xFFFF;
        this.SP(sp);
        this.pokew(sp, word);
    }

    public final int popw() {
        int sp = this.SP();
        int t = this.peekb(sp);
        t |= this.peekb(++sp & 0xFFFF) << 8;
        this.SP(++sp & 0xFFFF);
        return t;
    }

    public final void pushpc() {
        this.pushw(this.PC());
    }

    public final void poppc() {
        this.PC(this.popw());
    }

    private final int nxtpcb() {
        int pc = this.PC();
        int t = this.peekb(pc);
        this.PC(++pc & 0xFFFF);
        return t;
    }

    private final int nxtpcw() {
        int pc = this.PC();
        int t = this.peekb(pc);
        t |= this.peekb(++pc & 0xFFFF) << 8;
        this.PC(++pc & 0xFFFF);
        return t;
    }

    public void reset() {
        this.PC(0);
        this.SP(0);
        this.A(0);
        this.F(0);
        this.BC(0);
        this.DE(0);
        this.HL(0);
        this.exx();
        this.ex_af_af();
        this.A(0);
        this.F(0);
        this.BC(0);
        this.DE(0);
        this.HL(0);
        this.IX(0);
        this.IY(0);
        this.R(0);
        this.I(0);
        this.IFF1(false);
        this.IFF2(false);
        this.IM(0);
    }

    public void outb(int port, int bite, int tstates) {
    }

    public int inb(int port) {
        return 255;
    }

    private static final boolean interruptTriggered(int tstates) {
        return tstates >= 0;
    }

    public int interrupt() {
        if (!this.IFF1()) {
            return 0;
        }
        switch (this.IM()) {
            case 0: 
            case 1: {
                this.pushpc();
                this.IFF1(false);
                this.IFF2(false);
                this.PC(56);
                return 13;
            }
            case 2: {
                this.pushpc();
                this.IFF1(false);
                this.IFF2(false);
                int t = this.I() << 8 | 0xFF;
                this.PC(this.peekw(t));
                return 19;
            }
        }
        return 0;
    }

    public void abort() {
        this.running = false;
    }

    public final void execute() {
        int local_tstates = -this.tstatesPerInterrupt;
        this.running = true;
        while (this.running) {
            if (this.trace) {
                System.out.println("PC " + Z80.toHexWord(this.PC()) + " DE " + Z80.toHexWord(this.DE()) + " HL " + Z80.toHexWord(this.HL()) + " BC " + Z80.toHexWord(this.BC()) + " AF " + Z80.toHexWord(this.AF()) + " IX " + Z80.toHexWord(this.IX()) + " IY " + Z80.toHexWord(this.IY()));
            }
            if (Z80.interruptTriggered(local_tstates)) {
                local_tstates -= this.tstatesPerInterrupt - this.interrupt();
            }
            this.REFRESH(1);
            switch (this.nxtpcb()) {
                case 0: {
                    local_tstates += 4;
                    break;
                }
                case 8: {
                    this.ex_af_af();
                    local_tstates += 4;
                    break;
                }
                case 16: {
                    int b = Z80.qdec8(this.B());
                    this.B(b);
                    if (b != 0) {
                        byte d = (byte)this.nxtpcb();
                        this.PC(this.PC() + d & 0xFFFF);
                        local_tstates += 13;
                        break;
                    }
                    this.PC(Z80.inc16(this.PC()));
                    local_tstates += 8;
                    break;
                }
                case 24: {
                    byte d = (byte)this.nxtpcb();
                    this.PC(this.PC() + d & 0xFFFF);
                    local_tstates += 12;
                    break;
                }
                case 32: {
                    byte d;
                    if (!this.Zset()) {
                        d = (byte)this.nxtpcb();
                        this.PC(this.PC() + d & 0xFFFF);
                        local_tstates += 12;
                        break;
                    }
                    this.PC(Z80.inc16(this.PC()));
                    local_tstates += 7;
                    break;
                }
                case 40: {
                    byte d;
                    if (this.Zset()) {
                        d = (byte)this.nxtpcb();
                        this.PC(this.PC() + d & 0xFFFF);
                        local_tstates += 12;
                        break;
                    }
                    this.PC(Z80.inc16(this.PC()));
                    local_tstates += 7;
                    break;
                }
                case 48: {
                    byte d;
                    if (!this.Cset()) {
                        d = (byte)this.nxtpcb();
                        this.PC(this.PC() + d & 0xFFFF);
                        local_tstates += 12;
                        break;
                    }
                    this.PC(Z80.inc16(this.PC()));
                    local_tstates += 7;
                    break;
                }
                case 56: {
                    byte d;
                    if (this.Cset()) {
                        d = (byte)this.nxtpcb();
                        this.PC(this.PC() + d & 0xFFFF);
                        local_tstates += 12;
                        break;
                    }
                    this.PC(Z80.inc16(this.PC()));
                    local_tstates += 7;
                    break;
                }
                case 1: {
                    this.BC(this.nxtpcw());
                    local_tstates += 10;
                    break;
                }
                case 9: {
                    this.HL(this.add16(this.HL(), this.BC()));
                    local_tstates += 11;
                    break;
                }
                case 17: {
                    this.DE(this.nxtpcw());
                    local_tstates += 10;
                    break;
                }
                case 25: {
                    this.HL(this.add16(this.HL(), this.DE()));
                    local_tstates += 11;
                    break;
                }
                case 33: {
                    this.HL(this.nxtpcw());
                    local_tstates += 10;
                    break;
                }
                case 41: {
                    int hl = this.HL();
                    this.HL(this.add16(hl, hl));
                    local_tstates += 11;
                    break;
                }
                case 49: {
                    this.SP(this.nxtpcw());
                    local_tstates += 10;
                    break;
                }
                case 57: {
                    this.HL(this.add16(this.HL(), this.SP()));
                    local_tstates += 11;
                    break;
                }
                case 2: {
                    this.pokeb(this.BC(), this.A());
                    local_tstates += 7;
                    break;
                }
                case 10: {
                    this.A(this.peekb(this.BC()));
                    local_tstates += 7;
                    break;
                }
                case 18: {
                    this.pokeb(this.DE(), this.A());
                    local_tstates += 7;
                    break;
                }
                case 26: {
                    this.A(this.peekb(this.DE()));
                    local_tstates += 7;
                    break;
                }
                case 34: {
                    this.pokew(this.nxtpcw(), this.HL());
                    local_tstates += 16;
                    break;
                }
                case 42: {
                    this.HL(this.peekw(this.nxtpcw()));
                    local_tstates += 16;
                    break;
                }
                case 50: {
                    this.pokeb(this.nxtpcw(), this.A());
                    local_tstates += 13;
                    break;
                }
                case 58: {
                    this.A(this.peekb(this.nxtpcw()));
                    local_tstates += 13;
                    break;
                }
                case 3: {
                    this.BC(Z80.inc16(this.BC()));
                    local_tstates += 6;
                    break;
                }
                case 11: {
                    this.BC(Z80.dec16(this.BC()));
                    local_tstates += 6;
                    break;
                }
                case 19: {
                    this.DE(Z80.inc16(this.DE()));
                    local_tstates += 6;
                    break;
                }
                case 27: {
                    this.DE(Z80.dec16(this.DE()));
                    local_tstates += 6;
                    break;
                }
                case 35: {
                    this.HL(Z80.inc16(this.HL()));
                    local_tstates += 6;
                    break;
                }
                case 43: {
                    this.HL(Z80.dec16(this.HL()));
                    local_tstates += 6;
                    break;
                }
                case 51: {
                    this.SP(Z80.inc16(this.SP()));
                    local_tstates += 6;
                    break;
                }
                case 59: {
                    this.SP(Z80.dec16(this.SP()));
                    local_tstates += 6;
                    break;
                }
                case 4: {
                    this.B(this.inc8(this.B()));
                    local_tstates += 4;
                    break;
                }
                case 12: {
                    this.C(this.inc8(this.C()));
                    local_tstates += 4;
                    break;
                }
                case 20: {
                    this.D(this.inc8(this.D()));
                    local_tstates += 4;
                    break;
                }
                case 28: {
                    this.E(this.inc8(this.E()));
                    local_tstates += 4;
                    break;
                }
                case 36: {
                    this.H(this.inc8(this.H()));
                    local_tstates += 4;
                    break;
                }
                case 44: {
                    this.L(this.inc8(this.L()));
                    local_tstates += 4;
                    break;
                }
                case 52: {
                    int hl = this.HL();
                    this.pokeb(hl, this.inc8(this.peekb(hl)));
                    local_tstates += 11;
                    break;
                }
                case 60: {
                    this.A(this.inc8(this.A()));
                    local_tstates += 4;
                    break;
                }
                case 5: {
                    this.B(this.dec8(this.B()));
                    local_tstates += 4;
                    break;
                }
                case 13: {
                    this.C(this.dec8(this.C()));
                    local_tstates += 4;
                    break;
                }
                case 21: {
                    this.D(this.dec8(this.D()));
                    local_tstates += 4;
                    break;
                }
                case 29: {
                    this.E(this.dec8(this.E()));
                    local_tstates += 4;
                    break;
                }
                case 37: {
                    this.H(this.dec8(this.H()));
                    local_tstates += 4;
                    break;
                }
                case 45: {
                    this.L(this.dec8(this.L()));
                    local_tstates += 4;
                    break;
                }
                case 53: {
                    int hl = this.HL();
                    this.pokeb(hl, this.dec8(this.peekb(hl)));
                    local_tstates += 11;
                    break;
                }
                case 61: {
                    this.A(this.dec8(this.A()));
                    local_tstates += 4;
                    break;
                }
                case 6: {
                    this.B(this.nxtpcb());
                    local_tstates += 7;
                    break;
                }
                case 14: {
                    this.C(this.nxtpcb());
                    local_tstates += 7;
                    break;
                }
                case 22: {
                    this.D(this.nxtpcb());
                    local_tstates += 7;
                    break;
                }
                case 30: {
                    this.E(this.nxtpcb());
                    local_tstates += 7;
                    break;
                }
                case 38: {
                    this.H(this.nxtpcb());
                    local_tstates += 7;
                    break;
                }
                case 46: {
                    this.L(this.nxtpcb());
                    local_tstates += 7;
                    break;
                }
                case 54: {
                    this.pokeb(this.HL(), this.nxtpcb());
                    local_tstates += 10;
                    break;
                }
                case 62: {
                    this.A(this.nxtpcb());
                    local_tstates += 7;
                    break;
                }
                case 7: {
                    this.rlc_a();
                    local_tstates += 4;
                    break;
                }
                case 15: {
                    this.rrc_a();
                    local_tstates += 4;
                    break;
                }
                case 23: {
                    this.rl_a();
                    local_tstates += 4;
                    break;
                }
                case 31: {
                    this.rr_a();
                    local_tstates += 4;
                    break;
                }
                case 39: {
                    this.daa_a();
                    local_tstates += 4;
                    break;
                }
                case 47: {
                    this.cpl_a();
                    local_tstates += 4;
                    break;
                }
                case 55: {
                    this.scf();
                    local_tstates += 4;
                    break;
                }
                case 63: {
                    this.ccf();
                    local_tstates += 4;
                    break;
                }
                case 64: {
                    local_tstates += 4;
                    break;
                }
                case 65: {
                    this.B(this.C());
                    local_tstates += 4;
                    break;
                }
                case 66: {
                    this.B(this.D());
                    local_tstates += 4;
                    break;
                }
                case 67: {
                    this.B(this.E());
                    local_tstates += 4;
                    break;
                }
                case 68: {
                    this.B(this.H());
                    local_tstates += 4;
                    break;
                }
                case 69: {
                    this.B(this.L());
                    local_tstates += 4;
                    break;
                }
                case 70: {
                    this.B(this.peekb(this.HL()));
                    local_tstates += 7;
                    break;
                }
                case 71: {
                    this.B(this.A());
                    local_tstates += 4;
                    break;
                }
                case 72: {
                    this.C(this.B());
                    local_tstates += 4;
                    break;
                }
                case 73: {
                    local_tstates += 4;
                    break;
                }
                case 74: {
                    this.C(this.D());
                    local_tstates += 4;
                    break;
                }
                case 75: {
                    this.C(this.E());
                    local_tstates += 4;
                    break;
                }
                case 76: {
                    this.C(this.H());
                    local_tstates += 4;
                    break;
                }
                case 77: {
                    this.C(this.L());
                    local_tstates += 4;
                    break;
                }
                case 78: {
                    this.C(this.peekb(this.HL()));
                    local_tstates += 7;
                    break;
                }
                case 79: {
                    this.C(this.A());
                    local_tstates += 4;
                    break;
                }
                case 80: {
                    this.D(this.B());
                    local_tstates += 4;
                    break;
                }
                case 81: {
                    this.D(this.C());
                    local_tstates += 4;
                    break;
                }
                case 82: {
                    local_tstates += 4;
                    break;
                }
                case 83: {
                    this.D(this.E());
                    local_tstates += 4;
                    break;
                }
                case 84: {
                    this.D(this.H());
                    local_tstates += 4;
                    break;
                }
                case 85: {
                    this.D(this.L());
                    local_tstates += 4;
                    break;
                }
                case 86: {
                    this.D(this.peekb(this.HL()));
                    local_tstates += 7;
                    break;
                }
                case 87: {
                    this.D(this.A());
                    local_tstates += 4;
                    break;
                }
                case 88: {
                    this.E(this.B());
                    local_tstates += 4;
                    break;
                }
                case 89: {
                    this.E(this.C());
                    local_tstates += 4;
                    break;
                }
                case 90: {
                    this.E(this.D());
                    local_tstates += 4;
                    break;
                }
                case 91: {
                    local_tstates += 4;
                    break;
                }
                case 92: {
                    this.E(this.H());
                    local_tstates += 4;
                    break;
                }
                case 93: {
                    this.E(this.L());
                    local_tstates += 4;
                    break;
                }
                case 94: {
                    this.E(this.peekb(this.HL()));
                    local_tstates += 7;
                    break;
                }
                case 95: {
                    this.E(this.A());
                    local_tstates += 4;
                    break;
                }
                case 96: {
                    this.H(this.B());
                    local_tstates += 4;
                    break;
                }
                case 97: {
                    this.H(this.C());
                    local_tstates += 4;
                    break;
                }
                case 98: {
                    this.H(this.D());
                    local_tstates += 4;
                    break;
                }
                case 99: {
                    this.H(this.E());
                    local_tstates += 4;
                    break;
                }
                case 100: {
                    local_tstates += 4;
                    break;
                }
                case 101: {
                    this.H(this.L());
                    local_tstates += 4;
                    break;
                }
                case 102: {
                    this.H(this.peekb(this.HL()));
                    local_tstates += 7;
                    break;
                }
                case 103: {
                    this.H(this.A());
                    local_tstates += 4;
                    break;
                }
                case 104: {
                    this.L(this.B());
                    local_tstates += 4;
                    break;
                }
                case 105: {
                    this.L(this.C());
                    local_tstates += 4;
                    break;
                }
                case 106: {
                    this.L(this.D());
                    local_tstates += 4;
                    break;
                }
                case 107: {
                    this.L(this.E());
                    local_tstates += 4;
                    break;
                }
                case 108: {
                    this.L(this.H());
                    local_tstates += 4;
                    break;
                }
                case 109: {
                    local_tstates += 4;
                    break;
                }
                case 110: {
                    this.L(this.peekb(this.HL()));
                    local_tstates += 7;
                    break;
                }
                case 111: {
                    this.L(this.A());
                    local_tstates += 4;
                    break;
                }
                case 112: {
                    this.pokeb(this.HL(), this.B());
                    local_tstates += 7;
                    break;
                }
                case 113: {
                    this.pokeb(this.HL(), this.C());
                    local_tstates += 7;
                    break;
                }
                case 114: {
                    this.pokeb(this.HL(), this.D());
                    local_tstates += 7;
                    break;
                }
                case 115: {
                    this.pokeb(this.HL(), this.E());
                    local_tstates += 7;
                    break;
                }
                case 116: {
                    this.pokeb(this.HL(), this.H());
                    local_tstates += 7;
                    break;
                }
                case 117: {
                    this.pokeb(this.HL(), this.L());
                    local_tstates += 7;
                    break;
                }
                case 118: {
                    int haltsToInterrupt = (-local_tstates - 1) / 4 + 1;
                    local_tstates += haltsToInterrupt * 4;
                    this.REFRESH(haltsToInterrupt - 1);
                    break;
                }
                case 119: {
                    this.pokeb(this.HL(), this.A());
                    local_tstates += 7;
                    break;
                }
                case 120: {
                    this.A(this.B());
                    local_tstates += 4;
                    break;
                }
                case 121: {
                    this.A(this.C());
                    local_tstates += 4;
                    break;
                }
                case 122: {
                    this.A(this.D());
                    local_tstates += 4;
                    break;
                }
                case 123: {
                    this.A(this.E());
                    local_tstates += 4;
                    break;
                }
                case 124: {
                    this.A(this.H());
                    local_tstates += 4;
                    break;
                }
                case 125: {
                    this.A(this.L());
                    local_tstates += 4;
                    break;
                }
                case 126: {
                    this.A(this.peekb(this.HL()));
                    local_tstates += 7;
                    break;
                }
                case 127: {
                    local_tstates += 4;
                    break;
                }
                case 128: {
                    this.add_a(this.B());
                    local_tstates += 4;
                    break;
                }
                case 129: {
                    this.add_a(this.C());
                    local_tstates += 4;
                    break;
                }
                case 130: {
                    this.add_a(this.D());
                    local_tstates += 4;
                    break;
                }
                case 131: {
                    this.add_a(this.E());
                    local_tstates += 4;
                    break;
                }
                case 132: {
                    this.add_a(this.H());
                    local_tstates += 4;
                    break;
                }
                case 133: {
                    this.add_a(this.L());
                    local_tstates += 4;
                    break;
                }
                case 134: {
                    this.add_a(this.peekb(this.HL()));
                    local_tstates += 7;
                    break;
                }
                case 135: {
                    this.add_a(this.A());
                    local_tstates += 4;
                    break;
                }
                case 136: {
                    this.adc_a(this.B());
                    local_tstates += 4;
                    break;
                }
                case 137: {
                    this.adc_a(this.C());
                    local_tstates += 4;
                    break;
                }
                case 138: {
                    this.adc_a(this.D());
                    local_tstates += 4;
                    break;
                }
                case 139: {
                    this.adc_a(this.E());
                    local_tstates += 4;
                    break;
                }
                case 140: {
                    this.adc_a(this.H());
                    local_tstates += 4;
                    break;
                }
                case 141: {
                    this.adc_a(this.L());
                    local_tstates += 4;
                    break;
                }
                case 142: {
                    this.adc_a(this.peekb(this.HL()));
                    local_tstates += 7;
                    break;
                }
                case 143: {
                    this.adc_a(this.A());
                    local_tstates += 4;
                    break;
                }
                case 144: {
                    this.sub_a(this.B());
                    local_tstates += 4;
                    break;
                }
                case 145: {
                    this.sub_a(this.C());
                    local_tstates += 4;
                    break;
                }
                case 146: {
                    this.sub_a(this.D());
                    local_tstates += 4;
                    break;
                }
                case 147: {
                    this.sub_a(this.E());
                    local_tstates += 4;
                    break;
                }
                case 148: {
                    this.sub_a(this.H());
                    local_tstates += 4;
                    break;
                }
                case 149: {
                    this.sub_a(this.L());
                    local_tstates += 4;
                    break;
                }
                case 150: {
                    this.sub_a(this.peekb(this.HL()));
                    local_tstates += 7;
                    break;
                }
                case 151: {
                    this.sub_a(this.A());
                    local_tstates += 4;
                    break;
                }
                case 152: {
                    this.sbc_a(this.B());
                    local_tstates += 4;
                    break;
                }
                case 153: {
                    this.sbc_a(this.C());
                    local_tstates += 4;
                    break;
                }
                case 154: {
                    this.sbc_a(this.D());
                    local_tstates += 4;
                    break;
                }
                case 155: {
                    this.sbc_a(this.E());
                    local_tstates += 4;
                    break;
                }
                case 156: {
                    this.sbc_a(this.H());
                    local_tstates += 4;
                    break;
                }
                case 157: {
                    this.sbc_a(this.L());
                    local_tstates += 4;
                    break;
                }
                case 158: {
                    this.sbc_a(this.peekb(this.HL()));
                    local_tstates += 7;
                    break;
                }
                case 159: {
                    this.sbc_a(this.A());
                    local_tstates += 4;
                    break;
                }
                case 160: {
                    this.and_a(this.B());
                    local_tstates += 4;
                    break;
                }
                case 161: {
                    this.and_a(this.C());
                    local_tstates += 4;
                    break;
                }
                case 162: {
                    this.and_a(this.D());
                    local_tstates += 4;
                    break;
                }
                case 163: {
                    this.and_a(this.E());
                    local_tstates += 4;
                    break;
                }
                case 164: {
                    this.and_a(this.H());
                    local_tstates += 4;
                    break;
                }
                case 165: {
                    this.and_a(this.L());
                    local_tstates += 4;
                    break;
                }
                case 166: {
                    this.and_a(this.peekb(this.HL()));
                    local_tstates += 7;
                    break;
                }
                case 167: {
                    this.and_a(this.A());
                    local_tstates += 4;
                    break;
                }
                case 168: {
                    this.xor_a(this.B());
                    local_tstates += 4;
                    break;
                }
                case 169: {
                    this.xor_a(this.C());
                    local_tstates += 4;
                    break;
                }
                case 170: {
                    this.xor_a(this.D());
                    local_tstates += 4;
                    break;
                }
                case 171: {
                    this.xor_a(this.E());
                    local_tstates += 4;
                    break;
                }
                case 172: {
                    this.xor_a(this.H());
                    local_tstates += 4;
                    break;
                }
                case 173: {
                    this.xor_a(this.L());
                    local_tstates += 4;
                    break;
                }
                case 174: {
                    this.xor_a(this.peekb(this.HL()));
                    local_tstates += 7;
                    break;
                }
                case 175: {
                    this.xor_a(this.A());
                    local_tstates += 4;
                    break;
                }
                case 176: {
                    this.or_a(this.B());
                    local_tstates += 4;
                    break;
                }
                case 177: {
                    this.or_a(this.C());
                    local_tstates += 4;
                    break;
                }
                case 178: {
                    this.or_a(this.D());
                    local_tstates += 4;
                    break;
                }
                case 179: {
                    this.or_a(this.E());
                    local_tstates += 4;
                    break;
                }
                case 180: {
                    this.or_a(this.H());
                    local_tstates += 4;
                    break;
                }
                case 181: {
                    this.or_a(this.L());
                    local_tstates += 4;
                    break;
                }
                case 182: {
                    this.or_a(this.peekb(this.HL()));
                    local_tstates += 7;
                    break;
                }
                case 183: {
                    this.or_a(this.A());
                    local_tstates += 4;
                    break;
                }
                case 184: {
                    this.cp_a(this.B());
                    local_tstates += 4;
                    break;
                }
                case 185: {
                    this.cp_a(this.C());
                    local_tstates += 4;
                    break;
                }
                case 186: {
                    this.cp_a(this.D());
                    local_tstates += 4;
                    break;
                }
                case 187: {
                    this.cp_a(this.E());
                    local_tstates += 4;
                    break;
                }
                case 188: {
                    this.cp_a(this.H());
                    local_tstates += 4;
                    break;
                }
                case 189: {
                    this.cp_a(this.L());
                    local_tstates += 4;
                    break;
                }
                case 190: {
                    this.cp_a(this.peekb(this.HL()));
                    local_tstates += 7;
                    break;
                }
                case 191: {
                    this.cp_a(this.A());
                    local_tstates += 4;
                    break;
                }
                case 192: {
                    if (!this.Zset()) {
                        this.poppc();
                        local_tstates += 11;
                        break;
                    }
                    local_tstates += 5;
                    break;
                }
                case 200: {
                    if (this.Zset()) {
                        this.poppc();
                        local_tstates += 11;
                        break;
                    }
                    local_tstates += 5;
                    break;
                }
                case 208: {
                    if (!this.Cset()) {
                        this.poppc();
                        local_tstates += 11;
                        break;
                    }
                    local_tstates += 5;
                    break;
                }
                case 216: {
                    if (this.Cset()) {
                        this.poppc();
                        local_tstates += 11;
                        break;
                    }
                    local_tstates += 5;
                    break;
                }
                case 224: {
                    if (!this.PVset()) {
                        this.poppc();
                        local_tstates += 11;
                        break;
                    }
                    local_tstates += 5;
                    break;
                }
                case 232: {
                    if (this.PVset()) {
                        this.poppc();
                        local_tstates += 11;
                        break;
                    }
                    local_tstates += 5;
                    break;
                }
                case 240: {
                    if (!this.Sset()) {
                        this.poppc();
                        local_tstates += 11;
                        break;
                    }
                    local_tstates += 5;
                    break;
                }
                case 248: {
                    if (this.Sset()) {
                        this.poppc();
                        local_tstates += 11;
                        break;
                    }
                    local_tstates += 5;
                    break;
                }
                case 193: {
                    this.BC(this.popw());
                    local_tstates += 10;
                    break;
                }
                case 201: {
                    this.poppc();
                    local_tstates += 10;
                    break;
                }
                case 209: {
                    this.DE(this.popw());
                    local_tstates += 10;
                    break;
                }
                case 217: {
                    this.exx();
                    local_tstates += 4;
                    break;
                }
                case 225: {
                    this.HL(this.popw());
                    local_tstates += 10;
                    break;
                }
                case 233: {
                    this.PC(this.HL());
                    local_tstates += 4;
                    break;
                }
                case 241: {
                    this.AF(this.popw());
                    local_tstates += 10;
                    break;
                }
                case 249: {
                    this.SP(this.HL());
                    local_tstates += 6;
                    break;
                }
                case 194: {
                    if (!this.Zset()) {
                        this.PC(this.nxtpcw());
                    } else {
                        this.PC(this.PC() + 2 & 0xFFFF);
                    }
                    local_tstates += 10;
                    break;
                }
                case 202: {
                    if (this.Zset()) {
                        this.PC(this.nxtpcw());
                    } else {
                        this.PC(this.PC() + 2 & 0xFFFF);
                    }
                    local_tstates += 10;
                    break;
                }
                case 210: {
                    if (!this.Cset()) {
                        this.PC(this.nxtpcw());
                    } else {
                        this.PC(this.PC() + 2 & 0xFFFF);
                    }
                    local_tstates += 10;
                    break;
                }
                case 218: {
                    if (this.Cset()) {
                        this.PC(this.nxtpcw());
                    } else {
                        this.PC(this.PC() + 2 & 0xFFFF);
                    }
                    local_tstates += 10;
                    break;
                }
                case 226: {
                    if (!this.PVset()) {
                        this.PC(this.nxtpcw());
                    } else {
                        this.PC(this.PC() + 2 & 0xFFFF);
                    }
                    local_tstates += 10;
                    break;
                }
                case 234: {
                    if (this.PVset()) {
                        this.PC(this.nxtpcw());
                    } else {
                        this.PC(this.PC() + 2 & 0xFFFF);
                    }
                    local_tstates += 10;
                    break;
                }
                case 242: {
                    if (!this.Sset()) {
                        this.PC(this.nxtpcw());
                    } else {
                        this.PC(this.PC() + 2 & 0xFFFF);
                    }
                    local_tstates += 10;
                    break;
                }
                case 250: {
                    if (this.Sset()) {
                        this.PC(this.nxtpcw());
                    } else {
                        this.PC(this.PC() + 2 & 0xFFFF);
                    }
                    local_tstates += 10;
                    break;
                }
                case 195: {
                    this.PC(this.peekw(this.PC()));
                    local_tstates += 10;
                    break;
                }
                case 203: {
                    local_tstates += this.execute_cb();
                    break;
                }
                case 211: {
                    this.outb(this.nxtpcb(), this.A(), local_tstates);
                    local_tstates += 11;
                    break;
                }
                case 219: {
                    this.A(this.inb(this.A() << 8 | this.nxtpcb()));
                    local_tstates += 11;
                    break;
                }
                case 227: {
                    int t = this.HL();
                    int sp = this.SP();
                    this.HL(this.peekw(sp));
                    this.pokew(sp, t);
                    local_tstates += 19;
                    break;
                }
                case 235: {
                    int t = this.HL();
                    this.HL(this.DE());
                    this.DE(t);
                    local_tstates += 4;
                    break;
                }
                case 243: {
                    this.IFF1(false);
                    this.IFF2(false);
                    local_tstates += 4;
                    break;
                }
                case 251: {
                    this.IFF1(true);
                    this.IFF2(true);
                    local_tstates += 4;
                    break;
                }
                case 196: {
                    int t;
                    if (!this.Zset()) {
                        t = this.nxtpcw();
                        this.pushpc();
                        this.PC(t);
                        local_tstates += 17;
                        break;
                    }
                    this.PC(this.PC() + 2 & 0xFFFF);
                    local_tstates += 10;
                    break;
                }
                case 204: {
                    int t;
                    if (this.Zset()) {
                        t = this.nxtpcw();
                        this.pushpc();
                        this.PC(t);
                        local_tstates += 17;
                        break;
                    }
                    this.PC(this.PC() + 2 & 0xFFFF);
                    local_tstates += 10;
                    break;
                }
                case 212: {
                    int t;
                    if (!this.Cset()) {
                        t = this.nxtpcw();
                        this.pushpc();
                        this.PC(t);
                        local_tstates += 17;
                        break;
                    }
                    this.PC(this.PC() + 2 & 0xFFFF);
                    local_tstates += 10;
                    break;
                }
                case 220: {
                    int t;
                    if (this.Cset()) {
                        t = this.nxtpcw();
                        this.pushpc();
                        this.PC(t);
                        local_tstates += 17;
                        break;
                    }
                    this.PC(this.PC() + 2 & 0xFFFF);
                    local_tstates += 10;
                    break;
                }
                case 228: {
                    int t;
                    if (!this.PVset()) {
                        t = this.nxtpcw();
                        this.pushpc();
                        this.PC(t);
                        local_tstates += 17;
                        break;
                    }
                    this.PC(this.PC() + 2 & 0xFFFF);
                    local_tstates += 10;
                    break;
                }
                case 236: {
                    int t;
                    if (this.PVset()) {
                        t = this.nxtpcw();
                        this.pushpc();
                        this.PC(t);
                        local_tstates += 17;
                        break;
                    }
                    this.PC(this.PC() + 2 & 0xFFFF);
                    local_tstates += 10;
                    break;
                }
                case 244: {
                    int t;
                    if (!this.Sset()) {
                        t = this.nxtpcw();
                        this.pushpc();
                        this.PC(t);
                        local_tstates += 17;
                        break;
                    }
                    this.PC(this.PC() + 2 & 0xFFFF);
                    local_tstates += 10;
                    break;
                }
                case 252: {
                    int t;
                    if (this.Sset()) {
                        t = this.nxtpcw();
                        this.pushpc();
                        this.PC(t);
                        local_tstates += 17;
                        break;
                    }
                    this.PC(this.PC() + 2 & 0xFFFF);
                    local_tstates += 10;
                    break;
                }
                case 197: {
                    this.pushw(this.BC());
                    local_tstates += 11;
                    break;
                }
                case 205: {
                    int t = this.nxtpcw();
                    this.pushpc();
                    this.PC(t);
                    local_tstates += 17;
                    break;
                }
                case 213: {
                    this.pushw(this.DE());
                    local_tstates += 11;
                    break;
                }
                case 221: {
                    this.ID(this.IX());
                    local_tstates += this.execute_id();
                    this.IX(this.ID());
                    break;
                }
                case 229: {
                    this.pushw(this.HL());
                    local_tstates += 11;
                    break;
                }
                case 237: {
                    local_tstates += this.execute_ed(local_tstates);
                    break;
                }
                case 245: {
                    this.pushw(this.AF());
                    local_tstates += 11;
                    break;
                }
                case 253: {
                    this.ID(this.IY());
                    local_tstates += this.execute_id();
                    this.IY(this.ID());
                    break;
                }
                case 198: {
                    this.add_a(this.nxtpcb());
                    local_tstates += 7;
                    break;
                }
                case 206: {
                    this.adc_a(this.nxtpcb());
                    local_tstates += 7;
                    break;
                }
                case 214: {
                    this.sub_a(this.nxtpcb());
                    local_tstates += 7;
                    break;
                }
                case 222: {
                    this.sbc_a(this.nxtpcb());
                    local_tstates += 7;
                    break;
                }
                case 230: {
                    this.and_a(this.nxtpcb());
                    local_tstates += 7;
                    break;
                }
                case 238: {
                    this.xor_a(this.nxtpcb());
                    local_tstates += 7;
                    break;
                }
                case 246: {
                    this.or_a(this.nxtpcb());
                    local_tstates += 7;
                    break;
                }
                case 254: {
                    this.cp_a(this.nxtpcb());
                    local_tstates += 7;
                    break;
                }
                case 199: {
                    this.pushpc();
                    this.PC(0);
                    local_tstates += 11;
                    break;
                }
                case 207: {
                    this.pushpc();
                    this.PC(8);
                    local_tstates += 11;
                    break;
                }
                case 215: {
                    this.pushpc();
                    this.PC(16);
                    local_tstates += 11;
                    break;
                }
                case 223: {
                    this.pushpc();
                    this.PC(24);
                    local_tstates += 11;
                    break;
                }
                case 231: {
                    this.pushpc();
                    this.PC(32);
                    local_tstates += 11;
                    break;
                }
                case 239: {
                    this.pushpc();
                    this.PC(40);
                    local_tstates += 11;
                    break;
                }
                case 247: {
                    this.pushpc();
                    this.PC(48);
                    local_tstates += 11;
                    break;
                }
                case 255: {
                    this.pushpc();
                    this.PC(56);
                    local_tstates += 11;
                }
            }
        }
    }

    private final int execute_ed(int local_tstates) {
        this.REFRESH(1);
        switch (this.nxtpcb()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 180: 
            case 181: 
            case 182: 
            case 183: {
                return 8;
            }
            case 64: {
                this.B(this.in_bc());
                return 12;
            }
            case 72: {
                this.C(this.in_bc());
                return 12;
            }
            case 80: {
                this.D(this.in_bc());
                return 12;
            }
            case 88: {
                this.E(this.in_bc());
                return 12;
            }
            case 96: {
                this.H(this.in_bc());
                return 12;
            }
            case 104: {
                this.L(this.in_bc());
                return 12;
            }
            case 112: {
                this.in_bc();
                return 12;
            }
            case 120: {
                this.A(this.in_bc());
                return 12;
            }
            case 65: {
                this.outb(this.BC(), this.B(), local_tstates);
                return 12;
            }
            case 73: {
                this.outb(this.BC(), this.C(), local_tstates);
                return 12;
            }
            case 81: {
                this.outb(this.BC(), this.D(), local_tstates);
                return 12;
            }
            case 89: {
                this.outb(this.BC(), this.E(), local_tstates);
                return 12;
            }
            case 97: {
                this.outb(this.BC(), this.H(), local_tstates);
                return 12;
            }
            case 105: {
                this.outb(this.BC(), this.L(), local_tstates);
                return 12;
            }
            case 113: {
                this.outb(this.BC(), 0, local_tstates);
                return 12;
            }
            case 121: {
                this.outb(this.BC(), this.A(), local_tstates);
                return 12;
            }
            case 66: {
                this.HL(this.sbc16(this.HL(), this.BC()));
                return 15;
            }
            case 74: {
                this.HL(this.adc16(this.HL(), this.BC()));
                return 15;
            }
            case 82: {
                this.HL(this.sbc16(this.HL(), this.DE()));
                return 15;
            }
            case 90: {
                this.HL(this.adc16(this.HL(), this.DE()));
                return 15;
            }
            case 98: {
                int hl = this.HL();
                this.HL(this.sbc16(hl, hl));
                return 15;
            }
            case 106: {
                int hl = this.HL();
                this.HL(this.adc16(hl, hl));
                return 15;
            }
            case 114: {
                this.HL(this.sbc16(this.HL(), this.SP()));
                return 15;
            }
            case 122: {
                this.HL(this.adc16(this.HL(), this.SP()));
                return 15;
            }
            case 67: {
                this.pokew(this.nxtpcw(), this.BC());
                return 20;
            }
            case 75: {
                this.BC(this.peekw(this.nxtpcw()));
                return 20;
            }
            case 83: {
                this.pokew(this.nxtpcw(), this.DE());
                return 20;
            }
            case 91: {
                this.DE(this.peekw(this.nxtpcw()));
                return 20;
            }
            case 99: {
                this.pokew(this.nxtpcw(), this.HL());
                return 20;
            }
            case 107: {
                this.HL(this.peekw(this.nxtpcw()));
                return 20;
            }
            case 115: {
                this.pokew(this.nxtpcw(), this.SP());
                return 20;
            }
            case 123: {
                this.SP(this.peekw(this.nxtpcw()));
                return 20;
            }
            case 68: 
            case 76: 
            case 84: 
            case 92: 
            case 100: 
            case 108: 
            case 116: 
            case 124: {
                this.neg_a();
                return 8;
            }
            case 69: 
            case 85: 
            case 101: 
            case 117: {
                this.IFF1(this.IFF2());
                this.poppc();
                return 14;
            }
            case 77: 
            case 93: 
            case 109: 
            case 125: {
                this.poppc();
                return 14;
            }
            case 70: 
            case 78: 
            case 102: 
            case 110: {
                this.IM(0);
                return 8;
            }
            case 86: 
            case 118: {
                this.IM(1);
                return 8;
            }
            case 94: 
            case 126: {
                this.IM(2);
                return 8;
            }
            case 71: {
                this.I(this.A());
                return 9;
            }
            case 79: {
                this.R(this.A());
                return 9;
            }
            case 87: {
                this.ld_a_i();
                return 9;
            }
            case 95: {
                this.ld_a_r();
                return 9;
            }
            case 103: {
                this.rrd_a();
                return 18;
            }
            case 111: {
                this.rld_a();
                return 18;
            }
            case 160: {
                this.pokeb(this.DE(), this.peekb(this.HL()));
                this.DE(Z80.inc16(this.DE()));
                this.HL(Z80.inc16(this.HL()));
                this.BC(Z80.dec16(this.BC()));
                this.setPV(this.BC() != 0);
                this.setH(false);
                this.setN(false);
                return 16;
            }
            case 161: {
                boolean c = this.Cset();
                this.cp_a(this.peekb(this.HL()));
                this.HL(Z80.inc16(this.HL()));
                this.BC(Z80.dec16(this.BC()));
                this.setPV(this.BC() != 0);
                this.setC(c);
                return 16;
            }
            case 162: {
                this.pokeb(this.HL(), this.inb(this.BC()));
                int b = Z80.qdec8(this.B());
                this.B(b);
                this.HL(Z80.inc16(this.HL()));
                this.setZ(b == 0);
                this.setN(true);
                return 16;
            }
            case 163: {
                int b = Z80.qdec8(this.B());
                this.B(b);
                this.outb(this.BC(), this.peekb(this.HL()), local_tstates);
                this.HL(Z80.inc16(this.HL()));
                this.setZ(b == 0);
                this.setN(true);
                return 16;
            }
            case 168: {
                this.pokeb(this.DE(), this.peekb(this.HL()));
                this.DE(Z80.dec16(this.DE()));
                this.HL(Z80.dec16(this.HL()));
                this.BC(Z80.dec16(this.BC()));
                this.setPV(this.BC() != 0);
                this.setH(false);
                this.setN(false);
                return 16;
            }
            case 169: {
                boolean c = this.Cset();
                this.cp_a(this.peekb(this.HL()));
                this.HL(Z80.dec16(this.HL()));
                this.BC(Z80.dec16(this.BC()));
                this.setPV(this.BC() != 0);
                this.setC(c);
                return 16;
            }
            case 170: {
                this.pokeb(this.HL(), this.inb(this.BC()));
                int b = Z80.qdec8(this.B());
                this.B(b);
                this.HL(Z80.dec16(this.HL()));
                this.setZ(b == 0);
                this.setN(true);
                return 16;
            }
            case 171: {
                int b = Z80.qdec8(this.B());
                this.B(b);
                this.outb(this.BC(), this.peekb(this.HL()), local_tstates);
                this.HL(Z80.dec16(this.HL()));
                this.setZ(b == 0);
                this.setN(true);
                return 16;
            }
            case 176: {
                int _local_tstates = 0;
                int count = this.BC();
                int dest = this.DE();
                int from = this.HL();
                this.REFRESH(-2);
                do {
                    this.pokeb(dest, this.peekb(from));
                    from = Z80.inc16(from);
                    dest = Z80.inc16(dest);
                    count = Z80.dec16(count);
                    this.REFRESH(2);
                } while (!Z80.interruptTriggered(_local_tstates += 21) && count != 0);
                if (count != 0) {
                    this.PC(this.PC() - 2 & 0xFFFF);
                    this.setH(false);
                    this.setN(false);
                    this.setPV(true);
                } else {
                    _local_tstates -= 5;
                    this.setH(false);
                    this.setN(false);
                    this.setPV(false);
                }
                this.DE(dest);
                this.HL(from);
                this.BC(count);
                return _local_tstates;
            }
            case 177: {
                boolean c = this.Cset();
                this.cp_a(this.peekb(this.HL()));
                this.HL(Z80.inc16(this.HL()));
                this.BC(Z80.dec16(this.BC()));
                boolean pv = this.BC() != 0;
                this.setPV(pv);
                this.setC(c);
                if (pv && !this.Zset()) {
                    this.PC(this.PC() - 2 & 0xFFFF);
                    return 21;
                }
                return 16;
            }
            case 178: {
                this.pokeb(this.HL(), this.inb(this.BC()));
                int b = Z80.qdec8(this.B());
                this.B(b);
                this.HL(Z80.inc16(this.HL()));
                this.setZ(true);
                this.setN(true);
                if (b != 0) {
                    this.PC(this.PC() - 2 & 0xFFFF);
                    return 21;
                }
                return 16;
            }
            case 179: {
                int b = Z80.qdec8(this.B());
                this.B(b);
                this.outb(this.BC(), this.peekb(this.HL()), local_tstates);
                this.HL(Z80.inc16(this.HL()));
                this.setZ(true);
                this.setN(true);
                if (b != 0) {
                    this.PC(this.PC() - 2 & 0xFFFF);
                    return 21;
                }
                return 16;
            }
            case 184: {
                int _local_tstates = 0;
                int count = this.BC();
                int dest = this.DE();
                int from = this.HL();
                this.REFRESH(-2);
                do {
                    this.pokeb(dest, this.peekb(from));
                    from = Z80.dec16(from);
                    dest = Z80.dec16(dest);
                    count = Z80.dec16(count);
                    this.REFRESH(2);
                } while (!Z80.interruptTriggered(_local_tstates += 21) && count != 0);
                if (count != 0) {
                    this.PC(this.PC() - 2 & 0xFFFF);
                    this.setH(false);
                    this.setN(false);
                    this.setPV(true);
                } else {
                    _local_tstates -= 5;
                    this.setH(false);
                    this.setN(false);
                    this.setPV(false);
                }
                this.DE(dest);
                this.HL(from);
                this.BC(count);
                return _local_tstates;
            }
            case 185: {
                boolean c = this.Cset();
                this.cp_a(this.peekb(this.HL()));
                this.HL(Z80.dec16(this.HL()));
                this.BC(Z80.dec16(this.BC()));
                boolean pv = this.BC() != 0;
                this.setPV(pv);
                this.setC(c);
                if (pv && !this.Zset()) {
                    this.PC(this.PC() - 2 & 0xFFFF);
                    return 21;
                }
                return 16;
            }
            case 186: {
                this.pokeb(this.HL(), this.inb(this.BC()));
                int b = Z80.qdec8(this.B());
                this.B(b);
                this.HL(Z80.dec16(this.HL()));
                this.setZ(true);
                this.setN(true);
                if (b != 0) {
                    this.PC(this.PC() - 2 & 0xFFFF);
                    return 21;
                }
                return 16;
            }
            case 187: {
                int b = Z80.qdec8(this.B());
                this.B(b);
                this.outb(this.BC(), this.peekb(this.HL()), local_tstates);
                this.HL(Z80.dec16(this.HL()));
                this.setZ(true);
                this.setN(true);
                if (b != 0) {
                    this.PC(this.PC() - 2 & 0xFFFF);
                    return 21;
                }
                return 16;
            }
        }
        return 8;
    }

    private final int execute_cb() {
        this.REFRESH(1);
        switch (this.nxtpcb()) {
            case 0: {
                this.B(this.rlc(this.B()));
                return 8;
            }
            case 1: {
                this.C(this.rlc(this.C()));
                return 8;
            }
            case 2: {
                this.D(this.rlc(this.D()));
                return 8;
            }
            case 3: {
                this.E(this.rlc(this.E()));
                return 8;
            }
            case 4: {
                this.H(this.rlc(this.H()));
                return 8;
            }
            case 5: {
                this.L(this.rlc(this.L()));
                return 8;
            }
            case 6: {
                int hl = this.HL();
                this.pokeb(hl, this.rlc(this.peekb(hl)));
                return 15;
            }
            case 7: {
                this.A(this.rlc(this.A()));
                return 8;
            }
            case 8: {
                this.B(this.rrc(this.B()));
                return 8;
            }
            case 9: {
                this.C(this.rrc(this.C()));
                return 8;
            }
            case 10: {
                this.D(this.rrc(this.D()));
                return 8;
            }
            case 11: {
                this.E(this.rrc(this.E()));
                return 8;
            }
            case 12: {
                this.H(this.rrc(this.H()));
                return 8;
            }
            case 13: {
                this.L(this.rrc(this.L()));
                return 8;
            }
            case 14: {
                int hl = this.HL();
                this.pokeb(hl, this.rrc(this.peekb(hl)));
                return 15;
            }
            case 15: {
                this.A(this.rrc(this.A()));
                return 8;
            }
            case 16: {
                this.B(this.rl(this.B()));
                return 8;
            }
            case 17: {
                this.C(this.rl(this.C()));
                return 8;
            }
            case 18: {
                this.D(this.rl(this.D()));
                return 8;
            }
            case 19: {
                this.E(this.rl(this.E()));
                return 8;
            }
            case 20: {
                this.H(this.rl(this.H()));
                return 8;
            }
            case 21: {
                this.L(this.rl(this.L()));
                return 8;
            }
            case 22: {
                int hl = this.HL();
                this.pokeb(hl, this.rl(this.peekb(hl)));
                return 15;
            }
            case 23: {
                this.A(this.rl(this.A()));
                return 8;
            }
            case 24: {
                this.B(this.rr(this.B()));
                return 8;
            }
            case 25: {
                this.C(this.rr(this.C()));
                return 8;
            }
            case 26: {
                this.D(this.rr(this.D()));
                return 8;
            }
            case 27: {
                this.E(this.rr(this.E()));
                return 8;
            }
            case 28: {
                this.H(this.rr(this.H()));
                return 8;
            }
            case 29: {
                this.L(this.rr(this.L()));
                return 8;
            }
            case 30: {
                int hl = this.HL();
                this.pokeb(hl, this.rr(this.peekb(hl)));
                return 15;
            }
            case 31: {
                this.A(this.rr(this.A()));
                return 8;
            }
            case 32: {
                this.B(this.sla(this.B()));
                return 8;
            }
            case 33: {
                this.C(this.sla(this.C()));
                return 8;
            }
            case 34: {
                this.D(this.sla(this.D()));
                return 8;
            }
            case 35: {
                this.E(this.sla(this.E()));
                return 8;
            }
            case 36: {
                this.H(this.sla(this.H()));
                return 8;
            }
            case 37: {
                this.L(this.sla(this.L()));
                return 8;
            }
            case 38: {
                int hl = this.HL();
                this.pokeb(hl, this.sla(this.peekb(hl)));
                return 15;
            }
            case 39: {
                this.A(this.sla(this.A()));
                return 8;
            }
            case 40: {
                this.B(this.sra(this.B()));
                return 8;
            }
            case 41: {
                this.C(this.sra(this.C()));
                return 8;
            }
            case 42: {
                this.D(this.sra(this.D()));
                return 8;
            }
            case 43: {
                this.E(this.sra(this.E()));
                return 8;
            }
            case 44: {
                this.H(this.sra(this.H()));
                return 8;
            }
            case 45: {
                this.L(this.sra(this.L()));
                return 8;
            }
            case 46: {
                int hl = this.HL();
                this.pokeb(hl, this.sra(this.peekb(hl)));
                return 15;
            }
            case 47: {
                this.A(this.sra(this.A()));
                return 8;
            }
            case 48: {
                this.B(this.sls(this.B()));
                return 8;
            }
            case 49: {
                this.C(this.sls(this.C()));
                return 8;
            }
            case 50: {
                this.D(this.sls(this.D()));
                return 8;
            }
            case 51: {
                this.E(this.sls(this.E()));
                return 8;
            }
            case 52: {
                this.H(this.sls(this.H()));
                return 8;
            }
            case 53: {
                this.L(this.sls(this.L()));
                return 8;
            }
            case 54: {
                int hl = this.HL();
                this.pokeb(hl, this.sls(this.peekb(hl)));
                return 15;
            }
            case 55: {
                this.A(this.sls(this.A()));
                return 8;
            }
            case 56: {
                this.B(this.srl(this.B()));
                return 8;
            }
            case 57: {
                this.C(this.srl(this.C()));
                return 8;
            }
            case 58: {
                this.D(this.srl(this.D()));
                return 8;
            }
            case 59: {
                this.E(this.srl(this.E()));
                return 8;
            }
            case 60: {
                this.H(this.srl(this.H()));
                return 8;
            }
            case 61: {
                this.L(this.srl(this.L()));
                return 8;
            }
            case 62: {
                int hl = this.HL();
                this.pokeb(hl, this.srl(this.peekb(hl)));
                return 15;
            }
            case 63: {
                this.A(this.srl(this.A()));
                return 8;
            }
            case 64: {
                this.bit(1, this.B());
                return 8;
            }
            case 65: {
                this.bit(1, this.C());
                return 8;
            }
            case 66: {
                this.bit(1, this.D());
                return 8;
            }
            case 67: {
                this.bit(1, this.E());
                return 8;
            }
            case 68: {
                this.bit(1, this.H());
                return 8;
            }
            case 69: {
                this.bit(1, this.L());
                return 8;
            }
            case 70: {
                this.bit(1, this.peekb(this.HL()));
                return 12;
            }
            case 71: {
                this.bit(1, this.A());
                return 8;
            }
            case 72: {
                this.bit(2, this.B());
                return 8;
            }
            case 73: {
                this.bit(2, this.C());
                return 8;
            }
            case 74: {
                this.bit(2, this.D());
                return 8;
            }
            case 75: {
                this.bit(2, this.E());
                return 8;
            }
            case 76: {
                this.bit(2, this.H());
                return 8;
            }
            case 77: {
                this.bit(2, this.L());
                return 8;
            }
            case 78: {
                this.bit(2, this.peekb(this.HL()));
                return 12;
            }
            case 79: {
                this.bit(2, this.A());
                return 8;
            }
            case 80: {
                this.bit(4, this.B());
                return 8;
            }
            case 81: {
                this.bit(4, this.C());
                return 8;
            }
            case 82: {
                this.bit(4, this.D());
                return 8;
            }
            case 83: {
                this.bit(4, this.E());
                return 8;
            }
            case 84: {
                this.bit(4, this.H());
                return 8;
            }
            case 85: {
                this.bit(4, this.L());
                return 8;
            }
            case 86: {
                this.bit(4, this.peekb(this.HL()));
                return 12;
            }
            case 87: {
                this.bit(4, this.A());
                return 8;
            }
            case 88: {
                this.bit(8, this.B());
                return 8;
            }
            case 89: {
                this.bit(8, this.C());
                return 8;
            }
            case 90: {
                this.bit(8, this.D());
                return 8;
            }
            case 91: {
                this.bit(8, this.E());
                return 8;
            }
            case 92: {
                this.bit(8, this.H());
                return 8;
            }
            case 93: {
                this.bit(8, this.L());
                return 8;
            }
            case 94: {
                this.bit(8, this.peekb(this.HL()));
                return 12;
            }
            case 95: {
                this.bit(8, this.A());
                return 8;
            }
            case 96: {
                this.bit(16, this.B());
                return 8;
            }
            case 97: {
                this.bit(16, this.C());
                return 8;
            }
            case 98: {
                this.bit(16, this.D());
                return 8;
            }
            case 99: {
                this.bit(16, this.E());
                return 8;
            }
            case 100: {
                this.bit(16, this.H());
                return 8;
            }
            case 101: {
                this.bit(16, this.L());
                return 8;
            }
            case 102: {
                this.bit(16, this.peekb(this.HL()));
                return 12;
            }
            case 103: {
                this.bit(16, this.A());
                return 8;
            }
            case 104: {
                this.bit(32, this.B());
                return 8;
            }
            case 105: {
                this.bit(32, this.C());
                return 8;
            }
            case 106: {
                this.bit(32, this.D());
                return 8;
            }
            case 107: {
                this.bit(32, this.E());
                return 8;
            }
            case 108: {
                this.bit(32, this.H());
                return 8;
            }
            case 109: {
                this.bit(32, this.L());
                return 8;
            }
            case 110: {
                this.bit(32, this.peekb(this.HL()));
                return 12;
            }
            case 111: {
                this.bit(32, this.A());
                return 8;
            }
            case 112: {
                this.bit(64, this.B());
                return 8;
            }
            case 113: {
                this.bit(64, this.C());
                return 8;
            }
            case 114: {
                this.bit(64, this.D());
                return 8;
            }
            case 115: {
                this.bit(64, this.E());
                return 8;
            }
            case 116: {
                this.bit(64, this.H());
                return 8;
            }
            case 117: {
                this.bit(64, this.L());
                return 8;
            }
            case 118: {
                this.bit(64, this.peekb(this.HL()));
                return 12;
            }
            case 119: {
                this.bit(64, this.A());
                return 8;
            }
            case 120: {
                this.bit(128, this.B());
                return 8;
            }
            case 121: {
                this.bit(128, this.C());
                return 8;
            }
            case 122: {
                this.bit(128, this.D());
                return 8;
            }
            case 123: {
                this.bit(128, this.E());
                return 8;
            }
            case 124: {
                this.bit(128, this.H());
                return 8;
            }
            case 125: {
                this.bit(128, this.L());
                return 8;
            }
            case 126: {
                this.bit(128, this.peekb(this.HL()));
                return 12;
            }
            case 127: {
                this.bit(128, this.A());
                return 8;
            }
            case 128: {
                this.B(Z80.res(1, this.B()));
                return 8;
            }
            case 129: {
                this.C(Z80.res(1, this.C()));
                return 8;
            }
            case 130: {
                this.D(Z80.res(1, this.D()));
                return 8;
            }
            case 131: {
                this.E(Z80.res(1, this.E()));
                return 8;
            }
            case 132: {
                this.H(Z80.res(1, this.H()));
                return 8;
            }
            case 133: {
                this.L(Z80.res(1, this.L()));
                return 8;
            }
            case 134: {
                int hl = this.HL();
                this.pokeb(hl, Z80.res(1, this.peekb(hl)));
                return 15;
            }
            case 135: {
                this.A(Z80.res(1, this.A()));
                return 8;
            }
            case 136: {
                this.B(Z80.res(2, this.B()));
                return 8;
            }
            case 137: {
                this.C(Z80.res(2, this.C()));
                return 8;
            }
            case 138: {
                this.D(Z80.res(2, this.D()));
                return 8;
            }
            case 139: {
                this.E(Z80.res(2, this.E()));
                return 8;
            }
            case 140: {
                this.H(Z80.res(2, this.H()));
                return 8;
            }
            case 141: {
                this.L(Z80.res(2, this.L()));
                return 8;
            }
            case 142: {
                int hl = this.HL();
                this.pokeb(hl, Z80.res(2, this.peekb(hl)));
                return 15;
            }
            case 143: {
                this.A(Z80.res(2, this.A()));
                return 8;
            }
            case 144: {
                this.B(Z80.res(4, this.B()));
                return 8;
            }
            case 145: {
                this.C(Z80.res(4, this.C()));
                return 8;
            }
            case 146: {
                this.D(Z80.res(4, this.D()));
                return 8;
            }
            case 147: {
                this.E(Z80.res(4, this.E()));
                return 8;
            }
            case 148: {
                this.H(Z80.res(4, this.H()));
                return 8;
            }
            case 149: {
                this.L(Z80.res(4, this.L()));
                return 8;
            }
            case 150: {
                int hl = this.HL();
                this.pokeb(hl, Z80.res(4, this.peekb(hl)));
                return 15;
            }
            case 151: {
                this.A(Z80.res(4, this.A()));
                return 8;
            }
            case 152: {
                this.B(Z80.res(8, this.B()));
                return 8;
            }
            case 153: {
                this.C(Z80.res(8, this.C()));
                return 8;
            }
            case 154: {
                this.D(Z80.res(8, this.D()));
                return 8;
            }
            case 155: {
                this.E(Z80.res(8, this.E()));
                return 8;
            }
            case 156: {
                this.H(Z80.res(8, this.H()));
                return 8;
            }
            case 157: {
                this.L(Z80.res(8, this.L()));
                return 8;
            }
            case 158: {
                int hl = this.HL();
                this.pokeb(hl, Z80.res(8, this.peekb(hl)));
                return 15;
            }
            case 159: {
                this.A(Z80.res(8, this.A()));
                return 8;
            }
            case 160: {
                this.B(Z80.res(16, this.B()));
                return 8;
            }
            case 161: {
                this.C(Z80.res(16, this.C()));
                return 8;
            }
            case 162: {
                this.D(Z80.res(16, this.D()));
                return 8;
            }
            case 163: {
                this.E(Z80.res(16, this.E()));
                return 8;
            }
            case 164: {
                this.H(Z80.res(16, this.H()));
                return 8;
            }
            case 165: {
                this.L(Z80.res(16, this.L()));
                return 8;
            }
            case 166: {
                int hl = this.HL();
                this.pokeb(hl, Z80.res(16, this.peekb(hl)));
                return 15;
            }
            case 167: {
                this.A(Z80.res(16, this.A()));
                return 8;
            }
            case 168: {
                this.B(Z80.res(32, this.B()));
                return 8;
            }
            case 169: {
                this.C(Z80.res(32, this.C()));
                return 8;
            }
            case 170: {
                this.D(Z80.res(32, this.D()));
                return 8;
            }
            case 171: {
                this.E(Z80.res(32, this.E()));
                return 8;
            }
            case 172: {
                this.H(Z80.res(32, this.H()));
                return 8;
            }
            case 173: {
                this.L(Z80.res(32, this.L()));
                return 8;
            }
            case 174: {
                int hl = this.HL();
                this.pokeb(hl, Z80.res(32, this.peekb(hl)));
                return 15;
            }
            case 175: {
                this.A(Z80.res(32, this.A()));
                return 8;
            }
            case 176: {
                this.B(Z80.res(64, this.B()));
                return 8;
            }
            case 177: {
                this.C(Z80.res(64, this.C()));
                return 8;
            }
            case 178: {
                this.D(Z80.res(64, this.D()));
                return 8;
            }
            case 179: {
                this.E(Z80.res(64, this.E()));
                return 8;
            }
            case 180: {
                this.H(Z80.res(64, this.H()));
                return 8;
            }
            case 181: {
                this.L(Z80.res(64, this.L()));
                return 8;
            }
            case 182: {
                int hl = this.HL();
                this.pokeb(hl, Z80.res(64, this.peekb(hl)));
                return 15;
            }
            case 183: {
                this.A(Z80.res(64, this.A()));
                return 8;
            }
            case 184: {
                this.B(Z80.res(128, this.B()));
                return 8;
            }
            case 185: {
                this.C(Z80.res(128, this.C()));
                return 8;
            }
            case 186: {
                this.D(Z80.res(128, this.D()));
                return 8;
            }
            case 187: {
                this.E(Z80.res(128, this.E()));
                return 8;
            }
            case 188: {
                this.H(Z80.res(128, this.H()));
                return 8;
            }
            case 189: {
                this.L(Z80.res(128, this.L()));
                return 8;
            }
            case 190: {
                int hl = this.HL();
                this.pokeb(hl, Z80.res(128, this.peekb(hl)));
                return 15;
            }
            case 191: {
                this.A(Z80.res(128, this.A()));
                return 8;
            }
            case 192: {
                this.B(Z80.set(1, this.B()));
                return 8;
            }
            case 193: {
                this.C(Z80.set(1, this.C()));
                return 8;
            }
            case 194: {
                this.D(Z80.set(1, this.D()));
                return 8;
            }
            case 195: {
                this.E(Z80.set(1, this.E()));
                return 8;
            }
            case 196: {
                this.H(Z80.set(1, this.H()));
                return 8;
            }
            case 197: {
                this.L(Z80.set(1, this.L()));
                return 8;
            }
            case 198: {
                int hl = this.HL();
                this.pokeb(hl, Z80.set(1, this.peekb(hl)));
                return 15;
            }
            case 199: {
                this.A(Z80.set(1, this.A()));
                return 8;
            }
            case 200: {
                this.B(Z80.set(2, this.B()));
                return 8;
            }
            case 201: {
                this.C(Z80.set(2, this.C()));
                return 8;
            }
            case 202: {
                this.D(Z80.set(2, this.D()));
                return 8;
            }
            case 203: {
                this.E(Z80.set(2, this.E()));
                return 8;
            }
            case 204: {
                this.H(Z80.set(2, this.H()));
                return 8;
            }
            case 205: {
                this.L(Z80.set(2, this.L()));
                return 8;
            }
            case 206: {
                int hl = this.HL();
                this.pokeb(hl, Z80.set(2, this.peekb(hl)));
                return 15;
            }
            case 207: {
                this.A(Z80.set(2, this.A()));
                return 8;
            }
            case 208: {
                this.B(Z80.set(4, this.B()));
                return 8;
            }
            case 209: {
                this.C(Z80.set(4, this.C()));
                return 8;
            }
            case 210: {
                this.D(Z80.set(4, this.D()));
                return 8;
            }
            case 211: {
                this.E(Z80.set(4, this.E()));
                return 8;
            }
            case 212: {
                this.H(Z80.set(4, this.H()));
                return 8;
            }
            case 213: {
                this.L(Z80.set(4, this.L()));
                return 8;
            }
            case 214: {
                int hl = this.HL();
                this.pokeb(hl, Z80.set(4, this.peekb(hl)));
                return 15;
            }
            case 215: {
                this.A(Z80.set(4, this.A()));
                return 8;
            }
            case 216: {
                this.B(Z80.set(8, this.B()));
                return 8;
            }
            case 217: {
                this.C(Z80.set(8, this.C()));
                return 8;
            }
            case 218: {
                this.D(Z80.set(8, this.D()));
                return 8;
            }
            case 219: {
                this.E(Z80.set(8, this.E()));
                return 8;
            }
            case 220: {
                this.H(Z80.set(8, this.H()));
                return 8;
            }
            case 221: {
                this.L(Z80.set(8, this.L()));
                return 8;
            }
            case 222: {
                int hl = this.HL();
                this.pokeb(hl, Z80.set(8, this.peekb(hl)));
                return 15;
            }
            case 223: {
                this.A(Z80.set(8, this.A()));
                return 8;
            }
            case 224: {
                this.B(Z80.set(16, this.B()));
                return 8;
            }
            case 225: {
                this.C(Z80.set(16, this.C()));
                return 8;
            }
            case 226: {
                this.D(Z80.set(16, this.D()));
                return 8;
            }
            case 227: {
                this.E(Z80.set(16, this.E()));
                return 8;
            }
            case 228: {
                this.H(Z80.set(16, this.H()));
                return 8;
            }
            case 229: {
                this.L(Z80.set(16, this.L()));
                return 8;
            }
            case 230: {
                int hl = this.HL();
                this.pokeb(hl, Z80.set(16, this.peekb(hl)));
                return 15;
            }
            case 231: {
                this.A(Z80.set(16, this.A()));
                return 8;
            }
            case 232: {
                this.B(Z80.set(32, this.B()));
                return 8;
            }
            case 233: {
                this.C(Z80.set(32, this.C()));
                return 8;
            }
            case 234: {
                this.D(Z80.set(32, this.D()));
                return 8;
            }
            case 235: {
                this.E(Z80.set(32, this.E()));
                return 8;
            }
            case 236: {
                this.H(Z80.set(32, this.H()));
                return 8;
            }
            case 237: {
                this.L(Z80.set(32, this.L()));
                return 8;
            }
            case 238: {
                int hl = this.HL();
                this.pokeb(hl, Z80.set(32, this.peekb(hl)));
                return 15;
            }
            case 239: {
                this.A(Z80.set(32, this.A()));
                return 8;
            }
            case 240: {
                this.B(Z80.set(64, this.B()));
                return 8;
            }
            case 241: {
                this.C(Z80.set(64, this.C()));
                return 8;
            }
            case 242: {
                this.D(Z80.set(64, this.D()));
                return 8;
            }
            case 243: {
                this.E(Z80.set(64, this.E()));
                return 8;
            }
            case 244: {
                this.H(Z80.set(64, this.H()));
                return 8;
            }
            case 245: {
                this.L(Z80.set(64, this.L()));
                return 8;
            }
            case 246: {
                int hl = this.HL();
                this.pokeb(hl, Z80.set(64, this.peekb(hl)));
                return 15;
            }
            case 247: {
                this.A(Z80.set(64, this.A()));
                return 8;
            }
            case 248: {
                this.B(Z80.set(128, this.B()));
                return 8;
            }
            case 249: {
                this.C(Z80.set(128, this.C()));
                return 8;
            }
            case 250: {
                this.D(Z80.set(128, this.D()));
                return 8;
            }
            case 251: {
                this.E(Z80.set(128, this.E()));
                return 8;
            }
            case 252: {
                this.H(Z80.set(128, this.H()));
                return 8;
            }
            case 253: {
                this.L(Z80.set(128, this.L()));
                return 8;
            }
            case 254: {
                int hl = this.HL();
                this.pokeb(hl, Z80.set(128, this.peekb(hl)));
                return 15;
            }
            case 255: {
                this.A(Z80.set(128, this.A()));
                return 8;
            }
        }
        return 0;
    }

    private final int execute_id() {
        this.REFRESH(1);
        switch (this.nxtpcb()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 39: 
            case 40: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 55: 
            case 56: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 95: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 167: 
            case 168: 
            case 169: 
            case 170: 
            case 171: 
            case 175: 
            case 176: 
            case 177: 
            case 178: 
            case 179: 
            case 183: 
            case 184: 
            case 185: 
            case 186: 
            case 187: 
            case 191: 
            case 192: 
            case 193: 
            case 194: 
            case 195: 
            case 196: 
            case 197: 
            case 198: 
            case 199: 
            case 200: 
            case 201: 
            case 202: 
            case 204: 
            case 205: 
            case 206: 
            case 207: 
            case 208: 
            case 209: 
            case 210: 
            case 211: 
            case 212: 
            case 213: 
            case 214: 
            case 215: 
            case 216: 
            case 217: 
            case 218: 
            case 219: 
            case 220: 
            case 221: 
            case 222: 
            case 223: 
            case 224: 
            case 226: 
            case 228: 
            case 230: 
            case 231: 
            case 232: 
            case 234: 
            case 235: 
            case 236: 
            case 237: 
            case 238: 
            case 239: 
            case 240: 
            case 241: 
            case 242: 
            case 243: 
            case 244: 
            case 245: 
            case 246: 
            case 247: 
            case 248: {
                this.PC(Z80.dec16(this.PC()));
                this.REFRESH(-1);
                return 4;
            }
            case 9: {
                this.ID(this.add16(this.ID(), this.BC()));
                return 15;
            }
            case 25: {
                this.ID(this.add16(this.ID(), this.DE()));
                return 15;
            }
            case 41: {
                int id = this.ID();
                this.ID(this.add16(id, id));
                return 15;
            }
            case 57: {
                this.ID(this.add16(this.ID(), this.SP()));
                return 15;
            }
            case 33: {
                this.ID(this.nxtpcw());
                return 14;
            }
            case 34: {
                this.pokew(this.nxtpcw(), this.ID());
                return 20;
            }
            case 42: {
                this.ID(this.peekw(this.nxtpcw()));
                return 20;
            }
            case 35: {
                this.ID(Z80.inc16(this.ID()));
                return 10;
            }
            case 43: {
                this.ID(Z80.dec16(this.ID()));
                return 10;
            }
            case 36: {
                this.IDH(this.inc8(this.IDH()));
                return 8;
            }
            case 44: {
                this.IDL(this.inc8(this.IDL()));
                return 8;
            }
            case 52: {
                int z = this.ID_d();
                this.pokeb(z, this.inc8(this.peekb(z)));
                return 23;
            }
            case 37: {
                this.IDH(this.dec8(this.IDH()));
                return 8;
            }
            case 45: {
                this.IDL(this.dec8(this.IDL()));
                return 8;
            }
            case 53: {
                int z = this.ID_d();
                this.pokeb(z, this.dec8(this.peekb(z)));
                return 23;
            }
            case 38: {
                this.IDH(this.nxtpcb());
                return 11;
            }
            case 46: {
                this.IDL(this.nxtpcb());
                return 11;
            }
            case 54: {
                int z = this.ID_d();
                this.pokeb(z, this.nxtpcb());
                return 19;
            }
            case 68: {
                this.B(this.IDH());
                return 8;
            }
            case 69: {
                this.B(this.IDL());
                return 8;
            }
            case 70: {
                this.B(this.peekb(this.ID_d()));
                return 19;
            }
            case 76: {
                this.C(this.IDH());
                return 8;
            }
            case 77: {
                this.C(this.IDL());
                return 8;
            }
            case 78: {
                this.C(this.peekb(this.ID_d()));
                return 19;
            }
            case 84: {
                this.D(this.IDH());
                return 8;
            }
            case 85: {
                this.D(this.IDL());
                return 8;
            }
            case 86: {
                this.D(this.peekb(this.ID_d()));
                return 19;
            }
            case 92: {
                this.E(this.IDH());
                return 8;
            }
            case 93: {
                this.E(this.IDL());
                return 8;
            }
            case 94: {
                this.E(this.peekb(this.ID_d()));
                return 19;
            }
            case 96: {
                this.IDH(this.B());
                return 8;
            }
            case 97: {
                this.IDH(this.C());
                return 8;
            }
            case 98: {
                this.IDH(this.D());
                return 8;
            }
            case 99: {
                this.IDH(this.E());
                return 8;
            }
            case 100: {
                return 8;
            }
            case 101: {
                this.IDH(this.IDL());
                return 8;
            }
            case 102: {
                this.H(this.peekb(this.ID_d()));
                return 19;
            }
            case 103: {
                this.IDH(this.A());
                return 8;
            }
            case 104: {
                this.IDL(this.B());
                return 8;
            }
            case 105: {
                this.IDL(this.C());
                return 8;
            }
            case 106: {
                this.IDL(this.D());
                return 8;
            }
            case 107: {
                this.IDL(this.E());
                return 8;
            }
            case 108: {
                this.IDL(this.IDH());
                return 8;
            }
            case 109: {
                return 8;
            }
            case 110: {
                this.L(this.peekb(this.ID_d()));
                return 19;
            }
            case 111: {
                this.IDL(this.A());
                return 8;
            }
            case 112: {
                this.pokeb(this.ID_d(), this.B());
                return 19;
            }
            case 113: {
                this.pokeb(this.ID_d(), this.C());
                return 19;
            }
            case 114: {
                this.pokeb(this.ID_d(), this.D());
                return 19;
            }
            case 115: {
                this.pokeb(this.ID_d(), this.E());
                return 19;
            }
            case 116: {
                this.pokeb(this.ID_d(), this.H());
                return 19;
            }
            case 117: {
                this.pokeb(this.ID_d(), this.L());
                return 19;
            }
            case 119: {
                this.pokeb(this.ID_d(), this.A());
                return 19;
            }
            case 124: {
                this.A(this.IDH());
                return 8;
            }
            case 125: {
                this.A(this.IDL());
                return 8;
            }
            case 126: {
                this.A(this.peekb(this.ID_d()));
                return 19;
            }
            case 132: {
                this.add_a(this.IDH());
                return 8;
            }
            case 133: {
                this.add_a(this.IDL());
                return 8;
            }
            case 134: {
                this.add_a(this.peekb(this.ID_d()));
                return 19;
            }
            case 140: {
                this.adc_a(this.IDH());
                return 8;
            }
            case 141: {
                this.adc_a(this.IDL());
                return 8;
            }
            case 142: {
                this.adc_a(this.peekb(this.ID_d()));
                return 19;
            }
            case 148: {
                this.sub_a(this.IDH());
                return 8;
            }
            case 149: {
                this.sub_a(this.IDL());
                return 8;
            }
            case 150: {
                this.sub_a(this.peekb(this.ID_d()));
                return 19;
            }
            case 156: {
                this.sbc_a(this.IDH());
                return 8;
            }
            case 157: {
                this.sbc_a(this.IDL());
                return 8;
            }
            case 158: {
                this.sbc_a(this.peekb(this.ID_d()));
                return 19;
            }
            case 164: {
                this.and_a(this.IDH());
                return 8;
            }
            case 165: {
                this.and_a(this.IDL());
                return 8;
            }
            case 166: {
                this.and_a(this.peekb(this.ID_d()));
                return 19;
            }
            case 172: {
                this.xor_a(this.IDH());
                return 8;
            }
            case 173: {
                this.xor_a(this.IDL());
                return 8;
            }
            case 174: {
                this.xor_a(this.peekb(this.ID_d()));
                return 19;
            }
            case 180: {
                this.or_a(this.IDH());
                return 8;
            }
            case 181: {
                this.or_a(this.IDL());
                return 8;
            }
            case 182: {
                this.or_a(this.peekb(this.ID_d()));
                return 19;
            }
            case 188: {
                this.cp_a(this.IDH());
                return 8;
            }
            case 189: {
                this.cp_a(this.IDL());
                return 8;
            }
            case 190: {
                this.cp_a(this.peekb(this.ID_d()));
                return 19;
            }
            case 225: {
                this.ID(this.popw());
                return 14;
            }
            case 233: {
                this.PC(this.ID());
                return 8;
            }
            case 249: {
                this.SP(this.ID());
                return 10;
            }
            case 203: {
                int z = this.ID_d();
                int op = this.nxtpcb();
                this.execute_id_cb(op, z);
                return (op & 0xC0) == 64 ? 20 : 23;
            }
            case 227: {
                int t = this.ID();
                int sp = this.SP();
                this.ID(this.peekw(sp));
                this.pokew(sp, t);
                return 23;
            }
            case 229: {
                this.pushw(this.ID());
                return 15;
            }
        }
        return 0;
    }

    private final void execute_id_cb(int op, int z) {
        switch (op) {
            case 0: {
                op = this.rlc(this.peekb(z));
                this.B(op);
                this.pokeb(z, op);
                return;
            }
            case 1: {
                op = this.rlc(this.peekb(z));
                this.C(op);
                this.pokeb(z, op);
                return;
            }
            case 2: {
                op = this.rlc(this.peekb(z));
                this.D(op);
                this.pokeb(z, op);
                return;
            }
            case 3: {
                op = this.rlc(this.peekb(z));
                this.E(op);
                this.pokeb(z, op);
                return;
            }
            case 4: {
                op = this.rlc(this.peekb(z));
                this.H(op);
                this.pokeb(z, op);
                return;
            }
            case 5: {
                op = this.rlc(this.peekb(z));
                this.L(op);
                this.pokeb(z, op);
                return;
            }
            case 6: {
                this.pokeb(z, this.rlc(this.peekb(z)));
                return;
            }
            case 7: {
                op = this.rlc(this.peekb(z));
                this.A(op);
                this.pokeb(z, op);
                return;
            }
            case 8: {
                op = this.rrc(this.peekb(z));
                this.B(op);
                this.pokeb(z, op);
                return;
            }
            case 9: {
                op = this.rrc(this.peekb(z));
                this.C(op);
                this.pokeb(z, op);
                return;
            }
            case 10: {
                op = this.rrc(this.peekb(z));
                this.D(op);
                this.pokeb(z, op);
                return;
            }
            case 11: {
                op = this.rrc(this.peekb(z));
                this.E(op);
                this.pokeb(z, op);
                return;
            }
            case 12: {
                op = this.rrc(this.peekb(z));
                this.H(op);
                this.pokeb(z, op);
                return;
            }
            case 13: {
                op = this.rrc(this.peekb(z));
                this.L(op);
                this.pokeb(z, op);
                return;
            }
            case 14: {
                this.pokeb(z, this.rrc(this.peekb(z)));
                return;
            }
            case 15: {
                op = this.rrc(this.peekb(z));
                this.A(op);
                this.pokeb(z, op);
                return;
            }
            case 16: {
                op = this.rl(this.peekb(z));
                this.B(op);
                this.pokeb(z, op);
                return;
            }
            case 17: {
                op = this.rl(this.peekb(z));
                this.C(op);
                this.pokeb(z, op);
                return;
            }
            case 18: {
                op = this.rl(this.peekb(z));
                this.D(op);
                this.pokeb(z, op);
                return;
            }
            case 19: {
                op = this.rl(this.peekb(z));
                this.E(op);
                this.pokeb(z, op);
                return;
            }
            case 20: {
                op = this.rl(this.peekb(z));
                this.H(op);
                this.pokeb(z, op);
                return;
            }
            case 21: {
                op = this.rl(this.peekb(z));
                this.L(op);
                this.pokeb(z, op);
                return;
            }
            case 22: {
                this.pokeb(z, this.rl(this.peekb(z)));
                return;
            }
            case 23: {
                op = this.rl(this.peekb(z));
                this.A(op);
                this.pokeb(z, op);
                return;
            }
            case 24: {
                op = this.rr(this.peekb(z));
                this.B(op);
                this.pokeb(z, op);
                return;
            }
            case 25: {
                op = this.rr(this.peekb(z));
                this.C(op);
                this.pokeb(z, op);
                return;
            }
            case 26: {
                op = this.rr(this.peekb(z));
                this.D(op);
                this.pokeb(z, op);
                return;
            }
            case 27: {
                op = this.rr(this.peekb(z));
                this.E(op);
                this.pokeb(z, op);
                return;
            }
            case 28: {
                op = this.rr(this.peekb(z));
                this.H(op);
                this.pokeb(z, op);
                return;
            }
            case 29: {
                op = this.rr(this.peekb(z));
                this.L(op);
                this.pokeb(z, op);
                return;
            }
            case 30: {
                this.pokeb(z, this.rr(this.peekb(z)));
                return;
            }
            case 31: {
                op = this.rr(this.peekb(z));
                this.A(op);
                this.pokeb(z, op);
                return;
            }
            case 32: {
                op = this.sla(this.peekb(z));
                this.B(op);
                this.pokeb(z, op);
                return;
            }
            case 33: {
                op = this.sla(this.peekb(z));
                this.C(op);
                this.pokeb(z, op);
                return;
            }
            case 34: {
                op = this.sla(this.peekb(z));
                this.D(op);
                this.pokeb(z, op);
                return;
            }
            case 35: {
                op = this.sla(this.peekb(z));
                this.E(op);
                this.pokeb(z, op);
                return;
            }
            case 36: {
                op = this.sla(this.peekb(z));
                this.H(op);
                this.pokeb(z, op);
                return;
            }
            case 37: {
                op = this.sla(this.peekb(z));
                this.L(op);
                this.pokeb(z, op);
                return;
            }
            case 38: {
                this.pokeb(z, this.sla(this.peekb(z)));
                return;
            }
            case 39: {
                op = this.sla(this.peekb(z));
                this.A(op);
                this.pokeb(z, op);
                return;
            }
            case 40: {
                op = this.sra(this.peekb(z));
                this.B(op);
                this.pokeb(z, op);
                return;
            }
            case 41: {
                op = this.sra(this.peekb(z));
                this.C(op);
                this.pokeb(z, op);
                return;
            }
            case 42: {
                op = this.sra(this.peekb(z));
                this.D(op);
                this.pokeb(z, op);
                return;
            }
            case 43: {
                op = this.sra(this.peekb(z));
                this.E(op);
                this.pokeb(z, op);
                return;
            }
            case 44: {
                op = this.sra(this.peekb(z));
                this.H(op);
                this.pokeb(z, op);
                return;
            }
            case 45: {
                op = this.sra(this.peekb(z));
                this.L(op);
                this.pokeb(z, op);
                return;
            }
            case 46: {
                this.pokeb(z, this.sra(this.peekb(z)));
                return;
            }
            case 47: {
                op = this.sra(this.peekb(z));
                this.A(op);
                this.pokeb(z, op);
                return;
            }
            case 48: {
                op = this.sls(this.peekb(z));
                this.B(op);
                this.pokeb(z, op);
                return;
            }
            case 49: {
                op = this.sls(this.peekb(z));
                this.C(op);
                this.pokeb(z, op);
                return;
            }
            case 50: {
                op = this.sls(this.peekb(z));
                this.D(op);
                this.pokeb(z, op);
                return;
            }
            case 51: {
                op = this.sls(this.peekb(z));
                this.E(op);
                this.pokeb(z, op);
                return;
            }
            case 52: {
                op = this.sls(this.peekb(z));
                this.H(op);
                this.pokeb(z, op);
                return;
            }
            case 53: {
                op = this.sls(this.peekb(z));
                this.L(op);
                this.pokeb(z, op);
                return;
            }
            case 54: {
                this.pokeb(z, this.sls(this.peekb(z)));
                return;
            }
            case 55: {
                op = this.sls(this.peekb(z));
                this.A(op);
                this.pokeb(z, op);
                return;
            }
            case 56: {
                op = this.srl(this.peekb(z));
                this.B(op);
                this.pokeb(z, op);
                return;
            }
            case 57: {
                op = this.srl(this.peekb(z));
                this.C(op);
                this.pokeb(z, op);
                return;
            }
            case 58: {
                op = this.srl(this.peekb(z));
                this.D(op);
                this.pokeb(z, op);
                return;
            }
            case 59: {
                op = this.srl(this.peekb(z));
                this.E(op);
                this.pokeb(z, op);
                return;
            }
            case 60: {
                op = this.srl(this.peekb(z));
                this.H(op);
                this.pokeb(z, op);
                return;
            }
            case 61: {
                op = this.srl(this.peekb(z));
                this.L(op);
                this.pokeb(z, op);
                return;
            }
            case 62: {
                this.pokeb(z, this.srl(this.peekb(z)));
                return;
            }
            case 63: {
                op = this.srl(this.peekb(z));
                this.A(op);
                this.pokeb(z, op);
                return;
            }
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: {
                this.bit(1, this.peekb(z));
                return;
            }
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: {
                this.bit(2, this.peekb(z));
                return;
            }
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: {
                this.bit(4, this.peekb(z));
                return;
            }
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: {
                this.bit(8, this.peekb(z));
                return;
            }
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: {
                this.bit(16, this.peekb(z));
                return;
            }
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: {
                this.bit(32, this.peekb(z));
                return;
            }
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: {
                this.bit(64, this.peekb(z));
                return;
            }
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: {
                this.bit(128, this.peekb(z));
                return;
            }
            case 128: {
                op = Z80.res(1, this.peekb(z));
                this.B(op);
                this.pokeb(z, op);
                return;
            }
            case 129: {
                op = Z80.res(1, this.peekb(z));
                this.C(op);
                this.pokeb(z, op);
                return;
            }
            case 130: {
                op = Z80.res(1, this.peekb(z));
                this.D(op);
                this.pokeb(z, op);
                return;
            }
            case 131: {
                op = Z80.res(1, this.peekb(z));
                this.E(op);
                this.pokeb(z, op);
                return;
            }
            case 132: {
                op = Z80.res(1, this.peekb(z));
                this.H(op);
                this.pokeb(z, op);
                return;
            }
            case 133: {
                op = Z80.res(1, this.peekb(z));
                this.L(op);
                this.pokeb(z, op);
                return;
            }
            case 134: {
                this.pokeb(z, Z80.res(1, this.peekb(z)));
                return;
            }
            case 135: {
                op = Z80.res(1, this.peekb(z));
                this.A(op);
                this.pokeb(z, op);
                return;
            }
            case 136: {
                op = Z80.res(2, this.peekb(z));
                this.B(op);
                this.pokeb(z, op);
                return;
            }
            case 137: {
                op = Z80.res(2, this.peekb(z));
                this.C(op);
                this.pokeb(z, op);
                return;
            }
            case 138: {
                op = Z80.res(2, this.peekb(z));
                this.D(op);
                this.pokeb(z, op);
                return;
            }
            case 139: {
                op = Z80.res(2, this.peekb(z));
                this.E(op);
                this.pokeb(z, op);
                return;
            }
            case 140: {
                op = Z80.res(2, this.peekb(z));
                this.H(op);
                this.pokeb(z, op);
                return;
            }
            case 141: {
                op = Z80.res(2, this.peekb(z));
                this.L(op);
                this.pokeb(z, op);
                return;
            }
            case 142: {
                this.pokeb(z, Z80.res(2, this.peekb(z)));
                return;
            }
            case 143: {
                op = Z80.res(2, this.peekb(z));
                this.A(op);
                this.pokeb(z, op);
                return;
            }
            case 144: {
                op = Z80.res(4, this.peekb(z));
                this.B(op);
                this.pokeb(z, op);
                return;
            }
            case 145: {
                op = Z80.res(4, this.peekb(z));
                this.C(op);
                this.pokeb(z, op);
                return;
            }
            case 146: {
                op = Z80.res(4, this.peekb(z));
                this.D(op);
                this.pokeb(z, op);
                return;
            }
            case 147: {
                op = Z80.res(4, this.peekb(z));
                this.E(op);
                this.pokeb(z, op);
                return;
            }
            case 148: {
                op = Z80.res(4, this.peekb(z));
                this.H(op);
                this.pokeb(z, op);
                return;
            }
            case 149: {
                op = Z80.res(4, this.peekb(z));
                this.L(op);
                this.pokeb(z, op);
                return;
            }
            case 150: {
                this.pokeb(z, Z80.res(4, this.peekb(z)));
                return;
            }
            case 151: {
                op = Z80.res(4, this.peekb(z));
                this.A(op);
                this.pokeb(z, op);
                return;
            }
            case 152: {
                op = Z80.res(8, this.peekb(z));
                this.B(op);
                this.pokeb(z, op);
                return;
            }
            case 153: {
                op = Z80.res(8, this.peekb(z));
                this.C(op);
                this.pokeb(z, op);
                return;
            }
            case 154: {
                op = Z80.res(8, this.peekb(z));
                this.D(op);
                this.pokeb(z, op);
                return;
            }
            case 155: {
                op = Z80.res(8, this.peekb(z));
                this.E(op);
                this.pokeb(z, op);
                return;
            }
            case 156: {
                op = Z80.res(8, this.peekb(z));
                this.H(op);
                this.pokeb(z, op);
                return;
            }
            case 157: {
                op = Z80.res(8, this.peekb(z));
                this.L(op);
                this.pokeb(z, op);
                return;
            }
            case 158: {
                this.pokeb(z, Z80.res(8, this.peekb(z)));
                return;
            }
            case 159: {
                op = Z80.res(8, this.peekb(z));
                this.A(op);
                this.pokeb(z, op);
                return;
            }
            case 160: {
                op = Z80.res(16, this.peekb(z));
                this.B(op);
                this.pokeb(z, op);
                return;
            }
            case 161: {
                op = Z80.res(16, this.peekb(z));
                this.C(op);
                this.pokeb(z, op);
                return;
            }
            case 162: {
                op = Z80.res(16, this.peekb(z));
                this.D(op);
                this.pokeb(z, op);
                return;
            }
            case 163: {
                op = Z80.res(16, this.peekb(z));
                this.E(op);
                this.pokeb(z, op);
                return;
            }
            case 164: {
                op = Z80.res(16, this.peekb(z));
                this.H(op);
                this.pokeb(z, op);
                return;
            }
            case 165: {
                op = Z80.res(16, this.peekb(z));
                this.L(op);
                this.pokeb(z, op);
                return;
            }
            case 166: {
                this.pokeb(z, Z80.res(16, this.peekb(z)));
                return;
            }
            case 167: {
                op = Z80.res(16, this.peekb(z));
                this.A(op);
                this.pokeb(z, op);
                return;
            }
            case 168: {
                op = Z80.res(32, this.peekb(z));
                this.B(op);
                this.pokeb(z, op);
                return;
            }
            case 169: {
                op = Z80.res(32, this.peekb(z));
                this.C(op);
                this.pokeb(z, op);
                return;
            }
            case 170: {
                op = Z80.res(32, this.peekb(z));
                this.D(op);
                this.pokeb(z, op);
                return;
            }
            case 171: {
                op = Z80.res(32, this.peekb(z));
                this.E(op);
                this.pokeb(z, op);
                return;
            }
            case 172: {
                op = Z80.res(32, this.peekb(z));
                this.H(op);
                this.pokeb(z, op);
                return;
            }
            case 173: {
                op = Z80.res(32, this.peekb(z));
                this.L(op);
                this.pokeb(z, op);
                return;
            }
            case 174: {
                this.pokeb(z, Z80.res(32, this.peekb(z)));
                return;
            }
            case 175: {
                op = Z80.res(32, this.peekb(z));
                this.A(op);
                this.pokeb(z, op);
                return;
            }
            case 176: {
                op = Z80.res(64, this.peekb(z));
                this.B(op);
                this.pokeb(z, op);
                return;
            }
            case 177: {
                op = Z80.res(64, this.peekb(z));
                this.C(op);
                this.pokeb(z, op);
                return;
            }
            case 178: {
                op = Z80.res(64, this.peekb(z));
                this.D(op);
                this.pokeb(z, op);
                return;
            }
            case 179: {
                op = Z80.res(64, this.peekb(z));
                this.E(op);
                this.pokeb(z, op);
                return;
            }
            case 180: {
                op = Z80.res(64, this.peekb(z));
                this.H(op);
                this.pokeb(z, op);
                return;
            }
            case 181: {
                op = Z80.res(64, this.peekb(z));
                this.L(op);
                this.pokeb(z, op);
                return;
            }
            case 182: {
                this.pokeb(z, Z80.res(64, this.peekb(z)));
                return;
            }
            case 183: {
                op = Z80.res(64, this.peekb(z));
                this.A(op);
                this.pokeb(z, op);
                return;
            }
            case 184: {
                op = Z80.res(128, this.peekb(z));
                this.B(op);
                this.pokeb(z, op);
                return;
            }
            case 185: {
                op = Z80.res(128, this.peekb(z));
                this.C(op);
                this.pokeb(z, op);
                return;
            }
            case 186: {
                op = Z80.res(128, this.peekb(z));
                this.D(op);
                this.pokeb(z, op);
                return;
            }
            case 187: {
                op = Z80.res(128, this.peekb(z));
                this.E(op);
                this.pokeb(z, op);
                return;
            }
            case 188: {
                op = Z80.res(128, this.peekb(z));
                this.H(op);
                this.pokeb(z, op);
                return;
            }
            case 189: {
                op = Z80.res(128, this.peekb(z));
                this.L(op);
                this.pokeb(z, op);
                return;
            }
            case 190: {
                this.pokeb(z, Z80.res(128, this.peekb(z)));
                return;
            }
            case 191: {
                op = Z80.res(128, this.peekb(z));
                this.A(op);
                this.pokeb(z, op);
                return;
            }
            case 192: {
                op = Z80.set(1, this.peekb(z));
                this.B(op);
                this.pokeb(z, op);
                return;
            }
            case 193: {
                op = Z80.set(1, this.peekb(z));
                this.C(op);
                this.pokeb(z, op);
                return;
            }
            case 194: {
                op = Z80.set(1, this.peekb(z));
                this.D(op);
                this.pokeb(z, op);
                return;
            }
            case 195: {
                op = Z80.set(1, this.peekb(z));
                this.E(op);
                this.pokeb(z, op);
                return;
            }
            case 196: {
                op = Z80.set(1, this.peekb(z));
                this.H(op);
                this.pokeb(z, op);
                return;
            }
            case 197: {
                op = Z80.set(1, this.peekb(z));
                this.L(op);
                this.pokeb(z, op);
                return;
            }
            case 198: {
                this.pokeb(z, Z80.set(1, this.peekb(z)));
                return;
            }
            case 199: {
                op = Z80.set(1, this.peekb(z));
                this.A(op);
                this.pokeb(z, op);
                return;
            }
            case 200: {
                op = Z80.set(2, this.peekb(z));
                this.B(op);
                this.pokeb(z, op);
                return;
            }
            case 201: {
                op = Z80.set(2, this.peekb(z));
                this.C(op);
                this.pokeb(z, op);
                return;
            }
            case 202: {
                op = Z80.set(2, this.peekb(z));
                this.D(op);
                this.pokeb(z, op);
                return;
            }
            case 203: {
                op = Z80.set(2, this.peekb(z));
                this.E(op);
                this.pokeb(z, op);
                return;
            }
            case 204: {
                op = Z80.set(2, this.peekb(z));
                this.H(op);
                this.pokeb(z, op);
                return;
            }
            case 205: {
                op = Z80.set(2, this.peekb(z));
                this.L(op);
                this.pokeb(z, op);
                return;
            }
            case 206: {
                this.pokeb(z, Z80.set(2, this.peekb(z)));
                return;
            }
            case 207: {
                op = Z80.set(2, this.peekb(z));
                this.A(op);
                this.pokeb(z, op);
                return;
            }
            case 208: {
                op = Z80.set(4, this.peekb(z));
                this.B(op);
                this.pokeb(z, op);
                return;
            }
            case 209: {
                op = Z80.set(4, this.peekb(z));
                this.C(op);
                this.pokeb(z, op);
                return;
            }
            case 210: {
                op = Z80.set(4, this.peekb(z));
                this.D(op);
                this.pokeb(z, op);
                return;
            }
            case 211: {
                op = Z80.set(4, this.peekb(z));
                this.E(op);
                this.pokeb(z, op);
                return;
            }
            case 212: {
                op = Z80.set(4, this.peekb(z));
                this.H(op);
                this.pokeb(z, op);
                return;
            }
            case 213: {
                op = Z80.set(4, this.peekb(z));
                this.L(op);
                this.pokeb(z, op);
                return;
            }
            case 214: {
                this.pokeb(z, Z80.set(4, this.peekb(z)));
                return;
            }
            case 215: {
                op = Z80.set(4, this.peekb(z));
                this.A(op);
                this.pokeb(z, op);
                return;
            }
            case 216: {
                op = Z80.set(8, this.peekb(z));
                this.B(op);
                this.pokeb(z, op);
                return;
            }
            case 217: {
                op = Z80.set(8, this.peekb(z));
                this.C(op);
                this.pokeb(z, op);
                return;
            }
            case 218: {
                op = Z80.set(8, this.peekb(z));
                this.D(op);
                this.pokeb(z, op);
                return;
            }
            case 219: {
                op = Z80.set(8, this.peekb(z));
                this.E(op);
                this.pokeb(z, op);
                return;
            }
            case 220: {
                op = Z80.set(8, this.peekb(z));
                this.H(op);
                this.pokeb(z, op);
                return;
            }
            case 221: {
                op = Z80.set(8, this.peekb(z));
                this.L(op);
                this.pokeb(z, op);
                return;
            }
            case 222: {
                this.pokeb(z, Z80.set(8, this.peekb(z)));
                return;
            }
            case 223: {
                op = Z80.set(8, this.peekb(z));
                this.A(op);
                this.pokeb(z, op);
                return;
            }
            case 224: {
                op = Z80.set(16, this.peekb(z));
                this.B(op);
                this.pokeb(z, op);
                return;
            }
            case 225: {
                op = Z80.set(16, this.peekb(z));
                this.C(op);
                this.pokeb(z, op);
                return;
            }
            case 226: {
                op = Z80.set(16, this.peekb(z));
                this.D(op);
                this.pokeb(z, op);
                return;
            }
            case 227: {
                op = Z80.set(16, this.peekb(z));
                this.E(op);
                this.pokeb(z, op);
                return;
            }
            case 228: {
                op = Z80.set(16, this.peekb(z));
                this.H(op);
                this.pokeb(z, op);
                return;
            }
            case 229: {
                op = Z80.set(16, this.peekb(z));
                this.L(op);
                this.pokeb(z, op);
                return;
            }
            case 230: {
                this.pokeb(z, Z80.set(16, this.peekb(z)));
                return;
            }
            case 231: {
                op = Z80.set(16, this.peekb(z));
                this.A(op);
                this.pokeb(z, op);
                return;
            }
            case 232: {
                op = Z80.set(32, this.peekb(z));
                this.B(op);
                this.pokeb(z, op);
                return;
            }
            case 233: {
                op = Z80.set(32, this.peekb(z));
                this.C(op);
                this.pokeb(z, op);
                return;
            }
            case 234: {
                op = Z80.set(32, this.peekb(z));
                this.D(op);
                this.pokeb(z, op);
                return;
            }
            case 235: {
                op = Z80.set(32, this.peekb(z));
                this.E(op);
                this.pokeb(z, op);
                return;
            }
            case 236: {
                op = Z80.set(32, this.peekb(z));
                this.H(op);
                this.pokeb(z, op);
                return;
            }
            case 237: {
                op = Z80.set(32, this.peekb(z));
                this.L(op);
                this.pokeb(z, op);
                return;
            }
            case 238: {
                this.pokeb(z, Z80.set(32, this.peekb(z)));
                return;
            }
            case 239: {
                op = Z80.set(32, this.peekb(z));
                this.A(op);
                this.pokeb(z, op);
                return;
            }
            case 240: {
                op = Z80.set(64, this.peekb(z));
                this.B(op);
                this.pokeb(z, op);
                return;
            }
            case 241: {
                op = Z80.set(64, this.peekb(z));
                this.C(op);
                this.pokeb(z, op);
                return;
            }
            case 242: {
                op = Z80.set(64, this.peekb(z));
                this.D(op);
                this.pokeb(z, op);
                return;
            }
            case 243: {
                op = Z80.set(64, this.peekb(z));
                this.E(op);
                this.pokeb(z, op);
                return;
            }
            case 244: {
                op = Z80.set(64, this.peekb(z));
                this.H(op);
                this.pokeb(z, op);
                return;
            }
            case 245: {
                op = Z80.set(64, this.peekb(z));
                this.L(op);
                this.pokeb(z, op);
                return;
            }
            case 246: {
                this.pokeb(z, Z80.set(64, this.peekb(z)));
                return;
            }
            case 247: {
                op = Z80.set(64, this.peekb(z));
                this.A(op);
                this.pokeb(z, op);
                return;
            }
            case 248: {
                op = Z80.set(128, this.peekb(z));
                this.B(op);
                this.pokeb(z, op);
                return;
            }
            case 249: {
                op = Z80.set(128, this.peekb(z));
                this.C(op);
                this.pokeb(z, op);
                return;
            }
            case 250: {
                op = Z80.set(128, this.peekb(z));
                this.D(op);
                this.pokeb(z, op);
                return;
            }
            case 251: {
                op = Z80.set(128, this.peekb(z));
                this.E(op);
                this.pokeb(z, op);
                return;
            }
            case 252: {
                op = Z80.set(128, this.peekb(z));
                this.H(op);
                this.pokeb(z, op);
                return;
            }
            case 253: {
                op = Z80.set(128, this.peekb(z));
                this.L(op);
                this.pokeb(z, op);
                return;
            }
            case 254: {
                this.pokeb(z, Z80.set(128, this.peekb(z)));
                return;
            }
            case 255: {
                op = Z80.set(128, this.peekb(z));
                this.A(op);
                this.pokeb(z, op);
                return;
            }
        }
    }

    private final int in_bc() {
        int ans = this.inb(this.BC());
        this.setZ(ans == 0);
        this.setS((ans & 0x80) != 0);
        this.set3((ans & 8) != 0);
        this.set5((ans & 0x20) != 0);
        this.setPV(parity[ans]);
        this.setN(false);
        this.setH(false);
        return ans;
    }

    private final void adc_a(int b) {
        int a = this.A();
        int c = this.Cset() ? 1 : 0;
        int wans = a + b + c;
        int ans = wans & 0xFF;
        this.setS((ans & 0x80) != 0);
        this.set3((ans & 8) != 0);
        this.set5((ans & 0x20) != 0);
        this.setZ(ans == 0);
        this.setC((wans & 0x100) != 0);
        this.setPV(((a ^ ~b) & (a ^ ans) & 0x80) != 0);
        this.setH(((a & 0xF) + (b & 0xF) + c & 0x10) != 0);
        this.setN(false);
        this.A(ans);
    }

    private final void add_a(int b) {
        int a = this.A();
        int wans = a + b;
        int ans = wans & 0xFF;
        this.setS((ans & 0x80) != 0);
        this.set3((ans & 8) != 0);
        this.set5((ans & 0x20) != 0);
        this.setZ(ans == 0);
        this.setC((wans & 0x100) != 0);
        this.setPV(((a ^ ~b) & (a ^ ans) & 0x80) != 0);
        this.setH(((a & 0xF) + (b & 0xF) & 0x10) != 0);
        this.setN(false);
        this.A(ans);
    }

    private final void sbc_a(int b) {
        int a = this.A();
        int c = this.Cset() ? 1 : 0;
        int wans = a - b - c;
        int ans = wans & 0xFF;
        this.setS((ans & 0x80) != 0);
        this.set3((ans & 8) != 0);
        this.set5((ans & 0x20) != 0);
        this.setZ(ans == 0);
        this.setC((wans & 0x100) != 0);
        this.setPV(((a ^ b) & (a ^ ans) & 0x80) != 0);
        this.setH(((a & 0xF) - (b & 0xF) - c & 0x10) != 0);
        this.setN(true);
        this.A(ans);
    }

    private final void sub_a(int b) {
        int a = this.A();
        int wans = a - b;
        int ans = wans & 0xFF;
        this.setS((ans & 0x80) != 0);
        this.set3((ans & 8) != 0);
        this.set5((ans & 0x20) != 0);
        this.setZ(ans == 0);
        this.setC((wans & 0x100) != 0);
        this.setPV(((a ^ b) & (a ^ ans) & 0x80) != 0);
        this.setH(((a & 0xF) - (b & 0xF) & 0x10) != 0);
        this.setN(true);
        this.A(ans);
    }

    private final void rlc_a() {
        boolean c;
        int ans = this.A();
        boolean bl = c = (ans & 0x80) != 0;
        ans = c ? ans << 1 | 1 : (ans <<= 1);
        this.set3(((ans &= 0xFF) & 8) != 0);
        this.set5((ans & 0x20) != 0);
        this.setN(false);
        this.setH(false);
        this.setC(c);
        this.A(ans);
    }

    private final void rrc_a() {
        boolean c;
        int ans = this.A();
        boolean bl = c = (ans & 1) != 0;
        ans = c ? ans >> 1 | 0x80 : (ans >>= 1);
        this.set3((ans & 8) != 0);
        this.set5((ans & 0x20) != 0);
        this.setN(false);
        this.setH(false);
        this.setC(c);
        this.A(ans);
    }

    private final void rl_a() {
        boolean c;
        int ans = this.A();
        boolean bl = c = (ans & 0x80) != 0;
        ans = this.Cset() ? ans << 1 | 1 : (ans <<= 1);
        this.set3(((ans &= 0xFF) & 8) != 0);
        this.set5((ans & 0x20) != 0);
        this.setN(false);
        this.setH(false);
        this.setC(c);
        this.A(ans);
    }

    private final void rr_a() {
        boolean c;
        int ans = this.A();
        boolean bl = c = (ans & 1) != 0;
        ans = this.Cset() ? ans >> 1 | 0x80 : (ans >>= 1);
        this.set3((ans & 8) != 0);
        this.set5((ans & 0x20) != 0);
        this.setN(false);
        this.setH(false);
        this.setC(c);
        this.A(ans);
    }

    private final void cp_a(int b) {
        int a = this.A();
        int wans = a - b;
        int ans = wans & 0xFF;
        this.setS((ans & 0x80) != 0);
        this.set3((b & 8) != 0);
        this.set5((b & 0x20) != 0);
        this.setN(true);
        this.setZ(ans == 0);
        this.setC((wans & 0x100) != 0);
        this.setH(((a & 0xF) - (b & 0xF) & 0x10) != 0);
        this.setPV(((a ^ b) & (a ^ ans) & 0x80) != 0);
    }

    private final void and_a(int b) {
        int ans = this.A() & b;
        this.setS((ans & 0x80) != 0);
        this.set3((ans & 8) != 0);
        this.set5((ans & 0x20) != 0);
        this.setH(true);
        this.setPV(parity[ans]);
        this.setZ(ans == 0);
        this.setN(false);
        this.setC(false);
        this.A(ans);
    }

    private final void or_a(int b) {
        int ans = this.A() | b;
        this.setS((ans & 0x80) != 0);
        this.set3((ans & 8) != 0);
        this.set5((ans & 0x20) != 0);
        this.setH(false);
        this.setPV(parity[ans]);
        this.setZ(ans == 0);
        this.setN(false);
        this.setC(false);
        this.A(ans);
    }

    private final void xor_a(int b) {
        int ans = (this.A() ^ b) & 0xFF;
        this.setS((ans & 0x80) != 0);
        this.set3((ans & 8) != 0);
        this.set5((ans & 0x20) != 0);
        this.setH(false);
        this.setPV(parity[ans]);
        this.setZ(ans == 0);
        this.setN(false);
        this.setC(false);
        this.A(ans);
    }

    private final void neg_a() {
        int t = this.A();
        this.A(0);
        this.sub_a(t);
    }

    private final void cpl_a() {
        int ans = this.A() ^ 0xFF;
        this.set3((ans & 8) != 0);
        this.set5((ans & 0x20) != 0);
        this.setH(true);
        this.setN(true);
        this.A(ans);
    }

    private final void daa_a() {
        int ans = this.A();
        int incr = 0;
        boolean carry = this.Cset();
        if (this.Hset() || (ans & 0xF) > 9) {
            incr |= 6;
        }
        if (carry || ans > 159 || ans > 143 && (ans & 0xF) > 9) {
            incr |= 0x60;
        }
        if (ans > 153) {
            carry = true;
        }
        if (this.Nset()) {
            this.sub_a(incr);
        } else {
            this.add_a(incr);
        }
        ans = this.A();
        this.setC(carry);
        this.setPV(parity[ans]);
    }

    private final void ld_a_i() {
        int ans = this.I();
        this.setS((ans & 0x80) != 0);
        this.set3((ans & 8) != 0);
        this.set5((ans & 0x20) != 0);
        this.setZ(ans == 0);
        this.setPV(this.IFF2());
        this.setH(false);
        this.setN(false);
        this.A(ans);
    }

    private final void ld_a_r() {
        int ans = this.R();
        this.setS((ans & 0x80) != 0);
        this.set3((ans & 8) != 0);
        this.set5((ans & 0x20) != 0);
        this.setZ(ans == 0);
        this.setPV(this.IFF2());
        this.setH(false);
        this.setN(false);
        this.A(ans);
    }

    private final void rrd_a() {
        int t;
        int ans = this.A();
        int q = t = this.peekb(this.HL());
        t = t >> 4 | ans << 4;
        ans = ans & 0xF0 | q & 0xF;
        this.pokeb(this.HL(), t);
        this.setS((ans & 0x80) != 0);
        this.set3((ans & 8) != 0);
        this.set5((ans & 0x20) != 0);
        this.setZ(ans == 0);
        this.setPV(this.IFF2());
        this.setH(false);
        this.setN(false);
        this.A(ans);
    }

    private final void rld_a() {
        int t;
        int ans = this.A();
        int q = t = this.peekb(this.HL());
        t = t << 4 | ans & 0xF;
        ans = ans & 0xF0 | q >> 4;
        this.pokeb(this.HL(), t & 0xFF);
        this.setS((ans & 0x80) != 0);
        this.set3((ans & 8) != 0);
        this.set5((ans & 0x20) != 0);
        this.setZ(ans == 0);
        this.setPV(this.IFF2());
        this.setH(false);
        this.setN(false);
        this.A(ans);
    }

    private final void bit(int b, int r) {
        boolean bitSet = (r & b) != 0;
        this.setN(false);
        this.setH(true);
        this.set3((r & 8) != 0);
        this.set5((r & 0x20) != 0);
        this.setS(b == 128 ? bitSet : false);
        this.setZ(!bitSet);
        this.setPV(!bitSet);
    }

    private final void scf() {
        int ans = this.A();
        this.set3((ans & 8) != 0);
        this.set5((ans & 0x20) != 0);
        this.setN(false);
        this.setH(false);
        this.setC(true);
    }

    private final void ccf() {
        int ans = this.A();
        this.set3((ans & 8) != 0);
        this.set5((ans & 0x20) != 0);
        this.setN(false);
        this.setC(!this.Cset());
    }

    private final int rlc(int ans) {
        boolean c;
        boolean bl = c = (ans & 0x80) != 0;
        ans = c ? ans << 1 | 1 : (ans <<= 1);
        this.setS(((ans &= 0xFF) & 0x80) != 0);
        this.set3((ans & 8) != 0);
        this.set5((ans & 0x20) != 0);
        this.setZ(ans == 0);
        this.setPV(parity[ans]);
        this.setH(false);
        this.setN(false);
        this.setC(c);
        return ans;
    }

    private final int rrc(int ans) {
        boolean c;
        boolean bl = c = (ans & 1) != 0;
        ans = c ? ans >> 1 | 0x80 : (ans >>= 1);
        this.setS((ans & 0x80) != 0);
        this.set3((ans & 8) != 0);
        this.set5((ans & 0x20) != 0);
        this.setZ(ans == 0);
        this.setPV(parity[ans]);
        this.setH(false);
        this.setN(false);
        this.setC(c);
        return ans;
    }

    private final int rl(int ans) {
        boolean c;
        boolean bl = c = (ans & 0x80) != 0;
        ans = this.Cset() ? ans << 1 | 1 : (ans <<= 1);
        this.setS(((ans &= 0xFF) & 0x80) != 0);
        this.set3((ans & 8) != 0);
        this.set5((ans & 0x20) != 0);
        this.setZ(ans == 0);
        this.setPV(parity[ans]);
        this.setH(false);
        this.setN(false);
        this.setC(c);
        return ans;
    }

    private final int rr(int ans) {
        boolean c;
        boolean bl = c = (ans & 1) != 0;
        ans = this.Cset() ? ans >> 1 | 0x80 : (ans >>= 1);
        this.setS((ans & 0x80) != 0);
        this.set3((ans & 8) != 0);
        this.set5((ans & 0x20) != 0);
        this.setZ(ans == 0);
        this.setPV(parity[ans]);
        this.setH(false);
        this.setN(false);
        this.setC(c);
        return ans;
    }

    private final int sla(int ans) {
        boolean c = (ans & 0x80) != 0;
        ans = ans << 1 & 0xFF;
        this.setS((ans & 0x80) != 0);
        this.set3((ans & 8) != 0);
        this.set5((ans & 0x20) != 0);
        this.setZ(ans == 0);
        this.setPV(parity[ans]);
        this.setH(false);
        this.setN(false);
        this.setC(c);
        return ans;
    }

    private final int sls(int ans) {
        boolean c = (ans & 0x80) != 0;
        ans = (ans << 1 | 1) & 0xFF;
        this.setS((ans & 0x80) != 0);
        this.set3((ans & 8) != 0);
        this.set5((ans & 0x20) != 0);
        this.setZ(ans == 0);
        this.setPV(parity[ans]);
        this.setH(false);
        this.setN(false);
        this.setC(c);
        return ans;
    }

    private final int sra(int ans) {
        boolean c = (ans & 1) != 0;
        ans = ans >> 1 | ans & 0x80;
        this.setS((ans & 0x80) != 0);
        this.set3((ans & 8) != 0);
        this.set5((ans & 0x20) != 0);
        this.setZ(ans == 0);
        this.setPV(parity[ans]);
        this.setH(false);
        this.setN(false);
        this.setC(c);
        return ans;
    }

    private final int srl(int ans) {
        boolean c = (ans & 1) != 0;
        this.setS(((ans >>= 1) & 0x80) != 0);
        this.set3((ans & 8) != 0);
        this.set5((ans & 0x20) != 0);
        this.setZ(ans == 0);
        this.setPV(parity[ans]);
        this.setH(false);
        this.setN(false);
        this.setC(c);
        return ans;
    }

    private final int dec8(int ans) {
        boolean pv = ans == 128;
        boolean h = ((ans & 0xF) - 1 & 0x10) != 0;
        ans = ans - 1 & 0xFF;
        this.setS((ans & 0x80) != 0);
        this.set3((ans & 8) != 0);
        this.set5((ans & 0x20) != 0);
        this.setZ(ans == 0);
        this.setPV(pv);
        this.setH(h);
        this.setN(true);
        return ans;
    }

    private final int inc8(int ans) {
        boolean pv = ans == 127;
        boolean h = ((ans & 0xF) + 1 & 0x10) != 0;
        ans = ans + 1 & 0xFF;
        this.setS((ans & 0x80) != 0);
        this.set3((ans & 8) != 0);
        this.set5((ans & 0x20) != 0);
        this.setZ(ans == 0);
        this.setPV(pv);
        this.setH(h);
        this.setN(false);
        return ans;
    }

    private final int adc16(int a, int b) {
        int c = this.Cset() ? 1 : 0;
        int lans = a + b + c;
        int ans = lans & 0xFFFF;
        this.setS((ans & 0x8000) != 0);
        this.set3((ans & 0x800) != 0);
        this.set5((ans & 0x2000) != 0);
        this.setZ(ans == 0);
        this.setC((lans & 0x10000) != 0);
        this.setPV(((a ^ ~b) & (a ^ ans) & 0x8000) != 0);
        this.setH(((a & 0xFFF) + (b & 0xFFF) + c & 0x1000) != 0);
        this.setN(false);
        return ans;
    }

    private final int add16(int a, int b) {
        int lans = a + b;
        int ans = lans & 0xFFFF;
        this.set3((ans & 0x800) != 0);
        this.set5((ans & 0x2000) != 0);
        this.setC((lans & 0x10000) != 0);
        this.setH(((a & 0xFFF) + (b & 0xFFF) & 0x1000) != 0);
        this.setN(false);
        return ans;
    }

    private final int sbc16(int a, int b) {
        int c = this.Cset() ? 1 : 0;
        int lans = a - b - c;
        int ans = lans & 0xFFFF;
        this.setS((ans & 0x8000) != 0);
        this.set3((ans & 0x800) != 0);
        this.set5((ans & 0x2000) != 0);
        this.setZ(ans == 0);
        this.setC((lans & 0x10000) != 0);
        this.setPV(((a ^ b) & (a ^ ans) & 0x8000) != 0);
        this.setH(((a & 0xFFF) - (b & 0xFFF) - c & 0x1000) != 0);
        this.setN(true);
        return ans;
    }

    public final void exx() {
        int t = this.HL();
        this.HL(this._HL_);
        this._HL_ = t;
        t = this.DE();
        this.DE(this._DE_);
        this._DE_ = t;
        t = this.BC();
        this.BC(this._BC_);
        this._BC_ = t;
    }

    public final void ex_af_af() {
        int t = this.AF();
        this.AF(this._AF_);
        this._AF_ = t;
    }

    private static final int inc16(int a) {
        return a + 1 & 0xFFFF;
    }

    private static final int qinc8(int a) {
        return a + 1 & 0xFF;
    }

    private static final int dec16(int a) {
        return a - 1 & 0xFFFF;
    }

    private static final int qdec8(int a) {
        return a - 1 & 0xFF;
    }

    private static final int res(int bit, int val) {
        return val & ~bit;
    }

    private static final int set(int bit, int val) {
        return val | bit;
    }
}

