package sorcererII;

import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

import javax.swing.ImageIcon;
import javax.swing.JLabel;

public abstract class JBistableImageButton extends JLabel {
  /**
   * 
   */
  private static final long serialVersionUID = 2854321504503168298L;
  
  private final Image _image1; 
  private final Image _image2; 
  private final ImageIcon _icon;
  private boolean _pressed = false;
 
  public JBistableImageButton(final Image image1, 
                              final Image image2,
                              final String tooltip) {
    _image1 = image1;
    _image2 = image2;    
    _icon = new ImageIcon();
    _icon.setImage(image1);
    setIcon(_icon);
    setToolTipText(tooltip);
    setHorizontalTextPosition(LEFT);
    addMouseListener(new MouseListener() {
      
      @Override
      public void mouseReleased(final MouseEvent e) {
      }
      
      @Override
      public void mousePressed(final MouseEvent e) {
        if(_icon.getImage() == _image1) {
          _icon.setImage(_image2);
        }
        else {
          _icon.setImage(_image1);          
        }
        repaint();
      }
      
      @Override
      public void mouseExited(final MouseEvent e) {
        if(_pressed) {
          _icon.setImage(_image2);
        }
        else {
          _icon.setImage(_image1);          
        }
        repaint();
      }
      
      @Override
      public void mouseEntered(final MouseEvent e) {
      }

      @Override
      public void mouseClicked(final MouseEvent e) {
        if(_pressed) {
          if(gotoState1()) {
            _pressed = !_pressed;
          }
        }
        else {
          if(gotoState2()) {
            _pressed = !_pressed;
          }
        }
        if(_pressed) {
          _icon.setImage(_image2);
        }
        else {
          _icon.setImage(_image1);          
        }
        repaint();      
      }
    });
  }

  public abstract boolean gotoState1();
  
  public abstract boolean gotoState2();
}
