package sorcererII;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;

import javax.imageio.ImageIO;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public class JSorcererFileOpener extends JMonostableImageButton {
  
  /**
   * 
   */
  private static final long serialVersionUID = 5184346364731454400L;
  
  private final Sorcerer _sorcerer;
  private File _file = new File("snaps/");
  final JFileChooser _fileChooser = new JFileChooser(_file);
  final JCheckBox _autorunCheckBox = new JCheckBox("Autorun");

  public JSorcererFileOpener(final Sorcerer sorcerer) throws IOException {
    super(ImageIO.read(new File("images/icon-open-faint.png")),
          ImageIO.read(new File("images/icon-open.png")),
          "Load a file");
    
    _sorcerer = sorcerer;

    _fileChooser.setFileFilter(new FileFilter() {

      @Override
      public String getDescription() {
        return "Quick Load";
      }

      @Override
      public boolean accept(File f) {
        if (f.isDirectory()) {
          return true;
        }
        final String lowerFileName = f.getName().toLowerCase();

        return lowerFileName.endsWith(".snp") ||
        lowerFileName.endsWith(".snap") ||
        lowerFileName.endsWith(".bin") ||
        lowerFileName.endsWith(".com");
      }
    });


    _autorunCheckBox.setSelected(true);
    _fileChooser.setAccessory(_autorunCheckBox);
  }
  
  @Override
  public void gotoState1() {
  }

  @Override
  public void gotoState2() {


    final int returnVal = _fileChooser.showOpenDialog(JSorcererFileOpener.this);
    if (returnVal == JFileChooser.APPROVE_OPTION) {

      try {
        _file = _fileChooser.getSelectedFile();
        final String lowerFileName = _file.getName().toLowerCase();
        if(lowerFileName.endsWith(".snp") || lowerFileName.endsWith(".snap")) {
          loadSnap(_file);
        }
        else if(lowerFileName.endsWith(".bin")) {
          loadBin(_file, _autorunCheckBox.isSelected());
        }
        else if(lowerFileName.endsWith(".com")) {
          loadCom(_file, _autorunCheckBox.isSelected());
        }
        else {
          _sorcerer.LOGGER.log(Level.SEVERE, "Do not know how to load a file of this type");
        }
      }
      catch (final IOException ex) {
        _sorcerer.LOGGER.log(Level.SEVERE, "Could not read file to load into memory");
      }
    }
  }

  private void loadSnap(final File file) throws IOException {
    _sorcerer.stop();
    try {
      final InputStream is = new  FileInputStream(file);
      try {
        _sorcerer.loadSNP(new FileInputStream(_file));
      }
      finally {
        is.close();
      }
    } 
    finally {
      _sorcerer.start();
    }
  }
  
  private void loadBin(final File file, final boolean autorun) throws IOException {
    _sorcerer.stop();
    try {
      final InputStream is = new  FileInputStream(file);
      try {
        _sorcerer.loadBin(new FileInputStream(_file), autorun);
      }
      finally {
        is.close();
      }
    } 
    finally {
      _sorcerer.start();
    }    
  }
  
  private void loadCom(final File file, final boolean autorun) throws IOException {
    _sorcerer.stop();
    try {
      final InputStream is = new  FileInputStream(file);
      try {
        _sorcerer.loadCom(new FileInputStream(_file), autorun);
      }
      finally {
        is.close();
      }
    } 
    finally {
      _sorcerer.start();
    }    
  }  
}
