package sorcererII;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.MemoryImageSource;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;

public class SorcererScreen
{
  public int _pixels[];

  private Image _image;
  private SorcererImageProducer _producer;
  private ColorModel _cm = new DirectColorModel(32,0xFF0000,0xFF00,0xFF);

  public static final int WIDTH_CHARS  = 64;
  public static final int HEIGHT_CHARS = 30;
  public static final int WIDTH_PIXELS = WIDTH_CHARS * 8;
  public static final int HEIGHT_PIXELS = HEIGHT_CHARS * 16;

  public static final int COLOUR_ON  = 0xFFFFFFFF;
  public static final int COLOUR_OFF = 0xFF000000;

  public SorcererScreen()
  {
    _pixels =new int[ WIDTH_PIXELS * HEIGHT_PIXELS ];

    _producer = new SorcererImageProducer( WIDTH_PIXELS, HEIGHT_PIXELS, _cm, _pixels );
    _image = Toolkit.getDefaultToolkit().createImage( _producer );
  }

  public Image getImage()
  {
    _producer.update();
    return _image;
  }

  public void drawCharacter( int row, int column, int[] mem, int start )
  {
    // Get a start position for the character in image memory
    // Use a shift here!
    int imageIndex = ( row << (6+4+3) ) + ( column << 3 );

    // Loop around the rows of the character
    for( int i = 0; i < 8; ++i )
    {
      for( int s = 0; s < 2; ++s )
      {
        int c = mem[ start + i ];

        // Loop around the pixels in the row
        for( int p = 0; p < 8; ++p )
        {
          if( ( c & ( 0x80 >> p ) ) != 0 )
          {
            _pixels[ imageIndex + p ] = COLOUR_ON;
          }
          else
          {
            _pixels[ imageIndex + p ] = COLOUR_OFF;
          }
        }

        imageIndex += WIDTH_PIXELS;
      }
    }
  }
}
