package sorcererII;

import java.util.*;
import java.io.*;
import java.net.*;

public class UrlSorcererTape implements SorcererTape
{
  Random rand = new Random();

  InputStream inputStream = null;
  URL tapeUrl;

  public UrlSorcererTape( URL db, String name ) throws MalformedURLException
  {
    tapeUrl = new URL( db, name );
  }

  public void play() throws IOException
  {
    if( inputStream == null )
    {
      inputStream = tapeUrl.openStream();
    }
  }

  public void rewind()
  {
    motorOff();
  }

  public void motorOn(float baudRate)
  {
  }

  public void motorOff()
  {
    try
    {
      if( inputStream != null )
      {
        inputStream.close();
        inputStream = null;
      }
    }
    catch( Exception e )
    {
      e.printStackTrace();
    }
  }

  public byte getByte() throws IOException
  {
    if( inputStream == null )
    {
      play();
    }
    int b = inputStream.read();
    
    if(b == -1) {
      inputStream.close();
      inputStream = null;
      return 0x1A;
    }
    
    return (byte)(b&0xff);
  }

  public void writeByte( byte b ) throws IOException
  {
  }
}