package sorcererII;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class FileSorcererTape implements SorcererTape
{
  private InputStream inputStream = null;
  private OutputStream outputStream = null;
  private File _file;
  private boolean _readOnly = false;
  
  public FileSorcererTape( File file, final boolean readOnly ) {
    this(file);
    _readOnly = readOnly;
  }

  public FileSorcererTape( File file )
  {
    _file = file;
  }
  
  public FileSorcererTape( String name )
  {
    _file = new File(name);
  }

  private void record() throws IOException
  {
    if( !_readOnly && outputStream == null )
    {
      outputStream = new FileOutputStream( _file, false );
    }
  }

  private void play() throws IOException
  {
    if( inputStream == null )
    {
      inputStream = new FileInputStream( _file );
    }
  }

  public void rewind()
  {

  }

  public void motorOn(float baudRate)
  {
  }

  public void motorOff()
  {
    try
    {
      if( outputStream != null )
      {
        outputStream.close();
        outputStream = null;
      }
      if( inputStream != null )
      {
        inputStream.close();
        inputStream = null;
      }
    }
    catch( Exception e )
    {
      e.printStackTrace();
    }
    rewind();
  }

  public byte getByte() throws IOException
  {
    if( inputStream == null )
    {
      play();
    }

    int b = inputStream.read();
    
    if(b == -1) {
      inputStream.close();
      inputStream = null;
      return 0x1A;
    }
    
    return (byte)(b&0xff);
  }

  public void writeByte( byte b ) throws IOException
  {
    if(!_readOnly) {
      if( outputStream == null )
      {
        record();
      }
      outputStream.write( 0xff & (int)b );
    }
  }
}