package sorcererII;

import java.io.*;
import java.util.*;

public class HexToRom
{
  private static int hexCharToInt( int c )
  {
    if( ( c >= '0' ) && ( c <= '9' ) )
    {
      return c - '0';
    }
    if( ( c >= 'A' ) && ( c <= 'F' ) )
    {
      return c - 'A' + 10;
    }
    if( ( c >= 'a' ) && ( c <= 'f' ) )
    {
      return c - 'a' + 10;
    }
    System.out.println( "ERROR" );
    return 0;
  }

  private static int readByte( Reader r ) throws IOException
  {
    int c1;
    while( ( c1 = r.read() ) >= 0 )
    {
      if( ( c1 >= '0' ) && ( c1 <= '9' ) ) break;
      if( ( c1 >= 'A' ) && ( c1 <= 'F' ) ) break;
      if( ( c1 >= 'a' ) && ( c1 <= 'f' ) ) break;
    }
    if( c1 < 0 )
    {
      return -1;
    }
    int c2 = r.read();
    if( c2 < 0 )
    {
      return -1;
    }
    //System.out.println( "" + (char)c1 + "" + (char)c2 + " "
    //          + hexCharToInt( c1 ) + " " + hexCharToInt( c2 ) );

    return ( hexCharToInt( c1 ) * 16 ) + hexCharToInt( c2 );
  }

  public static void main( String[] args )
  {
    if( args.length != 2 )
    {
      System.out.println( "usage: java HexToRom <hexFileName> <romFileName>" );
    }
    else
    {
      try
      {
        System.out.println( "Reading from " + args[ 0 ] + " and writing to " + args[ 1 ] );
        File hexFile = new File( args[ 0 ] );
        File romFile = new File( args[ 1 ] );
        FileInputStream inputStream = new FileInputStream( hexFile );
        FileOutputStream outputStream = new FileOutputStream( romFile );
        Reader r = new BufferedReader( new InputStreamReader( inputStream ) );

        int c;
        while( ( c = readByte( r ) ) >= 0 )
        {
          outputStream.write( c );
        }

        inputStream.close();
        outputStream.close();
      }
      catch( Exception e )
      {
        e.printStackTrace();
      }
    }
  }
}