package sorcererII;

import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

import javax.swing.ImageIcon;
import javax.swing.JLabel;

public abstract class JMonostableImageButton extends JLabel {
  /**
   * 
   */
  private static final long serialVersionUID = 2854321504503168298L;
  
  private final Image _image1; 
  private final Image _image2; 
  private final ImageIcon _icon;
 
  public JMonostableImageButton(final Image image1, 
                              final Image image2,
                              final String tooltip) {
    _image1 = image1;
    _image2 = image2;    
    _icon = new ImageIcon();
    _icon.setImage(image1);
    setToolTipText(tooltip);
    setIcon(_icon);
    setHorizontalTextPosition(LEFT);
    addMouseListener(new MouseListener() {
      
      @Override
      public void mouseReleased(final MouseEvent e) {
        _icon.setImage(_image1);
        repaint();
      }
      
      @Override
      public void mousePressed(final MouseEvent e) {
        _icon.setImage(_image2);
        repaint();
      }
      
      @Override
      public void mouseExited(final MouseEvent e) {
      }
      
      @Override
      public void mouseEntered(final MouseEvent e) {
      }

      @Override
      public void mouseClicked(final MouseEvent e) {
        gotoState2();
        gotoState1();
      }
    });
  }

  public abstract void gotoState1();
  
  public abstract void gotoState2();
}
