package sorcererII;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

import javax.imageio.ImageIO;
import javax.swing.filechooser.FileFilter;

public class JSorcererRomPack extends JFileChooserWithImage {
  /**
   * 
   */
  private static final long serialVersionUID = -3695105504141235512L;
  
  private final Sorcerer _sorcerer;
  private File _file = null;
  
  public JSorcererRomPack(final Sorcerer sorcerer) throws IOException {
    super(ImageIO.read(new File("images/icon-rom-out.png")),
        ImageIO.read(new File("images/icon-rom-in.png")),
        new File("rom-packs/"),
        "ROM Pack");
    _sorcerer = sorcerer;
    setFileFilter(new FileFilter() {

      @Override
      public String getDescription() {
        return "ROM Pack files";
      }

      @Override
      public boolean accept(File f) {
        if (f.isDirectory()) {
          return true;
        }
        final String lowerFileName = f.getName().toLowerCase();

        return lowerFileName.endsWith(".rom");
      }
    });
  }
  
  @Override
  public void load(final File file) throws IOException {
    _file = file;
    _sorcerer.stop();
    _sorcerer.load8kRomPack(new FileInputStream(file));
    _sorcerer.reset();
    _sorcerer.start();
  }  
  
  @Override
  public void eject() {
    _file = null;
    _sorcerer.stop();
    _sorcerer.clear8kRomPack();
    _sorcerer.reset();
    _sorcerer.start();    
  }
  
  public void reload() throws IOException {
    if(_file != null) {
      _sorcerer.load8kRomPack(new FileInputStream(_file));
    }
    else {
      _sorcerer.clear8kRomPack();
    }
  }
}
