package sorcererII;

import java.io.*;

public class ScanDisk
{
  public static int modcheck( int checksum, byte data )
  {
    int d = ( (int)data ) & 0xff;
    if( checksum > 255 )
    {
      checksum = checksum & 0xff;
      checksum += d + 1;
    }
    else
    {
      checksum += d;
    }
    return checksum;
  }

  public static void scan( ArraySorcererDisk disk ) throws Exception
  {
    for( int track = 0; track < 77; ++track )
    {
      for( int sector = 0; sector < 16; ++sector )
      {
        int checksum = 0;

//        checksum = modcheck( checksum, disk.read( track, sector, 1 ) );
        checksum = modcheck( checksum, disk.read( track, sector, 2 ) );
/*
        for( int offset = 13; offset < 256+13; ++offset )
        {
          checksum = modcheck( checksum, disk.read( track, sector, offset ) );
        }

        checksum = checksum & 0xff;

        if( checksum != (((int)disk.read( track, sector, 256+13)) & 0xff) )
        {
          System.out.println( "Error: Track=" + track + " Sector=" + sector );
        }
        */
      }
    }
  }

  public static void main( String[] args )
  {
    try
    {
      //
      // A Disk to scan
      //

      ArraySorcererDisk disk = new ArraySorcererDisk( new FileInputStream( args[ 0 ] ) );

      scan( disk );


    }
    catch( Exception e )
    {
      e.printStackTrace();
    }
  }

}