package sorcererII;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;

public class SorcererFileDisk extends ArraySorcererDisk
{
  private File _file;
  private boolean _readOnly = false;

  public SorcererFileDisk( final String filename ) throws IOException {
    this(new File( filename ));   
  }
  
  public SorcererFileDisk( final File file, final boolean readOnly ) throws IOException {
    this( file );
    _readOnly = readOnly;
  }

  public SorcererFileDisk( final File file ) throws IOException
  {
    _file =  file;
    
    if( _file.isFile() )
    {
      InputStream inputStream = new FileInputStream( _file );
      try 
      {
        inputStream.read( _data );
      }
      finally
      {
        inputStream.close();
      }
    }
  }

  public void flush() throws IOException
  {
    if(!_readOnly) {
      Sorcerer.LOGGER.log(Level.INFO, "Flushing disk to " + _file.getName());
     
      FileOutputStream outputStream = new FileOutputStream( _file );
  
      try 
      {
        outputStream.write( _data );
      }
      finally
      {
        outputStream.close();
      }
    }
  }
}