//
//                                                              
// GALAKSIJA emulator Copyright (C) by Miodrag Jevremovic 1997. 
//                                                              
//

#include <stdio.h>
#include <string.h>
#include <ctype.h>
//Win #include <dos.h>
//Win #include <go32.h>
//Win #include <sys/farptr.h>
#include <allegro.h>
#include <winalleg.h>
#include "z80\z80.h"
//Win #include "twkuser.c"

#define BezGAL_PLUS

//
//                       
// GENERALNE PROMENLJIVE 
//                       
//

// Dakle 6k RAM-a
// 64k memorije, prvih 8k je ROM
//#define WORK_SPACE  0xFFF
//#define KRAJ_RAMA   0xFFFF
#define WORK_SPACE  0x4000
#define KRAJ_RAMA   0x4000
// Ako zelite GALAKSIJA moze i da ne vidi ROM2 !!! Samo uklonite '//' ispod.
//#define BezROM2

// CPU_SPEED is the speed of the CPU in Hz. It is used together with
// FRAMES_PER_SECOND to calculate how much CPU cycles must pass between
// interrupts.
#define CPU_SPEED 3072000       // 6.144/2 Mhz

int Z80_IRQ;                    // Current IRQ status. Checked after EI occurs.
byte   *MEMORY=NULL;            // 64k of MEMORY
//Z80_Regs R; 
Z80 R;




//
//        
// DEFINE 
//        
//

#define NE              0
#define DA              1

#define MAX_X           256     // 32 chars in line.
#define MAX_Y           224     // 8+16+8 ! Prva i poslednja linija od po 8 ekranskih su statusne.

#define VISINA          13
#define SIRINA          8
#define BROJ_ZNAKOVA    128

#define SAVE    0
#define LOAD    1

#define MAX_KEY_DEFINES 88

// DOS verzija pair definicija !!!
typedef unsigned char  byte;
typedef unsigned short word;
typedef unsigned       dword;
typedef signed char    offset;

typedef union
{
 #ifdef LSB_FIRST
   struct { byte l,h,h2,h3; } B;
   struct { word l,h; } W;
   dword D;
 #else
   struct { byte h3,h2,h,l; } B;
   struct { word h,l; } W;
   dword D;
 #endif
} pairDOS;

typedef struct
{
  pairDOS AF,BC,DE,HL,IX,IY,PC,SP;
  pairDOS AF2,BC2,DE2,HL2;
  unsigned IFF1,IFF2,HALT,IM,I,R,R2;
} Z80_RegsDOS;

Z80_RegsDOS DOS_R;

//
//                  
// PALETA i oko nje 
//                  
//

PALLETE paleta, fio_paleta; // FadeInOut
int     fade;
int     ssaver;

#define FADE_IN_SPEED   4
#define FADE_OUT_SPEED  4

#define FIN     0
#define FOUT    1
#define FINIT   2


#define CRNA        0
#define SIVA        1
#define BELA        2
#define CRFENA      3
#define ZELENA      4
#define PLAFA       5
#define JARKOCRFENA 6
#define ROZA        7




//
//                      
// INTERAPT i oko njega 
//                      
//

// Mora biti volatile, da se kompajler ne bi zeznuo.
volatile int Interapt = 0;
volatile int Sekunda  = 0;

// Timer interrupt handler.
void TimerVsync()
{
   Interapt=1;
}
END_OF_FUNCTION(TimerVsync);

// Da li da prikazujem FPS ili ne ?!?
int ShowFPS;
int Cur_fps;
int Disp_fps;

void TimerSekunda()
{
   Sekunda=1;
}
END_OF_FUNCTION(TimerSekunda);




//
//                       
// GLOBALNE PROMENLIJIVE 
//                       
//

BITMAP  *ekran;
byte    *bafer;
byte    *Font;
byte    *TZZ;       // TabelaZameneZnakova
byte    Fassst;
byte    EZP[512];   // Ekran Za Porediti
int     HorPos;
/*static Kmap[54]={ 0,30,48, 46, 32, 18, 33,34,
                 35,23,36, 37, 38, 50, 49,24,
                 25,16,19, 31, 20, 22, 47,17,
                 45,21,44,KEY_UP,KEY_DOWN,KEY_LEFT,KEY_RIGHT,57,
                 KEY_0, KEY_1, KEY_2,  KEY_3,  KEY_4,  KEY_5,  KEY_6, KEY_7,
                 KEY_8, KEY_9, KEY_COLON, KEY_QUOTE, KEY_COMMA, KEY_EQUALS, KEY_STOP, KEY_SLASH,
                 KEY_ENTER, KEY_TAB, KEY_ALT, KEY_BACKSPACE, KEY_SCRLOCK, KEY_LSHIFT};
*/
//WIN
static Kmap[54]={ 0, 1, 2,  3,  4,  5,  6, 7,
                  8, 9,10, 11, 12, 13, 14,15,
                 16,17,18, 19, 20, 21, 22,23,
                 24,25,26,KEY_UP,KEY_DOWN,KEY_LEFT,KEY_RIGHT,KEY_SPACE,
                 KEY_0, KEY_1, KEY_2,  KEY_3,  KEY_4,  KEY_5,  KEY_6, KEY_7,
                 KEY_8, KEY_9, KEY_COLON, KEY_QUOTE, KEY_COMMA, KEY_EQUALS, KEY_STOP, KEY_SLASH,
                 KEY_ENTER, KEY_TAB, KEY_ALT, KEY_DEL, KEY_SCRLOCK, KEY_LSHIFT};

// Ako je taster F11 (Aktiviranje/Deaktiviranje statusa) pritisnut nece se
// menjati stanje sve dok se taster ne otpusti, i kasnije pritisne.
// Moralo je ovako da bi se izbeglo zaustavljanje priliskom pritiskanja na
// F11. Pre je bilo realizovano na sledeci nacin : while (key[KEY_F11]);
// tj. dok je bio drzan, GALAKSIJA je bila ukocena. Samim tim ni GALAKSIJIN
// casovnik, niti bilo sta drugo nije moglo da radi. Mozda se nekome ucini
// kao sitnica, ali bag po bag i nastade Windows NT 5.0 ! ;)

int     F11_hold;


//
//          
// DIJALOZI 
//          
//

byte    InitUnos;
int         moja_d_edit_proc    (int msg, DIALOG *d, int c);

char the_string[32] = "proba";
DIALOG Save[] =
{
   /* (dialog proc)     (x)   (y)   (w)   (h)   (fg)  (bg)  (key) (flags)  (d1)  (d2)  (dp) */
   { d_box_proc,       90,  102,   76,   22,    2,    4,    0,    0,       0,    0,    0 },
   { d_text_proc,      92,  104,   72,    8,    2,    4,    0,    0,       0,    0,    " Save as "},
   { moja_d_edit_proc, 92,  114,   72,    8,    2,    5,    0,    0,       8,    0,    the_string },
   { NULL,              0,    0,    0,    0,    0,    0,    0,    0,       0,    0,    NULL }
};

DIALOG Load[] =
{
   /* (dialog proc)     (x)   (y)   (w)   (h)   (fg)  (bg)  (key) (flags)  (d1)  (d2)  (dp) */
   { d_box_proc,       90,  102,   76,   22,    2,    4,    0,    0,       0,    0,    0 },
   { d_text_proc,      92,  104,   72,    8,    2,    4,    0,    0,       0,    0,    " Load    "},
   { moja_d_edit_proc, 92,  114,   72,    8,    2,    5,    0,    0,       8,    0,    the_string },
   { NULL,              0,    0,    0,    0,    0,    0,    0,    0,       0,    0,    NULL }
};




//
//                              
// PREKIDACI iz komandne linije 
//                              
//

// S_witches
int     S_sync;     //  0 - none,
                    //  1 - 50Hz (preko timera),
                    //  2 - Vsync,
                    //  3 - 50Hz (pravih) preko twiknutog 360x270 moda,
                    //  >=10 - FPS Hz
int     S_fps;
int     S_gfx_X, S_gfx_Y;
int     S_ssaver;
int     S_real_black;
int		d_gfx;


//
//              
// SCREEN SAVER 
//              
//

int     ScreenSaverCounter;




//
//                      
// PROTOTIPOVI funkcija 
//                      
//

void        AnalyzeCommandLineSwitches (int argc,char *argv[]);
void        tolowerS            (char *string);
void        InicijalizujAllegro (void);
void        InicijalizujMasinu  (void);
void        StartujMasinu       (void);
void        ZaustaviMasinu      (void);

//byte        Z80_In              (byte Port);
byte InZ80(register word Port);
//void        Z80_Out             (byte Port,byte Value);
void OutZ80(register word Port,register byte Value);
//unsigned    Z80_RDMEM           (dword A);
byte		RdZ80				(register word Addr);
//void        Z80_WRMEM           (dword A,byte V);
void		WrZ80				(register word Addr,register byte Value);
void        Z80_Reti            (void);
void        Z80_Retn            (void);

void        LoadSave            (int Taster, DIALOG *opcija, int sta);
void        SetColor            (byte red, byte green, byte blue, byte color);
void        SetupVideo          (void);
void        NacrtajKarakter     (byte karakter, byte x, byte y);
void        OsveziEkran         (void);
void        OsveziPrviRed       (void);
void        OcitajTastaturu     (void);
int         KeyPressed          (void);
void        ErrorMessage        (int x, int y, char *tekst);
void        Zvuk                (int puta, int freq);

void        CekajVSync          (void);

void        ObrisiGornjiDeoEkrana   (void);
void        ObrisiDonjiDeoEkrana    (void);

void        FadeInOut           (void);
int         FadeIn              (void);
int         FadeOut             (void);
void        PostaviPaletu       (PALLETE p);
void        InicijalizujSSaver  (void);

// Pogledaj parametre komandne linije.

void AnalyzeCommandLineSwitches (int argc,char *argv[])
{
    int n,ignoreDisp;

    ignoreDisp=NE;

    S_sync=1;
    S_fps=50;
    S_gfx_X=320;
    S_gfx_Y=240;
    S_ssaver=15;   // Minuta
    S_real_black=NE;
	d_gfx = 2;

    for (n=1; n<argc; n++)
        tolowerS(argv[n]);

    for (n=1; n<argc; n++)
    {
	    if (strcmp(argv[n],"-single") == 0)
		{
			d_gfx = 1;
		}
		
		if (strcmp(argv[n],"-sync") == 0)
		{
		    n++;
			if (n<argc)
            {
			    S_sync=atoi(argv[n]);

                if (S_sync>3)
                    S_sync=1;

                if (S_sync==3)
                {
                    S_gfx_X=360;
                    S_gfx_Y=270;
                    ignoreDisp=DA;
                }

                if (S_sync>=10)
                    S_fps=S_sync;
            }
		}

	    if ((strcmp(argv[n],"-display") == 0) && !ignoreDisp)
        {
		    n++;
			if (n<argc)
			    S_gfx_X=atoi(argv[n]);
		    n++;
			if (n<argc)
			    S_gfx_Y=atoi(argv[n]);
        }

	    if (strcmp(argv[n],"-ssaver") == 0)
        {
		    n++;
			if (n<argc)
			    S_ssaver=atoi(argv[n]);
        }

	    if (strcmp(argv[n],"-realblack") == 0)
            S_real_black=DA;
    }

    // U minutama. E sad', pretvori u sekunde !!!
    S_ssaver*=60;
}

void tolowerS (char *string)
{
    int    i;

    for (i=0; string[i]; i++)
        string[i] = tolower(string[i]);
}


// Kao sto samo ime kaze.

void InicijalizujAllegro (void)
{
    allegro_init();
    install_keyboard();
    install_timer();

    LOCK_VARIABLE(Interapt);
    LOCK_VARIABLE(Sekunda);
    LOCK_FUNCTION(TimerVsync);
    LOCK_FUNCTION(TimerSekunda);

    // Nakon isteka vremena u milisekundama, proziva se navedena funkcija.
    install_int_ex(TimerVsync, BPS_TO_TIMER(S_fps));
    install_int_ex(TimerSekunda, BPS_TO_TIMER(1));
    text_mode(-1);
}


//Sve moguce inicijalizacije vezane za emulator, odrade se ovde.

void InicijalizujMasinu  (void)
{
    byte    a,b,x;
    byte    karakter;
    word    n,adresa;

    FILE    *rom, *chrgen;




    if ((chrgen=fopen("chrgen.bin","rb"))==NULL)
    {
        printf ("Ne mogu da otvorim CHRGEN.BIN !!!\n");
//WIN        delay (3000);
        ZaustaviMasinu ();
        exit (1);
    }

    bafer=malloc(2048);
    fread (bafer, 1, 2048, chrgen);

    Font=malloc(BROJ_ZNAKOVA*VISINA*SIRINA);
    if (S_real_black)
        memset (Font, CRNA, BROJ_ZNAKOVA*VISINA*SIRINA);
    else
        memset (Font, SIVA, BROJ_ZNAKOVA*VISINA*SIRINA);

    for (karakter=0; karakter<BROJ_ZNAKOVA; karakter++)
        for (n=0; n<VISINA; n++)
        {
            adresa=n<<7;
            adresa|=karakter;

            a=1;
            b=bafer[adresa];

            for (x=0; x<SIRINA; x++)
            {
                if (!(b&a))
                    Font[(karakter*VISINA*SIRINA)+(n*SIRINA)+x]=BELA;

                a<<=1;
            }
        }

    free (bafer);
    fclose (chrgen);

    if ((rom=fopen("ROM1.BIN","rb"))==NULL)
    {
        printf ("Ne mogu da otvorim ROM1.BIN !!!\n");
//WIN        delay (3000);
        ZaustaviMasinu ();
        exit (1);
    }

    if ((MEMORY=(byte *)malloc(WORK_SPACE))==NULL)
    {
        printf ("Ne mogu da alociram potrebnu memoriju.\n");
//WIN        delay (3000);
        ZaustaviMasinu ();
        exit (1);
    }
    fread (&MEMORY[0], 1, 4096, rom);
    fclose (rom);

#ifndef BezROM2
    if ((rom=fopen("ROM2.BIN","rb"))==NULL)
    {
        printf ("Ne mogu da otvorim ROM2.BIN !!!\n");
//WIN   delay (3000);
        ZaustaviMasinu ();
        exit (2);
    }
    fread (&MEMORY[0x1000], 1, 4096, rom);
    fclose (rom);
#else
    for (n=0x1000; n<0x2000; n++)
        MEMORY[n]=0xFF;
#endif

#ifndef BezGAL_PLUS
    if ((rom=fopen("GAL_PLUS.BIN","rb"))==NULL)
    {
        printf ("Ne mogu da otvorim GAL_PLUS.BIN !!!\n");
//WIN        delay (3000);
        ZaustaviMasinu ();
        exit (2);
    }
    fread (&MEMORY[0xE000], 1, 4096, rom);
    fclose (rom);
#else
//    for (n=0xE000; n<0xF000; n++)
//       MEMORY[n]=0xFF;
#endif


    // Tastatura
    for (n=0x2000; n<0x2800; n++)
        MEMORY[n]=0xFF;

    // Ekran
    for (n=0x2800; n<0x2A00; n++)
        MEMORY[n]=' '+n;

    // 6116-ice
    for (n=0x2A00; n<KRAJ_RAMA; n++)
        MEMORY[n]=0;

//    Z80_IRQ=Z80_IGNORE_INT;




    // TZZ je iskoriscen da bi se izbegla provera unutar glavne petlje za ispis.
    TZZ=malloc(256);

    for (n=0; n<256; n++)
	{
        if ((n>63 && n<96) || (n>127 && n < 192))
		{
            TZZ[n]=n-64;
		}
        else if (n > 191)
		{
			TZZ[n]=n-128;
		}
		else
		{
            TZZ[n]=n;
		}
	}

    Fassst=0;

    memset (EZP, 0, 512);

    InitUnos=1;

    F11_hold=NE;

    ShowFPS=0;
    Cur_fps=Disp_fps=0;
    HorPos=0;

    InicijalizujSSaver();
}


// Jet, set, Willy ...

void StartujMasinu (void)
{
	ResetZ80 (&R); 

//	R.Trace=0;
//	R.IAutoReset=0;
//	R.TrapBadOps=0;

	R.ICount=CPU_SPEED / S_fps; // to ensure that all operations will be done
//	R.ICount=0;
	
//	Z80_IPeriod = CPU_SPEED / S_fps;    // T-ciklusa po interaptu

//    Z80_Reset ();                       // Pokloni se, i ...
    RunZ80 (&R);                             // ... pocni da ?@#?$%^&@!@!?!!!!!
}


// Da bi izasli iz programa moramo odraditi par dole navedenih stvari.
// Nazad u 80x25 text mod.
// Oslobodi memoriju alociranu za double-buffering.
// Kazi ALLEGRO-u da zavrsava posao ...

void ZaustaviMasinu (void)
{
//   set_gfx_mode (GFX_TEXT,80,25,0,0);
   destroy_bitmap (ekran);

//   allegro_exit ();
}


// Vidi Z80.H za dodatne informacije!
/*
byte Z80_In (byte Port)
{
    return (0xFF);
}


// Vidi Z80.H za dodatne informacije!

void Z80_Out (byte Port,byte Value)
{
}
*/
void OutZ80(register word Port,register byte Value)
{
}

byte InZ80(register word Port)
{
}

// Svako citanje iz memorije emulatora se obavlja ovde. Funkcija mora da bude
// uradjena bas u minimalistickom maniru. Ukoliko se iole poveca, drasticno
// se usporava emulacija !!!

/*
unsigned Z80_RDMEM(dword A)
{
    // More citaj bre odakle god 'oces.
    return (MEMORY[A&0xFFFF]);
}


// Isto kao i za prethodnu funkciju s' tim sto sam ovde ipak morao da uradim
// jos nesto, da proverim da li je upis u RAM podrucju.

void Z80_WRMEM(dword A,byte V)
{
    // 0x0000 - 0x1FFF je ROM.
    // 0x2000 - 0x2800 su tastatura i kasetofon.

    if (A>=0x2800 && A<KRAJ_RAMA)
        MEMORY[A]=V;
}
*/
byte		RdZ80				(register word Addr)
{
    return (MEMORY[Addr&0xFFFF]);
}

void		WrZ80				(register word Addr,register byte Value)
{
    // 0x0000 - 0x1FFF je ROM.
    // 0x2000 - 0x2800 su tastatura i kasetofon.

    if (Addr>=0x2800 && Addr<KRAJ_RAMA)
        MEMORY[Addr]=Value;
}


// Vidi Z80.H za dodatne informacije!

void PatchZ80(register Z80 *R)
{
}


//
//              
// Z80 INTERAPT 
//              
//

// Nakon CPU_SPEED/fps T-ciklusa, jezgro Z80 emulatora proziva ovu funkciju.
// Tada se odradi sve sto je neophodno za emulator, a onda se izvrsi ona
// prava Z80 interapt rutina iz ROM-a.
// Dakle osvezi se ekran, skanira tastatura, obradi screen saver, ispituju
// kontrolni tasteri (Izlazak, Reset, NMI, Status, LOAD/SAVE), meri stvarni
// FPS ukoliko se ne radi o SYNC 1 modu, i sve ostalo sto je potrebno.

word LoopZ80(register Z80 *R)
//int Z80_Interrupt(void)
{
    char    bafer[128];

	// Reset the ICount so that next interrupt happens 
	R->ICount=CPU_SPEED / S_fps; // to ensure that all operations will be done


    // Da li treba da se pomera slika ?
    if (HorPos!=MEMORY[0x2BA8])
    {
        clear_to_color (screen,0);
        HorPos=MEMORY[0x2BA8];
    }

    if (Sekunda)
    {
        ScreenSaverCounter++;
        if (ScreenSaverCounter>S_ssaver)
            ssaver=DA;

        Sekunda=0;
        Disp_fps=Cur_fps;
        Cur_fps=0;
    }

    // Ako treba ispisi statusnu liniju.
    if (ShowFPS)
    {
        text_mode(-1);

        ObrisiGornjiDeoEkrana();

        sprintf (bafer, "FPS                CLK          ");
        textout (ekran, font, bafer, 0, 0, 7);

        sprintf (bafer, "%d", Disp_fps);
        textout (ekran, font, bafer, 32, 0, 6);

//        sprintf (bafer, "%d", Disp_fps*(R->ICount));
        sprintf (bafer, "%d", Disp_fps*(R->ICount));
        textout (ekran, font, bafer, 184, 0, 6);

        OsveziPrviRed ();
    }

    // Da li je screen saver aktivan ?
    if (ssaver)
        FadeInOut();

    // Broji frejmove.
    Cur_fps++;

    // Usluzi SAVE/LOAD opcije.
    LoadSave (KEY_F2, Save, SAVE);
    LoadSave (KEY_F3, Load, LOAD);

    InitUnos=1;

    // Mozda neki od kontrolnih tastera.
//WIN    if (key[KEY_CONTROL])
    if (key[KEY_LCONTROL])
    {
        // Na CTRL+Q se izlazi iz emulatora.
        if (key[KEY_Q])
        {
            fade_out (FADE_OUT_SPEED);
            return INT_QUIT;
        }
        // Na CTRL+R se resetuje emulator.
        else if (key[KEY_R])
        {
            while (key[KEY_R]);
            ResetZ80(R);
        }
        // Na CTRL+N se HARD-BREJKUJE emulator.
        else if (key[KEY_N])
        {
            while (key[KEY_N]);
//            return (Z80_NMI_INT);
			IntZ80(R, INT_NMI);
			return (0);
        }
    }

    // Da prikazem/uklonim statusnu liniju ?

    if (key[KEY_F11])
    {
        if (!F11_hold)
        {
            F11_hold=DA;
            InicijalizujSSaver();

            if (ShowFPS)
            {
                ShowFPS=0;
                ObrisiGornjiDeoEkrana();
                OsveziPrviRed ();
            }
            else
                ShowFPS=1;
        }
    }
    else
        F11_hold=NE;

//    Z80_GetRegs (&R);        // Daj bre te registre ovamo ...

    if (!(R->IFF & IFF_2))
        Fassst++;
    else
        Fassst=0;

//        OsveziEkran ();
    // Ako je EI osvezavaj i ekran i tastaturu, kao i kod prave masine.
    if (!Fassst)
    {
        OcitajTastaturu ();
        OsveziEkran ();
    }
    else
        switch (Fassst)
        {
            // Because screen is made under IRQ, there is no more further screen updates.
            case 1:
				// Need to clear it ?
                clear_to_color (screen,0);
                break;

            // Stay where You are.
            case 2:
                Fassst--;
                break;
        }

    return (0);
}



byte DebugZ80(register Z80 *R)
{
}


// Obradjuje opcije LOAD/SAVE.

void LoadSave (int Taster, DIALOG *opcija, int sta)
{
    char    tmp_baf[128];
    char    m_baf[128];
    int     ret;
    FILE    *snimak;

    if (key[Taster])
    {
        InicijalizujSSaver();

        clear_keybuf();
        if ((ret=do_dialog(opcija, 2))==2)
        {
            if (strlen(the_string)>0)
            {
                strcpy(tmp_baf, the_string);
                strcat(tmp_baf, ".gal");

                if (sta==SAVE)
                {
                    if ((snimak=fopen(tmp_baf,"wb"))==NULL)
                    {
                        sprintf (m_baf,"Ne mogu da snimim %s !!!\n", tmp_baf);
                        ErrorMessage (SCREEN_W/8/2-((strlen(m_baf)+1)/2),SCREEN_H/8/2,m_baf);
                        return;
                    }

//                    Z80_GetRegs (&R);        // Daj' !!!
					
					ret = sizeof(R);

                    fwrite (&R, 1, sizeof(R), snimak);
                    fwrite (&MEMORY[0x2000], 1, WORK_SPACE-0x2000, snimak);
                    fclose (snimak);
                }
                else
                {
                    if ((snimak=fopen(tmp_baf,"rb"))==NULL)
                    {
                        sprintf (m_baf,"Ne mogu da otvorim %s !!!", tmp_baf);
                        ErrorMessage (SCREEN_W/8/2-((strlen(m_baf)+1)/2),SCREEN_H/8/2,m_baf);
                        return;
                    }

					if (file_size(tmp_baf) == 8268)
					{
						// DOS verzija Snapshot - za sad !!!
						fread (&DOS_R, 1, sizeof(Z80_RegsDOS), snimak);
						fread (&MEMORY[0x2000], 1, WORK_SPACE-0x2000, snimak);
						// Convert registers Now !
						R.AF.W = DOS_R.AF.W.l;
						R.BC.W = DOS_R.BC.W.l;
						R.DE.W = DOS_R.DE.W.l;
						R.HL.W = DOS_R.HL.W.l;
						R.IX.W = DOS_R.IX.W.l;
						R.IY.W = DOS_R.IY.W.l;
						R.PC.W = DOS_R.PC.W.l;
						R.SP.W = DOS_R.SP.W.l;
						R.AF1.W = DOS_R.AF2.W.l;
						R.BC1.W = DOS_R.BC2.W.l;
						R.DE1.W = DOS_R.DE2.W.l;
						R.HL1.W = DOS_R.HL2.W.l;
						R.IFF = 0;
						if (DOS_R.IM == 1) R.IFF+=2;
						if (DOS_R.IM == 2) R.IFF+=4;
						if (DOS_R.IFF1) R.IFF+=1;
						R.I = DOS_R.I;
						R.R = (DOS_R.R&127)|(DOS_R.R2&128);
					}
					else
					{
						// Win Experimental snapshot !
						fread (&R, 1, sizeof(R), snimak);
						fread (&MEMORY[0x2000], 1, WORK_SPACE-0x2000, snimak);
					}
					fclose (snimak);

//                    Z80_SetRegs (&R);        // Na' ?!@#$!?
                }
            }
            InitUnos=1;
        }

        // Morao sam ovo da dodam kako bi se korektno brisao LOAD/SAVE prozorcic.
        rectfill (screen, 90, 102, 166, 124, 0);

//        clear_keybuf();
		while (key[KEY_ENTER]);
		clear_keybuf();
    }
}


// Postavi jedan elemenat palete.
// Doduse, za to nije potrebna ova funkcija, moglo bi se uraditi i ovako kao
// sto je to uradjeno u njoj, ali ovako je na nekim mestima ipak elegantnije.

void SetColor(byte red, byte green, byte blue, byte color)
{
   paleta[color].r=red;
   paleta[color].g=green;
   paleta[color].b=blue;
}


void CenterWindow(void)
{
	HWND	wnd=win_get_window(); 
	HWND	desktop=GetDesktopWindow(); 
	RECT	wndRect,desktopRect; 
	int	w,h,dw,dh,WINx,WINy; 
	
	GetWindowRect(wnd,&wndRect);
	GetWindowRect(desktop,&desktopRect); 
	w =wndRect.right      - wndRect.left;
	h =wndRect.bottom     - wndRect.top; 
	dw=desktopRect.right  - desktopRect.left; 
	dh=desktopRect.bottom - desktopRect.top; 
	
	WINx=(dw-w)/2;
	WINy=(dh-h)/2;
	
	MoveWindow(wnd,WINx,WINy, w, h, TRUE);
}	


// Ovde se inicijalizuju stvari vezane za pustanje grafike u rad, kao i
// za prikazivanje uvodne slike.

void SetupVideo (void)
{
//WIN    Register PositionRegs[6];

    get_pallete (paleta);
    fade_out (FADE_OUT_SPEED);

/*	set_color_depth(8);
   if (set_gfx_mode(GFX_AUTODETECT, 1280, 1024, 0, 0)<0)
    {
        ZaustaviMasinu();
        printf ("Can't set 640x480 mode !");
        exit (0);
    }
*/
	set_color_depth(8);
    if (set_gfx_mode(GFX_AUTODETECT_WINDOWED, S_gfx_X*d_gfx, S_gfx_Y*d_gfx, 0, 0)<0)
    {
        ZaustaviMasinu();
        printf ("Can't set graphics mode !");
        exit (0);
    }

	CenterWindow();

    ekran = create_bitmap(SCREEN_W, SCREEN_H);
    clear_to_color (ekran,1);

   // Sve boje inicijalizuj na potpuno crnilo.
    memset (paleta, 0, sizeof(paleta));

    set_pallete (paleta);

    if ((ekran=load_pcx ("galaxy.pcx", paleta))!=NULL)
    {
        blit (ekran, screen, 0,0, 0,0, SCREEN_W, SCREEN_H);

        fade_in (paleta,FADE_IN_SPEED);
        readkey();
        fade_out (FADE_OUT_SPEED);

        clear_keybuf();
        destroy_bitmap (ekran);
    }



    // Sve boje inicijalizuj na potpuno crnilo.
    memset (paleta, 0, sizeof(paleta));

    SetColor(00,16,16,SIVA       );	// Nesto malo iznad crnog
    SetColor(48,48,48,BELA       );	// Bela
    SetColor(32,00,00,CRFENA     ); // Crfena
    SetColor(00,24,00,ZELENA     ); // Zelena
    SetColor(00,00,24,PLAFA      ); // Blue
    SetColor(48,00,16,JARKOCRFENA); // Statusna linija,brojevi. Crrfena
    SetColor(32,00,48,ROZA       ); // Statusna linija, tekst.

    // Pokusaj da ostvaris onih obecanih 50Hz.

/*
    if (S_sync==3)
    {
        PositionRegs[0].port=0x3D4;
        PositionRegs[0].index=0;

        PositionRegs[1].port=0x3D4;
        PositionRegs[1].index=3;

        PositionRegs[2].port=0x3D4;
        PositionRegs[2].index=4;

        PositionRegs[3].port=0x3D4;
        PositionRegs[3].index=5;

        PositionRegs[4].port=0x3D4;
        PositionRegs[4].index=6;

        PositionRegs[5].port=0x3D4;
        PositionRegs[5].index=0x10;

        PositionRegs[0].value=0x6B;
        PositionRegs[1].value=0x8E;
        PositionRegs[2].value=0x5F;
        PositionRegs[3].value=0x8B;
        PositionRegs[4].value=0x74;
        PositionRegs[5].value=0x29;
*/
/*
        PositionRegs[0].value=0x6C;
        PositionRegs[1].value=0x8F;
        PositionRegs[2].value=0x60;
        PositionRegs[3].value=0x8C;
        PositionRegs[4].value=0x6E;
        PositionRegs[5].value=0x37;
*/

/*
        outRegArray(PositionRegs, 6);
    }
*/
    ekran = create_bitmap(MAX_X, MAX_Y);

    if (S_real_black)
        clear_to_color (ekran,CRNA);
    else
        clear_to_color (ekran,SIVA);

    // Prvih 8 i poslednjih 8 koristim kao statusne linije.
    // Kada se ne koristi pretopi u boju bordera.
    // Efektivno ostaje 208 linija.
    ObrisiGornjiDeoEkrana();
    ObrisiDonjiDeoEkrana();

    set_palette(paleta);
}


// Ako bi trebalo negde poraditi na ubrzavanju EMULACIJE , onda je to ova
// funkcija. Naime sliku na ekranu moramo generisati dovoljno brzo da to ne
// treperi. Dakle odprilike onih 50 Hz kao na TV-u. Da bi se to izvelo moramo
// napraviti 50 slika na osnovu GALAKSIJINE 'video memorije' i prebaciti ih
// na ekran PC-a. Kao sto ste mozda i primetili, primenjena je tehnika duplog
// baferovanja. Zasto ? Zato sto je direktan pristup video memoriji VGA
// karte i do 100-inak PUTA sporiji nego pristup glavnoj memoriji.
// Neverovatno ali istinito. Startujte recimo PCCONFIG pa vidite. Dakle,
// izgenerisemo sliku u tom privremenom baferu, a onda sto brze to prebacimo
// u memoriju VGA karte, kako bi se to i prikazalo na ekranu. Kritican deo
// je upravo to generisanje slike. (Zanemarimo prebacivanje slike koje je
// sastavni deo ALLEGRO biblioteke)
// Da bi se izgenerisala slika moramo pretrcati svih 512 (32x16) pozicija u
// GALAKSIJINOJ video memoriji i za svaku potraziti oblik tog znaka, pa ga
// onda prebaciti u bafer. Evo matematike.
//
// Znak je visok 12bajta.
// Znakova ima 512
// Slika u sekundi ima 50 (ili vise, zavisno od 'sync' moda)
// ----------------------
// Svega 12x512x50=307200
//
// I da vam posle toga ostane i dovoljno vremena za pristojnu emulaciju ?!?
// Eto zasto je potrebna malo jaca masina, odnosno zasto je i originalna
// GALAKSIJA ipak bila spora. Cim se ukine generisanje slike to letiiii...
// Probajte FASTMODE.GAL

void NacrtajKarakter (byte karakter, byte x, byte y)
{
    byte    tmpX;
    byte    n, pozX, pozY;
    word    pozK;

    pozX=x*SIRINA;
    pozY=(y*VISINA)+8;
    pozK=(karakter&0x7F)*VISINA*SIRINA;

    for (n=0; n<VISINA; n++, pozY++)
        for (tmpX=0; tmpX<SIRINA; tmpX++)
            ekran->line[pozY][pozX+tmpX]=Font[pozK++];
}


// Osvezi ekran na osnovu GALAKSIJINE video memorije.

void OsveziEkran (void)
{
    byte    x,y;
    word    adresa,EZPadresa;
	int barva;
	int offset;

    adresa=0x2800;
    EZPadresa=0;

    for (y=0; y<16; y++)
        for (x=0; x<32; x++)

            // TZZ se inicijalizuje u funkciji 'InicijalizujMasinu'
            // Eto, sluzi da iole ubrza stvari. (Normalno, samo u SYNC 0 modu)

            if (TZZ[MEMORY[adresa]] != EZP[EZPadresa++])
                NacrtajKarakter (TZZ[MEMORY[adresa++]],x,y);
            else
                adresa++;


    if (S_sync==2 || S_sync==3) // Refresh on Vsync.
        CekajVSync();

    if (S_sync==1)              // Refresh on timer.
    {
        while (!Interapt);
        Interapt=0;
    }

    if (MEMORY[0x2BB0])
    {
        // Obrisi prvi galaksijin red.

		barva = SIVA;
        if (S_real_black)
		{
			barva = CRNA;
		}
		offset = (MEMORY[0x2BB0]*3);
		if (offset > MAX_Y-16)
		{
			offset = MAX_Y-16;
		}

		if (d_gfx == 2)
		{
	        rectfill (screen, 2*(((S_gfx_X-MAX_X)/2)-88+(MEMORY[0x2BA8]*8)),          2*(((S_gfx_Y-MAX_Y)/2)+8),
		                     2*((((S_gfx_X-MAX_X)/2)-88+(MEMORY[0x2BA8]*8))+MAX_X-1), 2*(((S_gfx_Y-MAX_Y)/2)+8+offset), barva);
		}
		else
		{
	        rectfill (screen, ((S_gfx_X-MAX_X)/2)-88+(MEMORY[0x2BA8]*8),          ((S_gfx_Y-MAX_Y)/2)+8,
		                     (((S_gfx_X-MAX_X)/2)-88+(MEMORY[0x2BA8]*8))+MAX_X-1, ((S_gfx_Y-MAX_Y)/2)+8+offset, barva);
		}

        // Ispisi ostatak Galaksijine slike vodeci racuna o sadrzaju 0x2BA8 !
		if (d_gfx == 2)
		{
	        stretch_blit (ekran, screen, 0,8, MAX_X, MAX_Y-16-(MEMORY[0x2BB0]*3), 2*(((S_gfx_X-MAX_X)/2)-88+(MEMORY[0x2BA8]*8)),2*(((S_gfx_Y-MAX_Y)/2)+8+(MEMORY[0x2BB0]*3)), 2*MAX_X, 2*(MAX_Y-16-(MEMORY[0x2BB0]*3)));
		}
		else
		{
	        blit (ekran, screen, 0,8, ((S_gfx_X-MAX_X)/2)-88+(MEMORY[0x2BA8]*8),((S_gfx_Y-MAX_Y)/2)+8+(MEMORY[0x2BB0]*3), MAX_X, MAX_Y-16-(MEMORY[0x2BB0]*3));
		}
    }
    else
	{
        // Ako nema pomeranja samo pukni sliku na ekran.
		if (d_gfx == 2)
		{
	        stretch_blit (ekran, screen, 0,0, MAX_X, MAX_Y, 2*(((S_gfx_X-MAX_X)/2)-88+(MEMORY[0x2BA8]*8)),2*((S_gfx_Y-MAX_Y)/2), MAX_X*2, MAX_Y*2);
		}
		else
		{
	        blit (ekran, screen, 0,0, ((S_gfx_X-MAX_X)/2)-88+(MEMORY[0x2BA8]*8),(S_gfx_Y-MAX_Y)/2, MAX_X, MAX_Y);
		}
	}

    memcpy (EZP, &MEMORY[0x2800], 512);
}


// Osvezi sadrzaj gornje statusne linije.

void OsveziPrviRed (void)
{
	if (d_gfx == 2)
	{
	    stretch_blit (ekran, screen, 0,0, MAX_X, 8, 2*(((S_gfx_X-MAX_X)/2)-88+(MEMORY[0x2BA8]*8)), 2*((S_gfx_Y-MAX_Y)/2), MAX_X*2, 8*2);
	}
	else
	{
	    blit (ekran, screen, 0,0, ((S_gfx_X-MAX_X)/2)-88+(MEMORY[0x2BA8]*8),(S_gfx_Y-MAX_Y)/2, MAX_X, 8);
	}
}


//
//           
// TASTATURA 
//           
//


// Skanira tastaturu, i GALAKSIJI servira ono sto ona ocekuje.

void OcitajTastaturu (void)
{
    byte    A;

    for (A=1; A<54; A++)
    {

        // Ako smo u ScreenSaver modu, vrati se u normalno stanje i
        // anuliraj upravo pritisnuti taster.

        if (key[Kmap[A]])
        {
            InicijalizujSSaver();
            if (ssaver)
            {
                // Ovaj taster kao da nismo ni pritisnuli !!!
                key[Kmap[A]]=NE;
                return;
            }
        }

        // Par modifikacija, radi udobnosti.
        // Shift je Shift, pa bio on levi ili desni. I tome slicno.

        switch (Kmap[A])
        {
            case KEY_LEFT:
                MEMORY[0x2000+A]=key[Kmap[A]]||key[KEY_BACKSPACE] ? 0xFE : 0xFF;
                break;

            case KEY_LSHIFT:
                MEMORY[0x2000+A]=key[Kmap[A]]||key[KEY_RSHIFT] ? 0xFE : 0xFF;
                break;

            default:
                MEMORY[0x2000+A]=key[Kmap[A]] ? 0xFE : 0xFF;
        }
    }
}


// Da li je pritisnut bilo koji taster od onih koje prepoznaje ALLEGRO
// biblioteka. (Tj. bilo koji !)

int KeyPressed(void)
{
    int n;

    for (n=1; n<MAX_KEY_DEFINES; n++)
        if (key[n])
            return (1);

    return(0);
}


// Problem je bio sledeci. d_edit_proc nije tretirao nikako taster
// enter. S' obzirom na namenu to je i ok, ALI !!! Meni je trebalo
// da se iz d_edit_proc izadje i sa enter. Pisati novu proceduru !?!
// Ispravljati sors allegro-a ?!?! Kad ono ... presretnes poziv ovoj
// funkciji i udesis kako tebi odgovara. Uobicajena procedura.
// Naravoucenije: Kad' ti se spava, idi bre spavaj !!!

int  moja_d_edit_proc (int msg, DIALOG *d, int c)
{
    int Skey, Akey;

    Skey=c>>8;
    Akey=c&0xFF;
    if (msg==MSG_CHAR)
    {
        // Na ESC vrati originalnu boju polja za unos.
	    if (Skey == KEY_ESC)
        {
            d->bg=5;
            return (d_edit_proc (msg, d, c));
        }

        // Na enter izidji.
	    if (Skey == KEY_ENTER)
        {
            d->bg=5;
            return (D_CLOSE);
        }

        // Space nije dozvoljen u nazivu datoteka.
        if (Skey == KEY_SPACE)
            return (D_O_K);

        // Kontrolni karakteri, StrelLevo, StrelDesno, itd. su dozvoljeni
        if (iscntrl(Akey))
        {
            InitUnos=0;
            d->bg=3;
            return (d_edit_proc (msg, d, c));
        }

        // Bilo sta sem slova, brojeva i ovog gore je nedozvoljeno !!!
        if (!isalnum(Akey))
            return (D_O_K);

        if (InitUnos)
        {
            InitUnos=0;
            d->bg=3;
            the_string[0]=0;
        }
    }

    return (d_edit_proc (msg, d, c));
}


// Ispise poruku o gresci, uokviri je, zapisti i ceka na bilo koji taster.

void ErrorMessage (int x, int y, char *tekst)
{
    char    mes_baf[128];
    int xpos, ypos, sirina, visina;

    xpos=x*8;
    ypos=y*8;

    // Ovo +1 je rastojanje od po 4 tackice na pocetku i kraju teksta od okvira.
    sirina=xpos+((strlen(tekst)+1)*8);
    visina=ypos+15;

    rectfill (screen, xpos, ypos, sirina, visina, CRFENA);
    rect     (screen, xpos, ypos, sirina, visina, BELA);

    text_mode(-1);

    sprintf (mes_baf, "%s", tekst);
    textout (screen, font, mes_baf, xpos+4, ypos+4, BELA);

    Zvuk (3, 3000);

    readkey();

    rectfill (screen, xpos, ypos, sirina, visina, 0);
    clear_keybuf();
}


void Zvuk (int puta, int freq)
{
//WIN
/*    int n;
    for (n=0; n<puta; n++)
    {
        sound(freq);
        rest (150);
        nosound();
        rest (50);
    }
*/
}


// Ceka Vertikalnu Sinhronizaciju.

void CekajVSync (void)
{
/*    while(inportb(0x3DA)&8);
    while((inportb(0x3DA)&8)==0);
*/
	vsync();
}


// Obrise gornju statusnu liniju.

void ObrisiGornjiDeoEkrana (void)
{
    rectfill (ekran, 0, 0, MAX_X, 7, 0);
}


void ObrisiDonjiDeoEkrana (void)
{
    rectfill (ekran, 0, MAX_Y-7, MAX_X, MAX_Y, 0);
}


//
//                                 
// Funkcije vezane za SCREEN SAVER 
//                                 
//

// Morao sam da napisem svoje rutine za ovo, zato sto, dok one ugradjene u
// ALLEGRO-u, dok rade, u potpunosti zaustavljaju GALAKSIJU.
// SCREEN SAVER je tu da zastiti monitor a ne da remeti uobicajene poslove.

void FadeInOut (void)
{
	switch (fade)
    {
        case FIN:
            if (!FadeIn())
                fade=FOUT;
            break;

        case FOUT:
            if (!FadeOut())
                fade=FIN;
            break;

        case FINIT:
            fade=FOUT;
            memcpy (fio_paleta, paleta, sizeof(paleta));
            break;
    }
}


int FadeIn (void)
{
    int     n, ima;

    ima=0;
    for (n=0; n<256; n++)
    {
        if (fio_paleta[n].r != paleta[n].r ||
            fio_paleta[n].g != paleta[n].g ||
            fio_paleta[n].b != paleta[n].b) ima=1;

        if (fio_paleta[n].r != paleta[n].r) fio_paleta[n].r++;
        if (fio_paleta[n].g != paleta[n].g) fio_paleta[n].g++;
        if (fio_paleta[n].b != paleta[n].b) fio_paleta[n].b++;
    }

    if (ima)
        PostaviPaletu (fio_paleta);

    return (ima);
}


int FadeOut (void)
{
    int     n, ima;

    ima=0;
    for (n=0; n<256; n++)
    {
        if (fio_paleta[n].r ||
            fio_paleta[n].g ||
            fio_paleta[n].b) ima=1;

        if (fio_paleta[n].r) fio_paleta[n].r--;
        if (fio_paleta[n].g) fio_paleta[n].g--;
        if (fio_paleta[n].b) fio_paleta[n].b--;
    }

    if (ima)
        PostaviPaletu (fio_paleta);

    return (ima);
}


// Morao sam da napisem ovu funkciju zato sto funkcija set_palette ceka na
// VSync pa tek onda odradi postavljanje nove palete. To dovodi do
// nezeljene sinhronizacije ispisa slike sa VSync-om.
// Shvatio ? NE? Umesto FALSE stavi TRUE, prekompajliraj, startuj, pa F11 !

void PostaviPaletu (PALLETE p)
{
   set_pallete_range(p, 0, PAL_SIZE-1, FALSE);
}


void InicijalizujSSaver (void)
{
    ScreenSaverCounter=0;
    ssaver=NE;
    fade=FINIT;
    if (ssaver)
        PostaviPaletu (paleta);
}
//
//         
// M A I N 
//         
//

void main (int argc,char *argv[])
{
    AnalyzeCommandLineSwitches(argc,argv);
    InicijalizujAllegro();
    InicijalizujMasinu();
    SetupVideo();
    StartujMasinu();
    ZaustaviMasinu();
}
END_OF_MAIN()

