// Solace -- Sol Anachronistic Computer Emulation
// A Win32 emulator for the Sol-20 computer.
//
// Copyright (c) Jim Battle, 2000

// This is a binary version of the character generator ROM in the
// Processor Technology Sol-20 computer.  The book says it is a 6574
// character generator.
//
// The character cell on the display is 13 rows of 9 pixels.  However,
// the character generator only ever produces 9 rows of 7 pixels for
// any given character; the rest is padding or shifting of the cell
// for descenders (descenders shift down three rows).
//
// This table encodes both the leading empty line and the descender shifting.
// It doesn't encode the two pixel pad of each row due to the encoding pain.
//
// The msb of each byte is ignored; ie, the 7 active pixels per row
// are encoded in bits 6 to 0.

#include "solace_types.h"

uint8 charset_6574[] = {

    /*00*/  0x00, 0xFE, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0xFE, 0x00, 0x00, 0x00,  // square
    /*01*/  0x00, 0xFE, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x00, 0x00, 0x00,  // top-left angle
    /*02*/  0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0xFE, 0x00, 0x00, 0x00,  // inverted T
    /*03*/  0x00, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0xFE, 0x00, 0x00, 0x00,  // bot-rgt angle
    /*04*/  0x00, 0x40, 0x20, 0x10, 0x08, 0x7C, 0x20, 0x10, 0x08, 0x04, 0x00, 0x00, 0x00,  // lightning
    /*05*/  0x00, 0xFE, 0x82, 0xC6, 0xAA, 0x92, 0xAA, 0xC6, 0x82, 0xFE, 0x00, 0x00, 0x00,  // x in a box
    /*06*/  0x00, 0x00, 0x02, 0x04, 0x08, 0x90, 0xA0, 0xC0, 0x80, 0x00, 0x00, 0x00, 0x00,  // check
    /*07*/  0x00, 0x38, 0x44, 0x82, 0x82, 0x82, 0xFE, 0x28, 0x28, 0xEE, 0x00, 0x00, 0x00,  // vert nand
    /*08*/  0x00, 0x20, 0x40, 0xF8, 0x44, 0x22, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00,  // left turn
    /*09*/  0x00, 0x00, 0x10, 0x08, 0x04, 0xFE, 0x04, 0x08, 0x10, 0x00, 0x00, 0x00, 0x00,  // rt arrow
    /*0A*/  0x00, 0xFE, 0x00, 0x00, 0x00, 0xFE, 0x00, 0x00, 0x00, 0xFE, 0x00, 0x00, 0x00,  // equivalence
    /*0B*/  0x00, 0x00, 0x10, 0x10, 0x10, 0x92, 0x54, 0x38, 0x10, 0x00, 0x00, 0x00, 0x00,  // dwn arrow
    /*0C*/  0x00, 0x10, 0x10, 0x54, 0x38, 0x10, 0x92, 0x54, 0x38, 0x10, 0x00, 0x00, 0x00,  // dbl dwn arrow
    /*0D*/  0x00, 0x00, 0x10, 0x20, 0x40, 0xFE, 0x40, 0x20, 0x10, 0x00, 0x00, 0x00, 0x00,  // left arrow
    /*0E*/  0x00, 0x38, 0x44, 0xC6, 0xAA, 0x92, 0xAA, 0xC6, 0x44, 0x38, 0x00, 0x00, 0x00,  // x in oval
    /*0F*/  0x00, 0x38, 0x44, 0x82, 0x82, 0x92, 0x82, 0x82, 0x44, 0x38, 0x00, 0x00, 0x00,  // . in oval

    /*10*/  0x00, 0xFE, 0x82, 0x82, 0x82, 0xFE, 0x82, 0x82, 0x82, 0xFE, 0x00, 0x00, 0x00,  // 2-pane window
    /*11*/  0x00, 0x38, 0x54, 0x92, 0x92, 0x9E, 0x82, 0x82, 0x44, 0x38, 0x00, 0x00, 0x00,  // 3:00 oval
    /*12*/  0x00, 0x38, 0x44, 0x82, 0x82, 0x9E, 0x92, 0x92, 0x54, 0x38, 0x00, 0x00, 0x00,  // 3:30 oval
    /*13*/  0x00, 0x38, 0x44, 0x82, 0x82, 0xF2, 0x92, 0x92, 0x54, 0x38, 0x00, 0x00, 0x00,  // 9:30 oval
    /*14*/  0x00, 0x38, 0x54, 0x92, 0x92, 0xF2, 0x82, 0x82, 0x44, 0x38, 0x00, 0x00, 0x00,  // 9:00 oval
    /*15*/  0x00, 0x00, 0x22, 0x14, 0x08, 0x94, 0xA2, 0xC0, 0x80, 0x00, 0x00, 0x00, 0x00,  // not check
    /*16*/  0x00, 0x7C, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0xC6, 0x00, 0x00, 0x00,  // croquet hoop
    /*17*/  0x00, 0x02, 0x02, 0x02, 0x02, 0xFE, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00,  // 90-cw T
    /*18*/  0x00, 0xFE, 0x82, 0x44, 0x28, 0x10, 0x28, 0x44, 0x82, 0xFE, 0x00, 0x00, 0x00,  // hourglass
    /*19*/  0x00, 0x10, 0x10, 0x10, 0x38, 0x38, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00,  // pogo stick
    /*1A*/  0x00, 0x78, 0x84, 0x84, 0x80, 0x60, 0x10, 0x10, 0x00, 0x10, 0x00, 0x00, 0x00,  // mirror question mark
    /*1B*/  0x00, 0x38, 0x44, 0x82, 0x82, 0xFE, 0x82, 0x82, 0x44, 0x38, 0x00, 0x00, 0x00,  // 9:15 oval
    /*1C*/  0x00, 0xFE, 0x92, 0x92, 0x92, 0xF2, 0x82, 0x82, 0x82, 0xFE, 0x00, 0x00, 0x00,  // 9:00 square
    /*1D*/  0x00, 0xFE, 0x82, 0x82, 0x82, 0xF2, 0x92, 0x92, 0x92, 0xFE, 0x00, 0x00, 0x00,  // 9:30 square
    /*1E*/  0x00, 0xFE, 0x82, 0x82, 0x82, 0x9E, 0x92, 0x92, 0x92, 0xFE, 0x00, 0x00, 0x00,  // 3:30 square
    /*1F*/  0x00, 0xFE, 0x92, 0x92, 0x92, 0x9E, 0x82, 0x82, 0x82, 0xFE, 0x00, 0x00, 0x00,  // 3:00 square

    /*20*/  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // space
    /*21*/  0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x10, 0x10, 0x00, 0x00, 0x00,  // !
    /*22*/  0x00, 0x48, 0x48, 0x48, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // "
    /*23*/  0x00, 0x28, 0x28, 0x28, 0xFE, 0x28, 0xFE, 0x28, 0x28, 0x28, 0x00, 0x00, 0x00,  // #
    /*24*/  0x00, 0x10, 0x7E, 0x90, 0x90, 0x7C, 0x12, 0x12, 0xFC, 0x10, 0x00, 0x00, 0x00,  // $
    /*25*/  0x00, 0x40, 0xA2, 0x44, 0x08, 0x10, 0x20, 0x44, 0x8A, 0x04, 0x00, 0x00, 0x00,  // %
    /*26*/  0x00, 0x70, 0x88, 0x88, 0x50, 0x20, 0x52, 0x8C, 0x8C, 0x72, 0x00, 0x00, 0x00,  // &
    /*27*/  0x00, 0x18, 0x18, 0x10, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // '
    /*28*/  0x00, 0x08, 0x10, 0x20, 0x20, 0x20, 0x20, 0x20, 0x10, 0x08, 0x00, 0x00, 0x00,  // (
    /*29*/  0x00, 0x20, 0x10, 0x08, 0x08, 0x08, 0x08, 0x08, 0x10, 0x20, 0x00, 0x00, 0x00,  // )
    /*2A*/  0x00, 0x00, 0x10, 0x92, 0x54, 0x38, 0x54, 0x92, 0x10, 0x00, 0x00, 0x00, 0x00,  // *
    /*2B*/  0x00, 0x00, 0x10, 0x10, 0x10, 0xFE, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00,  // +
    /*2C*/  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x20, 0x40, 0x00,  // ,
    /*2D*/  0x00, 0x00, 0x00, 0x00, 0x00, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // -
    /*2E*/  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00,  // .
    /*2F*/  0x00, 0x00, 0x02, 0x04, 0x08, 0x10, 0x20, 0x40, 0x80, 0x00, 0x00, 0x00, 0x00,  // /

    /*30*/  0x00, 0x7C, 0x82, 0x86, 0x8A, 0x92, 0xA2, 0xC2, 0x82, 0x7C, 0x00, 0x00, 0x00,  // 0
    /*31*/  0x00, 0x10, 0x30, 0x50, 0x10, 0x10, 0x10, 0x10, 0x10, 0x7C, 0x00, 0x00, 0x00,  // 1
    /*32*/  0x00, 0x7C, 0x82, 0x02, 0x04, 0x38, 0x40, 0x80, 0x80, 0xFE, 0x00, 0x00, 0x00,  // 2
    /*33*/  0x00, 0x7C, 0x82, 0x02, 0x02, 0x3C, 0x02, 0x02, 0x82, 0x7C, 0x00, 0x00, 0x00,  // 3
    /*34*/  0x00, 0x04, 0x0C, 0x14, 0x24, 0x44, 0x84, 0xFE, 0x04, 0x04, 0x00, 0x00, 0x00,  // 4
    /*35*/  0x00, 0xFE, 0x80, 0x80, 0xF8, 0x04, 0x02, 0x02, 0x84, 0x78, 0x00, 0x00, 0x00,  // 5
    /*36*/  0x00, 0x3C, 0x40, 0x80, 0x80, 0xFC, 0x82, 0x82, 0x82, 0x7C, 0x00, 0x00, 0x00,  // 6
    /*37*/  0x00, 0xFE, 0x82, 0x04, 0x08, 0x10, 0x20, 0x20, 0x20, 0x20, 0x00, 0x00, 0x00,  // 7
    /*38*/  0x00, 0x7C, 0x82, 0x82, 0x82, 0x7C, 0x82, 0x82, 0x82, 0x7C, 0x00, 0x00, 0x00,  // 8
    /*39*/  0x00, 0x7C, 0x82, 0x82, 0x82, 0x7E, 0x02, 0x02, 0x04, 0x78, 0x00, 0x00, 0x00,  // 9
    /*3A*/  0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00,  // :
    /*3B*/  0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x30, 0x30, 0x20, 0x40, 0x00,  // ;
    /*3C*/  0x00, 0x08, 0x10, 0x20, 0x40, 0x80, 0x40, 0x20, 0x10, 0x08, 0x00, 0x00, 0x00,  // <
    /*3D*/  0x00, 0x00, 0x00, 0x00, 0x7C, 0x00, 0x7C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // =
    /*3E*/  0x00, 0x20, 0x10, 0x08, 0x04, 0x02, 0x04, 0x08, 0x10, 0x20, 0x00, 0x00, 0x00,  // >
    /*3F*/  0x00, 0x3C, 0x42, 0x42, 0x02, 0x0C, 0x10, 0x10, 0x00, 0x10, 0x00, 0x00, 0x00,  // ?

    /*40*/  0x00, 0x3C, 0x42, 0x9A, 0xAA, 0xAA, 0xBC, 0x80, 0x40, 0x3C, 0x00, 0x00, 0x00,  // @
    /*41*/  0x00, 0x38, 0x44, 0x82, 0x82, 0x82, 0xFE, 0x82, 0x82, 0x82, 0x00, 0x00, 0x00,  // A
    /*42*/  0x00, 0xFC, 0x42, 0x42, 0x42, 0x7C, 0x42, 0x42, 0x42, 0xFC, 0x00, 0x00, 0x00,  // B
    /*43*/  0x00, 0x3C, 0x42, 0x80, 0x80, 0x80, 0x80, 0x80, 0x42, 0x3C, 0x00, 0x00, 0x00,  // C
    /*44*/  0x00, 0xF8, 0x44, 0x42, 0x42, 0x42, 0x42, 0x42, 0x44, 0xF8, 0x00, 0x00, 0x00,  // D
    /*45*/  0x00, 0xFE, 0x80, 0x80, 0x80, 0xF0, 0x80, 0x80, 0x80, 0xFE, 0x00, 0x00, 0x00,  // E
    /*46*/  0x00, 0xFE, 0x80, 0x80, 0x80, 0xF0, 0x80, 0x80, 0x80, 0x80, 0x00, 0x00, 0x00,  // F
    /*47*/  0x00, 0x3C, 0x42, 0x80, 0x80, 0x80, 0x9E, 0x82, 0x42, 0x3C, 0x00, 0x00, 0x00,  // G
    /*48*/  0x00, 0x82, 0x82, 0x82, 0x82, 0xFE, 0x82, 0x82, 0x82, 0x82, 0x00, 0x00, 0x00,  // H
    /*49*/  0x00, 0x7C, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x7C, 0x00, 0x00, 0x00,  // I
    /*4A*/  0x00, 0x3E, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x88, 0x70, 0x00, 0x00, 0x00,  // J
    /*4B*/  0x00, 0x82, 0x84, 0x88, 0x90, 0xA0, 0xD0, 0x88, 0x84, 0x82, 0x00, 0x00, 0x00,  // K
    /*4C*/  0x00, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0xFE, 0x00, 0x00, 0x00,  // L
    /*4D*/  0x00, 0x82, 0xC6, 0xAA, 0x92, 0x92, 0x82, 0x82, 0x82, 0x82, 0x00, 0x00, 0x00,  // M
    /*4E*/  0x00, 0x82, 0xC2, 0xA2, 0x92, 0x8A, 0x86, 0x82, 0x82, 0x82, 0x00, 0x00, 0x00,  // N
    /*4F*/  0x00, 0x38, 0x44, 0x82, 0x82, 0x82, 0x82, 0x82, 0x44, 0x38, 0x00, 0x00, 0x00,  // O

    /*50*/  0x00, 0xFC, 0x82, 0x82, 0x82, 0xFC, 0x80, 0x80, 0x80, 0x80, 0x00, 0x00, 0x00,  // P
    /*51*/  0x00, 0x38, 0x44, 0x82, 0x82, 0x82, 0x92, 0x8A, 0x44, 0x3A, 0x00, 0x00, 0x00,  // Q
    /*52*/  0x00, 0xFC, 0x82, 0x82, 0x82, 0xFC, 0x90, 0x88, 0x84, 0x82, 0x00, 0x00, 0x00,  // R
    /*53*/  0x00, 0x7C, 0x82, 0x80, 0x80, 0x7C, 0x02, 0x02, 0x82, 0x7C, 0x00, 0x00, 0x00,  // S
    /*54*/  0x00, 0xFE, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00,  // T
    /*55*/  0x00, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7C, 0x00, 0x00, 0x00,  // U
    /*56*/  0x00, 0x82, 0x82, 0x82, 0x44, 0x44, 0x28, 0x28, 0x10, 0x10, 0x00, 0x00, 0x00,  // V
    /*57*/  0x00, 0x82, 0x82, 0x82, 0x82, 0x92, 0x92, 0xAA, 0xC6, 0x82, 0x00, 0x00, 0x00,  // W
    /*58*/  0x00, 0x82, 0x82, 0x44, 0x28, 0x10, 0x28, 0x44, 0x82, 0x82, 0x00, 0x00, 0x00,  // X
    /*59*/  0x00, 0x82, 0x82, 0x44, 0x28, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00,  // Y
    /*5A*/  0x00, 0xFE, 0x02, 0x04, 0x08, 0x10, 0x20, 0x40, 0x80, 0xFE, 0x00, 0x00, 0x00,  // Z
    /*5B*/  0x00, 0x78, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x78, 0x00, 0x00, 0x00,  // [
    /*5C*/  0x00, 0x00, 0x80, 0x40, 0x20, 0x10, 0x08, 0x04, 0x02, 0x00, 0x00, 0x00, 0x00,  // \ 
    /*5D*/  0x00, 0x78, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x78, 0x00, 0x00, 0x00,  // ]
    /*5E*/  0x00, 0x10, 0x28, 0x44, 0x82, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // ^
    /*5F*/  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFE, 0x00, 0x00, 0x00,  // _

    /*60*/  0x00, 0x30, 0x30, 0x10, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // `
    /*61*/  0x00, 0x00, 0x00, 0x00, 0x78, 0x04, 0x7C, 0x84, 0x84, 0x7A, 0x00, 0x00, 0x00,  // a
    /*62*/  0x00, 0x80, 0x80, 0x80, 0xB8, 0xC4, 0x84, 0x84, 0xC4, 0xB8, 0x00, 0x00, 0x00,  // b
    /*63*/  0x00, 0x00, 0x00, 0x00, 0x78, 0x84, 0x80, 0x80, 0x84, 0x78, 0x00, 0x00, 0x00,  // c
    /*64*/  0x00, 0x04, 0x04, 0x04, 0x74, 0x8C, 0x84, 0x84, 0x8C, 0x74, 0x00, 0x00, 0x00,  // d
    /*65*/  0x00, 0x00, 0x00, 0x00, 0x78, 0x84, 0xFC, 0x80, 0x80, 0x78, 0x00, 0x00, 0x00,  // e
    /*66*/  0x00, 0x18, 0x24, 0x20, 0x20, 0xF8, 0x20, 0x20, 0x20, 0x20, 0x00, 0x00, 0x00,  // f
    /*67*/  0x00, 0x00, 0x00, 0x00, 0x74, 0x8C, 0x84, 0x8C, 0x74, 0x04, 0x04, 0x84, 0x78,  // g
    /*68*/  0x00, 0x80, 0x80, 0x80, 0xB8, 0xC4, 0x84, 0x84, 0x84, 0x84, 0x00, 0x00, 0x00,  // h
    /*69*/  0x00, 0x00, 0x10, 0x00, 0x30, 0x10, 0x10, 0x10, 0x10, 0x38, 0x00, 0x00, 0x00,  // i
    /*6A*/  0x00, 0x00, 0x00, 0x00, 0x0C, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x44, 0x38,  // j
    /*6B*/  0x00, 0x80, 0x80, 0x80, 0x88, 0x90, 0xA0, 0xD0, 0x88, 0x84, 0x00, 0x00, 0x00,  // k
    /*6C*/  0x00, 0x30, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x38, 0x00, 0x00, 0x00,  // l
    /*6D*/  0x00, 0x00, 0x00, 0x00, 0xEC, 0x92, 0x92, 0x92, 0x92, 0x92, 0x00, 0x00, 0x00,  // m
    /*6E*/  0x00, 0x00, 0x00, 0x00, 0xB8, 0xC4, 0x84, 0x84, 0x84, 0x84, 0x00, 0x00, 0x00,  // n
    /*6F*/  0x00, 0x00, 0x00, 0x00, 0x78, 0x84, 0x84, 0x84, 0x84, 0x78, 0x00, 0x00, 0x00,  // o

    /*70*/  0x00, 0x00, 0x00, 0x00, 0xB8, 0xC4, 0x84, 0x84, 0xC4, 0xB8, 0x80, 0x80, 0x80,  // p
    /*71*/  0x00, 0x00, 0x00, 0x00, 0x74, 0x8C, 0x84, 0x84, 0x8C, 0x74, 0x04, 0x04, 0x04,  // q
    /*72*/  0x00, 0x00, 0x00, 0x00, 0xB8, 0xC4, 0x80, 0x80, 0x80, 0x80, 0x00, 0x00, 0x00,  // r
    /*73*/  0x00, 0x00, 0x00, 0x00, 0x78, 0x84, 0x60, 0x18, 0x84, 0x78, 0x00, 0x00, 0x00,  // s
    /*74*/  0x00, 0x00, 0x20, 0x20, 0xF8, 0x20, 0x20, 0x20, 0x24, 0x18, 0x00, 0x00, 0x00,  // t
    /*75*/  0x00, 0x00, 0x00, 0x00, 0x84, 0x84, 0x84, 0x84, 0x8C, 0x74, 0x00, 0x00, 0x00,  // u
    /*76*/  0x00, 0x00, 0x00, 0x00, 0x82, 0x82, 0x82, 0x44, 0x28, 0x10, 0x00, 0x00, 0x00,  // v
    /*77*/  0x00, 0x00, 0x00, 0x00, 0x82, 0x92, 0x92, 0x92, 0x92, 0x6C, 0x00, 0x00, 0x00,  // w
    /*78*/  0x00, 0x00, 0x00, 0x00, 0x84, 0x48, 0x30, 0x30, 0x48, 0x84, 0x00, 0x00, 0x00,  // x
    /*79*/  0x00, 0x00, 0x00, 0x00, 0x84, 0x84, 0x84, 0x84, 0x8C, 0x74, 0x04, 0x84, 0x78,  // y
    /*7A*/  0x00, 0x00, 0x00, 0x00, 0xFC, 0x08, 0x10, 0x20, 0x40, 0xFC, 0x00, 0x00, 0x00,  // z
    /*7B*/  0x00, 0x1C, 0x20, 0x20, 0x20, 0x40, 0x20, 0x20, 0x20, 0x1C, 0x00, 0x00, 0x00,  // {
    /*7C*/  0x00, 0x10, 0x10, 0x10, 0x00, 0x00, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00,  // |
    /*7D*/  0x00, 0x30, 0x08, 0x08, 0x08, 0x04, 0x08, 0x08, 0x08, 0x30, 0x00, 0x00, 0x00,  // }
    /*7E*/  0x00, 0x60, 0x92, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // ~
    /*7F*/  0x00, 0x48, 0x92, 0x24, 0x48, 0x92, 0x24, 0x48, 0x92, 0x24, 0x00, 0x00, 0x00,  // checkerboard

};
