// Solace -- Sol Anachronistic Computer Emulation
// A Win32 emulator for the Sol-20 computer.
//
// Copyright (c) Jim Battle, 2000, 2001

#ifndef _HEXFILE_H_
#define _HEXFILE_H_


// actually, none of the members of this struct needs to be visible
// outside of hexfile.c, but if there is some way to hide this in C,
// I'm ignorant of it.  All the world really needs to know is that
// it has a pointer to the struct.
typedef struct {
    unsigned long	 magic;		// handle validator
    int			 line;		// which line is being read
    char		*filename;	// for informational purposes
    int			 writeaccess;	// 1=write, 0=read
    int			 format;	// 0=ent, 1=intel hex
    FILE		*fp;		// file handle
    char 		*offset;	// parser offset into line buffer
    unsigned long	 state;		// used by parser
    char		*buffer;	// line buffer
} hfile_t;

#define HFILE_OK		(0)
#define HFILE_BAD_HANDLE	(1)
#define HFILE_BAD_FORMAT	(2)
#define HFILE_FILE_ERROR	(3)
#define HFILE_EOF		(4)


// --- Routines for hex file manipulation ---

// determine the type not by the file suffix, but by reading
// the first line of the file and guessing.
// returns 0 if HEX, 1 if ENT, 2 if unknown, -1 if file error.
int hexfile_guessformat(char *filename);

// byte at a time interface, open file for reading or writing.
// format indicates file type: 0=intel hex, 1=sol ent
// *access must be either "r" or "w".
// return NULL on error, otherwise returns a handle.
hfile_t *hexfile_hex_open(char *filename, int format, char *access);

// byte at a time interface, close file
// return 0 on success, something else on failure
int hexfile_hex_close(hfile_t *hf);

// byte at a time interface, read or write one byte
// return 0 on success, something else on failure
int hexfile_hex_write(hfile_t *hf, int  addr, byte  data);
int hexfile_hex_read( hfile_t *hf, int *addr, byte *data);


// read a binary file in either "ENter" or intel "hex" format.
// we determine the type not by the file suffix, but by reading
// the first line of the file and guessing.
int hexfile_read(char *filename, int report, byte *memory);

// write a binary file in either "ENter" or intel "hex" format.
// return 0 on success, something else on failure.
int hexfile_hexdump(char *filename, int format, int start, int end, byte *memory);


#endif // ifdef _HEXFILE_H_
