// Solace -- Sol Anachronistic Computer Emulation
// A Win32 emulator for the Sol-20 computer.
//
// Copyright (c) Jim Battle, 2001


#define SCRIPT_META_KEY 0x0001	// interpret \<LOAD> and the like
#define SCRIPT_META_HEX 0x0002	// interpret \3F and the like
#define SCRIPT_META_INC 0x0004	// interpret \include filename.foo

#define SCRIPT_MAX_HANDLES 10	// maximum number of script_open's at one time
#define SCRIPT_MAX_LINELEN 1024	// maximum length of one line in file

// return codes
#define SCRIPT_OK              ( 0)
#define SCRIPT_NOMORE_HANDLES  (-1)
#define SCRIPT_BAD_FILE        (-2)
#define SCRIPT_MALLOC_ERROR    (-3)
#define SCRIPT_BAD_HANDLE      (-4)
#define SCRIPT_EOF             (-5)

// just initialize/close the package
void script_initpkg(void);
void script_closepkg(void);

// open a script file.  if metaflags contians SCRIPT_META_INC,
// netdepth indicates what the maximum nesting depth is.
// the file first opened is considered depth 0.
// a return handle of SCRIPT_NOMORE_HANDLES means no more
// handles are available.
int script_open(char *filename, int metaflags, int nestdepth);

// test the script handle for EOF
int script_eof(int handle);

// read next character in script stream.
// returns 0 if OK, 1 if EOF, -1 if bad handle
int script_next_char(int handle, char *ch);

// read next line in script stream.  bufsize is the number
// of bytes in the buffer that *buf points at.
// trailing CR/LF's are stripped.
// returns 0 if OK, 1 if EOF, -1 if bad handle
int script_next_line(int handle, char *buf, int bufsize);

// close a script whether at EOF or not
void script_close(int handle);

