// Solace -- Sol Anachronistic Computer Emulation
// A Win32 emulator for the Sol-20 computer.
//
// Copyright (c) Jim Battle, 2001

#ifndef _SOLACE_TYPES_H_
#define _SOLACE_TYPES_H_


#ifndef TRUE
    #define TRUE 1
#endif
#ifndef FALSE
    #define FALSE 0
#endif

// pick up definitions for:
// min(), max(), MAX_PATH
#include <windows.h>

#if 1
#include <assert.h>
#define ASSERT(x) assert(x)
#else
#define ASSERT(x)
#endif


// used by Z80.h and related code
typedef unsigned char byte;
typedef unsigned short word;
typedef signed char offset;

// used here and there
typedef unsigned char  uint8;
typedef unsigned short uint16;
typedef          short  int16;
typedef unsigned int   uint32;
typedef          int    int32;
typedef unsigned __int64 uint64;
typedef          __int64 int64;

// used by the scheduler
typedef unsigned __int64 timer_t;

// used for reporting why the processor halted
typedef enum { BRKPT_BRK, BRKPT_HALT, BRKPT_ILLEGAL, BRKPT_DEBUG } brkpt_t;

// used in interface and core to describe 8080 clock rate
typedef enum { MHZ_2_04, MHZ_2_38, MHZ_2_86, MHZ_unregulated } speed_t;

// types of breakpoints
typedef enum { BRK_INVALID, BRK_TEMP, BRK_OP, BRK_IN, BRK_OUT,
	       BRK_RD, BRK_RD16, BRK_WR, BRK_WR16 } break_t;

// dipswitch 1 buttons
typedef enum {
	SW1_RESET	= 0x01,
	SW1_BLANKCTL	= 0x04,
	SW1_POLARITY	= 0x08,
	SW1_BLINKCUR	= 0x10,
	SW1_SOLIDCUR	= 0x20,
} sw1_t;


#endif // ifdef _SOLACE_TYPES_H_

