// Solace -- Sol Anachronistic Computer Emulation
// A Win32 emulator for the Sol-20 computer.
//
// Copyright (c) Jim Battle, 2000

// types shared between windebug.c and its subordinate windows.

#ifndef _WINDBGSUB_H_
#define _WINDBGSUB_H_

#include <windows.h>
#include "solace_types.h"	// pick up 'word' definition

typedef struct {

    BOOL active;		// FALSE=disabled

    BOOL valid_position;	// window size and position are known
    RECT position;		// window RECT

    int  xClient, yClient;	// client area

    HCURSOR hSplitCursor;	// handle to splitter cursor
    int  splitcursor;		// flag indicating if the new cursor is active
    RECT splitbar;		// location of splitter bar
    RECT splitrange;		// splitbar must remain inside this area
    int  splitpos;		// y client location of dragged split bar
    int  splitflag;		// TRUE if dragging the split bar
    int  splitpercent;		// dasm/log split is kept as a percentage

    HWND hRegWnd;		// register display window
    HWND hDasmWnd;		// disassembled output window
    HWND hMemWnd;		// memory display output window
    HWND hCmdWnd;		// command input window
    HWND hLogWnd;		// command output window

    // we attempt to use courier font, but failing that, we use
    // ANSI_FIXED_FONT.  thus, fixed_font is always defined, but
    // cour_font may or may not be.
    HFONT cour_font;	// courier new
    HFONT fixed_font;	// chosen fixed font
    int   fix_x;	// chosen font width (fixed pitch)
    int   fix_y;	// chosen font height (fixed pitch)

} dbgstate_t;

extern dbgstate_t dbgstate;


// scrollable window behaviors--
typedef enum {
    WA_INIT,		// initialize window
    WA_DISABLE,		// disable the window
    WA_ENABLE,		// enable the window
    WA_LINEUP,		// go up one instruction
    WA_LINEDOWN,	// go down one instruction
    WA_PAGEUP,		// go up one page
    WA_PAGEDOWN,	// go down one page
    WA_GOTO,		// go to a specific line
    WA_DASMREFRESH,	// special for DASM window
} win_action_t;


// -------- function prototypes --------

// stuff exported by container window
void GrayOutWindow(HWND hwnd, HDC hdc);
void handle_fkey(UINT key);


// function prototypes and types exported by debug command edit subwindow
HWND CreateCmdWindow(HWND hwnd);
void RegisterCmdClass(void);
void InitEditHist(void);
void windbg_cmd_fwdchar(WPARAM wParam, LPARAM lParam);


// function prototypes and types exported by debug register window
void RegisterRegClass();
HWND CreateRegWindow(HWND hwnd);


// function prototypes and types exported by debug memory (stack) subwindow
void RegisterMemClass(void);
HWND CreateMemWindow(HWND hwnd);
void MemWindowAction(win_action_t action, word addr);


// function prototypes and types exported by debug window logging subwindow.
void RegisterLogClass(void);
HWND CreateLogWindow(HWND hwnd);
void LogWindowAction(win_action_t action, int line);


// function prototypes and types exported by debug disassembler window
void RegisterDasmClass();
HWND CreateDasmWindow(HWND hwnd);
void DasmWindowAction(win_action_t action, word addr);
void RecomputeHScrollbarDasm(void);

#endif // ifdef _WINDBGSUB_H_
