/*
 * Decompiled with CFR 0.152.
 */
public class I8253
extends EmptyPort {
    public int subcycle;
    public int C0_mode;
    public int C1_mode;
    public int C2_mode;
    public int C0_RLmode;
    public int C1_RLmode;
    public int C2_RLmode;
    public boolean C0_RLlobyte;
    public boolean C1_RLlobyte;
    public boolean C2_RLlobyte;
    public int C0_state;
    public int C1_state;
    public int C2_state;
    public int C0_init = 65535;
    public int C1_init = 65535;
    public int C2_init = 65535;
    public int C0_latch;
    public int C1_latch;
    public int C2_latch;
    public int C0_sub;
    public int C1_sub;
    public int C2_sub;
    public boolean C0_BCD;
    public boolean C1_BCD;
    public boolean C2_BCD;

    public int in(int n, long l) {
        switch (n) {
            case 212: {
                break;
            }
            case 213: {
                int n2 = this.C1_state;
                switch (this.C1_RLmode) {
                    case 1: {
                        return n2 & 0xFF;
                    }
                    case 2: {
                        return n2 >>> 8 & 0xFF;
                    }
                    case 0: {
                        n2 = this.C1_latch;
                    }
                    case 3: {
                        if (this.C1_RLlobyte) {
                            this.C1_RLlobyte = false;
                            return n2 >>> 8 & 0xFF;
                        }
                        this.C1_RLlobyte = true;
                        return n2 & 0xFF;
                    }
                }
                break;
            }
            case 214: {
                int n3 = this.C2_state;
                switch (this.C2_RLmode) {
                    case 1: {
                        return n3 & 0xFF;
                    }
                    case 2: {
                        return n3 >>> 8 & 0xFF;
                    }
                    case 0: {
                        n3 = this.C2_latch;
                    }
                    case 3: {
                        if (this.C2_RLlobyte) {
                            this.C2_RLlobyte = false;
                            return n3 >>> 8 & 0xFF;
                        }
                        this.C2_RLlobyte = true;
                        return n3 & 0xFF;
                    }
                }
                break;
            }
            case 215: {
                System.out.println("Illegal read from CW");
                break;
            }
            default: {
                System.out.println("I8253.in() Unsupported port number " + Integer.toHexString(n));
            }
        }
        return 0;
    }

    public void out(int n, int n2, long l) {
        block0 : switch (n) {
            case 212: {
                break;
            }
            case 213: {
                switch (this.C1_RLmode) {
                    case 0: {
                        System.out.println("Latch write ???");
                        System.out.println("I8253.out(" + Integer.toHexString(n) + "," + Integer.toHexString(n2) + ")");
                        break;
                    }
                    case 1: {
                        this.C1_init &= n2 & 0xFF;
                        this.C1_state = this.C1_init;
                        break;
                    }
                    case 2: {
                        this.C1_init &= n2 << 8 & 0xFF00;
                        this.C1_state = this.C1_init;
                        break;
                    }
                    case 3: {
                        if (this.C1_RLlobyte) {
                            this.C1_init |= n2 << 8 & 0xFF00;
                            this.C1_state = this.C1_init;
                            this.C1_RLlobyte = false;
                            this.C1_mode &= 7;
                            break;
                        }
                        this.C1_init = n2 & 0xFF;
                        this.C1_RLlobyte = true;
                        this.C1_mode |= 0x100;
                    }
                }
                break;
            }
            case 214: {
                switch (this.C2_RLmode) {
                    case 0: {
                        System.out.println("Latch write ???");
                        System.out.println("I8253.out(" + Integer.toHexString(n) + "," + Integer.toHexString(n2) + ")");
                        break;
                    }
                    case 1: {
                        this.C2_init &= n2 & 0xFF;
                        this.C2_state = this.C2_init;
                        break;
                    }
                    case 2: {
                        this.C2_init &= n2 << 8 & 0xFF00;
                        this.C2_state = this.C2_init;
                        break;
                    }
                    case 3: {
                        if (this.C2_RLlobyte) {
                            this.C2_init |= n2 << 8 & 0xFF00;
                            this.C2_state = this.C2_init;
                            this.C2_RLlobyte = false;
                            this.C2_mode &= 7;
                            break;
                        }
                        this.C2_init = n2 & 0xFF;
                        this.C2_RLlobyte = true;
                        this.C2_mode |= 0x100;
                    }
                }
                break;
            }
            case 215: {
                boolean bl;
                int n3 = n2 >>> 6 & 3;
                int n4 = n2 >>> 4 & 3;
                int n5 = n2 >>> 1 & 7;
                boolean bl2 = bl = n2 == 1;
                if (bl) {
                    System.out.println("BCD not supported!!!");
                    System.out.println("I8253.out(" + Integer.toHexString(n) + "," + Integer.toHexString(n2) + ")");
                }
                switch (n3) {
                    case 0: {
                        this.C0_RLmode = n4;
                        if (n4 == 0) {
                            this.C0_latch = this.C0_state;
                        }
                        this.C0_mode = n5;
                        this.C0_BCD = bl;
                        this.C0_RLlobyte = false;
                        this.C0_state = this.C0_init;
                        break block0;
                    }
                    case 1: {
                        this.C1_RLmode = n4;
                        if (n4 == 0) {
                            this.C1_latch = this.C1_state;
                            break block0;
                        }
                        this.C1_mode = n5 | 0x100;
                        this.C1_BCD = bl;
                        this.C1_state = this.C1_init;
                        this.C1_RLlobyte = false;
                        break block0;
                    }
                    case 2: {
                        this.C2_RLmode = n4;
                        if (n4 == 0) {
                            this.C2_latch = this.C2_state;
                            break block0;
                        }
                        this.C2_mode = n5 | 0x100;
                        this.C2_BCD = bl;
                        this.C2_state = this.C2_init;
                        this.C2_RLlobyte = false;
                        break block0;
                    }
                }
                System.out.println("Illegal counter number (3)");
                break;
            }
            default: {
                System.out.println("I8253.out() Unsupported port number " + Integer.toHexString(n));
            }
        }
    }

    public void executeCTC1(int n) {
        if (n == 0) {
            return;
        }
        switch (this.C1_mode) {
            case 2: {
                if (this.C1_init > 0) {
                    --this.C1_state;
                    while (this.C1_state <= 0) {
                        this.C1_state += this.C1_init;
                        if (this.C2_mode >= 8) continue;
                        --this.C2_state;
                    }
                    break;
                }
                if (!this.m.umze.debug) break;
                System.out.println("CTC1 has zero init value");
                break;
            }
            default: {
                if (!this.m.umze.debug) break;
                System.out.println("Unsupported mode for CTC1: " + this.C1_mode);
            }
        }
        switch (this.C2_mode) {
            case 0: {
                if (this.C2_state >= 0) break;
                this.C2_state = 0;
                break;
            }
            default: {
                if (!this.m.umze.debug) break;
                System.out.println("Unsupported mode for CTC2: " + this.C2_mode);
            }
        }
    }

    public I8253() {
    }

    public I8253(Machine machine) {
        this();
        this.m = machine;
    }
}

