/*
 * Decompiled with CFR 0.152.
 */
public class Z80 {
    private Machine m;
    public int cycles = 0;
    public static final int IM0 = 0;
    public static final int IM1 = 1;
    public static final int IM2 = 2;
    private static final int F_C = 1;
    private static final int F_N = 2;
    private static final int F_PV = 4;
    private static final int F_3 = 8;
    private static final int F_H = 16;
    private static final int F_5 = 32;
    private static final int F_Z = 64;
    private static final int F_S = 128;
    private static final int PF = 4;
    private static final int p_ = 0;
    private static final boolean[] parity = new boolean[256];
    protected int _A = 0;
    protected int _HL = 0;
    protected int _B = 0;
    protected int _C = 0;
    protected int _DE = 0;
    protected boolean fS = false;
    protected boolean fZ = false;
    protected boolean f5 = false;
    protected boolean fH = false;
    protected boolean f3 = false;
    protected boolean fPV = false;
    protected boolean fN = false;
    protected boolean fC = false;
    protected int _AF_ = 0;
    protected int _HL_ = 0;
    protected int _BC_ = 0;
    protected int _DE_ = 0;
    protected int _IX = 0;
    protected int _IY = 0;
    protected int _ID = 0;
    protected int _SP = 0;
    protected int _PC = 0;
    protected int _I = 0;
    protected int _R = 0;
    protected int _R7 = 0;
    protected boolean _IFF1 = true;
    protected boolean _IFF2 = true;
    protected int _IM = 2;
    public final int[] mem = new int[65536];

    public Z80(Machine machine) {
        this.m = machine;
    }

    public final int AF() {
        return this.A() << 8 | this.F();
    }

    public final void AF(int n) {
        this.A(n >> 8);
        this.F(n & 0xFF);
    }

    public final int BC() {
        return this.B() << 8 | this.C();
    }

    public final void BC(int n) {
        this.B(n >> 8);
        this.C(n & 0xFF);
    }

    public final int DE() {
        return this._DE;
    }

    public final void DE(int n) {
        this._DE = n;
    }

    public final int HL() {
        return this._HL;
    }

    public final void HL(int n) {
        this._HL = n;
    }

    public final int PC() {
        return this._PC;
    }

    public final void PC(int n) {
        this._PC = n;
    }

    public final int SP() {
        return this._SP;
    }

    public final void SP(int n) {
        this._SP = n;
    }

    public final int ID() {
        return this._ID;
    }

    public final void ID(int n) {
        this._ID = n;
    }

    public final int IX() {
        return this._IX;
    }

    public final void IX(int n) {
        this._IX = n;
    }

    public final int IY() {
        return this._IY;
    }

    public final void IY(int n) {
        this._IY = n;
    }

    public final int A() {
        return this._A;
    }

    public final void A(int n) {
        this._A = n;
    }

    public final int F() {
        return (this.Sset() ? 128 : 0) | (this.Zset() ? 64 : 0) | (this.f5 ? 32 : 0) | (this.Hset() ? 16 : 0) | (this.f3 ? 8 : 0) | (this.PVset() ? 4 : 0) | (this.Nset() ? 2 : 0) | (this.Cset() ? 1 : 0);
    }

    public final void F(int n) {
        this.fS = (n & 0x80) != 0;
        this.fZ = (n & 0x40) != 0;
        this.f5 = (n & 0x20) != 0;
        this.fH = (n & 0x10) != 0;
        this.f3 = (n & 8) != 0;
        this.fPV = (n & 4) != 0;
        this.fN = (n & 2) != 0;
        this.fC = (n & 1) != 0;
    }

    public final int B() {
        return this._B;
    }

    public final void B(int n) {
        this._B = n;
    }

    public final int C() {
        return this._C;
    }

    public final void C(int n) {
        this._C = n;
    }

    public final int D() {
        return this._DE >> 8;
    }

    public final void D(int n) {
        this._DE = n << 8 | this._DE & 0xFF;
    }

    public final int E() {
        return this._DE & 0xFF;
    }

    public final void E(int n) {
        this._DE = this._DE & 0xFF00 | n;
    }

    public final int H() {
        return this._HL >> 8;
    }

    public final void H(int n) {
        this._HL = n << 8 | this._HL & 0xFF;
    }

    public final int L() {
        return this._HL & 0xFF;
    }

    public final void L(int n) {
        this._HL = this._HL & 0xFF00 | n;
    }

    public final int IDH() {
        return this._ID >> 8;
    }

    public final void IDH(int n) {
        this._ID = n << 8 | this._ID & 0xFF;
    }

    public final int IDL() {
        return this._ID & 0xFF;
    }

    public final void IDL(int n) {
        this._ID = this._ID & 0xFF00 | n;
    }

    public final int R7() {
        return this._R7;
    }

    public final int R() {
        return this._R & 0x7F | this._R7;
    }

    public final void R(int n) {
        this._R = n;
        this._R7 = n & 0x80;
    }

    public final void REFRESH(int n) {
        this._R += n;
    }

    public final int I() {
        return this._I;
    }

    public final void I(int n) {
        this._I = n;
    }

    public final boolean IFF1() {
        return this._IFF1;
    }

    public final void IFF1(boolean bl) {
        this._IFF1 = bl;
    }

    public final boolean IFF2() {
        return this._IFF2;
    }

    public final void IFF2(boolean bl) {
        this._IFF2 = bl;
    }

    public final int IM() {
        return this._IM;
    }

    public final void IM(int n) {
        this._IM = n;
    }

    public final void setZ(boolean bl) {
        this.fZ = bl;
    }

    public final void setC(boolean bl) {
        this.fC = bl;
    }

    public final void setS(boolean bl) {
        this.fS = bl;
    }

    public final void setH(boolean bl) {
        this.fH = bl;
    }

    public final void setN(boolean bl) {
        this.fN = bl;
    }

    public final void setPV(boolean bl) {
        this.fPV = bl;
    }

    public final void set3(boolean bl) {
        this.f3 = bl;
    }

    public final void set5(boolean bl) {
        this.f5 = bl;
    }

    public final boolean Zset() {
        return this.fZ;
    }

    public final boolean Cset() {
        return this.fC;
    }

    public final boolean Sset() {
        return this.fS;
    }

    public final boolean Hset() {
        return this.fH;
    }

    public final boolean Nset() {
        return this.fN;
    }

    public final boolean PVset() {
        return this.fPV;
    }

    private final int peekb(int n) {
        return this.m.mem_read(n, this.cycles) & 0xFF;
    }

    public void pokeb(int n, int n2) {
        this.m.mem_write(n, n2, this.cycles);
    }

    public void pokew(int n, int n2) {
        this.pokeb(n, n2 & 0xFF);
        this.pokeb(++n & 0xFFFF, n2 >> 8);
    }

    private final int peekw(int n) {
        int n2 = this.peekb(n);
        return n2 | this.peekb(++n & 0xFFFF) << 8;
    }

    private final int ID_d() {
        return this.ID() + (byte)this.nxtpcb() & 0xFFFF;
    }

    public final void pushw(int n) {
        int n2 = this.SP() - 2 & 0xFFFF;
        this.SP(n2);
        this.pokew(n2, n);
    }

    public final int popw() {
        int n = this.SP();
        int n2 = this.peekb(n);
        n2 |= this.peekb(++n & 0xFFFF) << 8;
        this.SP(++n & 0xFFFF);
        return n2;
    }

    public final void pushpc() {
        this.pushw(this.PC());
    }

    public final void poppc() {
        this.PC(this.popw());
    }

    private final int nxtpcb() {
        int n = this.PC();
        int n2 = this.peekb(n);
        this.PC(++n & 0xFFFF);
        return n2;
    }

    private final int nxtpcw() {
        int n = this.PC();
        int n2 = this.peekb(n);
        n2 |= this.peekb(++n & 0xFFFF) << 8;
        this.PC(++n & 0xFFFF);
        return n2;
    }

    public void reset() {
        this.PC(0);
        this.SP(0);
        this.A(0);
        this.F(0);
        this.BC(0);
        this.DE(0);
        this.HL(0);
        this.exx();
        this.ex_af_af();
        this.A(0);
        this.F(0);
        this.BC(0);
        this.DE(0);
        this.HL(0);
        this.IX(0);
        this.IY(0);
        this.R(0);
        this.I(0);
        this.IFF1(false);
        this.IFF2(false);
        this.IM(0);
    }

    public void outb(int n, int n2) {
        this.m.hw_port[n & 0xFF].out(n, n2, this.cycles);
    }

    public int inb(int n) {
        return this.m.hw_port[n & 0xFF].in(n, this.cycles);
    }

    private static boolean interruptTriggered(int n) {
        return n >= 0;
    }

    public int interrupt() {
        if (!this.IFF1()) {
            return 0;
        }
        switch (this.IM()) {
            case 0: 
            case 1: {
                this.pushpc();
                this.IFF1(false);
                this.IFF2(false);
                this.PC(56);
                return 13;
            }
            case 2: {
                this.pushpc();
                this.IFF1(false);
                this.IFF2(false);
                int n = this.I() << 8 | 0xFF;
                this.PC(this.peekw(n));
                return 19;
            }
        }
        return 0;
    }

    public final void execute(int n) {
        int n2 = 0;
        while (this.cycles < n) {
            if (Z80.interruptTriggered(n2)) {
                // empty if block
            }
            this.REFRESH(1);
            int n3 = this.nxtpcb();
            switch (n3) {
                case 0: {
                    n2 += 4;
                    break;
                }
                case 8: {
                    this.ex_af_af();
                    n2 += 4;
                    break;
                }
                case 16: {
                    int n4;
                    int n5 = Z80.qdec8(this.B());
                    this.B(n5);
                    if (n5 != 0) {
                        n4 = (byte)this.nxtpcb();
                        this.PC(this.PC() + n4 & 0xFFFF);
                        n2 += 13;
                        break;
                    }
                    this.PC(Z80.inc16(this.PC()));
                    n2 += 8;
                    break;
                }
                case 24: {
                    int n5 = (byte)this.nxtpcb();
                    this.PC(this.PC() + n5 & 0xFFFF);
                    n2 += 12;
                    break;
                }
                case 32: {
                    int n5;
                    if (!this.Zset()) {
                        n5 = (byte)this.nxtpcb();
                        this.PC(this.PC() + n5 & 0xFFFF);
                        n2 += 12;
                        break;
                    }
                    this.PC(Z80.inc16(this.PC()));
                    n2 += 7;
                    break;
                }
                case 40: {
                    int n5;
                    if (this.Zset()) {
                        n5 = (byte)this.nxtpcb();
                        this.PC(this.PC() + n5 & 0xFFFF);
                        n2 += 12;
                        break;
                    }
                    this.PC(Z80.inc16(this.PC()));
                    n2 += 7;
                    break;
                }
                case 48: {
                    int n5;
                    if (!this.Cset()) {
                        n5 = (byte)this.nxtpcb();
                        this.PC(this.PC() + n5 & 0xFFFF);
                        n2 += 12;
                        break;
                    }
                    this.PC(Z80.inc16(this.PC()));
                    n2 += 7;
                    break;
                }
                case 56: {
                    int n5;
                    if (this.Cset()) {
                        n5 = (byte)this.nxtpcb();
                        this.PC(this.PC() + n5 & 0xFFFF);
                        n2 += 12;
                        break;
                    }
                    this.PC(Z80.inc16(this.PC()));
                    n2 += 7;
                    break;
                }
                case 1: {
                    this.BC(this.nxtpcw());
                    n2 += 10;
                    break;
                }
                case 9: {
                    this.HL(this.add16(this.HL(), this.BC()));
                    n2 += 11;
                    break;
                }
                case 17: {
                    this.DE(this.nxtpcw());
                    n2 += 10;
                    break;
                }
                case 25: {
                    this.HL(this.add16(this.HL(), this.DE()));
                    n2 += 11;
                    break;
                }
                case 33: {
                    this.HL(this.nxtpcw());
                    n2 += 10;
                    break;
                }
                case 41: {
                    int n5 = this.HL();
                    this.HL(this.add16(n5, n5));
                    n2 += 11;
                    break;
                }
                case 49: {
                    this.SP(this.nxtpcw());
                    n2 += 10;
                    break;
                }
                case 57: {
                    this.HL(this.add16(this.HL(), this.SP()));
                    n2 += 11;
                    break;
                }
                case 2: {
                    this.pokeb(this.BC(), this.A());
                    n2 += 7;
                    break;
                }
                case 10: {
                    this.A(this.peekb(this.BC()));
                    n2 += 7;
                    break;
                }
                case 18: {
                    this.pokeb(this.DE(), this.A());
                    n2 += 7;
                    break;
                }
                case 26: {
                    this.A(this.peekb(this.DE()));
                    n2 += 7;
                    break;
                }
                case 34: {
                    this.pokew(this.nxtpcw(), this.HL());
                    n2 += 16;
                    break;
                }
                case 42: {
                    this.HL(this.peekw(this.nxtpcw()));
                    n2 += 16;
                    break;
                }
                case 50: {
                    this.pokeb(this.nxtpcw(), this.A());
                    n2 += 13;
                    break;
                }
                case 58: {
                    this.A(this.peekb(this.nxtpcw()));
                    n2 += 13;
                    break;
                }
                case 3: {
                    this.BC(Z80.inc16(this.BC()));
                    n2 += 6;
                    break;
                }
                case 11: {
                    this.BC(Z80.dec16(this.BC()));
                    n2 += 6;
                    break;
                }
                case 19: {
                    this.DE(Z80.inc16(this.DE()));
                    n2 += 6;
                    break;
                }
                case 27: {
                    this.DE(Z80.dec16(this.DE()));
                    n2 += 6;
                    break;
                }
                case 35: {
                    this.HL(Z80.inc16(this.HL()));
                    n2 += 6;
                    break;
                }
                case 43: {
                    this.HL(Z80.dec16(this.HL()));
                    n2 += 6;
                    break;
                }
                case 51: {
                    this.SP(Z80.inc16(this.SP()));
                    n2 += 6;
                    break;
                }
                case 59: {
                    this.SP(Z80.dec16(this.SP()));
                    n2 += 6;
                    break;
                }
                case 4: {
                    this.B(this.inc8(this.B()));
                    n2 += 4;
                    break;
                }
                case 12: {
                    this.C(this.inc8(this.C()));
                    n2 += 4;
                    break;
                }
                case 20: {
                    this.D(this.inc8(this.D()));
                    n2 += 4;
                    break;
                }
                case 28: {
                    this.E(this.inc8(this.E()));
                    n2 += 4;
                    break;
                }
                case 36: {
                    this.H(this.inc8(this.H()));
                    n2 += 4;
                    break;
                }
                case 44: {
                    this.L(this.inc8(this.L()));
                    n2 += 4;
                    break;
                }
                case 52: {
                    int n5 = this.HL();
                    this.pokeb(n5, this.inc8(this.peekb(n5)));
                    n2 += 11;
                    break;
                }
                case 60: {
                    this.A(this.inc8(this.A()));
                    n2 += 4;
                    break;
                }
                case 5: {
                    this.B(this.dec8(this.B()));
                    n2 += 4;
                    break;
                }
                case 13: {
                    this.C(this.dec8(this.C()));
                    n2 += 4;
                    break;
                }
                case 21: {
                    this.D(this.dec8(this.D()));
                    n2 += 4;
                    break;
                }
                case 29: {
                    this.E(this.dec8(this.E()));
                    n2 += 4;
                    break;
                }
                case 37: {
                    this.H(this.dec8(this.H()));
                    n2 += 4;
                    break;
                }
                case 45: {
                    this.L(this.dec8(this.L()));
                    n2 += 4;
                    break;
                }
                case 53: {
                    int n5 = this.HL();
                    this.pokeb(n5, this.dec8(this.peekb(n5)));
                    n2 += 11;
                    break;
                }
                case 61: {
                    this.A(this.dec8(this.A()));
                    n2 += 4;
                    break;
                }
                case 6: {
                    this.B(this.nxtpcb());
                    n2 += 7;
                    break;
                }
                case 14: {
                    this.C(this.nxtpcb());
                    n2 += 7;
                    break;
                }
                case 22: {
                    this.D(this.nxtpcb());
                    n2 += 7;
                    break;
                }
                case 30: {
                    this.E(this.nxtpcb());
                    n2 += 7;
                    break;
                }
                case 38: {
                    this.H(this.nxtpcb());
                    n2 += 7;
                    break;
                }
                case 46: {
                    this.L(this.nxtpcb());
                    n2 += 7;
                    break;
                }
                case 54: {
                    this.pokeb(this.HL(), this.nxtpcb());
                    n2 += 10;
                    break;
                }
                case 62: {
                    this.A(this.nxtpcb());
                    n2 += 7;
                    break;
                }
                case 7: {
                    this.rlc_a();
                    n2 += 4;
                    break;
                }
                case 15: {
                    this.rrc_a();
                    n2 += 4;
                    break;
                }
                case 23: {
                    this.rl_a();
                    n2 += 4;
                    break;
                }
                case 31: {
                    this.rr_a();
                    n2 += 4;
                    break;
                }
                case 39: {
                    this.daa_a();
                    n2 += 4;
                    break;
                }
                case 47: {
                    this.cpl_a();
                    n2 += 4;
                    break;
                }
                case 55: {
                    this.scf();
                    n2 += 4;
                    break;
                }
                case 63: {
                    this.ccf();
                    n2 += 4;
                    break;
                }
                case 64: {
                    n2 += 4;
                    break;
                }
                case 65: {
                    this.B(this.C());
                    n2 += 4;
                    break;
                }
                case 66: {
                    this.B(this.D());
                    n2 += 4;
                    break;
                }
                case 67: {
                    this.B(this.E());
                    n2 += 4;
                    break;
                }
                case 68: {
                    this.B(this.H());
                    n2 += 4;
                    break;
                }
                case 69: {
                    this.B(this.L());
                    n2 += 4;
                    break;
                }
                case 70: {
                    this.B(this.peekb(this.HL()));
                    n2 += 7;
                    break;
                }
                case 71: {
                    this.B(this.A());
                    n2 += 4;
                    break;
                }
                case 72: {
                    this.C(this.B());
                    n2 += 4;
                    break;
                }
                case 73: {
                    n2 += 4;
                    break;
                }
                case 74: {
                    this.C(this.D());
                    n2 += 4;
                    break;
                }
                case 75: {
                    this.C(this.E());
                    n2 += 4;
                    break;
                }
                case 76: {
                    this.C(this.H());
                    n2 += 4;
                    break;
                }
                case 77: {
                    this.C(this.L());
                    n2 += 4;
                    break;
                }
                case 78: {
                    this.C(this.peekb(this.HL()));
                    n2 += 7;
                    break;
                }
                case 79: {
                    this.C(this.A());
                    n2 += 4;
                    break;
                }
                case 80: {
                    this.D(this.B());
                    n2 += 4;
                    break;
                }
                case 81: {
                    this.D(this.C());
                    n2 += 4;
                    break;
                }
                case 82: {
                    n2 += 4;
                    break;
                }
                case 83: {
                    this.D(this.E());
                    n2 += 4;
                    break;
                }
                case 84: {
                    this.D(this.H());
                    n2 += 4;
                    break;
                }
                case 85: {
                    this.D(this.L());
                    n2 += 4;
                    break;
                }
                case 86: {
                    this.D(this.peekb(this.HL()));
                    n2 += 7;
                    break;
                }
                case 87: {
                    this.D(this.A());
                    n2 += 4;
                    break;
                }
                case 88: {
                    this.E(this.B());
                    n2 += 4;
                    break;
                }
                case 89: {
                    this.E(this.C());
                    n2 += 4;
                    break;
                }
                case 90: {
                    this.E(this.D());
                    n2 += 4;
                    break;
                }
                case 91: {
                    n2 += 4;
                    break;
                }
                case 92: {
                    this.E(this.H());
                    n2 += 4;
                    break;
                }
                case 93: {
                    this.E(this.L());
                    n2 += 4;
                    break;
                }
                case 94: {
                    this.E(this.peekb(this.HL()));
                    n2 += 7;
                    break;
                }
                case 95: {
                    this.E(this.A());
                    n2 += 4;
                    break;
                }
                case 96: {
                    this.H(this.B());
                    n2 += 4;
                    break;
                }
                case 97: {
                    this.H(this.C());
                    n2 += 4;
                    break;
                }
                case 98: {
                    this.H(this.D());
                    n2 += 4;
                    break;
                }
                case 99: {
                    this.H(this.E());
                    n2 += 4;
                    break;
                }
                case 100: {
                    n2 += 4;
                    break;
                }
                case 101: {
                    this.H(this.L());
                    n2 += 4;
                    break;
                }
                case 102: {
                    this.H(this.peekb(this.HL()));
                    n2 += 7;
                    break;
                }
                case 103: {
                    this.H(this.A());
                    n2 += 4;
                    break;
                }
                case 104: {
                    this.L(this.B());
                    n2 += 4;
                    break;
                }
                case 105: {
                    this.L(this.C());
                    n2 += 4;
                    break;
                }
                case 106: {
                    this.L(this.D());
                    n2 += 4;
                    break;
                }
                case 107: {
                    this.L(this.E());
                    n2 += 4;
                    break;
                }
                case 108: {
                    this.L(this.H());
                    n2 += 4;
                    break;
                }
                case 109: {
                    n2 += 4;
                    break;
                }
                case 110: {
                    this.L(this.peekb(this.HL()));
                    n2 += 7;
                    break;
                }
                case 111: {
                    this.L(this.A());
                    n2 += 4;
                    break;
                }
                case 112: {
                    this.pokeb(this.HL(), this.B());
                    n2 += 7;
                    break;
                }
                case 113: {
                    this.pokeb(this.HL(), this.C());
                    n2 += 7;
                    break;
                }
                case 114: {
                    this.pokeb(this.HL(), this.D());
                    n2 += 7;
                    break;
                }
                case 115: {
                    this.pokeb(this.HL(), this.E());
                    n2 += 7;
                    break;
                }
                case 116: {
                    this.pokeb(this.HL(), this.H());
                    n2 += 7;
                    break;
                }
                case 117: {
                    this.pokeb(this.HL(), this.L());
                    n2 += 7;
                    break;
                }
                case 118: {
                    int n5 = (-n2 - 1) / 4 + 1;
                    n2 += n5 * 4;
                    this.REFRESH(n5 - 1);
                    break;
                }
                case 119: {
                    this.pokeb(this.HL(), this.A());
                    n2 += 7;
                    break;
                }
                case 120: {
                    this.A(this.B());
                    n2 += 4;
                    break;
                }
                case 121: {
                    this.A(this.C());
                    n2 += 4;
                    break;
                }
                case 122: {
                    this.A(this.D());
                    n2 += 4;
                    break;
                }
                case 123: {
                    this.A(this.E());
                    n2 += 4;
                    break;
                }
                case 124: {
                    this.A(this.H());
                    n2 += 4;
                    break;
                }
                case 125: {
                    this.A(this.L());
                    n2 += 4;
                    break;
                }
                case 126: {
                    this.A(this.peekb(this.HL()));
                    n2 += 7;
                    break;
                }
                case 127: {
                    n2 += 4;
                    break;
                }
                case 128: {
                    this.add_a(this.B());
                    n2 += 4;
                    break;
                }
                case 129: {
                    this.add_a(this.C());
                    n2 += 4;
                    break;
                }
                case 130: {
                    this.add_a(this.D());
                    n2 += 4;
                    break;
                }
                case 131: {
                    this.add_a(this.E());
                    n2 += 4;
                    break;
                }
                case 132: {
                    this.add_a(this.H());
                    n2 += 4;
                    break;
                }
                case 133: {
                    this.add_a(this.L());
                    n2 += 4;
                    break;
                }
                case 134: {
                    this.add_a(this.peekb(this.HL()));
                    n2 += 7;
                    break;
                }
                case 135: {
                    this.add_a(this.A());
                    n2 += 4;
                    break;
                }
                case 136: {
                    this.adc_a(this.B());
                    n2 += 4;
                    break;
                }
                case 137: {
                    this.adc_a(this.C());
                    n2 += 4;
                    break;
                }
                case 138: {
                    this.adc_a(this.D());
                    n2 += 4;
                    break;
                }
                case 139: {
                    this.adc_a(this.E());
                    n2 += 4;
                    break;
                }
                case 140: {
                    this.adc_a(this.H());
                    n2 += 4;
                    break;
                }
                case 141: {
                    this.adc_a(this.L());
                    n2 += 4;
                    break;
                }
                case 142: {
                    this.adc_a(this.peekb(this.HL()));
                    n2 += 7;
                    break;
                }
                case 143: {
                    this.adc_a(this.A());
                    n2 += 4;
                    break;
                }
                case 144: {
                    this.sub_a(this.B());
                    n2 += 4;
                    break;
                }
                case 145: {
                    this.sub_a(this.C());
                    n2 += 4;
                    break;
                }
                case 146: {
                    this.sub_a(this.D());
                    n2 += 4;
                    break;
                }
                case 147: {
                    this.sub_a(this.E());
                    n2 += 4;
                    break;
                }
                case 148: {
                    this.sub_a(this.H());
                    n2 += 4;
                    break;
                }
                case 149: {
                    this.sub_a(this.L());
                    n2 += 4;
                    break;
                }
                case 150: {
                    this.sub_a(this.peekb(this.HL()));
                    n2 += 7;
                    break;
                }
                case 151: {
                    this.sub_a(this.A());
                    n2 += 4;
                    break;
                }
                case 152: {
                    this.sbc_a(this.B());
                    n2 += 4;
                    break;
                }
                case 153: {
                    this.sbc_a(this.C());
                    n2 += 4;
                    break;
                }
                case 154: {
                    this.sbc_a(this.D());
                    n2 += 4;
                    break;
                }
                case 155: {
                    this.sbc_a(this.E());
                    n2 += 4;
                    break;
                }
                case 156: {
                    this.sbc_a(this.H());
                    n2 += 4;
                    break;
                }
                case 157: {
                    this.sbc_a(this.L());
                    n2 += 4;
                    break;
                }
                case 158: {
                    this.sbc_a(this.peekb(this.HL()));
                    n2 += 7;
                    break;
                }
                case 159: {
                    this.sbc_a(this.A());
                    n2 += 4;
                    break;
                }
                case 160: {
                    this.and_a(this.B());
                    n2 += 4;
                    break;
                }
                case 161: {
                    this.and_a(this.C());
                    n2 += 4;
                    break;
                }
                case 162: {
                    this.and_a(this.D());
                    n2 += 4;
                    break;
                }
                case 163: {
                    this.and_a(this.E());
                    n2 += 4;
                    break;
                }
                case 164: {
                    this.and_a(this.H());
                    n2 += 4;
                    break;
                }
                case 165: {
                    this.and_a(this.L());
                    n2 += 4;
                    break;
                }
                case 166: {
                    this.and_a(this.peekb(this.HL()));
                    n2 += 7;
                    break;
                }
                case 167: {
                    this.and_a(this.A());
                    n2 += 4;
                    break;
                }
                case 168: {
                    this.xor_a(this.B());
                    n2 += 4;
                    break;
                }
                case 169: {
                    this.xor_a(this.C());
                    n2 += 4;
                    break;
                }
                case 170: {
                    this.xor_a(this.D());
                    n2 += 4;
                    break;
                }
                case 171: {
                    this.xor_a(this.E());
                    n2 += 4;
                    break;
                }
                case 172: {
                    this.xor_a(this.H());
                    n2 += 4;
                    break;
                }
                case 173: {
                    this.xor_a(this.L());
                    n2 += 4;
                    break;
                }
                case 174: {
                    this.xor_a(this.peekb(this.HL()));
                    n2 += 7;
                    break;
                }
                case 175: {
                    this.xor_a(this.A());
                    n2 += 4;
                    break;
                }
                case 176: {
                    this.or_a(this.B());
                    n2 += 4;
                    break;
                }
                case 177: {
                    this.or_a(this.C());
                    n2 += 4;
                    break;
                }
                case 178: {
                    this.or_a(this.D());
                    n2 += 4;
                    break;
                }
                case 179: {
                    this.or_a(this.E());
                    n2 += 4;
                    break;
                }
                case 180: {
                    this.or_a(this.H());
                    n2 += 4;
                    break;
                }
                case 181: {
                    this.or_a(this.L());
                    n2 += 4;
                    break;
                }
                case 182: {
                    this.or_a(this.peekb(this.HL()));
                    n2 += 7;
                    break;
                }
                case 183: {
                    this.or_a(this.A());
                    n2 += 4;
                    break;
                }
                case 184: {
                    this.cp_a(this.B());
                    n2 += 4;
                    break;
                }
                case 185: {
                    this.cp_a(this.C());
                    n2 += 4;
                    break;
                }
                case 186: {
                    this.cp_a(this.D());
                    n2 += 4;
                    break;
                }
                case 187: {
                    this.cp_a(this.E());
                    n2 += 4;
                    break;
                }
                case 188: {
                    this.cp_a(this.H());
                    n2 += 4;
                    break;
                }
                case 189: {
                    this.cp_a(this.L());
                    n2 += 4;
                    break;
                }
                case 190: {
                    this.cp_a(this.peekb(this.HL()));
                    n2 += 7;
                    break;
                }
                case 191: {
                    this.cp_a(this.A());
                    n2 += 4;
                    break;
                }
                case 192: {
                    if (!this.Zset()) {
                        this.poppc();
                        n2 += 11;
                        break;
                    }
                    n2 += 5;
                    break;
                }
                case 200: {
                    if (this.Zset()) {
                        this.poppc();
                        n2 += 11;
                        break;
                    }
                    n2 += 5;
                    break;
                }
                case 208: {
                    if (!this.Cset()) {
                        this.poppc();
                        n2 += 11;
                        break;
                    }
                    n2 += 5;
                    break;
                }
                case 216: {
                    if (this.Cset()) {
                        this.poppc();
                        n2 += 11;
                        break;
                    }
                    n2 += 5;
                    break;
                }
                case 224: {
                    if (!this.PVset()) {
                        this.poppc();
                        n2 += 11;
                        break;
                    }
                    n2 += 5;
                    break;
                }
                case 232: {
                    if (this.PVset()) {
                        this.poppc();
                        n2 += 11;
                        break;
                    }
                    n2 += 5;
                    break;
                }
                case 240: {
                    if (!this.Sset()) {
                        this.poppc();
                        n2 += 11;
                        break;
                    }
                    n2 += 5;
                    break;
                }
                case 248: {
                    if (this.Sset()) {
                        this.poppc();
                        n2 += 11;
                        break;
                    }
                    n2 += 5;
                    break;
                }
                case 193: {
                    this.BC(this.popw());
                    n2 += 10;
                    break;
                }
                case 201: {
                    this.poppc();
                    n2 += 10;
                    break;
                }
                case 209: {
                    this.DE(this.popw());
                    n2 += 10;
                    break;
                }
                case 217: {
                    this.exx();
                    n2 += 4;
                    break;
                }
                case 225: {
                    this.HL(this.popw());
                    n2 += 10;
                    break;
                }
                case 233: {
                    this.PC(this.HL());
                    n2 += 4;
                    break;
                }
                case 241: {
                    this.AF(this.popw());
                    n2 += 10;
                    break;
                }
                case 249: {
                    this.SP(this.HL());
                    n2 += 6;
                    break;
                }
                case 194: {
                    if (!this.Zset()) {
                        this.PC(this.nxtpcw());
                    } else {
                        this.PC(this.PC() + 2 & 0xFFFF);
                    }
                    n2 += 10;
                    break;
                }
                case 202: {
                    if (this.Zset()) {
                        this.PC(this.nxtpcw());
                    } else {
                        this.PC(this.PC() + 2 & 0xFFFF);
                    }
                    n2 += 10;
                    break;
                }
                case 210: {
                    if (!this.Cset()) {
                        this.PC(this.nxtpcw());
                    } else {
                        this.PC(this.PC() + 2 & 0xFFFF);
                    }
                    n2 += 10;
                    break;
                }
                case 218: {
                    if (this.Cset()) {
                        this.PC(this.nxtpcw());
                    } else {
                        this.PC(this.PC() + 2 & 0xFFFF);
                    }
                    n2 += 10;
                    break;
                }
                case 226: {
                    if (!this.PVset()) {
                        this.PC(this.nxtpcw());
                    } else {
                        this.PC(this.PC() + 2 & 0xFFFF);
                    }
                    n2 += 10;
                    break;
                }
                case 234: {
                    if (this.PVset()) {
                        this.PC(this.nxtpcw());
                    } else {
                        this.PC(this.PC() + 2 & 0xFFFF);
                    }
                    n2 += 10;
                    break;
                }
                case 242: {
                    if (!this.Sset()) {
                        this.PC(this.nxtpcw());
                    } else {
                        this.PC(this.PC() + 2 & 0xFFFF);
                    }
                    n2 += 10;
                    break;
                }
                case 250: {
                    if (this.Sset()) {
                        this.PC(this.nxtpcw());
                    } else {
                        this.PC(this.PC() + 2 & 0xFFFF);
                    }
                    n2 += 10;
                    break;
                }
                case 195: {
                    this.PC(this.peekw(this.PC()));
                    n2 += 10;
                    break;
                }
                case 203: {
                    n2 += this.execute_cb();
                    break;
                }
                case 211: {
                    this.outb(this.nxtpcb(), this.A());
                    n2 += 11;
                    break;
                }
                case 219: {
                    this.A(this.inb(this.A() << 8 | this.nxtpcb()));
                    n2 += 11;
                    break;
                }
                case 227: {
                    int n5 = this.HL();
                    int n4 = this.SP();
                    this.HL(this.peekw(n4));
                    this.pokew(n4, n5);
                    n2 += 19;
                    break;
                }
                case 235: {
                    int n5 = this.HL();
                    this.HL(this.DE());
                    this.DE(n5);
                    n2 += 4;
                    break;
                }
                case 243: {
                    this.IFF1(false);
                    this.IFF2(false);
                    n2 += 4;
                    break;
                }
                case 251: {
                    this.IFF1(true);
                    this.IFF2(true);
                    n2 += 4;
                    break;
                }
                case 196: {
                    int n5;
                    if (!this.Zset()) {
                        n5 = this.nxtpcw();
                        this.pushpc();
                        this.PC(n5);
                        n2 += 17;
                        break;
                    }
                    this.PC(this.PC() + 2 & 0xFFFF);
                    n2 += 10;
                    break;
                }
                case 204: {
                    int n5;
                    if (this.Zset()) {
                        n5 = this.nxtpcw();
                        this.pushpc();
                        this.PC(n5);
                        n2 += 17;
                        break;
                    }
                    this.PC(this.PC() + 2 & 0xFFFF);
                    n2 += 10;
                    break;
                }
                case 212: {
                    int n5;
                    if (!this.Cset()) {
                        n5 = this.nxtpcw();
                        this.pushpc();
                        this.PC(n5);
                        n2 += 17;
                        break;
                    }
                    this.PC(this.PC() + 2 & 0xFFFF);
                    n2 += 10;
                    break;
                }
                case 220: {
                    int n5;
                    if (this.Cset()) {
                        n5 = this.nxtpcw();
                        this.pushpc();
                        this.PC(n5);
                        n2 += 17;
                        break;
                    }
                    this.PC(this.PC() + 2 & 0xFFFF);
                    n2 += 10;
                    break;
                }
                case 228: {
                    int n5;
                    if (!this.PVset()) {
                        n5 = this.nxtpcw();
                        this.pushpc();
                        this.PC(n5);
                        n2 += 17;
                        break;
                    }
                    this.PC(this.PC() + 2 & 0xFFFF);
                    n2 += 10;
                    break;
                }
                case 236: {
                    int n5;
                    if (this.PVset()) {
                        n5 = this.nxtpcw();
                        this.pushpc();
                        this.PC(n5);
                        n2 += 17;
                        break;
                    }
                    this.PC(this.PC() + 2 & 0xFFFF);
                    n2 += 10;
                    break;
                }
                case 244: {
                    int n5;
                    if (!this.Sset()) {
                        n5 = this.nxtpcw();
                        this.pushpc();
                        this.PC(n5);
                        n2 += 17;
                        break;
                    }
                    this.PC(this.PC() + 2 & 0xFFFF);
                    n2 += 10;
                    break;
                }
                case 252: {
                    int n5;
                    if (this.Sset()) {
                        n5 = this.nxtpcw();
                        this.pushpc();
                        this.PC(n5);
                        n2 += 17;
                        break;
                    }
                    this.PC(this.PC() + 2 & 0xFFFF);
                    n2 += 10;
                    break;
                }
                case 197: {
                    this.pushw(this.BC());
                    n2 += 11;
                    break;
                }
                case 205: {
                    int n5 = this.nxtpcw();
                    this.pushpc();
                    this.PC(n5);
                    n2 += 17;
                    break;
                }
                case 213: {
                    this.pushw(this.DE());
                    n2 += 11;
                    break;
                }
                case 221: {
                    this.ID(this.IX());
                    n2 += this.execute_id();
                    this.IX(this.ID());
                    break;
                }
                case 229: {
                    this.pushw(this.HL());
                    n2 += 11;
                    break;
                }
                case 237: {
                    n2 += this.execute_ed(n2);
                    break;
                }
                case 245: {
                    this.pushw(this.AF());
                    n2 += 11;
                    break;
                }
                case 253: {
                    this.ID(this.IY());
                    n2 += this.execute_id();
                    this.IY(this.ID());
                    break;
                }
                case 198: {
                    this.add_a(this.nxtpcb());
                    n2 += 7;
                    break;
                }
                case 206: {
                    this.adc_a(this.nxtpcb());
                    n2 += 7;
                    break;
                }
                case 214: {
                    this.sub_a(this.nxtpcb());
                    n2 += 7;
                    break;
                }
                case 222: {
                    this.sbc_a(this.nxtpcb());
                    n2 += 7;
                    break;
                }
                case 230: {
                    this.and_a(this.nxtpcb());
                    n2 += 7;
                    break;
                }
                case 238: {
                    this.xor_a(this.nxtpcb());
                    n2 += 7;
                    break;
                }
                case 246: {
                    this.or_a(this.nxtpcb());
                    n2 += 7;
                    break;
                }
                case 254: {
                    this.cp_a(this.nxtpcb());
                    n2 += 7;
                    break;
                }
                case 199: {
                    this.pushpc();
                    this.PC(0);
                    n2 += 11;
                    break;
                }
                case 207: {
                    this.pushpc();
                    this.PC(8);
                    n2 += 11;
                    break;
                }
                case 215: {
                    this.pushpc();
                    this.PC(16);
                    n2 += 11;
                    break;
                }
                case 223: {
                    this.pushpc();
                    this.PC(24);
                    n2 += 11;
                    break;
                }
                case 231: {
                    this.pushpc();
                    this.PC(32);
                    n2 += 11;
                    break;
                }
                case 239: {
                    this.pushpc();
                    this.PC(40);
                    n2 += 11;
                    break;
                }
                case 247: {
                    this.pushpc();
                    this.PC(48);
                    n2 += 11;
                    break;
                }
                case 255: {
                    this.pushpc();
                    this.PC(56);
                    n2 += 11;
                }
            }
            this.cycles += n2;
            n2 = 0;
        }
        this.cycles -= n;
    }

    private final int execute_ed(int n) {
        this.REFRESH(1);
        switch (this.nxtpcb()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 180: 
            case 181: 
            case 182: 
            case 183: {
                return 8;
            }
            case 64: {
                this.B(this.in_bc());
                return 12;
            }
            case 72: {
                this.C(this.in_bc());
                return 12;
            }
            case 80: {
                this.D(this.in_bc());
                return 12;
            }
            case 88: {
                this.E(this.in_bc());
                return 12;
            }
            case 96: {
                this.H(this.in_bc());
                return 12;
            }
            case 104: {
                this.L(this.in_bc());
                return 12;
            }
            case 112: {
                this.in_bc();
                return 12;
            }
            case 120: {
                this.A(this.in_bc());
                return 12;
            }
            case 65: {
                this.outb(this.BC(), this.B());
                return 12;
            }
            case 73: {
                this.outb(this.BC(), this.C());
                return 12;
            }
            case 81: {
                this.outb(this.BC(), this.D());
                return 12;
            }
            case 89: {
                this.outb(this.BC(), this.E());
                return 12;
            }
            case 97: {
                this.outb(this.BC(), this.H());
                return 12;
            }
            case 105: {
                this.outb(this.BC(), this.L());
                return 12;
            }
            case 113: {
                this.outb(this.BC(), 0);
                return 12;
            }
            case 121: {
                this.outb(this.BC(), this.A());
                return 12;
            }
            case 66: {
                this.HL(this.sbc16(this.HL(), this.BC()));
                return 15;
            }
            case 74: {
                this.HL(this.adc16(this.HL(), this.BC()));
                return 15;
            }
            case 82: {
                this.HL(this.sbc16(this.HL(), this.DE()));
                return 15;
            }
            case 90: {
                this.HL(this.adc16(this.HL(), this.DE()));
                return 15;
            }
            case 98: {
                int n2 = this.HL();
                this.HL(this.sbc16(n2, n2));
                return 15;
            }
            case 106: {
                int n3 = this.HL();
                this.HL(this.adc16(n3, n3));
                return 15;
            }
            case 114: {
                this.HL(this.sbc16(this.HL(), this.SP()));
                return 15;
            }
            case 122: {
                this.HL(this.adc16(this.HL(), this.SP()));
                return 15;
            }
            case 67: {
                this.pokew(this.nxtpcw(), this.BC());
                return 20;
            }
            case 75: {
                this.BC(this.peekw(this.nxtpcw()));
                return 20;
            }
            case 83: {
                this.pokew(this.nxtpcw(), this.DE());
                return 20;
            }
            case 91: {
                this.DE(this.peekw(this.nxtpcw()));
                return 20;
            }
            case 99: {
                this.pokew(this.nxtpcw(), this.HL());
                return 20;
            }
            case 107: {
                this.HL(this.peekw(this.nxtpcw()));
                return 20;
            }
            case 115: {
                this.pokew(this.nxtpcw(), this.SP());
                return 20;
            }
            case 123: {
                this.SP(this.peekw(this.nxtpcw()));
                return 20;
            }
            case 68: 
            case 76: 
            case 84: 
            case 92: 
            case 100: 
            case 108: 
            case 116: 
            case 124: {
                this.neg_a();
                return 8;
            }
            case 69: 
            case 85: 
            case 101: 
            case 117: {
                this.IFF1(this.IFF2());
                this.poppc();
                return 14;
            }
            case 77: 
            case 93: 
            case 109: 
            case 125: {
                this.poppc();
                return 14;
            }
            case 70: 
            case 78: 
            case 102: 
            case 110: {
                this.IM(0);
                return 8;
            }
            case 86: 
            case 118: {
                this.IM(1);
                return 8;
            }
            case 94: 
            case 126: {
                this.IM(2);
                return 8;
            }
            case 71: {
                this.I(this.A());
                return 9;
            }
            case 79: {
                this.R(this.A());
                return 9;
            }
            case 87: {
                this.ld_a_i();
                return 9;
            }
            case 95: {
                this.ld_a_r();
                return 9;
            }
            case 103: {
                this.rrd_a();
                return 18;
            }
            case 111: {
                this.rld_a();
                return 18;
            }
            case 160: {
                this.pokeb(this.DE(), this.peekb(this.HL()));
                this.DE(Z80.inc16(this.DE()));
                this.HL(Z80.inc16(this.HL()));
                this.BC(Z80.dec16(this.BC()));
                this.setPV(this.BC() != 0);
                this.setH(false);
                this.setN(false);
                return 16;
            }
            case 161: {
                boolean bl = this.Cset();
                this.cp_a(this.peekb(this.HL()));
                this.HL(Z80.inc16(this.HL()));
                this.BC(Z80.dec16(this.BC()));
                this.setPV(this.BC() != 0);
                this.setC(bl);
                return 16;
            }
            case 162: {
                this.pokeb(this.HL(), this.inb(this.BC()));
                int n4 = Z80.qdec8(this.B());
                this.B(n4);
                this.HL(Z80.inc16(this.HL()));
                this.setZ(n4 == 0);
                this.setN(true);
                return 16;
            }
            case 163: {
                int n5 = Z80.qdec8(this.B());
                this.B(n5);
                this.outb(this.BC(), this.peekb(this.HL()));
                this.HL(Z80.inc16(this.HL()));
                this.setZ(n5 == 0);
                this.setN(true);
                return 16;
            }
            case 168: {
                this.pokeb(this.DE(), this.peekb(this.HL()));
                this.DE(Z80.dec16(this.DE()));
                this.HL(Z80.dec16(this.HL()));
                this.BC(Z80.dec16(this.BC()));
                this.setPV(this.BC() != 0);
                this.setH(false);
                this.setN(false);
                return 16;
            }
            case 169: {
                boolean bl = this.Cset();
                this.cp_a(this.peekb(this.HL()));
                this.HL(Z80.dec16(this.HL()));
                this.BC(Z80.dec16(this.BC()));
                this.setPV(this.BC() != 0);
                this.setC(bl);
                return 16;
            }
            case 170: {
                this.pokeb(this.HL(), this.inb(this.BC()));
                int n6 = Z80.qdec8(this.B());
                this.B(n6);
                this.HL(Z80.dec16(this.HL()));
                this.setZ(n6 == 0);
                this.setN(true);
                return 16;
            }
            case 171: {
                int n7 = Z80.qdec8(this.B());
                this.B(n7);
                this.outb(this.BC(), this.peekb(this.HL()));
                this.HL(Z80.dec16(this.HL()));
                this.setZ(n7 == 0);
                this.setN(true);
                return 16;
            }
            case 176: {
                int n8 = 0;
                int n9 = this.BC();
                int n10 = this.DE();
                int n11 = this.HL();
                this.REFRESH(-2);
                do {
                    this.pokeb(n10, this.peekb(n11));
                    n11 = Z80.inc16(n11);
                    n10 = Z80.inc16(n10);
                    n9 = Z80.dec16(n9);
                    this.REFRESH(2);
                } while (!Z80.interruptTriggered(n8 += 21) && n9 != 0);
                if (n9 != 0) {
                    this.PC(this.PC() - 2 & 0xFFFF);
                    this.setH(false);
                    this.setN(false);
                    this.setPV(true);
                } else {
                    n8 -= 5;
                    this.setH(false);
                    this.setN(false);
                    this.setPV(false);
                }
                this.DE(n10);
                this.HL(n11);
                this.BC(n9);
                return n8;
            }
            case 177: {
                boolean bl = this.Cset();
                this.cp_a(this.peekb(this.HL()));
                this.HL(Z80.inc16(this.HL()));
                this.BC(Z80.dec16(this.BC()));
                boolean bl2 = this.BC() != 0;
                this.setPV(bl2);
                this.setC(bl);
                if (bl2 && !this.Zset()) {
                    this.PC(this.PC() - 2 & 0xFFFF);
                    return 21;
                }
                return 16;
            }
            case 178: {
                this.pokeb(this.HL(), this.inb(this.BC()));
                int n12 = Z80.qdec8(this.B());
                this.B(n12);
                this.HL(Z80.inc16(this.HL()));
                this.setZ(true);
                this.setN(true);
                if (n12 != 0) {
                    this.PC(this.PC() - 2 & 0xFFFF);
                    return 21;
                }
                return 16;
            }
            case 179: {
                int n13 = Z80.qdec8(this.B());
                this.B(n13);
                this.outb(this.BC(), this.peekb(this.HL()));
                this.HL(Z80.inc16(this.HL()));
                this.setZ(true);
                this.setN(true);
                if (n13 != 0) {
                    this.PC(this.PC() - 2 & 0xFFFF);
                    return 21;
                }
                return 16;
            }
            case 184: {
                int n14 = 0;
                int n15 = this.BC();
                int n16 = this.DE();
                int n17 = this.HL();
                this.REFRESH(-2);
                do {
                    this.pokeb(n16, this.peekb(n17));
                    n17 = Z80.dec16(n17);
                    n16 = Z80.dec16(n16);
                    n15 = Z80.dec16(n15);
                    this.REFRESH(2);
                } while (!Z80.interruptTriggered(n14 += 21) && n15 != 0);
                if (n15 != 0) {
                    this.PC(this.PC() - 2 & 0xFFFF);
                    this.setH(false);
                    this.setN(false);
                    this.setPV(true);
                } else {
                    n14 -= 5;
                    this.setH(false);
                    this.setN(false);
                    this.setPV(false);
                }
                this.DE(n16);
                this.HL(n17);
                this.BC(n15);
                return n14;
            }
            case 185: {
                boolean bl = this.Cset();
                this.cp_a(this.peekb(this.HL()));
                this.HL(Z80.dec16(this.HL()));
                this.BC(Z80.dec16(this.BC()));
                boolean bl3 = this.BC() != 0;
                this.setPV(bl3);
                this.setC(bl);
                if (bl3 && !this.Zset()) {
                    this.PC(this.PC() - 2 & 0xFFFF);
                    return 21;
                }
                return 16;
            }
            case 186: {
                this.pokeb(this.HL(), this.inb(this.BC()));
                int n18 = Z80.qdec8(this.B());
                this.B(n18);
                this.HL(Z80.dec16(this.HL()));
                this.setZ(true);
                this.setN(true);
                if (n18 != 0) {
                    this.PC(this.PC() - 2 & 0xFFFF);
                    return 21;
                }
                return 16;
            }
            case 187: {
                int n19 = Z80.qdec8(this.B());
                this.B(n19);
                this.outb(this.BC(), this.peekb(this.HL()));
                this.HL(Z80.dec16(this.HL()));
                this.setZ(true);
                this.setN(true);
                if (n19 != 0) {
                    this.PC(this.PC() - 2 & 0xFFFF);
                    return 21;
                }
                return 16;
            }
        }
        return 8;
    }

    private final int execute_cb() {
        this.REFRESH(1);
        switch (this.nxtpcb()) {
            case 0: {
                this.B(this.rlc(this.B()));
                return 8;
            }
            case 1: {
                this.C(this.rlc(this.C()));
                return 8;
            }
            case 2: {
                this.D(this.rlc(this.D()));
                return 8;
            }
            case 3: {
                this.E(this.rlc(this.E()));
                return 8;
            }
            case 4: {
                this.H(this.rlc(this.H()));
                return 8;
            }
            case 5: {
                this.L(this.rlc(this.L()));
                return 8;
            }
            case 6: {
                int n = this.HL();
                this.pokeb(n, this.rlc(this.peekb(n)));
                return 15;
            }
            case 7: {
                this.A(this.rlc(this.A()));
                return 8;
            }
            case 8: {
                this.B(this.rrc(this.B()));
                return 8;
            }
            case 9: {
                this.C(this.rrc(this.C()));
                return 8;
            }
            case 10: {
                this.D(this.rrc(this.D()));
                return 8;
            }
            case 11: {
                this.E(this.rrc(this.E()));
                return 8;
            }
            case 12: {
                this.H(this.rrc(this.H()));
                return 8;
            }
            case 13: {
                this.L(this.rrc(this.L()));
                return 8;
            }
            case 14: {
                int n = this.HL();
                this.pokeb(n, this.rrc(this.peekb(n)));
                return 15;
            }
            case 15: {
                this.A(this.rrc(this.A()));
                return 8;
            }
            case 16: {
                this.B(this.rl(this.B()));
                return 8;
            }
            case 17: {
                this.C(this.rl(this.C()));
                return 8;
            }
            case 18: {
                this.D(this.rl(this.D()));
                return 8;
            }
            case 19: {
                this.E(this.rl(this.E()));
                return 8;
            }
            case 20: {
                this.H(this.rl(this.H()));
                return 8;
            }
            case 21: {
                this.L(this.rl(this.L()));
                return 8;
            }
            case 22: {
                int n = this.HL();
                this.pokeb(n, this.rl(this.peekb(n)));
                return 15;
            }
            case 23: {
                this.A(this.rl(this.A()));
                return 8;
            }
            case 24: {
                this.B(this.rr(this.B()));
                return 8;
            }
            case 25: {
                this.C(this.rr(this.C()));
                return 8;
            }
            case 26: {
                this.D(this.rr(this.D()));
                return 8;
            }
            case 27: {
                this.E(this.rr(this.E()));
                return 8;
            }
            case 28: {
                this.H(this.rr(this.H()));
                return 8;
            }
            case 29: {
                this.L(this.rr(this.L()));
                return 8;
            }
            case 30: {
                int n = this.HL();
                this.pokeb(n, this.rr(this.peekb(n)));
                return 15;
            }
            case 31: {
                this.A(this.rr(this.A()));
                return 8;
            }
            case 32: {
                this.B(this.sla(this.B()));
                return 8;
            }
            case 33: {
                this.C(this.sla(this.C()));
                return 8;
            }
            case 34: {
                this.D(this.sla(this.D()));
                return 8;
            }
            case 35: {
                this.E(this.sla(this.E()));
                return 8;
            }
            case 36: {
                this.H(this.sla(this.H()));
                return 8;
            }
            case 37: {
                this.L(this.sla(this.L()));
                return 8;
            }
            case 38: {
                int n = this.HL();
                this.pokeb(n, this.sla(this.peekb(n)));
                return 15;
            }
            case 39: {
                this.A(this.sla(this.A()));
                return 8;
            }
            case 40: {
                this.B(this.sra(this.B()));
                return 8;
            }
            case 41: {
                this.C(this.sra(this.C()));
                return 8;
            }
            case 42: {
                this.D(this.sra(this.D()));
                return 8;
            }
            case 43: {
                this.E(this.sra(this.E()));
                return 8;
            }
            case 44: {
                this.H(this.sra(this.H()));
                return 8;
            }
            case 45: {
                this.L(this.sra(this.L()));
                return 8;
            }
            case 46: {
                int n = this.HL();
                this.pokeb(n, this.sra(this.peekb(n)));
                return 15;
            }
            case 47: {
                this.A(this.sra(this.A()));
                return 8;
            }
            case 48: {
                this.B(this.sls(this.B()));
                return 8;
            }
            case 49: {
                this.C(this.sls(this.C()));
                return 8;
            }
            case 50: {
                this.D(this.sls(this.D()));
                return 8;
            }
            case 51: {
                this.E(this.sls(this.E()));
                return 8;
            }
            case 52: {
                this.H(this.sls(this.H()));
                return 8;
            }
            case 53: {
                this.L(this.sls(this.L()));
                return 8;
            }
            case 54: {
                int n = this.HL();
                this.pokeb(n, this.sls(this.peekb(n)));
                return 15;
            }
            case 55: {
                this.A(this.sls(this.A()));
                return 8;
            }
            case 56: {
                this.B(this.srl(this.B()));
                return 8;
            }
            case 57: {
                this.C(this.srl(this.C()));
                return 8;
            }
            case 58: {
                this.D(this.srl(this.D()));
                return 8;
            }
            case 59: {
                this.E(this.srl(this.E()));
                return 8;
            }
            case 60: {
                this.H(this.srl(this.H()));
                return 8;
            }
            case 61: {
                this.L(this.srl(this.L()));
                return 8;
            }
            case 62: {
                int n = this.HL();
                this.pokeb(n, this.srl(this.peekb(n)));
                return 15;
            }
            case 63: {
                this.A(this.srl(this.A()));
                return 8;
            }
            case 64: {
                this.bit(1, this.B());
                return 8;
            }
            case 65: {
                this.bit(1, this.C());
                return 8;
            }
            case 66: {
                this.bit(1, this.D());
                return 8;
            }
            case 67: {
                this.bit(1, this.E());
                return 8;
            }
            case 68: {
                this.bit(1, this.H());
                return 8;
            }
            case 69: {
                this.bit(1, this.L());
                return 8;
            }
            case 70: {
                this.bit(1, this.peekb(this.HL()));
                return 12;
            }
            case 71: {
                this.bit(1, this.A());
                return 8;
            }
            case 72: {
                this.bit(2, this.B());
                return 8;
            }
            case 73: {
                this.bit(2, this.C());
                return 8;
            }
            case 74: {
                this.bit(2, this.D());
                return 8;
            }
            case 75: {
                this.bit(2, this.E());
                return 8;
            }
            case 76: {
                this.bit(2, this.H());
                return 8;
            }
            case 77: {
                this.bit(2, this.L());
                return 8;
            }
            case 78: {
                this.bit(2, this.peekb(this.HL()));
                return 12;
            }
            case 79: {
                this.bit(2, this.A());
                return 8;
            }
            case 80: {
                this.bit(4, this.B());
                return 8;
            }
            case 81: {
                this.bit(4, this.C());
                return 8;
            }
            case 82: {
                this.bit(4, this.D());
                return 8;
            }
            case 83: {
                this.bit(4, this.E());
                return 8;
            }
            case 84: {
                this.bit(4, this.H());
                return 8;
            }
            case 85: {
                this.bit(4, this.L());
                return 8;
            }
            case 86: {
                this.bit(4, this.peekb(this.HL()));
                return 12;
            }
            case 87: {
                this.bit(4, this.A());
                return 8;
            }
            case 88: {
                this.bit(8, this.B());
                return 8;
            }
            case 89: {
                this.bit(8, this.C());
                return 8;
            }
            case 90: {
                this.bit(8, this.D());
                return 8;
            }
            case 91: {
                this.bit(8, this.E());
                return 8;
            }
            case 92: {
                this.bit(8, this.H());
                return 8;
            }
            case 93: {
                this.bit(8, this.L());
                return 8;
            }
            case 94: {
                this.bit(8, this.peekb(this.HL()));
                return 12;
            }
            case 95: {
                this.bit(8, this.A());
                return 8;
            }
            case 96: {
                this.bit(16, this.B());
                return 8;
            }
            case 97: {
                this.bit(16, this.C());
                return 8;
            }
            case 98: {
                this.bit(16, this.D());
                return 8;
            }
            case 99: {
                this.bit(16, this.E());
                return 8;
            }
            case 100: {
                this.bit(16, this.H());
                return 8;
            }
            case 101: {
                this.bit(16, this.L());
                return 8;
            }
            case 102: {
                this.bit(16, this.peekb(this.HL()));
                return 12;
            }
            case 103: {
                this.bit(16, this.A());
                return 8;
            }
            case 104: {
                this.bit(32, this.B());
                return 8;
            }
            case 105: {
                this.bit(32, this.C());
                return 8;
            }
            case 106: {
                this.bit(32, this.D());
                return 8;
            }
            case 107: {
                this.bit(32, this.E());
                return 8;
            }
            case 108: {
                this.bit(32, this.H());
                return 8;
            }
            case 109: {
                this.bit(32, this.L());
                return 8;
            }
            case 110: {
                this.bit(32, this.peekb(this.HL()));
                return 12;
            }
            case 111: {
                this.bit(32, this.A());
                return 8;
            }
            case 112: {
                this.bit(64, this.B());
                return 8;
            }
            case 113: {
                this.bit(64, this.C());
                return 8;
            }
            case 114: {
                this.bit(64, this.D());
                return 8;
            }
            case 115: {
                this.bit(64, this.E());
                return 8;
            }
            case 116: {
                this.bit(64, this.H());
                return 8;
            }
            case 117: {
                this.bit(64, this.L());
                return 8;
            }
            case 118: {
                this.bit(64, this.peekb(this.HL()));
                return 12;
            }
            case 119: {
                this.bit(64, this.A());
                return 8;
            }
            case 120: {
                this.bit(128, this.B());
                return 8;
            }
            case 121: {
                this.bit(128, this.C());
                return 8;
            }
            case 122: {
                this.bit(128, this.D());
                return 8;
            }
            case 123: {
                this.bit(128, this.E());
                return 8;
            }
            case 124: {
                this.bit(128, this.H());
                return 8;
            }
            case 125: {
                this.bit(128, this.L());
                return 8;
            }
            case 126: {
                this.bit(128, this.peekb(this.HL()));
                return 12;
            }
            case 127: {
                this.bit(128, this.A());
                return 8;
            }
            case 128: {
                this.B(Z80.res(1, this.B()));
                return 8;
            }
            case 129: {
                this.C(Z80.res(1, this.C()));
                return 8;
            }
            case 130: {
                this.D(Z80.res(1, this.D()));
                return 8;
            }
            case 131: {
                this.E(Z80.res(1, this.E()));
                return 8;
            }
            case 132: {
                this.H(Z80.res(1, this.H()));
                return 8;
            }
            case 133: {
                this.L(Z80.res(1, this.L()));
                return 8;
            }
            case 134: {
                int n = this.HL();
                this.pokeb(n, Z80.res(1, this.peekb(n)));
                return 15;
            }
            case 135: {
                this.A(Z80.res(1, this.A()));
                return 8;
            }
            case 136: {
                this.B(Z80.res(2, this.B()));
                return 8;
            }
            case 137: {
                this.C(Z80.res(2, this.C()));
                return 8;
            }
            case 138: {
                this.D(Z80.res(2, this.D()));
                return 8;
            }
            case 139: {
                this.E(Z80.res(2, this.E()));
                return 8;
            }
            case 140: {
                this.H(Z80.res(2, this.H()));
                return 8;
            }
            case 141: {
                this.L(Z80.res(2, this.L()));
                return 8;
            }
            case 142: {
                int n = this.HL();
                this.pokeb(n, Z80.res(2, this.peekb(n)));
                return 15;
            }
            case 143: {
                this.A(Z80.res(2, this.A()));
                return 8;
            }
            case 144: {
                this.B(Z80.res(4, this.B()));
                return 8;
            }
            case 145: {
                this.C(Z80.res(4, this.C()));
                return 8;
            }
            case 146: {
                this.D(Z80.res(4, this.D()));
                return 8;
            }
            case 147: {
                this.E(Z80.res(4, this.E()));
                return 8;
            }
            case 148: {
                this.H(Z80.res(4, this.H()));
                return 8;
            }
            case 149: {
                this.L(Z80.res(4, this.L()));
                return 8;
            }
            case 150: {
                int n = this.HL();
                this.pokeb(n, Z80.res(4, this.peekb(n)));
                return 15;
            }
            case 151: {
                this.A(Z80.res(4, this.A()));
                return 8;
            }
            case 152: {
                this.B(Z80.res(8, this.B()));
                return 8;
            }
            case 153: {
                this.C(Z80.res(8, this.C()));
                return 8;
            }
            case 154: {
                this.D(Z80.res(8, this.D()));
                return 8;
            }
            case 155: {
                this.E(Z80.res(8, this.E()));
                return 8;
            }
            case 156: {
                this.H(Z80.res(8, this.H()));
                return 8;
            }
            case 157: {
                this.L(Z80.res(8, this.L()));
                return 8;
            }
            case 158: {
                int n = this.HL();
                this.pokeb(n, Z80.res(8, this.peekb(n)));
                return 15;
            }
            case 159: {
                this.A(Z80.res(8, this.A()));
                return 8;
            }
            case 160: {
                this.B(Z80.res(16, this.B()));
                return 8;
            }
            case 161: {
                this.C(Z80.res(16, this.C()));
                return 8;
            }
            case 162: {
                this.D(Z80.res(16, this.D()));
                return 8;
            }
            case 163: {
                this.E(Z80.res(16, this.E()));
                return 8;
            }
            case 164: {
                this.H(Z80.res(16, this.H()));
                return 8;
            }
            case 165: {
                this.L(Z80.res(16, this.L()));
                return 8;
            }
            case 166: {
                int n = this.HL();
                this.pokeb(n, Z80.res(16, this.peekb(n)));
                return 15;
            }
            case 167: {
                this.A(Z80.res(16, this.A()));
                return 8;
            }
            case 168: {
                this.B(Z80.res(32, this.B()));
                return 8;
            }
            case 169: {
                this.C(Z80.res(32, this.C()));
                return 8;
            }
            case 170: {
                this.D(Z80.res(32, this.D()));
                return 8;
            }
            case 171: {
                this.E(Z80.res(32, this.E()));
                return 8;
            }
            case 172: {
                this.H(Z80.res(32, this.H()));
                return 8;
            }
            case 173: {
                this.L(Z80.res(32, this.L()));
                return 8;
            }
            case 174: {
                int n = this.HL();
                this.pokeb(n, Z80.res(32, this.peekb(n)));
                return 15;
            }
            case 175: {
                this.A(Z80.res(32, this.A()));
                return 8;
            }
            case 176: {
                this.B(Z80.res(64, this.B()));
                return 8;
            }
            case 177: {
                this.C(Z80.res(64, this.C()));
                return 8;
            }
            case 178: {
                this.D(Z80.res(64, this.D()));
                return 8;
            }
            case 179: {
                this.E(Z80.res(64, this.E()));
                return 8;
            }
            case 180: {
                this.H(Z80.res(64, this.H()));
                return 8;
            }
            case 181: {
                this.L(Z80.res(64, this.L()));
                return 8;
            }
            case 182: {
                int n = this.HL();
                this.pokeb(n, Z80.res(64, this.peekb(n)));
                return 15;
            }
            case 183: {
                this.A(Z80.res(64, this.A()));
                return 8;
            }
            case 184: {
                this.B(Z80.res(128, this.B()));
                return 8;
            }
            case 185: {
                this.C(Z80.res(128, this.C()));
                return 8;
            }
            case 186: {
                this.D(Z80.res(128, this.D()));
                return 8;
            }
            case 187: {
                this.E(Z80.res(128, this.E()));
                return 8;
            }
            case 188: {
                this.H(Z80.res(128, this.H()));
                return 8;
            }
            case 189: {
                this.L(Z80.res(128, this.L()));
                return 8;
            }
            case 190: {
                int n = this.HL();
                this.pokeb(n, Z80.res(128, this.peekb(n)));
                return 15;
            }
            case 191: {
                this.A(Z80.res(128, this.A()));
                return 8;
            }
            case 192: {
                this.B(Z80.set(1, this.B()));
                return 8;
            }
            case 193: {
                this.C(Z80.set(1, this.C()));
                return 8;
            }
            case 194: {
                this.D(Z80.set(1, this.D()));
                return 8;
            }
            case 195: {
                this.E(Z80.set(1, this.E()));
                return 8;
            }
            case 196: {
                this.H(Z80.set(1, this.H()));
                return 8;
            }
            case 197: {
                this.L(Z80.set(1, this.L()));
                return 8;
            }
            case 198: {
                int n = this.HL();
                this.pokeb(n, Z80.set(1, this.peekb(n)));
                return 15;
            }
            case 199: {
                this.A(Z80.set(1, this.A()));
                return 8;
            }
            case 200: {
                this.B(Z80.set(2, this.B()));
                return 8;
            }
            case 201: {
                this.C(Z80.set(2, this.C()));
                return 8;
            }
            case 202: {
                this.D(Z80.set(2, this.D()));
                return 8;
            }
            case 203: {
                this.E(Z80.set(2, this.E()));
                return 8;
            }
            case 204: {
                this.H(Z80.set(2, this.H()));
                return 8;
            }
            case 205: {
                this.L(Z80.set(2, this.L()));
                return 8;
            }
            case 206: {
                int n = this.HL();
                this.pokeb(n, Z80.set(2, this.peekb(n)));
                return 15;
            }
            case 207: {
                this.A(Z80.set(2, this.A()));
                return 8;
            }
            case 208: {
                this.B(Z80.set(4, this.B()));
                return 8;
            }
            case 209: {
                this.C(Z80.set(4, this.C()));
                return 8;
            }
            case 210: {
                this.D(Z80.set(4, this.D()));
                return 8;
            }
            case 211: {
                this.E(Z80.set(4, this.E()));
                return 8;
            }
            case 212: {
                this.H(Z80.set(4, this.H()));
                return 8;
            }
            case 213: {
                this.L(Z80.set(4, this.L()));
                return 8;
            }
            case 214: {
                int n = this.HL();
                this.pokeb(n, Z80.set(4, this.peekb(n)));
                return 15;
            }
            case 215: {
                this.A(Z80.set(4, this.A()));
                return 8;
            }
            case 216: {
                this.B(Z80.set(8, this.B()));
                return 8;
            }
            case 217: {
                this.C(Z80.set(8, this.C()));
                return 8;
            }
            case 218: {
                this.D(Z80.set(8, this.D()));
                return 8;
            }
            case 219: {
                this.E(Z80.set(8, this.E()));
                return 8;
            }
            case 220: {
                this.H(Z80.set(8, this.H()));
                return 8;
            }
            case 221: {
                this.L(Z80.set(8, this.L()));
                return 8;
            }
            case 222: {
                int n = this.HL();
                this.pokeb(n, Z80.set(8, this.peekb(n)));
                return 15;
            }
            case 223: {
                this.A(Z80.set(8, this.A()));
                return 8;
            }
            case 224: {
                this.B(Z80.set(16, this.B()));
                return 8;
            }
            case 225: {
                this.C(Z80.set(16, this.C()));
                return 8;
            }
            case 226: {
                this.D(Z80.set(16, this.D()));
                return 8;
            }
            case 227: {
                this.E(Z80.set(16, this.E()));
                return 8;
            }
            case 228: {
                this.H(Z80.set(16, this.H()));
                return 8;
            }
            case 229: {
                this.L(Z80.set(16, this.L()));
                return 8;
            }
            case 230: {
                int n = this.HL();
                this.pokeb(n, Z80.set(16, this.peekb(n)));
                return 15;
            }
            case 231: {
                this.A(Z80.set(16, this.A()));
                return 8;
            }
            case 232: {
                this.B(Z80.set(32, this.B()));
                return 8;
            }
            case 233: {
                this.C(Z80.set(32, this.C()));
                return 8;
            }
            case 234: {
                this.D(Z80.set(32, this.D()));
                return 8;
            }
            case 235: {
                this.E(Z80.set(32, this.E()));
                return 8;
            }
            case 236: {
                this.H(Z80.set(32, this.H()));
                return 8;
            }
            case 237: {
                this.L(Z80.set(32, this.L()));
                return 8;
            }
            case 238: {
                int n = this.HL();
                this.pokeb(n, Z80.set(32, this.peekb(n)));
                return 15;
            }
            case 239: {
                this.A(Z80.set(32, this.A()));
                return 8;
            }
            case 240: {
                this.B(Z80.set(64, this.B()));
                return 8;
            }
            case 241: {
                this.C(Z80.set(64, this.C()));
                return 8;
            }
            case 242: {
                this.D(Z80.set(64, this.D()));
                return 8;
            }
            case 243: {
                this.E(Z80.set(64, this.E()));
                return 8;
            }
            case 244: {
                this.H(Z80.set(64, this.H()));
                return 8;
            }
            case 245: {
                this.L(Z80.set(64, this.L()));
                return 8;
            }
            case 246: {
                int n = this.HL();
                this.pokeb(n, Z80.set(64, this.peekb(n)));
                return 15;
            }
            case 247: {
                this.A(Z80.set(64, this.A()));
                return 8;
            }
            case 248: {
                this.B(Z80.set(128, this.B()));
                return 8;
            }
            case 249: {
                this.C(Z80.set(128, this.C()));
                return 8;
            }
            case 250: {
                this.D(Z80.set(128, this.D()));
                return 8;
            }
            case 251: {
                this.E(Z80.set(128, this.E()));
                return 8;
            }
            case 252: {
                this.H(Z80.set(128, this.H()));
                return 8;
            }
            case 253: {
                this.L(Z80.set(128, this.L()));
                return 8;
            }
            case 254: {
                int n = this.HL();
                this.pokeb(n, Z80.set(128, this.peekb(n)));
                return 15;
            }
            case 255: {
                this.A(Z80.set(128, this.A()));
                return 8;
            }
        }
        return 0;
    }

    private final int execute_id() {
        this.REFRESH(1);
        switch (this.nxtpcb()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 39: 
            case 40: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 55: 
            case 56: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 95: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 167: 
            case 168: 
            case 169: 
            case 170: 
            case 171: 
            case 175: 
            case 176: 
            case 177: 
            case 178: 
            case 179: 
            case 183: 
            case 184: 
            case 185: 
            case 186: 
            case 187: 
            case 191: 
            case 192: 
            case 193: 
            case 194: 
            case 195: 
            case 196: 
            case 197: 
            case 198: 
            case 199: 
            case 200: 
            case 201: 
            case 202: 
            case 204: 
            case 205: 
            case 206: 
            case 207: 
            case 208: 
            case 209: 
            case 210: 
            case 211: 
            case 212: 
            case 213: 
            case 214: 
            case 215: 
            case 216: 
            case 217: 
            case 218: 
            case 219: 
            case 220: 
            case 221: 
            case 222: 
            case 223: 
            case 224: 
            case 226: 
            case 228: 
            case 230: 
            case 231: 
            case 232: 
            case 234: 
            case 235: 
            case 236: 
            case 237: 
            case 238: 
            case 239: 
            case 240: 
            case 241: 
            case 242: 
            case 243: 
            case 244: 
            case 245: 
            case 246: 
            case 247: 
            case 248: {
                this.PC(Z80.dec16(this.PC()));
                this.REFRESH(-1);
                return 4;
            }
            case 9: {
                this.ID(this.add16(this.ID(), this.BC()));
                return 15;
            }
            case 25: {
                this.ID(this.add16(this.ID(), this.DE()));
                return 15;
            }
            case 41: {
                int n = this.ID();
                this.ID(this.add16(n, n));
                return 15;
            }
            case 57: {
                this.ID(this.add16(this.ID(), this.SP()));
                return 15;
            }
            case 33: {
                this.ID(this.nxtpcw());
                return 14;
            }
            case 34: {
                this.pokew(this.nxtpcw(), this.ID());
                return 20;
            }
            case 42: {
                this.ID(this.peekw(this.nxtpcw()));
                return 20;
            }
            case 35: {
                this.ID(Z80.inc16(this.ID()));
                return 10;
            }
            case 43: {
                this.ID(Z80.dec16(this.ID()));
                return 10;
            }
            case 36: {
                this.IDH(this.inc8(this.IDH()));
                return 8;
            }
            case 44: {
                this.IDL(this.inc8(this.IDL()));
                return 8;
            }
            case 52: {
                int n = this.ID_d();
                this.pokeb(n, this.inc8(this.peekb(n)));
                return 23;
            }
            case 37: {
                this.IDH(this.dec8(this.IDH()));
                return 8;
            }
            case 45: {
                this.IDL(this.dec8(this.IDL()));
                return 8;
            }
            case 53: {
                int n = this.ID_d();
                this.pokeb(n, this.dec8(this.peekb(n)));
                return 23;
            }
            case 38: {
                this.IDH(this.nxtpcb());
                return 11;
            }
            case 46: {
                this.IDL(this.nxtpcb());
                return 11;
            }
            case 54: {
                int n = this.ID_d();
                this.pokeb(n, this.nxtpcb());
                return 19;
            }
            case 68: {
                this.B(this.IDH());
                return 8;
            }
            case 69: {
                this.B(this.IDL());
                return 8;
            }
            case 70: {
                this.B(this.peekb(this.ID_d()));
                return 19;
            }
            case 76: {
                this.C(this.IDH());
                return 8;
            }
            case 77: {
                this.C(this.IDL());
                return 8;
            }
            case 78: {
                this.C(this.peekb(this.ID_d()));
                return 19;
            }
            case 84: {
                this.D(this.IDH());
                return 8;
            }
            case 85: {
                this.D(this.IDL());
                return 8;
            }
            case 86: {
                this.D(this.peekb(this.ID_d()));
                return 19;
            }
            case 92: {
                this.E(this.IDH());
                return 8;
            }
            case 93: {
                this.E(this.IDL());
                return 8;
            }
            case 94: {
                this.E(this.peekb(this.ID_d()));
                return 19;
            }
            case 96: {
                this.IDH(this.B());
                return 8;
            }
            case 97: {
                this.IDH(this.C());
                return 8;
            }
            case 98: {
                this.IDH(this.D());
                return 8;
            }
            case 99: {
                this.IDH(this.E());
                return 8;
            }
            case 100: {
                return 8;
            }
            case 101: {
                this.IDH(this.IDL());
                return 8;
            }
            case 102: {
                this.H(this.peekb(this.ID_d()));
                return 19;
            }
            case 103: {
                this.IDH(this.A());
                return 8;
            }
            case 104: {
                this.IDL(this.B());
                return 8;
            }
            case 105: {
                this.IDL(this.C());
                return 8;
            }
            case 106: {
                this.IDL(this.D());
                return 8;
            }
            case 107: {
                this.IDL(this.E());
                return 8;
            }
            case 108: {
                this.IDL(this.IDH());
                return 8;
            }
            case 109: {
                return 8;
            }
            case 110: {
                this.L(this.peekb(this.ID_d()));
                return 19;
            }
            case 111: {
                this.IDL(this.A());
                return 8;
            }
            case 112: {
                this.pokeb(this.ID_d(), this.B());
                return 19;
            }
            case 113: {
                this.pokeb(this.ID_d(), this.C());
                return 19;
            }
            case 114: {
                this.pokeb(this.ID_d(), this.D());
                return 19;
            }
            case 115: {
                this.pokeb(this.ID_d(), this.E());
                return 19;
            }
            case 116: {
                this.pokeb(this.ID_d(), this.H());
                return 19;
            }
            case 117: {
                this.pokeb(this.ID_d(), this.L());
                return 19;
            }
            case 119: {
                this.pokeb(this.ID_d(), this.A());
                return 19;
            }
            case 124: {
                this.A(this.IDH());
                return 8;
            }
            case 125: {
                this.A(this.IDL());
                return 8;
            }
            case 126: {
                this.A(this.peekb(this.ID_d()));
                return 19;
            }
            case 132: {
                this.add_a(this.IDH());
                return 8;
            }
            case 133: {
                this.add_a(this.IDL());
                return 8;
            }
            case 134: {
                this.add_a(this.peekb(this.ID_d()));
                return 19;
            }
            case 140: {
                this.adc_a(this.IDH());
                return 8;
            }
            case 141: {
                this.adc_a(this.IDL());
                return 8;
            }
            case 142: {
                this.adc_a(this.peekb(this.ID_d()));
                return 19;
            }
            case 148: {
                this.sub_a(this.IDH());
                return 8;
            }
            case 149: {
                this.sub_a(this.IDL());
                return 8;
            }
            case 150: {
                this.sub_a(this.peekb(this.ID_d()));
                return 19;
            }
            case 156: {
                this.sbc_a(this.IDH());
                return 8;
            }
            case 157: {
                this.sbc_a(this.IDL());
                return 8;
            }
            case 158: {
                this.sbc_a(this.peekb(this.ID_d()));
                return 19;
            }
            case 164: {
                this.and_a(this.IDH());
                return 8;
            }
            case 165: {
                this.and_a(this.IDL());
                return 8;
            }
            case 166: {
                this.and_a(this.peekb(this.ID_d()));
                return 19;
            }
            case 172: {
                this.xor_a(this.IDH());
                return 8;
            }
            case 173: {
                this.xor_a(this.IDL());
                return 8;
            }
            case 174: {
                this.xor_a(this.peekb(this.ID_d()));
                return 19;
            }
            case 180: {
                this.or_a(this.IDH());
                return 8;
            }
            case 181: {
                this.or_a(this.IDL());
                return 8;
            }
            case 182: {
                this.or_a(this.peekb(this.ID_d()));
                return 19;
            }
            case 188: {
                this.cp_a(this.IDH());
                return 8;
            }
            case 189: {
                this.cp_a(this.IDL());
                return 8;
            }
            case 190: {
                this.cp_a(this.peekb(this.ID_d()));
                return 19;
            }
            case 225: {
                this.ID(this.popw());
                return 14;
            }
            case 233: {
                this.PC(this.ID());
                return 8;
            }
            case 249: {
                this.SP(this.ID());
                return 10;
            }
            case 203: {
                int n = this.ID_d();
                int n2 = this.nxtpcb();
                this.execute_id_cb(n2, n);
                return (n2 & 0xC0) == 64 ? 20 : 23;
            }
            case 227: {
                int n = this.ID();
                int n3 = this.SP();
                this.ID(this.peekw(n3));
                this.pokew(n3, n);
                return 23;
            }
            case 229: {
                this.pushw(this.ID());
                return 15;
            }
        }
        return 0;
    }

    private final void execute_id_cb(int n, int n2) {
        switch (n) {
            case 0: {
                n = this.rlc(this.peekb(n2));
                this.B(n);
                this.pokeb(n2, n);
                return;
            }
            case 1: {
                n = this.rlc(this.peekb(n2));
                this.C(n);
                this.pokeb(n2, n);
                return;
            }
            case 2: {
                n = this.rlc(this.peekb(n2));
                this.D(n);
                this.pokeb(n2, n);
                return;
            }
            case 3: {
                n = this.rlc(this.peekb(n2));
                this.E(n);
                this.pokeb(n2, n);
                return;
            }
            case 4: {
                n = this.rlc(this.peekb(n2));
                this.H(n);
                this.pokeb(n2, n);
                return;
            }
            case 5: {
                n = this.rlc(this.peekb(n2));
                this.L(n);
                this.pokeb(n2, n);
                return;
            }
            case 6: {
                this.pokeb(n2, this.rlc(this.peekb(n2)));
                return;
            }
            case 7: {
                n = this.rlc(this.peekb(n2));
                this.A(n);
                this.pokeb(n2, n);
                return;
            }
            case 8: {
                n = this.rrc(this.peekb(n2));
                this.B(n);
                this.pokeb(n2, n);
                return;
            }
            case 9: {
                n = this.rrc(this.peekb(n2));
                this.C(n);
                this.pokeb(n2, n);
                return;
            }
            case 10: {
                n = this.rrc(this.peekb(n2));
                this.D(n);
                this.pokeb(n2, n);
                return;
            }
            case 11: {
                n = this.rrc(this.peekb(n2));
                this.E(n);
                this.pokeb(n2, n);
                return;
            }
            case 12: {
                n = this.rrc(this.peekb(n2));
                this.H(n);
                this.pokeb(n2, n);
                return;
            }
            case 13: {
                n = this.rrc(this.peekb(n2));
                this.L(n);
                this.pokeb(n2, n);
                return;
            }
            case 14: {
                this.pokeb(n2, this.rrc(this.peekb(n2)));
                return;
            }
            case 15: {
                n = this.rrc(this.peekb(n2));
                this.A(n);
                this.pokeb(n2, n);
                return;
            }
            case 16: {
                n = this.rl(this.peekb(n2));
                this.B(n);
                this.pokeb(n2, n);
                return;
            }
            case 17: {
                n = this.rl(this.peekb(n2));
                this.C(n);
                this.pokeb(n2, n);
                return;
            }
            case 18: {
                n = this.rl(this.peekb(n2));
                this.D(n);
                this.pokeb(n2, n);
                return;
            }
            case 19: {
                n = this.rl(this.peekb(n2));
                this.E(n);
                this.pokeb(n2, n);
                return;
            }
            case 20: {
                n = this.rl(this.peekb(n2));
                this.H(n);
                this.pokeb(n2, n);
                return;
            }
            case 21: {
                n = this.rl(this.peekb(n2));
                this.L(n);
                this.pokeb(n2, n);
                return;
            }
            case 22: {
                this.pokeb(n2, this.rl(this.peekb(n2)));
                return;
            }
            case 23: {
                n = this.rl(this.peekb(n2));
                this.A(n);
                this.pokeb(n2, n);
                return;
            }
            case 24: {
                n = this.rr(this.peekb(n2));
                this.B(n);
                this.pokeb(n2, n);
                return;
            }
            case 25: {
                n = this.rr(this.peekb(n2));
                this.C(n);
                this.pokeb(n2, n);
                return;
            }
            case 26: {
                n = this.rr(this.peekb(n2));
                this.D(n);
                this.pokeb(n2, n);
                return;
            }
            case 27: {
                n = this.rr(this.peekb(n2));
                this.E(n);
                this.pokeb(n2, n);
                return;
            }
            case 28: {
                n = this.rr(this.peekb(n2));
                this.H(n);
                this.pokeb(n2, n);
                return;
            }
            case 29: {
                n = this.rr(this.peekb(n2));
                this.L(n);
                this.pokeb(n2, n);
                return;
            }
            case 30: {
                this.pokeb(n2, this.rr(this.peekb(n2)));
                return;
            }
            case 31: {
                n = this.rr(this.peekb(n2));
                this.A(n);
                this.pokeb(n2, n);
                return;
            }
            case 32: {
                n = this.sla(this.peekb(n2));
                this.B(n);
                this.pokeb(n2, n);
                return;
            }
            case 33: {
                n = this.sla(this.peekb(n2));
                this.C(n);
                this.pokeb(n2, n);
                return;
            }
            case 34: {
                n = this.sla(this.peekb(n2));
                this.D(n);
                this.pokeb(n2, n);
                return;
            }
            case 35: {
                n = this.sla(this.peekb(n2));
                this.E(n);
                this.pokeb(n2, n);
                return;
            }
            case 36: {
                n = this.sla(this.peekb(n2));
                this.H(n);
                this.pokeb(n2, n);
                return;
            }
            case 37: {
                n = this.sla(this.peekb(n2));
                this.L(n);
                this.pokeb(n2, n);
                return;
            }
            case 38: {
                this.pokeb(n2, this.sla(this.peekb(n2)));
                return;
            }
            case 39: {
                n = this.sla(this.peekb(n2));
                this.A(n);
                this.pokeb(n2, n);
                return;
            }
            case 40: {
                n = this.sra(this.peekb(n2));
                this.B(n);
                this.pokeb(n2, n);
                return;
            }
            case 41: {
                n = this.sra(this.peekb(n2));
                this.C(n);
                this.pokeb(n2, n);
                return;
            }
            case 42: {
                n = this.sra(this.peekb(n2));
                this.D(n);
                this.pokeb(n2, n);
                return;
            }
            case 43: {
                n = this.sra(this.peekb(n2));
                this.E(n);
                this.pokeb(n2, n);
                return;
            }
            case 44: {
                n = this.sra(this.peekb(n2));
                this.H(n);
                this.pokeb(n2, n);
                return;
            }
            case 45: {
                n = this.sra(this.peekb(n2));
                this.L(n);
                this.pokeb(n2, n);
                return;
            }
            case 46: {
                this.pokeb(n2, this.sra(this.peekb(n2)));
                return;
            }
            case 47: {
                n = this.sra(this.peekb(n2));
                this.A(n);
                this.pokeb(n2, n);
                return;
            }
            case 48: {
                n = this.sls(this.peekb(n2));
                this.B(n);
                this.pokeb(n2, n);
                return;
            }
            case 49: {
                n = this.sls(this.peekb(n2));
                this.C(n);
                this.pokeb(n2, n);
                return;
            }
            case 50: {
                n = this.sls(this.peekb(n2));
                this.D(n);
                this.pokeb(n2, n);
                return;
            }
            case 51: {
                n = this.sls(this.peekb(n2));
                this.E(n);
                this.pokeb(n2, n);
                return;
            }
            case 52: {
                n = this.sls(this.peekb(n2));
                this.H(n);
                this.pokeb(n2, n);
                return;
            }
            case 53: {
                n = this.sls(this.peekb(n2));
                this.L(n);
                this.pokeb(n2, n);
                return;
            }
            case 54: {
                this.pokeb(n2, this.sls(this.peekb(n2)));
                return;
            }
            case 55: {
                n = this.sls(this.peekb(n2));
                this.A(n);
                this.pokeb(n2, n);
                return;
            }
            case 56: {
                n = this.srl(this.peekb(n2));
                this.B(n);
                this.pokeb(n2, n);
                return;
            }
            case 57: {
                n = this.srl(this.peekb(n2));
                this.C(n);
                this.pokeb(n2, n);
                return;
            }
            case 58: {
                n = this.srl(this.peekb(n2));
                this.D(n);
                this.pokeb(n2, n);
                return;
            }
            case 59: {
                n = this.srl(this.peekb(n2));
                this.E(n);
                this.pokeb(n2, n);
                return;
            }
            case 60: {
                n = this.srl(this.peekb(n2));
                this.H(n);
                this.pokeb(n2, n);
                return;
            }
            case 61: {
                n = this.srl(this.peekb(n2));
                this.L(n);
                this.pokeb(n2, n);
                return;
            }
            case 62: {
                this.pokeb(n2, this.srl(this.peekb(n2)));
                return;
            }
            case 63: {
                n = this.srl(this.peekb(n2));
                this.A(n);
                this.pokeb(n2, n);
                return;
            }
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: {
                this.bit(1, this.peekb(n2));
                return;
            }
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: {
                this.bit(2, this.peekb(n2));
                return;
            }
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: {
                this.bit(4, this.peekb(n2));
                return;
            }
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: {
                this.bit(8, this.peekb(n2));
                return;
            }
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: {
                this.bit(16, this.peekb(n2));
                return;
            }
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: {
                this.bit(32, this.peekb(n2));
                return;
            }
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: {
                this.bit(64, this.peekb(n2));
                return;
            }
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: {
                this.bit(128, this.peekb(n2));
                return;
            }
            case 128: {
                n = Z80.res(1, this.peekb(n2));
                this.B(n);
                this.pokeb(n2, n);
                return;
            }
            case 129: {
                n = Z80.res(1, this.peekb(n2));
                this.C(n);
                this.pokeb(n2, n);
                return;
            }
            case 130: {
                n = Z80.res(1, this.peekb(n2));
                this.D(n);
                this.pokeb(n2, n);
                return;
            }
            case 131: {
                n = Z80.res(1, this.peekb(n2));
                this.E(n);
                this.pokeb(n2, n);
                return;
            }
            case 132: {
                n = Z80.res(1, this.peekb(n2));
                this.H(n);
                this.pokeb(n2, n);
                return;
            }
            case 133: {
                n = Z80.res(1, this.peekb(n2));
                this.L(n);
                this.pokeb(n2, n);
                return;
            }
            case 134: {
                this.pokeb(n2, Z80.res(1, this.peekb(n2)));
                return;
            }
            case 135: {
                n = Z80.res(1, this.peekb(n2));
                this.A(n);
                this.pokeb(n2, n);
                return;
            }
            case 136: {
                n = Z80.res(2, this.peekb(n2));
                this.B(n);
                this.pokeb(n2, n);
                return;
            }
            case 137: {
                n = Z80.res(2, this.peekb(n2));
                this.C(n);
                this.pokeb(n2, n);
                return;
            }
            case 138: {
                n = Z80.res(2, this.peekb(n2));
                this.D(n);
                this.pokeb(n2, n);
                return;
            }
            case 139: {
                n = Z80.res(2, this.peekb(n2));
                this.E(n);
                this.pokeb(n2, n);
                return;
            }
            case 140: {
                n = Z80.res(2, this.peekb(n2));
                this.H(n);
                this.pokeb(n2, n);
                return;
            }
            case 141: {
                n = Z80.res(2, this.peekb(n2));
                this.L(n);
                this.pokeb(n2, n);
                return;
            }
            case 142: {
                this.pokeb(n2, Z80.res(2, this.peekb(n2)));
                return;
            }
            case 143: {
                n = Z80.res(2, this.peekb(n2));
                this.A(n);
                this.pokeb(n2, n);
                return;
            }
            case 144: {
                n = Z80.res(4, this.peekb(n2));
                this.B(n);
                this.pokeb(n2, n);
                return;
            }
            case 145: {
                n = Z80.res(4, this.peekb(n2));
                this.C(n);
                this.pokeb(n2, n);
                return;
            }
            case 146: {
                n = Z80.res(4, this.peekb(n2));
                this.D(n);
                this.pokeb(n2, n);
                return;
            }
            case 147: {
                n = Z80.res(4, this.peekb(n2));
                this.E(n);
                this.pokeb(n2, n);
                return;
            }
            case 148: {
                n = Z80.res(4, this.peekb(n2));
                this.H(n);
                this.pokeb(n2, n);
                return;
            }
            case 149: {
                n = Z80.res(4, this.peekb(n2));
                this.L(n);
                this.pokeb(n2, n);
                return;
            }
            case 150: {
                this.pokeb(n2, Z80.res(4, this.peekb(n2)));
                return;
            }
            case 151: {
                n = Z80.res(4, this.peekb(n2));
                this.A(n);
                this.pokeb(n2, n);
                return;
            }
            case 152: {
                n = Z80.res(8, this.peekb(n2));
                this.B(n);
                this.pokeb(n2, n);
                return;
            }
            case 153: {
                n = Z80.res(8, this.peekb(n2));
                this.C(n);
                this.pokeb(n2, n);
                return;
            }
            case 154: {
                n = Z80.res(8, this.peekb(n2));
                this.D(n);
                this.pokeb(n2, n);
                return;
            }
            case 155: {
                n = Z80.res(8, this.peekb(n2));
                this.E(n);
                this.pokeb(n2, n);
                return;
            }
            case 156: {
                n = Z80.res(8, this.peekb(n2));
                this.H(n);
                this.pokeb(n2, n);
                return;
            }
            case 157: {
                n = Z80.res(8, this.peekb(n2));
                this.L(n);
                this.pokeb(n2, n);
                return;
            }
            case 158: {
                this.pokeb(n2, Z80.res(8, this.peekb(n2)));
                return;
            }
            case 159: {
                n = Z80.res(8, this.peekb(n2));
                this.A(n);
                this.pokeb(n2, n);
                return;
            }
            case 160: {
                n = Z80.res(16, this.peekb(n2));
                this.B(n);
                this.pokeb(n2, n);
                return;
            }
            case 161: {
                n = Z80.res(16, this.peekb(n2));
                this.C(n);
                this.pokeb(n2, n);
                return;
            }
            case 162: {
                n = Z80.res(16, this.peekb(n2));
                this.D(n);
                this.pokeb(n2, n);
                return;
            }
            case 163: {
                n = Z80.res(16, this.peekb(n2));
                this.E(n);
                this.pokeb(n2, n);
                return;
            }
            case 164: {
                n = Z80.res(16, this.peekb(n2));
                this.H(n);
                this.pokeb(n2, n);
                return;
            }
            case 165: {
                n = Z80.res(16, this.peekb(n2));
                this.L(n);
                this.pokeb(n2, n);
                return;
            }
            case 166: {
                this.pokeb(n2, Z80.res(16, this.peekb(n2)));
                return;
            }
            case 167: {
                n = Z80.res(16, this.peekb(n2));
                this.A(n);
                this.pokeb(n2, n);
                return;
            }
            case 168: {
                n = Z80.res(32, this.peekb(n2));
                this.B(n);
                this.pokeb(n2, n);
                return;
            }
            case 169: {
                n = Z80.res(32, this.peekb(n2));
                this.C(n);
                this.pokeb(n2, n);
                return;
            }
            case 170: {
                n = Z80.res(32, this.peekb(n2));
                this.D(n);
                this.pokeb(n2, n);
                return;
            }
            case 171: {
                n = Z80.res(32, this.peekb(n2));
                this.E(n);
                this.pokeb(n2, n);
                return;
            }
            case 172: {
                n = Z80.res(32, this.peekb(n2));
                this.H(n);
                this.pokeb(n2, n);
                return;
            }
            case 173: {
                n = Z80.res(32, this.peekb(n2));
                this.L(n);
                this.pokeb(n2, n);
                return;
            }
            case 174: {
                this.pokeb(n2, Z80.res(32, this.peekb(n2)));
                return;
            }
            case 175: {
                n = Z80.res(32, this.peekb(n2));
                this.A(n);
                this.pokeb(n2, n);
                return;
            }
            case 176: {
                n = Z80.res(64, this.peekb(n2));
                this.B(n);
                this.pokeb(n2, n);
                return;
            }
            case 177: {
                n = Z80.res(64, this.peekb(n2));
                this.C(n);
                this.pokeb(n2, n);
                return;
            }
            case 178: {
                n = Z80.res(64, this.peekb(n2));
                this.D(n);
                this.pokeb(n2, n);
                return;
            }
            case 179: {
                n = Z80.res(64, this.peekb(n2));
                this.E(n);
                this.pokeb(n2, n);
                return;
            }
            case 180: {
                n = Z80.res(64, this.peekb(n2));
                this.H(n);
                this.pokeb(n2, n);
                return;
            }
            case 181: {
                n = Z80.res(64, this.peekb(n2));
                this.L(n);
                this.pokeb(n2, n);
                return;
            }
            case 182: {
                this.pokeb(n2, Z80.res(64, this.peekb(n2)));
                return;
            }
            case 183: {
                n = Z80.res(64, this.peekb(n2));
                this.A(n);
                this.pokeb(n2, n);
                return;
            }
            case 184: {
                n = Z80.res(128, this.peekb(n2));
                this.B(n);
                this.pokeb(n2, n);
                return;
            }
            case 185: {
                n = Z80.res(128, this.peekb(n2));
                this.C(n);
                this.pokeb(n2, n);
                return;
            }
            case 186: {
                n = Z80.res(128, this.peekb(n2));
                this.D(n);
                this.pokeb(n2, n);
                return;
            }
            case 187: {
                n = Z80.res(128, this.peekb(n2));
                this.E(n);
                this.pokeb(n2, n);
                return;
            }
            case 188: {
                n = Z80.res(128, this.peekb(n2));
                this.H(n);
                this.pokeb(n2, n);
                return;
            }
            case 189: {
                n = Z80.res(128, this.peekb(n2));
                this.L(n);
                this.pokeb(n2, n);
                return;
            }
            case 190: {
                this.pokeb(n2, Z80.res(128, this.peekb(n2)));
                return;
            }
            case 191: {
                n = Z80.res(128, this.peekb(n2));
                this.A(n);
                this.pokeb(n2, n);
                return;
            }
            case 192: {
                n = Z80.set(1, this.peekb(n2));
                this.B(n);
                this.pokeb(n2, n);
                return;
            }
            case 193: {
                n = Z80.set(1, this.peekb(n2));
                this.C(n);
                this.pokeb(n2, n);
                return;
            }
            case 194: {
                n = Z80.set(1, this.peekb(n2));
                this.D(n);
                this.pokeb(n2, n);
                return;
            }
            case 195: {
                n = Z80.set(1, this.peekb(n2));
                this.E(n);
                this.pokeb(n2, n);
                return;
            }
            case 196: {
                n = Z80.set(1, this.peekb(n2));
                this.H(n);
                this.pokeb(n2, n);
                return;
            }
            case 197: {
                n = Z80.set(1, this.peekb(n2));
                this.L(n);
                this.pokeb(n2, n);
                return;
            }
            case 198: {
                this.pokeb(n2, Z80.set(1, this.peekb(n2)));
                return;
            }
            case 199: {
                n = Z80.set(1, this.peekb(n2));
                this.A(n);
                this.pokeb(n2, n);
                return;
            }
            case 200: {
                n = Z80.set(2, this.peekb(n2));
                this.B(n);
                this.pokeb(n2, n);
                return;
            }
            case 201: {
                n = Z80.set(2, this.peekb(n2));
                this.C(n);
                this.pokeb(n2, n);
                return;
            }
            case 202: {
                n = Z80.set(2, this.peekb(n2));
                this.D(n);
                this.pokeb(n2, n);
                return;
            }
            case 203: {
                n = Z80.set(2, this.peekb(n2));
                this.E(n);
                this.pokeb(n2, n);
                return;
            }
            case 204: {
                n = Z80.set(2, this.peekb(n2));
                this.H(n);
                this.pokeb(n2, n);
                return;
            }
            case 205: {
                n = Z80.set(2, this.peekb(n2));
                this.L(n);
                this.pokeb(n2, n);
                return;
            }
            case 206: {
                this.pokeb(n2, Z80.set(2, this.peekb(n2)));
                return;
            }
            case 207: {
                n = Z80.set(2, this.peekb(n2));
                this.A(n);
                this.pokeb(n2, n);
                return;
            }
            case 208: {
                n = Z80.set(4, this.peekb(n2));
                this.B(n);
                this.pokeb(n2, n);
                return;
            }
            case 209: {
                n = Z80.set(4, this.peekb(n2));
                this.C(n);
                this.pokeb(n2, n);
                return;
            }
            case 210: {
                n = Z80.set(4, this.peekb(n2));
                this.D(n);
                this.pokeb(n2, n);
                return;
            }
            case 211: {
                n = Z80.set(4, this.peekb(n2));
                this.E(n);
                this.pokeb(n2, n);
                return;
            }
            case 212: {
                n = Z80.set(4, this.peekb(n2));
                this.H(n);
                this.pokeb(n2, n);
                return;
            }
            case 213: {
                n = Z80.set(4, this.peekb(n2));
                this.L(n);
                this.pokeb(n2, n);
                return;
            }
            case 214: {
                this.pokeb(n2, Z80.set(4, this.peekb(n2)));
                return;
            }
            case 215: {
                n = Z80.set(4, this.peekb(n2));
                this.A(n);
                this.pokeb(n2, n);
                return;
            }
            case 216: {
                n = Z80.set(8, this.peekb(n2));
                this.B(n);
                this.pokeb(n2, n);
                return;
            }
            case 217: {
                n = Z80.set(8, this.peekb(n2));
                this.C(n);
                this.pokeb(n2, n);
                return;
            }
            case 218: {
                n = Z80.set(8, this.peekb(n2));
                this.D(n);
                this.pokeb(n2, n);
                return;
            }
            case 219: {
                n = Z80.set(8, this.peekb(n2));
                this.E(n);
                this.pokeb(n2, n);
                return;
            }
            case 220: {
                n = Z80.set(8, this.peekb(n2));
                this.H(n);
                this.pokeb(n2, n);
                return;
            }
            case 221: {
                n = Z80.set(8, this.peekb(n2));
                this.L(n);
                this.pokeb(n2, n);
                return;
            }
            case 222: {
                this.pokeb(n2, Z80.set(8, this.peekb(n2)));
                return;
            }
            case 223: {
                n = Z80.set(8, this.peekb(n2));
                this.A(n);
                this.pokeb(n2, n);
                return;
            }
            case 224: {
                n = Z80.set(16, this.peekb(n2));
                this.B(n);
                this.pokeb(n2, n);
                return;
            }
            case 225: {
                n = Z80.set(16, this.peekb(n2));
                this.C(n);
                this.pokeb(n2, n);
                return;
            }
            case 226: {
                n = Z80.set(16, this.peekb(n2));
                this.D(n);
                this.pokeb(n2, n);
                return;
            }
            case 227: {
                n = Z80.set(16, this.peekb(n2));
                this.E(n);
                this.pokeb(n2, n);
                return;
            }
            case 228: {
                n = Z80.set(16, this.peekb(n2));
                this.H(n);
                this.pokeb(n2, n);
                return;
            }
            case 229: {
                n = Z80.set(16, this.peekb(n2));
                this.L(n);
                this.pokeb(n2, n);
                return;
            }
            case 230: {
                this.pokeb(n2, Z80.set(16, this.peekb(n2)));
                return;
            }
            case 231: {
                n = Z80.set(16, this.peekb(n2));
                this.A(n);
                this.pokeb(n2, n);
                return;
            }
            case 232: {
                n = Z80.set(32, this.peekb(n2));
                this.B(n);
                this.pokeb(n2, n);
                return;
            }
            case 233: {
                n = Z80.set(32, this.peekb(n2));
                this.C(n);
                this.pokeb(n2, n);
                return;
            }
            case 234: {
                n = Z80.set(32, this.peekb(n2));
                this.D(n);
                this.pokeb(n2, n);
                return;
            }
            case 235: {
                n = Z80.set(32, this.peekb(n2));
                this.E(n);
                this.pokeb(n2, n);
                return;
            }
            case 236: {
                n = Z80.set(32, this.peekb(n2));
                this.H(n);
                this.pokeb(n2, n);
                return;
            }
            case 237: {
                n = Z80.set(32, this.peekb(n2));
                this.L(n);
                this.pokeb(n2, n);
                return;
            }
            case 238: {
                this.pokeb(n2, Z80.set(32, this.peekb(n2)));
                return;
            }
            case 239: {
                n = Z80.set(32, this.peekb(n2));
                this.A(n);
                this.pokeb(n2, n);
                return;
            }
            case 240: {
                n = Z80.set(64, this.peekb(n2));
                this.B(n);
                this.pokeb(n2, n);
                return;
            }
            case 241: {
                n = Z80.set(64, this.peekb(n2));
                this.C(n);
                this.pokeb(n2, n);
                return;
            }
            case 242: {
                n = Z80.set(64, this.peekb(n2));
                this.D(n);
                this.pokeb(n2, n);
                return;
            }
            case 243: {
                n = Z80.set(64, this.peekb(n2));
                this.E(n);
                this.pokeb(n2, n);
                return;
            }
            case 244: {
                n = Z80.set(64, this.peekb(n2));
                this.H(n);
                this.pokeb(n2, n);
                return;
            }
            case 245: {
                n = Z80.set(64, this.peekb(n2));
                this.L(n);
                this.pokeb(n2, n);
                return;
            }
            case 246: {
                this.pokeb(n2, Z80.set(64, this.peekb(n2)));
                return;
            }
            case 247: {
                n = Z80.set(64, this.peekb(n2));
                this.A(n);
                this.pokeb(n2, n);
                return;
            }
            case 248: {
                n = Z80.set(128, this.peekb(n2));
                this.B(n);
                this.pokeb(n2, n);
                return;
            }
            case 249: {
                n = Z80.set(128, this.peekb(n2));
                this.C(n);
                this.pokeb(n2, n);
                return;
            }
            case 250: {
                n = Z80.set(128, this.peekb(n2));
                this.D(n);
                this.pokeb(n2, n);
                return;
            }
            case 251: {
                n = Z80.set(128, this.peekb(n2));
                this.E(n);
                this.pokeb(n2, n);
                return;
            }
            case 252: {
                n = Z80.set(128, this.peekb(n2));
                this.H(n);
                this.pokeb(n2, n);
                return;
            }
            case 253: {
                n = Z80.set(128, this.peekb(n2));
                this.L(n);
                this.pokeb(n2, n);
                return;
            }
            case 254: {
                this.pokeb(n2, Z80.set(128, this.peekb(n2)));
                return;
            }
            case 255: {
                n = Z80.set(128, this.peekb(n2));
                this.A(n);
                this.pokeb(n2, n);
                return;
            }
        }
    }

    private final int in_bc() {
        int n = this.inb(this.BC());
        this.setZ(n == 0);
        this.setS((n & 0x80) != 0);
        this.set3((n & 8) != 0);
        this.set5((n & 0x20) != 0);
        this.setPV(parity[n]);
        this.setN(false);
        this.setH(false);
        return n;
    }

    private final void adc_a(int n) {
        int n2 = this.A();
        int n3 = this.Cset() ? 1 : 0;
        int n4 = n2 + n + n3;
        int n5 = n4 & 0xFF;
        this.setS((n5 & 0x80) != 0);
        this.set3((n5 & 8) != 0);
        this.set5((n5 & 0x20) != 0);
        this.setZ(n5 == 0);
        this.setC((n4 & 0x100) != 0);
        this.setPV(((n2 ^ ~n) & (n2 ^ n5) & 0x80) != 0);
        this.setH(((n2 & 0xF) + (n & 0xF) + n3 & 0x10) != 0);
        this.setN(false);
        this.A(n5);
    }

    private final void add_a(int n) {
        int n2 = this.A();
        int n3 = n2 + n;
        int n4 = n3 & 0xFF;
        this.setS((n4 & 0x80) != 0);
        this.set3((n4 & 8) != 0);
        this.set5((n4 & 0x20) != 0);
        this.setZ(n4 == 0);
        this.setC((n3 & 0x100) != 0);
        this.setPV(((n2 ^ ~n) & (n2 ^ n4) & 0x80) != 0);
        this.setH(((n2 & 0xF) + (n & 0xF) & 0x10) != 0);
        this.setN(false);
        this.A(n4);
    }

    private final void sbc_a(int n) {
        int n2 = this.A();
        int n3 = this.Cset() ? 1 : 0;
        int n4 = n2 - n - n3;
        int n5 = n4 & 0xFF;
        this.setS((n5 & 0x80) != 0);
        this.set3((n5 & 8) != 0);
        this.set5((n5 & 0x20) != 0);
        this.setZ(n5 == 0);
        this.setC((n4 & 0x100) != 0);
        this.setPV(((n2 ^ n) & (n2 ^ n5) & 0x80) != 0);
        this.setH(((n2 & 0xF) - (n & 0xF) - n3 & 0x10) != 0);
        this.setN(true);
        this.A(n5);
    }

    private final void sub_a(int n) {
        int n2 = this.A();
        int n3 = n2 - n;
        int n4 = n3 & 0xFF;
        this.setS((n4 & 0x80) != 0);
        this.set3((n4 & 8) != 0);
        this.set5((n4 & 0x20) != 0);
        this.setZ(n4 == 0);
        this.setC((n3 & 0x100) != 0);
        this.setPV(((n2 ^ n) & (n2 ^ n4) & 0x80) != 0);
        this.setH(((n2 & 0xF) - (n & 0xF) & 0x10) != 0);
        this.setN(true);
        this.A(n4);
    }

    private final void rlc_a() {
        boolean bl;
        int n = this.A();
        boolean bl2 = bl = (n & 0x80) != 0;
        n = bl ? n << 1 | 1 : (n <<= 1);
        this.set3(((n &= 0xFF) & 8) != 0);
        this.set5((n & 0x20) != 0);
        this.setN(false);
        this.setH(false);
        this.setC(bl);
        this.A(n);
    }

    private final void rrc_a() {
        boolean bl;
        int n = this.A();
        boolean bl2 = bl = (n & 1) != 0;
        n = bl ? n >> 1 | 0x80 : (n >>= 1);
        this.set3((n & 8) != 0);
        this.set5((n & 0x20) != 0);
        this.setN(false);
        this.setH(false);
        this.setC(bl);
        this.A(n);
    }

    private final void rl_a() {
        boolean bl;
        int n = this.A();
        boolean bl2 = bl = (n & 0x80) != 0;
        n = this.Cset() ? n << 1 | 1 : (n <<= 1);
        this.set3(((n &= 0xFF) & 8) != 0);
        this.set5((n & 0x20) != 0);
        this.setN(false);
        this.setH(false);
        this.setC(bl);
        this.A(n);
    }

    private final void rr_a() {
        boolean bl;
        int n = this.A();
        boolean bl2 = bl = (n & 1) != 0;
        n = this.Cset() ? n >> 1 | 0x80 : (n >>= 1);
        this.set3((n & 8) != 0);
        this.set5((n & 0x20) != 0);
        this.setN(false);
        this.setH(false);
        this.setC(bl);
        this.A(n);
    }

    private final void cp_a(int n) {
        int n2 = this.A();
        int n3 = n2 - n;
        int n4 = n3 & 0xFF;
        this.setS((n4 & 0x80) != 0);
        this.set3((n & 8) != 0);
        this.set5((n & 0x20) != 0);
        this.setN(true);
        this.setZ(n4 == 0);
        this.setC((n3 & 0x100) != 0);
        this.setH(((n2 & 0xF) - (n & 0xF) & 0x10) != 0);
        this.setPV(((n2 ^ n) & (n2 ^ n4) & 0x80) != 0);
    }

    private final void and_a(int n) {
        int n2 = this.A() & n;
        this.setS((n2 & 0x80) != 0);
        this.set3((n2 & 8) != 0);
        this.set5((n2 & 0x20) != 0);
        this.setH(true);
        this.setPV(parity[n2]);
        this.setZ(n2 == 0);
        this.setN(false);
        this.setC(false);
        this.A(n2);
    }

    private final void or_a(int n) {
        int n2 = this.A() | n;
        this.setS((n2 & 0x80) != 0);
        this.set3((n2 & 8) != 0);
        this.set5((n2 & 0x20) != 0);
        this.setH(false);
        this.setPV(parity[n2]);
        this.setZ(n2 == 0);
        this.setN(false);
        this.setC(false);
        this.A(n2);
    }

    private final void xor_a(int n) {
        int n2 = (this.A() ^ n) & 0xFF;
        this.setS((n2 & 0x80) != 0);
        this.set3((n2 & 8) != 0);
        this.set5((n2 & 0x20) != 0);
        this.setH(false);
        this.setPV(parity[n2]);
        this.setZ(n2 == 0);
        this.setN(false);
        this.setC(false);
        this.A(n2);
    }

    private final void neg_a() {
        int n = this.A();
        this.A(0);
        this.sub_a(n);
    }

    private final void cpl_a() {
        int n = this.A() ^ 0xFF;
        this.set3((n & 8) != 0);
        this.set5((n & 0x20) != 0);
        this.setH(true);
        this.setN(true);
        this.A(n);
    }

    private final void daa_a() {
        int n = this.A();
        int n2 = 0;
        boolean bl = this.Cset();
        if (this.Hset() || (n & 0xF) > 9) {
            n2 |= 6;
        }
        if (bl || n > 159 || n > 143 && (n & 0xF) > 9) {
            n2 |= 0x60;
        }
        if (n > 153) {
            bl = true;
        }
        if (this.Nset()) {
            this.sub_a(n2);
        } else {
            this.add_a(n2);
        }
        n = this.A();
        this.setC(bl);
        this.setPV(parity[n]);
    }

    private final void ld_a_i() {
        int n = this.I();
        this.setS((n & 0x80) != 0);
        this.set3((n & 8) != 0);
        this.set5((n & 0x20) != 0);
        this.setZ(n == 0);
        this.setPV(this.IFF2());
        this.setH(false);
        this.setN(false);
        this.A(n);
    }

    private final void ld_a_r() {
        int n = this.R();
        this.setS((n & 0x80) != 0);
        this.set3((n & 8) != 0);
        this.set5((n & 0x20) != 0);
        this.setZ(n == 0);
        this.setPV(this.IFF2());
        this.setH(false);
        this.setN(false);
        this.A(n);
    }

    private final void rrd_a() {
        int n;
        int n2 = this.A();
        int n3 = n = this.peekb(this.HL());
        n = n >> 4 | n2 << 4;
        n2 = n2 & 0xF0 | n3 & 0xF;
        this.pokeb(this.HL(), n);
        this.setS((n2 & 0x80) != 0);
        this.set3((n2 & 8) != 0);
        this.set5((n2 & 0x20) != 0);
        this.setZ(n2 == 0);
        this.setPV(this.IFF2());
        this.setH(false);
        this.setN(false);
        this.A(n2);
    }

    private final void rld_a() {
        int n;
        int n2 = this.A();
        int n3 = n = this.peekb(this.HL());
        n = n << 4 | n2 & 0xF;
        n2 = n2 & 0xF0 | n3 >> 4;
        this.pokeb(this.HL(), n & 0xFF);
        this.setS((n2 & 0x80) != 0);
        this.set3((n2 & 8) != 0);
        this.set5((n2 & 0x20) != 0);
        this.setZ(n2 == 0);
        this.setPV(this.IFF2());
        this.setH(false);
        this.setN(false);
        this.A(n2);
    }

    private final void bit(int n, int n2) {
        boolean bl = (n2 & n) != 0;
        this.setN(false);
        this.setH(true);
        this.set3((n2 & 8) != 0);
        this.set5((n2 & 0x20) != 0);
        this.setS(n == 128 ? bl : false);
        this.setZ(!bl);
        this.setPV(!bl);
    }

    private final void scf() {
        int n = this.A();
        this.set3((n & 8) != 0);
        this.set5((n & 0x20) != 0);
        this.setN(false);
        this.setH(false);
        this.setC(true);
    }

    private final void ccf() {
        int n = this.A();
        this.set3((n & 8) != 0);
        this.set5((n & 0x20) != 0);
        this.setN(false);
        this.setC(!this.Cset());
    }

    private final int rlc(int n) {
        boolean bl;
        boolean bl2 = bl = (n & 0x80) != 0;
        n = bl ? n << 1 | 1 : (n <<= 1);
        this.setS(((n &= 0xFF) & 0x80) != 0);
        this.set3((n & 8) != 0);
        this.set5((n & 0x20) != 0);
        this.setZ(n == 0);
        this.setPV(parity[n]);
        this.setH(false);
        this.setN(false);
        this.setC(bl);
        return n;
    }

    private final int rrc(int n) {
        boolean bl;
        boolean bl2 = bl = (n & 1) != 0;
        n = bl ? n >> 1 | 0x80 : (n >>= 1);
        this.setS((n & 0x80) != 0);
        this.set3((n & 8) != 0);
        this.set5((n & 0x20) != 0);
        this.setZ(n == 0);
        this.setPV(parity[n]);
        this.setH(false);
        this.setN(false);
        this.setC(bl);
        return n;
    }

    private final int rl(int n) {
        boolean bl;
        boolean bl2 = bl = (n & 0x80) != 0;
        n = this.Cset() ? n << 1 | 1 : (n <<= 1);
        this.setS(((n &= 0xFF) & 0x80) != 0);
        this.set3((n & 8) != 0);
        this.set5((n & 0x20) != 0);
        this.setZ(n == 0);
        this.setPV(parity[n]);
        this.setH(false);
        this.setN(false);
        this.setC(bl);
        return n;
    }

    private final int rr(int n) {
        boolean bl;
        boolean bl2 = bl = (n & 1) != 0;
        n = this.Cset() ? n >> 1 | 0x80 : (n >>= 1);
        this.setS((n & 0x80) != 0);
        this.set3((n & 8) != 0);
        this.set5((n & 0x20) != 0);
        this.setZ(n == 0);
        this.setPV(parity[n]);
        this.setH(false);
        this.setN(false);
        this.setC(bl);
        return n;
    }

    private final int sla(int n) {
        boolean bl = (n & 0x80) != 0;
        n = n << 1 & 0xFF;
        this.setS((n & 0x80) != 0);
        this.set3((n & 8) != 0);
        this.set5((n & 0x20) != 0);
        this.setZ(n == 0);
        this.setPV(parity[n]);
        this.setH(false);
        this.setN(false);
        this.setC(bl);
        return n;
    }

    private final int sls(int n) {
        boolean bl = (n & 0x80) != 0;
        n = (n << 1 | 1) & 0xFF;
        this.setS((n & 0x80) != 0);
        this.set3((n & 8) != 0);
        this.set5((n & 0x20) != 0);
        this.setZ(n == 0);
        this.setPV(parity[n]);
        this.setH(false);
        this.setN(false);
        this.setC(bl);
        return n;
    }

    private final int sra(int n) {
        boolean bl = (n & 1) != 0;
        n = n >> 1 | n & 0x80;
        this.setS((n & 0x80) != 0);
        this.set3((n & 8) != 0);
        this.set5((n & 0x20) != 0);
        this.setZ(n == 0);
        this.setPV(parity[n]);
        this.setH(false);
        this.setN(false);
        this.setC(bl);
        return n;
    }

    private final int srl(int n) {
        boolean bl = (n & 1) != 0;
        this.setS(((n >>= 1) & 0x80) != 0);
        this.set3((n & 8) != 0);
        this.set5((n & 0x20) != 0);
        this.setZ(n == 0);
        this.setPV(parity[n]);
        this.setH(false);
        this.setN(false);
        this.setC(bl);
        return n;
    }

    private final int dec8(int n) {
        boolean bl = n == 128;
        boolean bl2 = ((n & 0xF) - 1 & 0x10) != 0;
        n = n - 1 & 0xFF;
        this.setS((n & 0x80) != 0);
        this.set3((n & 8) != 0);
        this.set5((n & 0x20) != 0);
        this.setZ(n == 0);
        this.setPV(bl);
        this.setH(bl2);
        this.setN(true);
        return n;
    }

    private final int inc8(int n) {
        boolean bl = n == 127;
        boolean bl2 = ((n & 0xF) + 1 & 0x10) != 0;
        n = n + 1 & 0xFF;
        this.setS((n & 0x80) != 0);
        this.set3((n & 8) != 0);
        this.set5((n & 0x20) != 0);
        this.setZ(n == 0);
        this.setPV(bl);
        this.setH(bl2);
        this.setN(false);
        return n;
    }

    private final int adc16(int n, int n2) {
        int n3 = this.Cset() ? 1 : 0;
        int n4 = n + n2 + n3;
        int n5 = n4 & 0xFFFF;
        this.setS((n5 & 0x8000) != 0);
        this.set3((n5 & 0x800) != 0);
        this.set5((n5 & 0x2000) != 0);
        this.setZ(n5 == 0);
        this.setC((n4 & 0x10000) != 0);
        this.setPV(((n ^ ~n2) & (n ^ n5) & 0x8000) != 0);
        this.setH(((n & 0xFFF) + (n2 & 0xFFF) + n3 & 0x1000) != 0);
        this.setN(false);
        return n5;
    }

    private final int add16(int n, int n2) {
        int n3 = n + n2;
        int n4 = n3 & 0xFFFF;
        this.set3((n4 & 0x800) != 0);
        this.set5((n4 & 0x2000) != 0);
        this.setC((n3 & 0x10000) != 0);
        this.setH(((n & 0xFFF) + (n2 & 0xFFF) & 0x1000) != 0);
        this.setN(false);
        return n4;
    }

    private final int sbc16(int n, int n2) {
        int n3 = this.Cset() ? 1 : 0;
        int n4 = n - n2 - n3;
        int n5 = n4 & 0xFFFF;
        this.setS((n5 & 0x8000) != 0);
        this.set3((n5 & 0x800) != 0);
        this.set5((n5 & 0x2000) != 0);
        this.setZ(n5 == 0);
        this.setC((n4 & 0x10000) != 0);
        this.setPV(((n ^ n2) & (n ^ n5) & 0x8000) != 0);
        this.setH(((n & 0xFFF) - (n2 & 0xFFF) - n3 & 0x1000) != 0);
        this.setN(true);
        return n5;
    }

    public final void exx() {
        int n = this.HL();
        this.HL(this._HL_);
        this._HL_ = n;
        n = this.DE();
        this.DE(this._DE_);
        this._DE_ = n;
        n = this.BC();
        this.BC(this._BC_);
        this._BC_ = n;
    }

    public final void ex_af_af() {
        int n = this.AF();
        this.AF(this._AF_);
        this._AF_ = n;
    }

    private static int inc16(int n) {
        return n + 1 & 0xFFFF;
    }

    private static int qinc8(int n) {
        return n + 1 & 0xFF;
    }

    private static int dec16(int n) {
        return n - 1 & 0xFFFF;
    }

    private static int qdec8(int n) {
        return n - 1 & 0xFF;
    }

    private static int res(int n, int n2) {
        return n2 & ~n;
    }

    private static int set(int n, int n2) {
        return n2 | n;
    }

    static {
        int n = 0;
        while (n < 256) {
            boolean bl = true;
            int n2 = 0;
            while (n2 < 8) {
                if ((n & 1 << n2) != 0) {
                    bl = !bl;
                }
                ++n2;
            }
            Z80.parity[n] = bl;
            ++n;
        }
    }
}

