/*
 * Decompiled with CFR 0.152.
 */
import java.awt.image.BufferedImage;
import java.io.FileInputStream;

public class Machine
implements Runnable {
    public UMZE umze;
    public boolean mode800;
    private byte[] mem_RAM = new byte[65536];
    private byte[] mem_ROM700 = new byte[4096];
    public boolean mem_ROM700on;
    private byte[] mem_ROM800 = new byte[8192];
    public boolean mem_ROM800on;
    private byte[] mem_CGROM = new byte[4096];
    public boolean mem_CGROMon;
    public boolean mem_CGRAMon;
    public boolean mem_VRAMon;
    public boolean pause;
    private int[] colors;
    private int[] colors700;
    public boolean hiresmode;
    public BufferedImage imageLO = new BufferedImage(320, 200, 1);
    public BufferedImage imageHI = new BufferedImage(640, 200, 1);
    private Z80 hw_z80;
    public IOPort[] hw_port;
    public GDG hw_gdg;
    public I8253 hw_i8253;
    public I8255 hw_i8255;
    public QD hw_qd;
    public FD hw_fd;
    public SN76489 hw_snd;
    public E008 hw_e008;
    public SRAM hw_sram;
    private Thread thread;
    public boolean noSound;
    public boolean noROMs;

    public Machine(UMZE uMZE) {
        this.umze = uMZE;
        this.hw_port = new IOPort[256];
        EmptyPort emptyPort = new EmptyPort();
        int n = 0;
        while (n < 256) {
            this.hw_port[n] = emptyPort;
            ++n;
        }
        this.hw_z80 = new Z80(this);
        this.hw_gdg = new GDG(this);
        this.hw_port[204] = this.hw_gdg;
        this.hw_port[205] = this.hw_gdg;
        this.hw_port[206] = this.hw_gdg;
        this.hw_port[207] = this.hw_gdg;
        this.hw_port[224] = this.hw_gdg;
        this.hw_port[225] = this.hw_gdg;
        this.hw_port[226] = this.hw_gdg;
        this.hw_port[227] = this.hw_gdg;
        this.hw_port[228] = this.hw_gdg;
        this.hw_i8255 = new I8255(this);
        this.hw_port[208] = this.hw_i8255;
        this.hw_port[209] = this.hw_i8255;
        this.hw_port[210] = this.hw_i8255;
        this.hw_port[211] = this.hw_i8255;
        this.hw_i8253 = new I8253(this);
        this.hw_port[212] = this.hw_i8253;
        this.hw_port[213] = this.hw_i8253;
        this.hw_port[214] = this.hw_i8253;
        this.hw_port[215] = this.hw_i8253;
        this.hw_e008 = new E008(this);
        this.hw_fd = new FD(this);
        this.hw_port[216] = this.hw_fd;
        this.hw_port[217] = this.hw_fd;
        this.hw_port[218] = this.hw_fd;
        this.hw_port[219] = this.hw_fd;
        this.hw_port[220] = this.hw_fd;
        this.hw_snd = new SN76489(this);
        this.hw_port[242] = this.hw_snd;
        this.hw_qd = new QD(this);
        this.hw_port[244] = this.hw_qd;
        this.hw_port[245] = this.hw_qd;
        this.hw_port[246] = this.hw_qd;
        this.hw_port[247] = this.hw_qd;
        this.hw_sram = new SRAM(this);
        this.hw_port[248] = this.hw_sram;
        this.hw_port[249] = this.hw_sram;
        this.hw_port[250] = this.hw_sram;
        this.reset();
        this.thread = new Thread(this);
        this.thread.start();
    }

    public void run() {
        int n = 50;
        boolean bl = false;
        System.out.println("Emulation started...");
        int n2 = 20 * n;
        long l = System.currentTimeMillis() + (long)n2;
        int n3 = 0;
        int n4 = 20;
        int n5 = 0;
        while (true) {
            int n6;
            if (this.pause) {
                while (this.pause) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                n3 = 0;
                l = System.currentTimeMillis() + (long)n2;
            }
            if (this.umze.reset) {
                this.umze.reset = false;
                this.reset();
            }
            while (this.noROMs) {
                if (!this.umze.reset) continue;
                this.umze.reset = false;
                this.reset();
            }
            long l2 = System.currentTimeMillis();
            if (l2 >= l || n3 == n) {
                int n7 = (int)(l2 - l + 1000L) / 20;
                if (n3 > n7) {
                    ++n4;
                    n5 = 0;
                } else if (n3 < n7) {
                    n4 = 0;
                    if (n3 == 0) {
                        this.umze.repaint();
                        n5 = 0;
                    } else {
                        n5 = n7 / n3 + 1;
                    }
                }
                System.out.println();
                l = l2 + (long)n2;
                n3 = 0;
            }
            if (bl) {
                int n8 = 0;
                n6 = 0;
                while (n6 < 2216) {
                    this.hw_z80.execute(this.umze.speedCPU);
                    this.hw_i8253.executeCTC1(this.umze.speedCTC1);
                    if (n6 % 7 == 6) {
                        this.drawScanline(n8);
                        ++n8;
                    }
                    ++n6;
                }
            } else {
                n6 = 0;
                while (n6 < 2216) {
                    this.hw_z80.execute(this.umze.speedCPU);
                    this.hw_i8253.executeCTC1(this.umze.speedCTC1);
                    ++n6;
                }
                this.drawScreen();
            }
            ++n3;
            if (n5 > 0) {
                if (n3 % (n5 + 1) == 1) {
                    this.umze.repaint();
                    System.out.print("|");
                } else {
                    System.out.print(".");
                }
            } else {
                System.out.print("|");
                this.umze.repaint();
            }
            if (n4 <= 0) continue;
            try {
                Thread.sleep(n4);
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    public void redraw(int n) {
    }

    public void update() {
    }

    public int mem_read(int n, int n2) {
        int n3 = n >>> 12;
        switch (n3) {
            case 0: {
                if (this.mem_ROM700on) {
                    return this.mem_ROM700[n];
                }
                return this.mem_RAM[n];
            }
            case 12: {
                if (!this.mem_CGRAMon || this.mode800) break;
                return this.hw_gdg.mem_VRAM_II[n & 0xFFF] & 0xFF;
            }
            case 13: {
                if (!this.mem_VRAMon || this.mode800) break;
                return this.hw_gdg.mem_read(n) & 0xFF;
            }
            case 14: 
            case 15: {
                if (this.mem_ROM800on) {
                    if (n < 57353 && !this.mode800) {
                        switch (n & 0xF) {
                            case 0: 
                            case 1: 
                            case 2: 
                            case 3: {
                                return this.hw_i8255.in(n - 57136, n2);
                            }
                            case 4: 
                            case 5: 
                            case 6: 
                            case 7: {
                                return this.hw_i8253.in(n - 57136, n2);
                            }
                            case 8: {
                                return this.hw_e008.in(n - 57136, n2);
                            }
                        }
                        break;
                    }
                    return this.mem_ROM800[n & 0x1FFF];
                }
                return this.mem_RAM[n];
            }
        }
        return this.mem_RAM[n];
    }

    public void mem_write(int n, int n2, int n3) {
        int n4 = n >>> 12;
        switch (n4) {
            case 0: {
                if (!this.mem_ROM700on) break;
                return;
            }
            case 12: {
                if (!this.mem_CGRAMon || this.mode800) break;
                this.hw_gdg.mem_write(n, n2);
                return;
            }
            case 13: {
                if (!this.mem_VRAMon || this.mode800) break;
                this.hw_gdg.mem_write(n, n2);
                return;
            }
            case 14: 
            case 15: {
                if (!this.mem_ROM800on || n >= 57360 || this.mode800) break;
                switch (n & 0xF) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: {
                        this.hw_i8255.out(n - 57136, n2, n3);
                        return;
                    }
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        this.hw_i8253.out(n - 57136, n2, n3);
                        return;
                    }
                    case 8: {
                        this.hw_e008.out(57352, n2, n3);
                        return;
                    }
                }
                return;
            }
        }
        this.mem_RAM[n] = (byte)n2;
    }

    private void resetPAL() {
        this.colors = new int[16];
        this.colors[0] = 0;
        this.colors[1] = 128;
        this.colors[2] = 0x800000;
        this.colors[3] = 0x800080;
        this.colors[4] = 32768;
        this.colors[5] = 32896;
        this.colors[6] = 0x808000;
        this.colors[7] = 0x808080;
        this.colors[8] = 0x404040;
        this.colors[9] = 255;
        this.colors[10] = 0xFF0000;
        this.colors[11] = 0xFF00FF;
        this.colors[12] = 65280;
        this.colors[13] = 0xFF00FF;
        this.colors[14] = 65535;
        this.colors[15] = 0xFFFFFF;
        this.colors700 = new int[16];
        this.colors700[0] = this.colors[0];
        this.colors700[1] = this.colors[1];
        this.colors700[2] = this.colors[2];
        this.colors700[3] = this.colors[3];
        this.colors700[4] = this.colors[4];
        this.colors700[5] = this.colors[5];
        this.colors700[6] = this.colors[6];
        this.colors700[7] = this.colors[7];
    }

    private void loadROMs() {
        FileInputStream fileInputStream;
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        this.noROMs = false;
        String string = this.umze.tfROM0000.getText();
        if (string.equals("")) {
            System.err.println("Error: Lower ROM not specified");
            bl = true;
        } else {
            try {
                fileInputStream = new FileInputStream(string);
                if (fileInputStream != null) {
                    n2 = fileInputStream.read(this.mem_ROM700, 0, 4096);
                    while (n2 < 4096) {
                        n = fileInputStream.read(this.mem_ROM700, n2, 4096 - n2);
                        if (n == -1) break;
                        n2 += n;
                    }
                    if (n2 == 4096) {
                        System.out.println("Lower ROM loaded...");
                    } else {
                        System.err.println("Error: Wrong size of " + string);
                        bl = true;
                    }
                }
            }
            catch (SecurityException securityException) {
                securityException.printStackTrace();
                bl = true;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                bl = true;
            }
        }
        string = this.umze.tfROME000.getText();
        if (string.equals("")) {
            System.err.println("Error: Upper ROM not specified");
            bl = true;
        } else {
            try {
                fileInputStream = new FileInputStream(string);
                if (fileInputStream != null) {
                    n2 = fileInputStream.read(this.mem_ROM800, 0, 8192);
                    while (n2 < 8192) {
                        n = fileInputStream.read(this.mem_ROM800, n2, 8192 - n2);
                        if (n == -1) break;
                        n2 += n;
                    }
                    if (n2 == 8192) {
                        System.out.println("Upper ROM loaded...");
                    } else {
                        System.err.println("Error: Wrong size of " + string);
                        bl = true;
                    }
                }
            }
            catch (SecurityException securityException) {
                securityException.printStackTrace();
                bl = true;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                bl = true;
            }
        }
        string = this.umze.tfROMCG.getText();
        if (string.equals("")) {
            System.err.println("Error: CGROM not specified");
            bl = true;
        } else {
            try {
                fileInputStream = new FileInputStream(string);
                if (fileInputStream != null) {
                    n2 = fileInputStream.read(this.mem_CGROM, 0, 4096);
                    while (n2 < 4096) {
                        n = fileInputStream.read(this.mem_CGROM, n2, 4096 - n2);
                        if (n == -1) break;
                        n2 += n;
                    }
                    if (n2 == 4096) {
                        System.out.println("CGROM loaded...");
                    } else {
                        System.err.println("Error: Wrong size of " + string);
                        bl = true;
                    }
                }
            }
            catch (SecurityException securityException) {
                securityException.printStackTrace();
                bl = true;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                bl = true;
            }
        }
        if (bl) {
            this.noROMs = true;
        }
    }

    public void reset() {
        this.loadROMs();
        this.resetPAL();
        IOPort iOPort = null;
        int n = 0;
        while (n < 256) {
            IOPort iOPort2 = this.hw_port[n];
            if (iOPort2 != iOPort) {
                iOPort2.reset();
                iOPort = iOPort2;
            }
            ++n;
        }
        this.hw_z80.reset();
    }

    public void drawScreen() {
        byte[] byArray = this.hw_gdg.mem_VRAM_I;
        byte[] byArray2 = this.hw_gdg.mem_VRAM_II;
        byArray2 = this.mem_CGROM;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < 25) {
            if (this.hw_gdg.dirtyLine[n3]) {
                this.hw_gdg.dirtyLine[n3] = false;
                int n4 = 0;
                while (n4 < 40) {
                    int n5 = byArray[n] & 0xFF;
                    int n6 = byArray[2048 + n++] & 0xFF;
                    int n7 = this.colors[n6 >>> 4 & 7];
                    int n8 = this.colors[n6 & 7];
                    n2 = (n5 += n6 << 1 & 0x100) << 3;
                    int n9 = n3 << 3;
                    int n10 = 0;
                    while (n10 < 8) {
                        int n11 = byArray2[n2++] & 0xFF;
                        int n12 = n4 << 3;
                        if ((n11 & 1) > 0) {
                            this.imageLO.setRGB(n12, n9, n7);
                        } else {
                            this.imageLO.setRGB(n12, n9, n8);
                        }
                        ++n12;
                        if ((n11 & 2) > 0) {
                            this.imageLO.setRGB(n12, n9, n7);
                        } else {
                            this.imageLO.setRGB(n12, n9, n8);
                        }
                        ++n12;
                        if ((n11 & 4) > 0) {
                            this.imageLO.setRGB(n12, n9, n7);
                        } else {
                            this.imageLO.setRGB(n12, n9, n8);
                        }
                        ++n12;
                        if ((n11 & 8) > 0) {
                            this.imageLO.setRGB(n12, n9, n7);
                        } else {
                            this.imageLO.setRGB(n12, n9, n8);
                        }
                        ++n12;
                        if ((n11 & 0x10) > 0) {
                            this.imageLO.setRGB(n12, n9, n7);
                        } else {
                            this.imageLO.setRGB(n12, n9, n8);
                        }
                        ++n12;
                        if ((n11 & 0x20) > 0) {
                            this.imageLO.setRGB(n12, n9, n7);
                        } else {
                            this.imageLO.setRGB(n12, n9, n8);
                        }
                        ++n12;
                        if ((n11 & 0x40) > 0) {
                            this.imageLO.setRGB(n12, n9, n7);
                        } else {
                            this.imageLO.setRGB(n12, n9, n8);
                        }
                        ++n12;
                        if ((n11 & 0x80) > 0) {
                            this.imageLO.setRGB(n12, n9, n7);
                        } else {
                            this.imageLO.setRGB(n12, n9, n8);
                        }
                        ++n9;
                        ++n10;
                    }
                    ++n4;
                }
            } else {
                n += 40;
            }
            ++n3;
        }
    }

    public void drawScanline(int n) {
    }
}

