/*
 * Decompiled with CFR 0.152.
 */
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;

public class SRAM
extends EmptyPort {
    public boolean disabled;
    public File file;
    public String filename;
    public boolean readOnly;
    private byte[] memory = new byte[65536];
    private boolean memoryUpdated;
    private int pointer;
    private int pointerTop;

    public int in(int n, long l) {
        if (this.disabled) {
            return 255;
        }
        switch (n & 0xFF) {
            case 248: {
                this.pointer = 0;
                return 255;
            }
            case 249: {
                int n2 = this.memory[this.pointer++] & 0xFF;
                this.pointer &= 0xFFFF;
                return n2;
            }
            case 250: {
                System.out.println("Invalid read SRAM.in(" + Integer.toHexString(n) + ")");
                return 255;
            }
            case 168: {
                this.pointer = 0;
                return 255;
            }
            case 169: {
                int n3 = this.memory[this.pointer++] & 0xFF;
                this.pointer &= 0xFFFF;
                return n3;
            }
            case 170: {
                System.out.println("Invalid read SRAM.in(" + Integer.toHexString(n) + ")");
                return 255;
            }
        }
        System.out.println("Unsupported port SRAM.in(" + Integer.toHexString(n) + ")");
        return 255;
    }

    public void out(int n, int n2, long l) {
        if (this.disabled) {
            return;
        }
        switch (n & 0xFF) {
            case 248: {
                return;
            }
            case 249: {
                return;
            }
            case 250: {
                this.memoryUpdated = true;
                this.memory[this.pointer++] = (byte)n2;
                this.pointer &= 0xFFFF;
                if (this.pointer > this.pointerTop) {
                    this.pointerTop = this.pointer;
                }
                return;
            }
            case 168: {
                return;
            }
            case 169: {
                return;
            }
            case 170: {
                this.memoryUpdated = true;
                this.memory[this.pointer++] = (byte)n2;
                this.pointer &= 0xFFFF;
                if (this.pointer > this.pointerTop) {
                    this.pointerTop = this.pointer;
                }
                return;
            }
        }
        System.out.println("Unsupported port SRAM.out(" + Integer.toHexString(n) + "," + Integer.toHexString(n2) + ")");
    }

    public void init(int n, char[] cArray) {
    }

    public void reset() {
        Closeable closeable;
        if (!this.disabled && this.file != null) {
            try {
                closeable = new FileOutputStream(this.file);
                if (closeable != null) {
                    ((FileOutputStream)closeable).write(this.memory, 0, this.pointerTop + 1);
                    System.out.println("SRAM image updated...");
                }
            }
            catch (SecurityException securityException) {
                System.out.println("SRAM image is readonly...");
            }
            catch (Exception exception) {
                System.out.println("Unable to update SRAM image...");
            }
        }
        this.filename = this.m.umze.tfSRAMimage.getText();
        this.disabled = true;
        if (this.filename.equals("")) {
            return;
        }
        this.file = new File(this.filename);
        try {
            if (this.file.exists()) {
                closeable = new FileInputStream(this.file);
                closeable = new FileInputStream(this.file);
                int n = ((FileInputStream)closeable).read(this.memory, 0, 4096);
                while (n < 4096) {
                    int n2 = ((FileInputStream)closeable).read(this.memory, n, 4096 - n);
                    if (n2 == -1) break;
                    n += n2;
                }
                if (n > 0) {
                    this.pointerTop = n - 1;
                }
                System.out.println("SRAM loaded...");
            }
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.memoryUpdated = false;
        this.disabled = false;
    }

    public SRAM() {
    }

    public SRAM(Machine machine) {
        this();
        this.m = machine;
    }
}

