  ;*****************************************************************
  ;          BK0010-01  emulator
  ;
  ;  Copyright (c) 1996 by  Dmitry Tjurev     2:5061/15.49@FidoNet
  ;
  ;  make:     tasm /m2 bk.asm
  ;            tlink bk.obj
  ;*****************************************************************

    LOCALS

   adr_down_bytes EQU 28000  ; ⠡  256   ன ࠡ  ࠭

   stk            segment stack 'stack'
          db 1024 dup (0)
   stk            ends

   dat            segment para 'data'
r0b label byte
r0        dw 0
r1        dw 0
r2        dw 0
r3        dw 0
r4        dw 0
r5        dw 0
r6        dw 0
r7        dw 0
pswb label byte
psw       dw 0

commands dw enh1,_br,_bne,_beq,_bge,_blt,_bgt,_ble,_jsr,_jsr,enh2,enh2,enh2
         dw enh3,none,none,_mov,_mov,_mov,_mov,_mov,_mov,_mov,_mov,_mov,_mov
         dw _mov,_mov,_mov,_mov,_mov,_mov,_cmp,_cmp,_cmp,_cmp,_cmp,_cmp,_cmp
         dw _cmp,_cmp,_cmp,_cmp,_cmp,_cmp,_cmp,_cmp,_cmp,_bit,_bit,_bit,_bit
         dw _bit,_bit,_bit,_bit,_bit,_bit,_bit,_bit,_bit,_bit,_bit,_bit,_bic
         dw _bic,_bic,_bic,_bic,_bic,_bic,_bic,_bic,_bic,_bic,_bic,_bic,_bic,_bic
         dw _bic,_bis,_bis,_bis,_bis,_bis,_bis,_bis,_bis,_bis,_bis,_bis,_bis
         dw _bis,_bis,_bis,_bis,_add,_add,_add,_add,_add,_add,_add,_add,_add
         dw _add,_add,_add,_add,_add,_add,_add,none,none,none,none,none,none,none
         dw none,_xor,_xor,none,none,none,none,_sob,_sob,_bpl,_bmi,_bhi,_blos
         dw _bvc,_bvs,_bcc,_bcs,_emt,_trap,enh4,enh4,enh4,enh5,none,none
         dw _movb,_movb,_movb,_movb,_movb,_movb,_movb,_movb,_movb,_movb,_movb,_movb,_movb
         dw _movb,_movb,_movb,_cmpb,_cmpb,_cmpb,_cmpb,_cmpb,_cmpb,_cmpb,_cmpb,_cmpb,_cmpb
         dw _cmpb,_cmpb,_cmpb,_cmpb,_cmpb,_cmpb,_bitb,_bitb,_bitb,_bitb,_bitb,_bitb,_bitb
         dw _bitb,_bitb,_bitb,_bitb,_bitb,_bitb,_bitb,_bitb,_bitb,_bicb,_bicb,_bicb,_bicb
         dw _bicb,_bicb,_bicb,_bicb,_bicb,_bicb,_bicb,_bicb,_bicb,_bicb,_bicb,_bicb,_bisb
         dw _bisb,_bisb,_bisb,_bisb,_bisb,_bisb,_bisb,_bisb,_bisb,_bisb,_bisb,_bisb,_bisb
         dw _bisb,_bisb,_sub,_sub,_sub,_sub,_sub,_sub,_sub,_sub,_sub,_sub,_sub
         dw _sub,_sub,_sub,_sub,_sub,none,none,none,none,none,none,none,none
         dw none,none,none,none,none,none,none,none

adressing  dw 0,type1,type2,type3,type4,type5,type6,type7
adressingb dw 0,type1b,type2b,type3b,type4b,type5b,type6b,type7b

enh1atab dw _halt,_wait,_rti,_bpt,_iot,_reset,_rtt
enh1ctab dw clb,seb
enh2tab  dw _clr,_com,_inc,_dec
         dw _neg,_adc,_sbc,_tst
         dw _ror,_rol,_asr,_asl
enh4tab  dw _clrb,_comb,_incb,_decb
         dw _negb,_adcb,_sbcb,_tstb
         dw _rorb,_rolb,_asrb,_aslb
enh3tab  dw _mark,none,none,_sxt
enh5tab  dw _mtps,none,none,_mfps

keytab0  db 100 dup (0)
nkey     dw 74

keytab1  db 187,188,189,190,191,192,193,194,195,141,130,131,132,133,134,135
         db 136,137,138,139,140,171,142,143,144,145,146,147,148,149,150,151
         db 152,153,154,155,210,199,158,159,160,161,162,163,164,165,166,167
         db 168,211,156,172,173,174,175,176,177,178,179,180,181,203,200,205,208
         db 170,185,182,196,169,157,186,184
         db 1
keytab2  db 1q,3q,13q,26q,27q,2q,4q,0q,14q,73q,61q,62q,63q,64q,65q,66q,67q
         db 70q,71q,60q,55q,72q,30q,11q,112q,103q,125q,113q,105q,116q,107q
         db 133q,135q,132q,110q,137q,57q,23q,106q,131q,127q,101q,120q,122q
         db 117q,114q,104q,126q,134q,56q,12q,121q,136q,123q,115q,111q,124q,130q,102q,100q,54q,10q,32q,31q,33q
         db 216q,40q,217q,200q,201q,202q,203q,204q
         db 300q

keytab3  db 100 dup (0) ;ਧ 㤥ঠ 
keystop  db 0           ;ਧ 㤥ঠ 
keysjoy  db 0,0,1,0,0,2,0,4,0,0,16,8,32,0,0,0,0,0 ; ⮡ࠦ ᪠  70   177714
         db 40 dup (0)

         ;⠡ ४஢ ᨬ   䠩
fnames   db 8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8
         db 8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8
         db 32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47
         db 48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63
         db 64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79
         db 80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95
         db 96,97,98,99,100,101,102,103,104,105,106,107,108,109,110,111
         db 112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,254
         db 219,219,219,219,219,219,219,219,219,219,219,219,219,219,219,219
         db 219,219,219,219,219,219,219,219,219,219,219,219,219,219,219,219
         db 219,219,219,219,219,219,219,219,219,219,219,219,219,219,219,219
         db 219,219,219,219,219,219,219,219,219,219,219,219,219,219,219,219
         db 238,160,161,230,164,165,228,163,229,168,169,170,171,172,173,174
         db 175,239,224,225,226,227,166,162,236,235,167,232,237,233,231,234
         db 158,128,129,150,132,133,148,131,149,136,137,138,139,140,141,142
         db 143,159,144,145,146,147,134,130,156,155,135,152,157,153,151,154

disktab  db 300 dup (0) ;⠡  ᬮ  䠩 ( 10 )

palcol    db 0,0,0,0,0,63,0,63,0,63,0,0 ;  梥⭮ ०
palcol2   db 0,0,0,0,0,48,0,48,0,48,0,0 ;  梥⭮ ०
palbw     db 0,0,0,63,63,63             ;   ०
palsetup  db 42,0,42,63,63,21           ;  setupa
lvc1      dw 3760 ; ᬥ饭 ࠭  ⭮⥫쭮   㣫  
lvc2      dw 8    ;    ਧ⠫
acm       dw 0    ;256*80+lvc1+lvc2
acm2      dw 0    ;64*80+lvc1+lvc2
ext       dw 0  ;ਧ ० ७  (0 - , <>0 - )
scr       dw 0  ;(256-  ஫)*80
maska     db 0
lup1      db 0
lup2      dw 0
b2scpr    dw 0
opr1      dw 0 ;ᠭ  ணࠬ OPER1
opr2      dw 0 ;
korr      dw 0
pri       dw 0 ;뢠 WR  WRB   ॡ   ,  ਯ ࠡ稪 뢠
pri2      dw 0 ;뢠 WRB  맮   MOVB ( ७ )
tmp       dw 0
old9    dw     0,0
pri3      db 0 ;᪮쪮 , ᮮ⢥  ( 䨪ᠬ) ᥩ 
dfi       db 0 ; 뢠 (1 -   60q, 2 - 274q)
dfs       db 0 ;ॡ 뢠  ⮯
storekod  db 0
prkrl     db 0 ;ਧ /
prksz     db 0 ;        /
prksu     db 0 ;        
prknr     db 0 ;         ॣ
prkar     db 0 ;        2
trey      db 0
extra     db 0 ; ࢨ ᮢ (稭  300q- 室    ..)
pnk1      db 0 ;ਧ 室 䨪᭮ ᪠ 224
pnk2      db 0 ;ਧ /⦠ ⭮ 䨪᭮ 
keep1     db 0
trace     db 0
intpriw   db 0  ;ਧ ⮣,   WAIT  뢠
intpri    db 0  ;ਧ 뢠   WAIT
handle    dw 0
filecount dw 0
fileremem dw 0
filecur   dw 0
adrneed   dw 0  ;   襭 ⥭/
adrname   dw 0  ;  ஬ 室  䠩
com1      db 1
com2      db 1
com3      db 1
com4      db 1
com5      db 1
com6      db 1
tis       db 4  ;-   -  ६ ⠩
tcou      db 0
tcou3     dw 0
psp       dw 0
commline  dw 0

       ; ० ࠡ ணࠬ, ⠭  SETUPe

mode      db 1 ;୮/  梥⭮ ०
sound     db 1 ; 몫祭  祭
delay     dw 60 ;প ᫥     横 LOOP
sob       db 0 ;०  77r01  500r (sob  clr) 몫祭  祭
speed     db 1 ;० ⮡ࠦ ⥪饩 ந⥫쭮 
delaypr   db 1 ;ਧ 祭 প
delaysto  dw 60 ;祭 প

numb      db 00110000b  ; ࠩ   뢮 ந⥫쭮
          db 11001100b
          db 11001100b
          db 11001100b
          db 11001100b
          db 11001100b
          db 00110000b
          db 00000000b

          db 00110000b
          db 00111100b
          db 00110000b
          db 00110000b
          db 00110000b
          db 00110000b
          db 11111100b
          db 00000000b

          db 00110000b
          db 11001100b
          db 11000000b
          db 11110000b
          db 00001100b
          db 00001100b
          db 11111100b
          db 00000000b

          db 11111100b
          db 11000000b
          db 11000000b
          db 00110000b
          db 11000000b
          db 11000000b
          db 00111100b
          db 00000000b

          db 11001100b
          db 11001100b
          db 11001100b
          db 11111100b
          db 11000000b
          db 11000000b
          db 11000000b
          db 00000000b

          db 11111100b
          db 00001100b
          db 00001100b
          db 00111100b
          db 11000000b
          db 11000000b
          db 00111100b
          db 00000000b

          db 11110000b
          db 00001100b
          db 00001100b
          db 00111100b
          db 11001100b
          db 11001100b
          db 00110000b
          db 00000000b

          db 11111100b
          db 11000000b
          db 11000000b
          db 00110000b
          db 00110000b
          db 00110000b
          db 00110000b
          db 00000000b

          db 00110000b
          db 11001100b
          db 11001100b
          db 00110000b
          db 11001100b
          db 11001100b
          db 00110000b
          db 00000000b

          db 00110000b
          db 11001100b
          db 11001100b
          db 11110000b
          db 11000000b
          db 11000000b
          db 00111100b
          db 00000000b

          db 11001100b
          db 11000000b
          db 00110000b
          db 00110000b
          db 00110000b
          db 00001100b
          db 11001100b
          db 00000000b

          db 00000000b
          db 00000000b
          db 00000000b
          db 00000000b
          db 00000000b
          db 00000000b
          db 00000000b
          db 00000000b

points    db 00000011b
          db 00001100b
          db 00110000b
          db 11000000b

setup_txt db  ' ͻ ',0
          db  '  --- 0010-01 setup ---  ',0
          db  '                           ',0
          db  '  1. த            ',0
          db  '  2. १            ',0
          db  '  3. 室                 ',0
          db  '                           ',0
          db  '  4.                   ',0
          db  '  5.                   ',0
          db  '  6.             ',0
          db  '  7. ய SOB           ',0
          db  '  8.  =          ',0
          db  '  9.              ',0
          db  ' ͼ ',0,0

text      db '              : ਩ ॢ.     ⮢--   1996.$'
text2     db ' 䠩 "bk_rom.ovl" ?!!$'
fname1    db 'bk_rom.ovl',0
fname2    db 'bk_files.dat',0
fname3    db '    .bk',0
fname4    db 'bk.cfg',0
   dat            ends

   cod            segment para 'code'
    assume cs:cod, ds:dat, ss:stk

    byte2scr        proc   ;뢮    ࠭ 
     ;di -  40000(8)-77777(8)
     ;bl - 
        mov   dx,adr
        mov   es,dx
        sub   di,16384
        shl   di,1
        mov   si,es:[di]
        mov   dx,0a000h
        mov   es,dx
        xor   bh,bh
        add   bx,adr_down_bytes
        mov   al,es:[bx]
        add   si,scr
        cmp   si,acm
        jb    bs2
        sub   si,256*80
bs2:    cmp   ext,0
        jne   bs1
        cmp   si,acm2
        jae   bs3
bs1:    mov   es:[si],al
bs3:    ret
    byte2scr        endp

    video_init        proc
        mov  ax,10h  ; 640x350
        int  10h

        mov  ax,1130h        ; ⥬ 䮭
        mov  bh,6
        int  10h
        mov  word ptr font_adr,bp
        mov  word ptr font_adr+2,es
        mov  bx,4           ;⠭   setupa
        mov  cx,2
        mov  dx,offset palsetup
        call setblockpal

        mov  dx,3ceh  ; 祭 㯠  ॣ ᤢ
        mov  al,3
        out  dx,al
        inc  dx
        mov  al,0     ; 몫 ᤢ, ०  (mov)
        out  dx,al
        mov  dx,3c4h  ; 祭 㯠  ॣ map mask register
        mov  al,2
        out  dx,al
        inc  dx
        mov  al,0fh   ;   ⮢ 
        out  dx,al
        mov  ax,adr   ; ⠡ ᮮ⢥⢨ ࠭ ᮢ
        mov  es,ax
        xor  bx,bx
        xor  di,di
        mov  lup2,16384
vi4:    mov  ax,bx
        mov  si,ax
        and  ax,16320
        mov  cl,6
        shr  ax,cl
        mov  cl,80
        mul  cl
        add  ax,lvc1
        and  si,63
        add  si,lvc2
        add  si,ax
        mov  es:[di],si
        add  di,2
        inc  bx
        dec  lup2
        jne  vi4
        mov  ax,lvc1     ; ६ acm  acm2 (㦭  byte2scr)
        add  ax,lvc2
        mov  acm,ax
        mov  acm2,ax
        add  acm,80*256
        add  acm2,80*64
        cmp  mode,0
        je   vi7
        call colormode
        ret
vi7:    call bwmode
        ret
    video_init        endp

    colormode       proc
        mov  bx,0
        mov  cx,4
        mov  dx,offset palcol
        call setblockpal
        mov  bl,2
        call writemode
        mov  b2scpr,0
        call downbytes
        mov  bl,1
        call writemode
        mov  ax,0
        call redraw
        ret
    colormode       endp

    bwmode          proc
        mov  bx,0
        mov  cx,2
        mov  dx,offset palbw
        call setblockpal
        mov  bl,2
        call writemode
        mov  b2scpr,-1
        call downbytes
        mov  bl,1
        call writemode
        mov  ax,0
        call redraw
        ret
    bwmode          endp

    redraw          proc      ;࠭  -> ࠭ IBM
        cli
        push  ds
        mov   bx,bkseg
        mov   es,bx
        mov   di,lvc1
        add   di,lvc2
        mov   bx,0a000h
        mov   ds,bx
        xor   bx,bx
        mov   ax,es:[177664q]
        and   ax,255
        sub   ax,330q
        jae   rd5
        add   ax,256
rd5:    push  ax
        mov   cl,6
        shl   ax,cl
        add   ax,16384
        mov   si,ax
        mov   ax,es:[177664q]
        and   ax,1000q
        je    rd4
        pop   dx
        push  dx
        sub   dx,256
        neg   dx
        call  rd2
        pop   dx
        cmp   dx,0
        je    rd3
        mov   si,16384
        call  rd2
        jmp   short rd3
rd4:    pop   dx
        cmp   dx,192
        ja    rd7
        mov   dx,64
        jmp   short rd9
rd7:    sub   dx,192
        push  dx
        neg   dx
        add   dx,64
        call  rd2
        pop   dx
        mov   si,16384
rd9:    call  rd2
        mov   bx,adr_down_bytes
        mov   dx,192
rd11:   mov   cx,64
rd10:   mov   al,[bx]
        mov   [di],al
        inc   di
        loop  rd10
        add   di,16
        dec   dx
        jne   rd11
rd3:    pop   ds
        mov   ax,es:[177664q] ; ६ ext  scr (㦭  byte2scr)
        mov   ext,ax
        and   ext,1000q
        and   ax,255
        sub   ax,330q
        jae   rd14
        add   ax,256
rd14:   cmp   ax,0
        je    rd12
        sub   ax,256
        neg   ax
        mov   bl,80
        mul   bl
rd12:   mov   scr,ax
        sti
        ret
rd2:    mov   cx,64
rd1:    mov   bl,es:[si]
        mov   al,[bx+adr_down_bytes]
        mov   [di],al
        inc   si
        inc   di
        loop  rd1
        add   di,16
        dec   dx
        jne   rd2
        ret
    redraw          endp

    writemode       proc
      ;bl-० 
        mov  dx,3ceh  ; 祭 㯠  ॣ ०
        mov  al,5
        out  dx,al
        inc  dx
        mov  al,bl     ; ⠭ ०  2
        out  dx,al
        ret
    writemode       endp

    setblockpal     proc   ;⠭  梥⮢ 
      ;bx -  
      ;cx - 
      ;dx -  ⠡
        mov  ax,ds
        mov  es,ax
        mov  ax,1012h
        int  10h
        ret
    setblockpal     endp

    downbytes       proc
        mov  si,adr_down_bytes       ;뢥  ࠭  ⮢ 
        xor  bl,bl
        mov  lup2,256
vi3:    push bx
        call by2sc
        pop  bx
        inc  bl
        inc  si
        dec  lup2
        jne  vi3
        ret
    downbytes       endp

    by2sc             proc
     ;si -  IBM
     ;bl -   
        mov   dx,0a000h
        mov   es,dx
        cmp   b2scpr,0 ;뢮 梥⭮      ⠡
        je    vi5
        mov   maska,1
        mov   lup1,8
vi6:    xor   cl,cl
        shl   bl,1
        rcl   cl,1
        call  vi1
        shl   maska,1
        dec   lup1
        jne   vi6
        ret
vi5:    mov   maska,3
        mov   lup1,4
vi2:    xor   cl,cl
        shl   bl,1
        rcl   cl,1
        shl   bl,1
        rcl   cl,1
        call  vi1
        shl   maska,1
        shl   maska,1
        dec   lup1
        jne   vi2
        ret
vi1:    mov  al,es:[si]
        mov  dx,3ceh   ; 祭 㯠  ॣ bit mask register
        mov  al,8
        out  dx,al
        mov  dx,3cfh
        mov  al,maska  ; ⠭ 塞 樫஢
        out  dx,al
        mov  es:[si],cl
        ret
    by2sc           endp

  ;㯯e ࠡ稪 ----------------------------------------------------

    enh1           proc
        mov   bx,di
        cmp   bx,6
        ja    en1
        shl   bx,1
        jmp   enh1atab[bx]
en1:    cmp   bx,240q
        jb    en2
        cmp   bx,300q
        jae   en3
        sub   bx,240q
        mov   cl,4
        shr   bx,cl
        shl   bx,1
        jmp   enh1ctab[bx]
en2:    cmp   bx,100q
        jae   en4
en6:    jmp   none
en4:    cmp   bx,200q
        jae   en5
        jmp   _jmp
en5:    cmp   bx,210q
        jae   en6
        jmp   _rts
en3:    jmp   _swab
    enh1           endp

    enh2           proc
        mov   bx,di
        mov   cl,6
        shr   bx,cl
        shl   bx,1
        sub   bx,80
        jmp   enh2tab[bx]
    enh2           endp

    enh4           proc
        mov   bx,di
        mov   cl,6
        shr   bx,cl
        shl   bx,1
        sub   bx,1104
        jmp   enh4tab[bx]
    enh4           endp

    enh3           proc
        mov   bx,di
        mov   cl,6
        shr   bx,cl
        shl   bx,1
        sub   bx,104
        jmp   enh3tab[bx]
    enh3           endp

    enh5           proc
        mov   bx,di
        mov   cl,6
        shr   bx,cl
        shl   bx,1
        sub   bx,1128
        jmp   enh5tab[bx]
    enh5           endp

  ; 㯯  ----------------------------------------------
    clb            proc   ;㯯   ⮢ ᫮
        not   di
        and   di,15
        or    di,65535-15
        and   psw,di
        ret
    clb            endp

    seb            proc   ;㯯  ⠭ ⮢ ᫮
        and   di,15
        or    psw,di
        ret
    seb            endp

    _swab          proc
        mov   bx,di
        call  oper1
        cmp   ah,0
        xchg  al,ah
        jmp   second2
    _swab          endp

    _jmp           proc
        mov   bx,di
        call  oper2
        cmp   opr1,0
        jne   jm1
        jmp   _halt
jm1:    mov   ax,opr2
        mov   r7,ax
        ret
    _jmp           endp

    _jsr           proc
        mov   bx,di
        push  di
        call  oper2
        pop   di
        cmp   opr1,0
        jne   js1
        jmp   _halt
js1:    push  opr2
        mov   cl,5
        shr   di,cl
        and   di,14
        mov   opr1,1
        mov   pri,1
        sub   r6,2
        mov   bx,r6
        and   bx,177776q
        mov   opr2,bx
        mov   ax,r0[di]
        mov   tmp,di
        call  wr
        mov   di,tmp
        mov   pri,0
        mov   ax,r7
        mov   r0[di],ax
        pop   ax
        mov   r7,ax
        ret
    _jsr           endp

    _wait          proc
        mov   intpriw,255
        cmp   intpri,0
        jne   wa1
        sub   r7,2
        ret
wa1:    mov   intpri,0
        mov   intpriw,0
        ret
    _wait          endp

    _rti           proc
        mov   di,r6
        call  rt1
        mov   r7,ax
        add   r6,2
        mov   di,r6
        call  rt1
        mov   pswb,al
        add   r6,2
        and   psw,255-20q
        ret
rt1:    mov   korr,0          ;⥭ ᫮  
        xor   bx,bx
        and   di,177776q
        cmp   di,177600q
        jb    rt2
        jmp   syst
rt2:    mov   ax,es:[di]
        ret
    _rti           endp

    _reset         proc
        mov   word ptr es:[177660q],100q
        mov   dfi,0
        ret
    _reset         endp

    _rtt           proc
        mov   di,r6
        call  rt1
        mov   r7,ax
        add   r6,2
        mov   di,r6
        call  rt1
        mov   pswb,al
        add   r6,2
        ret
    _rtt           endp

    _rts           proc
        and   di,7
        shl   di,1
        mov   ax,r0[di]
        mov   r7,ax
        mov   si,di
        mov   di,r6
        call  rt1
        mov   r0[si],ax
        add   r6,2
        ret
    _rts           endp

    _xor           proc
        mov   bx,di
        mov   cl,5
        shr   di,cl
        and   di,14
        push  di
        call  oper1
        pop   di
        xor   ax,r0[di]
        push  ax
        call  setpswinc
        pop   ax
        jmp   wr
    _xor           endp

    _mtps          proc
        mov   bx,di
        call  oper2
        and   byte ptr psw,20q
        and   al,377q-20q
        or    byte ptr psw,al
        ret
    _mtps          endp

    _mfps          proc
        mov   bx,di
        call  oper2
        mov   al,pswb
        cmp   al,0
        push  ax
        call  setpswinc
        pop   ax
        jmp   wrb
    _mfps          endp

    _sob           proc
        mov   bx,di
        and   bx,63
        mov   cl,5
        shr   di,cl
        and   di,14
        cmp   bx,1
        jne   so2
        cmp   sob,0
        je    so2
        mov   ax,r0[di]
        add   command,ax
        mov   r0[di],0
        ret
so2:    dec   r0[di]
        je    so1
        shl   bx,1
        sub   r7,bx
so1:    ret
    _sob           endp

  ; ⢫ ------------------------------------------------------
    firstw          proc  ;᫥ 㬬  r7  ७ ⮢ ᫮
        mov   ax,di           ; PSW  bx (䮬 IBM)
        cbw
        shl   ax,1
        mov   dx,psw
        xor   bx,bx
        mov   dh,dl
        mov   cl,3
        shr   dl,cl
        rcr   bl,1
        shr   dl,1
        rcr   bl,1
        rcr   bl,1
        shr   dh,1
        rcl   bl,1
        shr   dh,1
        mov   cl,4
        rcl   bh,cl
        pushf
        pop   cx
        and   cx,65535-2241
        and   bx,2241
        or    bx,cx
        ret
    firstw          endp

    _br             proc
        mov   ax,di
        cbw
        shl   ax,1
        add   r7,ax
        ret
    _br             endp

    _bne            proc
        call  firstw
        push  bx
        popf
        jne   wt1
        ret
wt1:    add   r7,ax
        ret
    _bne            endp

    _beq            proc
        call  firstw
        push  bx
        popf
        je    wt2
        ret
wt2:    add   r7,ax
        ret
    _beq            endp

    _bge            proc
        call  firstw
        push  bx
        popf
        jge   wt3
        ret
wt3:    add   r7,ax
        ret
    _bge            endp

    _blt            proc
        call  firstw
        push  bx
        popf
        jl    wt4
        ret
wt4:    add   r7,ax
        ret
    _blt            endp

    _bgt            proc
        call  firstw
        push  bx
        popf
        jg    wt5
        ret
wt5:    add   r7,ax
        ret
    _bgt            endp

    _ble            proc
        call  firstw
        push  bx
        popf
        jle   wt6
        ret
wt6:    add   r7,ax
        ret
    _ble            endp

    _bpl            proc
        call  firstw
        push  bx
        popf
        jns   wt7
        ret
wt7:    add   r7,ax
        ret
    _bpl            endp

    _bmi            proc
        call  firstw
        push  bx
        popf
        js    wt8
        ret
wt8:    add   r7,ax
        ret
    _bmi            endp

    _bhi            proc
        call  firstw
        push  bx
        popf
        ja    wt9
        ret
wt9:    add   r7,ax
        ret
    _bhi            endp

    _blos           proc
        call  firstw
        push  bx
        popf
        jbe   wt10
        ret
wt10:   add   r7,ax
        ret
    _blos           endp

    _bvc            proc
        call  firstw
        push  bx
        popf
        jno   wt11
        ret
wt11:   add   r7,ax
        ret
    _bvc            endp

    _bvs            proc
        call  firstw
        push  bx
        popf
        jo    wt12
        ret
wt12:   add   r7,ax
        ret
    _bvs            endp

    _bcc            proc
        call  firstw
        push  bx
        popf
        jnc   wt14
        ret
wt14:   add   r7,ax
        ret
    _bcc            endp

    _bcs            proc
        call  firstw
        push  bx
        popf
        jc    wt15
        ret
wt15:   add   r7,ax
        ret
    _bcs            endp

  ; ࠭  ( ᫮)-----------------------------

    _sxt            proc
        mov   bx,di
        call  oper1
        xor   ax,ax
        mov   bx,psw
        and   bx,8
        je    sxt1
        mov   ax,177777q
sxt1:   cmp   ax,0
        push  ax
        call  setpswsxt
        pop   ax
        jmp   wr
    _sxt            endp

    _mark           proc
        and   di,77q
        shl   di,1
        add   di,r7
        mov   r6,di
        mov   ax,r5
        mov   r7,ax
        mov   bx,r6
        mov   ax,es:[bx]
        mov   r5,ax
        add   r6,2
        ret
    _mark           endp

    _clr            proc
        mov   bx,di
        call  oper1
        xor   ax,ax
        jmp   second2
    _clr            endp

    _com            proc
        or    psw,1
        mov   bx,di
        call  oper1
        not   ax
        cmp   ax,0
        push  ax
        call  setpswinc
        pop   ax
        jmp   wr
    _com            endp

    _inc            proc
        mov   bx,di
        call  oper1
        inc   ax
        push  ax
        call  setpswinc
        pop   ax
        jmp   wr
    _inc            endp

    _dec            proc
        mov   bx,di
        call  oper1
        dec   ax
        push  ax
        call  setpswinc
        pop   ax
        jmp   wr
    _dec            endp

    _neg            proc
        mov   bx,di
        call  oper1
        neg   ax
        jmp   second2
    _neg            endp

    _adc            proc
        mov   bx,di
        call  oper1
        mov   bx,psw
        and   bx,1
        add   ax,bx
        jmp   second2
    _adc            endp

    _sbc            proc
        mov   bx,di
        call  oper1
        mov   bx,psw
        and   bx,1
        sub   ax,bx
        jmp   second2
    _sbc            endp

    _tst            proc
        mov   bx,di
        call  oper1
        cmp   ax,0
        jmp   setpsw
    _tst            endp

    _ror            proc
        mov   bx,di
        call  oper1
        mov   bx,ax
        lahf
        mov   dx,psw
        and   dx,1
        and   ah,254
        or    ah,dl
        sahf
        rcr   bx,1
        pushf
        pop   ax
        and   ax,65535-128-64 ;   ஬ S  Z - ⨬ 
        mov   dx,ax
        cmp   bx,0
        pushf
        pop   ax
        and   ax,128+64 ;⠢ S  Z
        or    ax,dx
        mov   cl,al     ;४뢠  v
        rol   cl,1
        xor   cl,dl
        mov   bp,cx
        and   bp,1
        mov   cl,11
        shl   bp,cl
        and   ax,65535-2048
        or    ax,bp
        push  ax
        popf
        mov   ax,bx
        jmp   second2
    _ror            endp

    _rol            proc
        mov   bx,di
        call  oper1
        mov   bx,ax
        lahf
        mov   dx,psw
        and   dx,1
        and   ah,254
        or    ah,dl
        sahf
        rcl   bx,1
        pushf
        pop   ax
        and   ax,65535-128-64 ;   ஬ S  Z - ⨬ 
        mov   dx,ax
        cmp   bx,0
        pushf
        pop   ax
        and   ax,128+64 ;⠢ S  Z
        or    ax,dx
        push  ax
        popf
        mov   ax,bx
        jmp   second2
    _rol            endp

    _asr            proc
        mov   bx,di
        call  oper1
        mov   bx,ax
        sar   bx,1
        pushf
        pop   ax
        and   ax,65535-128-64 ;   ஬ S  Z - ⨬ 
        mov   dx,ax
        cmp   bx,0
        pushf
        pop   ax
        and   ax,128+64 ;⠢ S  Z
        or    ax,dx
        mov   cl,al     ;४뢠  v
        rol   cl,1
        xor   cl,dl
        mov   bp,cx
        and   bp,1
        mov   cl,11
        shl   bp,cl
        and   ax,65535-2048
        or    ax,bp
        push  ax
        popf
        mov   ax,bx
        jmp   second2
    _asr            endp

    _asl            proc
        mov   bx,di
        call  oper1
        mov   bx,ax
        shl   bx,1
        pushf
        pop   ax
        and   ax,65535-128-64 ;   ஬ S  Z - ⨬ 
        mov   dx,ax
        cmp   bx,0
        pushf
        pop   ax
        and   ax,128+64 ;⠢ S  Z
        or    ax,dx
        push  ax
        popf
        mov   ax,bx
        jmp   second2
    _asl            endp

  ; ࠭  ( ⠬)-------------------------------

    second2b        proc    ;ࠪ  ⢨ :
        push  ax               ;⠭ PSW   १
        call  setpsw
        pop   ax
        jmp   wrb
    second2b        endp

    _clrb           proc
        mov   bx,di
        call  oper2
        xor   al,al
        jmp   second2b
    _clrb           endp

    _comb           proc
        or    psw,1
        mov   bx,di
        call  oper2
        not   al
        cmp   al,0
        push  ax
        call  setpswinc
        pop   ax
        jmp   wrb
    _comb           endp

    _incb           proc
        mov   bx,di
        call  oper2
        inc   al
        push  ax
        call  setpswinc
        pop   ax
        jmp   wrb
    _incb           endp

    _decb           proc
        mov   bx,di
        call  oper2
        dec   al
        push  ax
        call  setpswinc
        pop   ax
        jmp   wrb
    _decb           endp

    _negb           proc
        mov   bx,di
        call  oper2
        neg   al
        jmp   second2b
    _negb           endp

    _adcb           proc
        mov   bx,di
        call  oper2
        mov   bx,psw
        and   bl,1
        add   al,bl
        jmp   second2b
    _adcb           endp

    _sbcb           proc
        mov   bx,di
        call  oper2
        mov   bx,psw
        and   bl,1
        sub   al,bl
        jmp   second2b
    _sbcb           endp

    _tstb           proc
        mov   bx,di
        call  oper2
        cmp   al,0
        jmp   setpsw
    _tstb           endp

    _rorb           proc
        mov   bx,di
        call  oper2
        mov   bl,al
        lahf
        mov   dx,psw
        and   dx,1
        and   ah,254
        or    ah,dl
        sahf
        rcr   bl,1
        pushf
        pop   ax
        and   ax,65535-128-64 ;   ஬ S  Z - ⨬ 
        mov   dx,ax
        cmp   bl,0
        pushf
        pop   ax
        and   ax,128+64 ;⠢ S  Z
        or    ax,dx
        mov   cl,al     ;४뢠  v
        rol   cl,1
        xor   cl,dl
        mov   bp,cx
        and   bp,1
        mov   cl,11
        shl   bp,cl
        and   ax,65535-2048
        or    ax,bp
        push  ax
        popf
        mov   al,bl
        jmp   second2b
    _rorb           endp

    _rolb           proc
        mov   bx,di
        call  oper2
        mov   bl,al
        lahf
        mov   dx,psw
        and   dx,1
        and   ah,254
        or    ah,dl
        sahf
        rcl   bl,1
        pushf
        pop   ax
        and   ax,65535-128-64 ;   ஬ S  Z - ⨬ 
        mov   dx,ax
        cmp   bl,0
        pushf
        pop   ax
        and   ax,128+64 ;⠢ S  Z
        or    ax,dx
        push  ax
        popf
        mov   al,bl
        jmp   second2b
    _rolb           endp

    _asrb           proc
        mov   bx,di
        call  oper2
        mov   bl,al
        sar   bl,1
        pushf
        pop   ax
        and   ax,65535-128-64 ;   ஬ S  Z - ⨬ 
        mov   dx,ax
        cmp   bl,0
        pushf
        pop   ax
        and   ax,128+64 ;⠢ S  Z
        or    ax,dx
        mov   cl,al     ;४뢠  v
        rol   cl,1
        xor   cl,dl
        mov   bp,cx
        and   bp,1
        mov   cl,11
        shl   bp,cl
        and   ax,65535-2048
        or    ax,bp
        push  ax
        popf
        mov   al,bl
        jmp   second2b
    _asrb           endp

    _aslb           proc
        mov   bx,di
        call  oper2
        mov   bl,al
        shl   bl,1
        pushf
        pop   ax
        and   ax,65535-128-64 ;   ஬ S  Z - ⨬ 
        mov   dx,ax
        cmp   bl,0
        pushf
        pop   ax
        and   ax,128+64 ;⠢ S  Z
        or    ax,dx
        push  ax
        popf
        mov   al,bl
        jmp   second2b
    _aslb           endp


  ; 宯࠭  ( ᫮)-----------------------------

    first2          proc   ;ࠪ 砫 ⢨ :
        push  di               ;⥭ ࠭  AX  BX
        mov   bx,di
        mov   cl,6
        shr   bx,cl
        call  oper1
        pop   bx
        push  ax
        call  oper1
        pop   bx
        ret
    first2          endp

    second2         proc    ;ࠪ  ⢨ :
        push  ax               ;⠭ PSW   १
        call  setpsw
        pop   ax
        jmp   wr
    second2         endp

    _add            proc
        call  first2
        add   ax,bx
        jmp   second2
    _add            endp

    _sub            proc
        call  first2
        sub   ax,bx
        jmp   second2
    _sub            endp

    _mov            proc
        call  first2
        mov   ax,bx
        cmp   ax,0
        push  ax
        call  setpswinc
        pop   ax
        jmp   wr
    _mov            endp

    _cmp            proc
        call  first2
        cmp   bx,ax
        jmp   setpsw
    _cmp            endp

    _bis            proc
        call  first2
        or    ax,bx
        push  ax
        call  setpswinc
        pop   ax
        jmp   wr
    _bis            endp

    _bic            proc
        call  first2
        not   bx
        and   ax,bx
        push  ax
        call  setpswinc
        pop   ax
        jmp   wr
    _bic            endp

    _bit            proc
        call  first2
        and   ax,bx
        jmp   setpswinc
    _bit            endp

  ; 宯࠭  ( ⠬)------------------------------

    first2b         proc   ;ࠪ 砫 ⢨ :
        push  di               ;⥭ ࠭  AX  BX
        mov   bx,di
        mov   cl,6
        shr   bx,cl
        call  oper2
        pop   bx
        push  ax
        call  oper2
        pop   bx
        ret
    first2b         endp

    _movb           proc
        call  first2b
        mov   al,bl
        cmp   al,0
        push  ax
        call  setpswinc
        pop   ax
        mov   pri2,255
        jmp   wrb
    _movb           endp

    _cmpb           proc
        call  first2b
        cmp   bl,al
        jmp   setpsw
    _cmpb           endp

    _bisb           proc
        call  first2b
        or    al,bl
        push  ax
        call  setpswinc
        pop   ax
        jmp   wrb
    _bisb           endp

    _bicb           proc
        call  first2b
        not   bl
        and   al,bl
        push  ax
        call  setpswinc
        pop   ax
        jmp   wrb
    _bicb           endp

    _bitb           proc
        call  first2b
        and   al,bl
        jmp   setpswinc
    _bitb           endp

 ; ணࠬ 뢠 ( 4 [⮫쪮 halt], 10,14,20,30,34)

    tostack         proc  ;ᥭ  ⥪ PSW  R7  뢠
        mov   opr1,1
        mov   pri,1
        sub   r6,2
        mov   bx,r6
        and   bx,177776q
        mov   opr2,bx
        mov   ax,psw
        call  wr
        sub   r6,2
        mov   bx,r6
        and   bx,177776q
        mov   opr2,bx
        mov   ax,r7
        call  wr
        mov   pri,0
        ret
    tostack         endp

    none            proc
        call  tostack
        mov   ax,es:[10q]
        mov   r7,ax
        mov   ax,es:[12q]
        mov   psw,ax
        ret
    none            endp

    _emt            proc
        and   di,255
        cmp   di,36q
        jne   em1
        jmp   disk
em1:    call  tostack
        mov   ax,es:[30q]
        mov   r7,ax
        mov   ax,es:[32q]
        mov   psw,ax
        ret
    _emt            endp

    _trap           proc
        call  tostack
        mov   ax,es:[34q]
        mov   r7,ax
        mov   ax,es:[36q]
        mov   psw,ax
        ret
    _trap           endp

    _iot            proc
        call  tostack
        mov   ax,es:[20q]
        mov   r7,ax
        mov   ax,es:[22q]
        mov   psw,ax
        ret
    _iot            endp

    _bpt            proc
        call  tostack
        mov   ax,es:[14q]
        mov   r7,ax
        mov   ax,es:[16q]
        mov   psw,ax
        ret
    _bpt            endp

    _halt           proc
        call  tostack
        mov   ax,es:[4q]
        mov   r7,ax
        mov   ax,es:[6q]
        mov   psw,ax
        ret
    _halt           endp

 ; ᯮ⥫ ணࠬ ---------------------------------------------

    setpsw          proc
        pushf
        pop   ax
        xor   bl,bl
        mov   dl,al
        shl   al,1
        rcl   bl,1
        shl   al,1
        rcl   bl,1
        mov   cl,4
        shr   ah,cl
        rcl   bl,1
        shr   dl,1
        rcl   bl,1
        and   byte ptr psw,377q-15
        or    byte ptr psw,bl
        ret
    setpsw          endp

    setpswsxt       proc  ;"C"  "N"  , V=0
        pushf
        pop   ax
        xor   bl,bl
        shl   al,1
        shl   al,1
        mov   cl,3
        rcl   bl,cl
        and   byte ptr psw,377q-6
        or    byte ptr psw,bl
        ret
    setpswsxt       endp

    setpswinc       proc  ;"C"  
        pushf
        pop   ax
        xor   bl,bl
        shl   al,1
        rcl   bl,1
        shl   al,1
        rcl   bl,1
        mov   cl,4
        shr   ah,cl
        rcl   bl,1
        rcl   bl,1
        and   byte ptr psw,377q-14
        or    byte ptr psw,bl
        ret
    setpswinc       endp

    wr              proc  ; ᫮ १
    ;:  ax -   
    ;     opr1,opr2,pri
        mov   bx,opr2
        cmp   opr1,0
        jne   wr1
        mov   r0[bx],ax
        ret
wr1:    cmp   bx,177600q
        jae   systwr
        cmp   bx,100000q
        jb    wr2
        cmp   pri,0
        je    wr4
;   ॠ      ࠡ ୮ ࠡ稪 뢠
wr4:    jmp   _halt        ;call+ret=jmp
wr2:    mov   es:[bx],ax
        cmp   bx,40000q
        jb    wr3
        mov   di,bx
        mov   bl,al
        push  di
        push  ax
        call  byte2scr
        pop   ax
        pop   di
        inc   di
        mov   bl,ah
        call  byte2scr
wr3:    ret
systwr: cmp   bx,177716q
        jne   wr10
        cmp   sound,0
        je    wr8
        call  speaker
        ret
wr10:   cmp   bx,177662q
        jne   wr6
        jmp   _halt
wr6:    cmp   bx,177660q
        jne   wr7
        and   byte ptr es:[bx],128
        and   al,127
        or    es:[bx],al
        ret
wr7:    cmp   bx,177714q
        je    wr8
        cmp   bx,177710q
        je    wr8
        mov   cx,es:[bx]
        mov   es:[bx],ax
        cmp   bx,177712q
        jne   wr11
        or    es:[bx],177400q
        mov   bx,es:[177706q]
        mov   es:[177710q],bx
        ret
wr11:   cmp   bx,177664q
        jne   wr5
        and   es:[bx],255+512
        ret
wr5:
wr8:    ret
    wr              endp

    wrb             proc  ;  १
    ;:  al -   
    ;     opr1,opr2,pri,pri2
        mov   bx,opr2
        cmp   opr1,0
        jne   wrb1
        cmp   pri2,0
        je    wrb5
        mov   pri2,0
        mov   r0b[bx],al
        cmp   al,0
        jge   wrb6
        mov   byte ptr r0b[bx+1],255
        ret
wrb6:   mov   byte ptr r0b[bx+1],0
        ret
wrb5:   mov   r0b[bx],al
        ret
wrb1:   mov   pri2,0
        cmp   bx,177600q
        jae   systwrb
        cmp   bx,100000q
        jb    wrb2
        cmp   pri,0
        je    wrb4
;   ॠ      ࠡ ୮ ࠡ稪 뢠
wrb4:   jmp   _halt        ;call+ret=jmp
wrb2:   mov   es:[bx],al
        cmp   bx,40000q
        jb    wrb3
        mov   di,bx
        mov   bl,al
        call  byte2scr
wrb3:   ret
systwrb:mov   cx,bx
        and   cx,65534
        cmp   cx,177716q
        jne   wrb11
        cmp   sound,0
        je    wrb10
        call  speaker
        ret
wrb11:  cmp   cx,177662q
        jne   wrb8
        jmp   _halt
wrb8:   cmp   bx,177660q
        jne   wrb9
        and   byte ptr es:[bx],128
        and   al,127
        or    es:[bx],al
        ret
wrb9:   cmp   bx,177661q
        je    wrb10
        cmp   cx,177714q
        je    wrb10
        cmp   cx,177710q
        je    wrb10
        cmp   bx,177713q
        je    wrb10
        mov   es:[bx],al
        cmp   bx,177712q
        jne   wrb12
        mov   bx,es:[177706q]
        mov   es:[177710q],bx
        ret
wrb12:  cmp   bx,177664q
        jne   wrb7
        and   es:[bx],255+512
        ret
wrb7:
wrb10:  ret
    wrb             endp

    oper1           proc   ;⥭ ᫮ 室  ⨯ 樨
      ;:  bx=[0..77(8)]
      ;     si -  ⥪.  + 2
      ;     es=bkseg
      ;: ax   - ࠭-᫮
      ;     opr1 - ਧ, ॣ   祩 
      ;     opr2 - ᮮ⢥⢥  ॣ*2   祩 
      ;            (ᥣ )
        mov   di,bx
        and   bx,7
        shl   bx,1
        and   di,70q
        jne   op1
        mov   opr1,0
        mov   opr2,bx
        mov   ax,r0[bx]
        ret
op1:    mov   opr1,1
        shr   di,1
        shr   di,1
        jmp   adressing[di]  ;jmp=call+ret
type1:  mov   korr,0
        mov   di,r0[bx]
        and   di,177776q
        mov   opr2,di
        cmp   di,177600q
        jb    op5
        jmp   syst
op5:    mov   ax,es:[di]
        ret
type2:  mov   korr,2
        mov   di,r0[bx]
        and   di,177776q
        mov   opr2,di
        cmp   di,177600q
        jb    op6
        jmp   syst
op6:    mov   ax,es:[di]
        mov   cx,korr
        add   r0[bx],cx
        ret
type3:  mov   korr,2
        mov   di,r0[bx]
        and   di,177776q
        mov   di,es:[di]
        and   di,177776q
        mov   opr2,di
        cmp   di,177600q
        jb    op7
        jmp   syst
op7:    mov   ax,es:[di]
        mov   cx,korr
        add   r0[bx],cx
        ret
type4:  mov   korr,0
        sub   r0[bx],2
        mov   di,r0[bx]
        and   di,177776q
        mov   opr2,di
        cmp   di,177600q
        jb    a111               ;jae
        jmp   syst
a111:   mov   ax,es:[di]
        ret
type5:  mov   korr,0
        sub   r0[bx],2
        mov   di,r0[bx]
        and   di,177776q
        mov   di,es:[di]
        and   di,177776q
        mov   opr2,di
        cmp   di,177600q
        jae   syst
        mov   ax,es:[di]
        ret
type6:  mov   korr,0
        mov   si,r7
        and   si,177776q
        add   r7,2
        mov   di,r0[bx]
        add   di,es:[si]
        and   di,177776q
        mov   opr2,di
        cmp   di,177600q
        jae   syst
        mov   ax,es:[di]
        ret
type7:  mov   korr,0
        mov   si,r7
        and   si,177776q
        add   r7,2
        mov   di,r0[bx]
        add   di,es:[si]
        and   di,177776q
        mov   di,es:[di]
        and   di,177776q
        mov   opr2,di
        cmp   di,177600q
        jae   syst
        mov   ax,es:[di]
        ret
syst:   mov   ax,es:[di]
        mov   cx,korr
        add   r0[bx],cx
        cmp   di,177662q
        jne   op12
        and   byte ptr es:[177660q],127
        mov   dfi,0
        mov   trey,0
op12:   ret
    oper1           endp

    oper2           proc   ;⥭  室  ⨯ 樨
      ;:  bx=[0..77(8)]
      ;     si -  ⥪.  + 2
      ;     es=bkseg
      ;: al   - ࠭-
      ;     opr1 - ਧ, ॣ   祩 
      ;     opr2 - ᮮ⢥⢥  ॣ*2   祩 
      ;            (ࠧ㬥,  㫥 襣 )
        mov   di,bx
        and   bx,7
        shl   bx,1
        and   di,70q
        jne   op2
        mov   opr1,0
        mov   opr2,bx
        mov   al,r0b[bx]
        ret
op2:    mov   opr1,1
        shr   di,1
        shr   di,1
        jmp   adressingb[di]  ;jmp=call+ret
type1b: mov   korr,0
        mov   di,r0[bx]
        mov   opr2,di
        cmp   di,177600q
        jb    op8
        jmp   syst2
op8:    mov   al,es:[di]
        ret
type2b: mov   korr,1
        cmp   bx,12
        jb    op3
        inc   korr
op3:    mov   di,r0[bx]
        mov   opr2,di
        cmp   di,177600q
        jb    op9
        jmp   syst2
op9:    mov   al,es:[di]
        mov   cx,korr
        add   r0[bx],cx
        ret
type3b: mov   korr,2
        mov   di,r0[bx]
        and   di,177776q
        mov   di,es:[di]
        mov   opr2,di
        cmp   di,177600q
        jb    op10
        jmp   syst2
op10:   mov   al,es:[di]
        mov   cx,korr
        add   r0[bx],cx
        ret
type4b: mov   korr,0
        cmp   bx,12
        jb    op4
        dec   r0[bx]
op4:    dec   r0[bx]
        mov   di,r0[bx]
        mov   opr2,di
        cmp   di,177600q
        jae   syst2
        mov   al,es:[di]
        ret
type5b: mov   korr,0
        sub   r0[bx],2
        mov   di,r0[bx]
        and   di,177776q
        mov   di,es:[di]
        mov   opr2,di
        cmp   di,177600q
        jae   syst2
        mov   al,es:[di]
        ret
type6b: mov   korr,0
        mov   si,r7
        and   si,177776q
        add   r7,2
        mov   di,r0[bx]
        add   di,es:[si]
        mov   opr2,di
        cmp   di,177600q
        jae   syst2
        mov   al,es:[di]
        ret
type7b: mov   korr,0
        mov   si,r7
        and   si,177776q
        add   r7,2
        mov   di,r0[bx]
        add   di,es:[si]
        and   di,177776q
        mov   di,es:[di]
        mov   opr2,di
        cmp   di,177600q
        jae   syst2
        mov   al,es:[di]
        ret
syst2:  mov   al,es:[di]
        mov   cx,korr
        add   r0[bx],cx
        cmp   di,177662q
        jne   op11
        and   byte ptr es:[177660q],127
        mov   dfi,0
        mov   trey,0
op11:   ret
    oper2           endp

   speaker          proc
        test  al,100q
        je    spe1
        in    al,61h
        or    al,2
        out   61h,al
        jmp   short spe2
spe1:   in    al,61h
        and   al,255-2
        out   61h,al
spe2:   ret
   speaker          endp

   decimal        proc ; ax- ᫮
        mov   dx,11
        push  dx
        push  dx
        push  dx
        mov   dx,10
        push  dx
        mov   cx,4
        mov   si,10
dec1:   xor   dx,dx
        div   si
        push  dx
        inc   cx
        or    ax,ax
        jne   dec1
        mov   si,26003
dec2:   pop   dx
        push  cx
        shl   dx,1
        shl   dx,1
        shl   dx,1
        add   dx,offset numb
        mov   cx,7
dec3:   push  cx
        push  dx
        push  si
        mov   bx,dx
        mov   bl,[bx]
        call  by2sc
        pop   si
        pop   dx
        pop   cx
        inc   dx
        add   si,80
        loop  dec3
        pop   cx
        sub   si,559
        loop  dec2
        ret
   decimal        endp

   open           proc   ;dx = offset fname
        mov   ax,03d02h
        int   21h
        mov   handle,ax
        ret
   open           endp

   close          proc
        mov   ah,03eh
        mov   bx,handle
        int   21h
        ret
   close          endp

   seek           proc     ;室  cx:dx
        mov   ax,4201h
        mov   bx,handle
        int   21h
        ret
   seek           endp

   read           proc     ;室: es:dx - 㤠 , cx - ᪮쪮
        mov   ah,03fh
        mov   bx,handle
        push  ds
        push  es
        pop   ds
        int   21h
        pop   ds
        ret
   read           endp

   save           proc     ;室: es:dx - 㤠 , cx - ᪮쪮
        mov   ah,040h
        mov   bx,handle
        push  ds
        push  es
        pop   ds
        int   21h
        pop   ds
        ret
   save           endp

   load_pzu       proc
        mov   dx,offset fname1
        call  open
        jc    lp
        mov   ax,bkseg
        mov   es,ax
        mov   dx,100000q
        mov   cx,32632
        call  read
        jc    lp
        call  close
        jc    lp
        ret
lp:     mov   dx,offset text2
        mov   ah,9
        int   21h
        jmp   fireex
   load_pzu       endp

   load_cfg       proc
        mov   dx,offset fname4
        call  open
        jc    lp2
        push  ds
        pop   es
        mov   dx,offset mode
        mov   cx,9
        call  read
        call  close
lp2:    ret
   load_cfg       endp

   save_cfg       proc
        mov   dx,offset fname4
        call  open
        jc    sp2
        push  ds
        pop   es
        mov   dx,offset mode
        mov   cx,9
        call  save
        call  close
sp2:    ret
   save_cfg       endp

   value_in       proc  ;: [bx] - ⥪⮢ ᫮, : ax - ᫮
        add     bx,5
        xor     ax,ax
        mov     cx,5
va2:    mov     dl,[bx]
        dec     bx
        sub     dl,48
        shr     dl,1
        rcr     ax,1
        shr     dl,1
        rcr     ax,1
        shr     dl,1
        rcr     ax,1
        loop    va2
        shr     ax,1
        mov     dl,[bx]
        cmp     dl,48
        je      va1
        or      ax,100000q
va1:    ret
   value_in       endp

    disk            proc         ; EMT 36
        call   tostack
        mov    ax,bkseg
        mov    es,ax
diskcom:mov    word ptr es:[300q],0
        mov    bx,r1
        mov    al,es:[bx]
        cmp    al,3
        je     dis11
        jmp    dis1
dis11:  mov    ax,es:[bx+2]
        mov    adrneed,ax
        add    bx,6
        mov    adrname,bx
        mov   dx,offset fname2
        call  open
        jnc   dis8
dis12:  mov   word ptr es:[300q],2
        mov   bx,r1
        mov   byte ptr es:[bx+1],2
        jmp   dis2
dis18:  mov   word ptr es:[300q],4
        mov   bx,r1
        mov   byte ptr es:[bx+1],4
        ret
dis8:   push  es
        push  ds
        pop   es
        mov   dx,offset disktab
        mov   cx,300
        call  read
        pop   es
        jnc   dis3
dis7:   call  close
        jmp   dis12
dis3:   or    ax,ax
        je    dis7
        mov   filecount,ax
        mov   fileremem,ax
        mov   filecur,offset disktab
        add   filecur,5
        xor   bx,bx
dis6:   mov   si,filecur
        mov   di,adrname
        mov   cx,16
dis5:   mov   bl,es:[di]
        cmp   commline,0
        je    dis20
        mov   al,bl
        jmp   short dis21
dis20:  mov   al,fnames[bx]
dis21:  cmp   al,[si]
        jne   dis4
        inc   si
        inc   di
        loop  dis5
        jmp   dis9    ;  䠩  ⠡ !
dis4:   add   filecur,30
        sub   filecount,30
        jne   dis6
        cmp   fileremem,300
        jne   dis7
        jmp   short dis8
dis9:   mov   bx,filecur
        sub   bx,5           ;⥭ 䠩
        mov   si,offset fname3
        mov   ax,[bx]
        mov   [si],ax
        mov   ax,[bx+2]
        mov   [si+2],ax
        add   bx,22
        call  value_in
        mov   es:[264q],ax
        cmp   adrneed,0
        jne   dis10
        mov   adrneed,ax
dis10:  call  close
        cmp   adrneed,100000q
        jb    dis17
        call  dis18
        jmp   dis2
dis17:  mov   dx,offset fname3
        call  open
        jnc   dis15
        jmp   dis12
dis15:  mov   ax,bkseg
        mov   es,ax
        mov   dx,adrneed
        mov   cx,100000q
        sub   cx,dx
        call  read
        mov   es:[266q],ax
        mov   bx,r1
        mov   es:[bx+30q],ax
        mov   ax,es:[264q]
        mov   es:[bx+26q],ax
        mov   cx,16
dis16:  mov   al,es:[bx+6]
        mov   es:[bx+32q],al
        inc   bx
        loop  dis16
        jnc   dis14
        mov   word ptr es:[300q],2
        mov   byte ptr es:[bx+1],2
dis14:  call  close
        call  redraw
        jmp   dis2
dis1:   cmp   al,2
        jne   dis2
;    䠩  
dis2:   cmp   commline,0
        je    dis22
        mov   si,filecur
        mov   al,[si-1]        ;頥  ।   bk_files.dat
        ret                    ; ਧ ⮣,  䠩  ᯮ塞
dis22:  mov    ax,bkseg
        mov    es,ax
        cmp    es:[300q],byte ptr 0
        jne    dis30
        cmp    es:[264q],1000q
        jae    dis30
        sub   r6,0  ;2
        mov   di,7
        jmp   _rts
dis30:  jmp   _rti
    disk            endp

   keys           proc
        push   ax
        push   bx
        push   cx
        push   ds
        push   es
        mov    ax,dat
        mov    ds,ax
        mov    ax,bkseg
        mov    es,ax
        in     al,60h
        cmp    al,224   ;⫠ 䨪 ᪠  ⮢
        jne    key24
        mov    pnk1,1
        jmp    key2
key24:  cmp    pnk1,0
        je     key25
        mov    pnk1,0
        cmp    al,42
        je     key26
        cmp    al,42+128
        jne    key27
key26:  jmp    key2
key25:  cmp    al,70    ;뢮 ५   177714
        jb     key27
        cmp    al,87
        je     key27
        cmp    al,128
        jae    key28
        mov    bl,al
        xor    bh,bh
        mov    bl,[bx+keysjoy-70]
        or     es:[177714q],bl
        jmp    key2
key28:  mov    bl,al
        sub    bl,128
        cmp    bl,70
        jb     key27
        cmp    bl,87
        je     key27
        xor    bh,bh
        mov    bl,[bx+keysjoy-70]
        not    bl
        and    es:[177714q],bl
        jmp    key2
key27:  mov    storekod,al
        and    storekod,128
        xor    storekod,128  ;=0 - ᪠, <>0 - ⨥
        and    al,127
        mov    cl,al
        mov    bl,al
        xor    bh,bh
        mov    al,keytab0[bx]
        cmp    al,255         ;  ᯮ
        jne    key1
        jmp    key2
key1:   cmp    al,200q
        jae    key18
        jmp    key3           ;㯯   맢 뢠  ࠬ 60  274
key18:  mov    bl,storekod
        cmp    al,201q
        jne    key4
        mov    prknr,bl
        jmp    key2
key4:   cmp    al,202q
        jne    key5
        mov    prksu,bl
        jmp    key2
key5:   cmp    al,204q
        jne    key6
        mov    prkar,bl
        jmp    key2
key6:   cmp    al,203q
        jne    key7
        cmp    bl,0
        je     key14
        xor    prksz,bl
key14:  jmp    key2
key7:   cmp    al,216q
        jne    key8
        mov    prkrl,128
        sub    al,200q
        jmp    short key3
key8:   cmp    al,217q
        jne    key9
        mov    prkrl,0
        sub    al,200q
        jmp    short key3
key9:   cmp    al,200q
        jne    key16
        cmp    bl,0
        je     key12
        cmp    keystop,0
        jne    key21
        mov    keystop,255
        mov    dfs,255
key21:  jmp    key2
key12:  mov    keystop,0
        jmp    key2
key16:  cmp    al,300q   ;ࢨ 
        jb     key23
        cmp    bl,0
        je     key23
        mov    extra,al
        jmp    key2
key3:   mov    bl,cl
        xor    bh,bh
        cmp    storekod,0 ;⨥  ⦠⨥ ?
        jne    key10      ;⨥ !
        mov    byte ptr keytab3[bx],0
        dec    pri3
        cmp    pri3,0
        jg     key2
        mov    pri3,0
        or     byte ptr es:[177716q],100q
key23:  jmp    short key2
key10:  cmp    byte ptr keytab3[bx],0
        jne    key2
        mov    byte ptr keytab3[bx],255
        inc    pri3
        cmp    pri3,1
        ja     key2
        push   ax
        call   koder
        mov    es:[177662q],al
        pop    ax
        and    es:[177716q],65535-100q
        or     word ptr es:[177660q],200q
        cmp   prkar,0
        jne   key20
        cmp   al,13q
        ja    key19
        cmp   al,2q
        jbe   key20
        cmp   al,4q
        je    key20
        cmp   al,11q
        je    key20
        cmp   al,13q
        je    key20
key19:  mov   dfi,1
        jmp   short key22
key20:  mov   dfi,2
key22:  cmp   trey,2
        je    key2
        inc   trey
key2:   in     al,61h  ;signal - end of interrupt
        mov    ah,al
        or     al,80h
        out    61h,al
        xchg   ah,al
        out    61h,al
        mov    al,20h
        out    20h,al  ;
        pop    es
        pop    ds
        pop    cx
        pop    bx
        pop    ax
        iret
   keys           endp

   koder          proc  ;᪠- -> ଠ  ( ⮬ 䨪ᮢ)
        cmp   al,40q
        jbe   kd1
        cmp   al,100q
        jae   kd2
        cmp   prknr,0
        je    kd1
        cmp   al,60q
        jae   kd3
        add   al,20q
        ret
kd3:    sub   al,20q
        ret
kd2:    cmp   prksu,0
        je    kd4
        sub   al,100q
        ret
kd4:    cmp   prknr,0
        jne   kd1
        mov   bl,prkrl
        cmp   bl,prksz
        je    kd1
        add   al,40q
kd1:    ret
   koder          endp

   keyswork       proc
        mov    ax,bkseg
        mov    es,ax
        mov    ax,psw
        mov    cl,5
        shr    al,cl
        cmp    al,4
        jae    kw4
        test   word ptr es:[177660q],100q
        jne    kw4
        cmp    trey,1
        jne    kw4
        inc    trey
        cmp    intpriw,0
        je     kw7
        mov    intpri,255
kw7:    call  tostack
        cmp   dfi,1
        jne   kw5
kw6:    mov   ax,es:[60q]
        mov   r7,ax
        mov   ax,es:[62q]
        mov   psw,ax
        mov   dfi,0
        jmp   short kw4
kw5:    mov   ax,es:[274q]
        mov   r7,ax
        mov   ax,es:[276q]
        mov   psw,ax
        mov   dfi,0
        jmp   short kw4
kw4:    cmp    dfs,0            ;ࠡ⪠ 
        je     kw3
        add    r7,2
        call   tostack
        mov   ax,es:[4q]
        mov   r7,ax
        mov   ax,es:[6q]
        mov   psw,ax
        mov   dfs,0
kw3:    ret
   keyswork       endp

   keyson        proc
        mov   bx,offset keytab3
        mov   cx,100
ksn3:   mov   [bx],byte ptr 0
        inc   bx
        loop  ksn3
        mov   bx,offset keytab0
        mov   cx,100
        mov   al,255
ksn2:   mov   [bx],al
        inc   bx
        loop  ksn2
        xor   ah,ah
        mov   bx,offset keytab1
        mov   di,offset keytab2
        mov   cx,nkey
ksn1:   mov   al,[bx]
        inc   bx
        and   al,127
        mov   si,ax
        mov   dl,[di]
        mov   keytab0[si],dl
        inc   di
        loop  ksn1
        mov   keystop,0
        mov   pri3,0
        mov   dfi,0
        mov   prkrl,0
        mov   prksz,0
        mov   prksu,0
        mov   prknr,0
        mov   prkar,0
        mov   extra,0
        mov   trey,0
        mov   pnk1,0
        mov   pnk2,0
        mov   ax,3509h
        int   21h
        mov   old9,bx
        mov   old9+2,es
        mov   ax,2509h
        push  ds
        push  cs
        pop   ds
        mov   dx,offset keys
        int   21h
        pop   ds
        ret
   keyson        endp

   keysoff        proc
        mov   ax,2509h
        push  ds
        mov   dx,old9
        mov   ds,old9+2
        int   21h
        pop   ds
        ret
   keysoff        endp

command   dw 0 ;  , 믮  1/18.2 ᥪ㭤 (0-x)
command2  dw 0 ;  , 믮  1/18.2 ᥪ㭤 (x)
tcou2     dw 0 ;稪 ⨪  뢮 ந⥫쭮

   timer          proc
        push  ax
        mov   ax,command
        mov   command2,ax
        pop   ax
        mov   command,0
        dec   tcou2
        db 0eah
old8    dw 0,0
   timer          endp

   timeroff       proc
        mov   ax,2508h
        push  ds
        mov   dx,old8
        mov   ds,old8+2
        int   21h
        pop   ds
        ret
   timeroff       endp

   timeron        proc
        mov   command,0
        mov   tcou2,5
        mov   ax,3508h
        int   21h
        mov   old8,bx
        mov   old8+2,es
        mov   ax,2508h
        push  ds
        push  cs
        pop   ds
        mov   dx,offset timer
        int   21h
        pop   ds
        ret
   timeron        endp

   bit_t          proc
        call      tostack
        mov   ax,es:[14q]
        mov   r7,ax
        mov   ax,es:[16q]
        mov   psw,ax
        ret
   bit_t          endp
lscroll   db 0
rrp       db 0
scou      dw 0
scou2     dw 0
swait1    dw 15000 ; ࠧ  ⠪ -  ந室 redraw,
                   ;᫨ ⫨稥  ﭨ ࠭  ॣ 177664
                   ; 祬
swait2    db 5     ; 祭.
swait3    dw 14000  ;  ࠧ  swait1-swait3 , ᫨ ⫨稥 
                   ;祬 swait2
swait4    dw 15000  ; ࠧ  ⠪ -  ந室 redraw,
                   ;᫨    ᪮ 1000q ॣ 177664

   scroll         proc
       mov   ax,bkseg
       mov   es,ax

       mov   al,es:[177664q]
       mov   bl,lscroll
       sub   bl,al
       jns   sc2
       neg   bl
sc2:   je    sc3
       cmp   bl,swait2
       jae   sc4
       cmp   scou,0
       jne   sc3
sc5:   mov   lscroll,al
       call  redraw
       mov   bx,swait1
       mov   scou,bx
       jmp   short sc3
sc4:   mov   bx,swait3
       cmp   scou,bx
       jb    sc5
sc3:
       cmp   scou2,0
       jne   sc7
       mov   al,es:[177665q]
       cmp   rrp,al
       je    sc7
       mov   rrp,al
       call  redraw
       mov   bx,swait4
       mov   scou2,bx
sc7:   ret
   scroll         endp

   bktimer        proc
        mov   al,tis
        mov   tcou,al
        mov   ax,bkseg
        mov   es,ax
        test  byte ptr es:[177712q],20q
        je    bkt1
        test  byte ptr es:[177712q],1q
        jne   bkt1
        test  byte ptr es:[177712q],40q
        je    bkt2
        neg   com1
        js    bkt1
        neg   com2
        js    bkt1
        neg   com3
        js    bkt1
        neg   com4
        js    bkt1
bkt2:   test  byte ptr es:[177712q],100q
        je    bkt3
        neg   com5
        js    bkt1
        neg   com6
        js    bkt1
bkt3:   cmp   word ptr es:[177710q],1
        jne   bkt5
        test  byte ptr es:[177712q],2
        jne   bkt5
        mov   ax,es:[177706q]
        inc   ax
        mov   es:[177710q],ax
bkt6:   test  byte ptr es:[177712q],4
        je    bkt4
        or    byte ptr es:[177712q],128
bkt4:   test  byte ptr es:[177712q],10q
        je    bkt5
        and   byte ptr es:[177712q],255-20q
bkt5:   dec   word ptr es:[177710q]
bkt1:   ret
   bktimer        endp

   power          proc    ; ந⥫쭮
        cmp   tcou2,0
        jg    pow1
        mov   tcou2,5
        cmp   speed,0
        je    pow1
        mov   bl,2
        call  writemode
        mov   ax,100
        mul   command2
        mov   bx,6000
        div   bx
        call  decimal
        mov   bl,1
        call  writemode
pow1:   ret
   power          endp

   extra_keys     proc     ;ࠡ⪠ ࢨ  
        cmp   extra,0
        je    ne2
        cmp   extra,300q
        jne   ne2
        call  setup
ne2:    mov   extra,0
        ret
   extra_keys     endp

   init           proc
        mov   al,tis
        mov   tcou,al
        mov   tcou3,1000
        mov   pri,0
        mov   pri2,0
        mov   intpriw,0
        mov   intpri,0
        mov   lscroll,0
        mov   rrp,0
        mov   scou,0
        mov   scou2,0
        mov   commline,0
        mov   r7,100000q
        mov   ax,bkseg
        mov   es,ax
        mov   es:[177716q],100300q
        mov   es:[177712q],177400q
        ret
   init           endp

   command_line   proc          ;㧪 䠩     ப
        push  ds
        mov   ds,psp
        mov   al,ds:[80h]
        or    al,al
        jne   sc17
        jmp   sc9
sc17:   mov   byte ptr ds:[80h],0
        dec   al
        cmp   al,16
        jbe   sc14
        mov   al,16
sc14:   mov   cl,16
        sub   cl,al
        mov   si,82h
        mov   di,326q
sc10:   mov   bl,[si]
        mov   es:[di],bl
        inc   si
        inc   di
        dec   al
        jne   sc10
        mov   al,40q
sc16:   or    cl,cl
        je    sc15
        mov   es:[di],al
        inc   di
        dec   cl
        jmp   short sc16
sc15:   pop   ds
        mov   word ptr es:[320q],3
        mov   word ptr es:[322q],0
        mov   r1,320q
        mov   commline,1
        call  diskcom
        mov   commline,0
        cmp   al,'='
        jne   sc11
        cmp   word ptr es:[300q],0
        jne   sc11
        mov   ax,es:[264q]
        cmp   ax,1000q
        jb    sc12
        mov   si,ax
        mov   r7,si
        ret
sc12:   mov   si,es:[770q]
        mov   r7,si
        mov   r6,772q
        ret
sc9:    pop   ds
sc11:   mov   si,120000q
        mov   r7,si
        ret
   command_line   endp

rit   dw comb1,comb2,comb3,comb4  ;routines indexing table
ink   db 0
paper db 0
font_adr dd 0

    video_init2       proc near    ;樠  室  setup
        mov  dx,3ceh
        mov  ax,3      ; 몫 ᤢ, ० mov
        out  dx,ax
        mov  ax,1      ;  ஢ , ᫠ ஬
        out  dx,ax
        mov  ax,0ff08h ; ࠧ   ᥫ
        out  dx,ax
        ret
    video_init2       endp

    video_init3       proc near    ;樠  室  setupa
        mov  dx,3ceh  ; 祭 㯠  ॣ ᤢ
        mov  al,3
        out  dx,al
        inc  dx
        mov  al,0     ; 몫 ᤢ, ०  (mov)
        out  dx,al
        mov  dx,3c4h  ; 祭 㯠  ॣ map mask register
        mov  al,2
        out  dx,al
        inc  dx
        mov  al,0fh   ;   ⮢ 
        out  dx,al
        mov  bl,1
        call writemode
        ret
    video_init3       endp

char_output   proc near  ;: cl-  ᨬ, ch- ਡ, ax,bx -x,y
  P386
        push  ax
        mov   ax,5      ; ०  ஫ = 0
        mov   dx,3ceh
        out   dx,ax
        pop   ax
        push  ds
        mov   di,ax
        mov   ax,80*16
        mul   bx
        add   di,ax
        mov   ax,0a000h
        mov   es,ax
        mov   ink,ch
        and   ink,0fh
        shr   ch,4
        mov   paper,ch
        xor   ch,ch
        shl   cx,4
        lds   si,font_adr
        add   si,cx

        mov   dx,3c4h
        mov   ax,102h
        out   dx,ax
        xor   bx,bx
        shr   ink,1
        rcl   bx,1
        shr   paper,1
        rcl   bx,1
        shl   bx,1
        call  cs:[bx+rit]

        mov   dx,3c4h
        mov   ax,202h
        out   dx,ax
        xor   bx,bx
        shr   ink,1
        rcl   bx,1
        shr   paper,1
        rcl   bx,1
        shl   bx,1
        call  cs:[bx+rit]

        mov   dx,3c4h
        mov   ax,402h
        out   dx,ax
        xor   bx,bx
        shr   ink,1
        rcl   bx,1
        shr   paper,1
        rcl   bx,1
        shl   bx,1
        call  cs:[bx+rit]

        mov   dx,3c4h
        mov   ax,802h
        out   dx,ax
        xor   bx,bx
        shr   ink,1
        rcl   bx,1
        shr   paper,1
        rcl   bx,1
        shl   bx,1
        call  cs:[bx+rit]
        pop   ds
        ret

comb1:  mov   al,0
        mov   es:[di+80*0],al
        mov   es:[di+80*1],al
        mov   es:[di+80*2],al
        mov   es:[di+80*3],al
        mov   es:[di+80*4],al
        mov   es:[di+80*5],al
        mov   es:[di+80*6],al
        mov   es:[di+80*7],al
        mov   es:[di+80*8],al
        mov   es:[di+80*9],al
        mov   es:[di+80*10],al
        mov   es:[di+80*11],al
        mov   es:[di+80*12],al
        mov   es:[di+80*13],al
        mov   es:[di+80*14],al
        mov   es:[di+80*15],al
        ret

comb4:  mov   al,255
        mov   es:[di+80*0],al
        mov   es:[di+80*1],al
        mov   es:[di+80*2],al
        mov   es:[di+80*3],al
        mov   es:[di+80*4],al
        mov   es:[di+80*5],al
        mov   es:[di+80*6],al
        mov   es:[di+80*7],al
        mov   es:[di+80*8],al
        mov   es:[di+80*9],al
        mov   es:[di+80*10],al
        mov   es:[di+80*11],al
        mov   es:[di+80*12],al
        mov   es:[di+80*13],al
        mov   es:[di+80*14],al
        mov   es:[di+80*15],al
        ret

comb3:  mov   al,[si+0]
        mov   es:[di+80*0],al
        mov   al,[si+1]
        mov   es:[di+80*1],al
        mov   al,[si+2]
        mov   es:[di+80*2],al
        mov   al,[si+3]
        mov   es:[di+80*3],al
        mov   al,[si+4]
        mov   es:[di+80*4],al
        mov   al,[si+5]
        mov   es:[di+80*5],al
        mov   al,[si+6]
        mov   es:[di+80*6],al
        mov   al,[si+7]
        mov   es:[di+80*7],al
        mov   al,[si+8]
        mov   es:[di+80*8],al
        mov   al,[si+9]
        mov   es:[di+80*9],al
        mov   al,[si+10]
        mov   es:[di+80*10],al
        mov   al,[si+11]
        mov   es:[di+80*11],al
        mov   al,[si+12]
        mov   es:[di+80*12],al
        mov   al,[si+13]
        mov   es:[di+80*13],al
        mov   al,[si+14]
        mov   es:[di+80*14],al
        mov   al,[si+15]
        mov   es:[di+80*15],al
        ret

comb2:  mov   al,[si+0]
        not   al
        mov   es:[di+80*0],al
        mov   al,[si+1]
        not   al
        mov   es:[di+80*1],al
        mov   al,[si+2]
        not   al
        mov   es:[di+80*2],al
        mov   al,[si+3]
        not   al
        mov   es:[di+80*3],al
        mov   al,[si+4]
        not   al
        mov   es:[di+80*4],al
        mov   al,[si+5]
        not   al
        mov   es:[di+80*5],al
        mov   al,[si+6]
        not   al
        mov   es:[di+80*6],al
        mov   al,[si+7]
        not   al
        mov   es:[di+80*7],al
        mov   al,[si+8]
        not   al
        mov   es:[di+80*8],al
        mov   al,[si+9]
        not   al
        mov   es:[di+80*9],al
        mov   al,[si+10]
        not   al
        mov   es:[di+80*10],al
        mov   al,[si+11]
        not   al
        mov   es:[di+80*11],al
        mov   al,[si+12]
        not   al
        mov   es:[di+80*12],al
        mov   al,[si+13]
        not   al
        mov   es:[di+80*13],al
        mov   al,[si+14]
        not   al
        mov   es:[di+80*14],al
        mov   al,[si+15]
        not   al
        mov   es:[di+80*15],al
        ret
  P8086
char_output   endp

stmp    dw 0
stmp2   dw 0

    setup       proc
   P386
        call  video_init2
        mov   si,offset setup_txt    ; 뢮  setupa
        mov   bx,3          ; y-न 
@@3:    mov   ax,26         ; x-न 
@@2:    mov   cl,[si]
        or    cl,cl
        je    @@1
        mov   ch,01000101b
        push  si
        push  ax
        push  bx
        call  char_output
        pop   bx
        pop   ax
        pop   si
        inc   si
        inc   ax
        jmp   short @@2
@@1:    inc   bx
        inc   si
        cmp   [si],byte ptr 0
        jne   @@3
        call  keysoff

@@19:   mov   ax,46                ;뢮 ਡ⮢
        mov   bx,10
        mov   ch,01000101b
        mov   cl,'-'
        cmp   mode,0
        je    @@11
        mov   cl,'+'
@@11:   call  char_output

        mov   ax,46
        mov   bx,11
        mov   ch,01000101b
        mov   cl,'-'
        cmp   sound,0
        je    @@12
        mov   cl,'+'
@@12:   call  char_output

        mov   ax,46
        mov   bx,13
        mov   ch,01000101b
        mov   cl,'-'
        cmp   sob,0
        je    @@14
        mov   cl,'+'
@@14:   call  char_output

        mov   ax,46
        mov   bx,15
        mov   ch,01000101b
        mov   cl,'-'
        cmp   speed,0
        je    @@15
        mov   cl,'+'
@@15:   call  char_output

        mov   ax,46
        mov   bx,12
        mov   ch,01000101b
        mov   cl,'-'
        cmp   delaypr,0
        je    @@16
        mov   cl,'+'
@@16:   call  char_output
        call  @@32
        jmp   @@10

@@32:   xor   cx,cx            ;뢮 祭 প
        mov   ax,delaysto
        mov   si,10
@@17:   xor   dx,dx
        div   si
        push  dx
        inc   cx
        or    ax,ax
        jne   @@17
        mov   stmp2,cx
        mov   stmp,46
@@18:   pop   cx
        mov   ch,01000101b
        add   cl,'0'
        mov   bx,14
        mov   ax,stmp
        call  char_output
        inc   stmp
        dec   stmp2
        jne   @@18
@@31:   cmp   stmp,52
        jae   @@33
        mov   ch,01000101b
        mov   cl,' '
        mov   bx,14
        mov   ax,stmp
        call  char_output
        inc   stmp
        jmp   short @@31
@@33:   ret


@@10:   mov   ah,7               ; 権,  믮 
        int   21h
        cmp   al,'1'
        jne   @@35
        jmp   @@9
@@35:   cmp   al,'3'
        jne   @@8
        jmp   exit
@@8:    cmp   al,'2'
        jne   @@20
        mov   r7,100000q
        jmp   @@9
@@20:   cmp   al,'4'
        jne   @@21
        dec   mode
        neg   mode
        jmp   @@19
@@21:   cmp   al,'5'
        jne   @@22
        dec   sound
        neg   sound
        jmp   @@19
@@22:   cmp   al,'6'
        jne   @@23
        dec   delaypr
        neg   delaypr
        je    @@28
        mov   ax,delaysto
        mov   delay,ax
        jmp   @@19
@@28:   mov   delay,1
        jmp   @@19
@@23:   cmp   al,'7'
        jne   @@24
        dec   sob
        neg   sob
        jmp   @@19
@@24:   cmp   al,'9'
        jne   @@25
        dec   speed
        neg   speed
        jmp   @@19
@@25:   cmp   al,'8'
        je    @@30
        jmp   @@10
@@30:   mov   delaysto,0
@@37:   call  @@32
@@34:   mov   ah,7
        int   21h
        cmp   al,13
        je    @@38
        cmp   al,8
        je    @@36
        cmp   al,'0'
        jb    @@37
        cmp   al,'9'
        ja    @@37
        cmp   delaysto,1000
        jae   @@37
        xor   ah,ah
        sub   al,'0'
        push  ax
        mov   ax,delaysto
        mov   bx,10
        mul   bx
        pop   bx
        add   ax,bx
        mov   delaysto,ax
        jmp   short @@37
@@36:   mov   ax,delaysto
        xor   dx,dx
        mov   bx,10
        div   bx
        mov   delaysto,ax
        jmp   short @@37
@@38:   cmp   delaysto,0
        jne   @@40
        mov   delaysto,1
@@40:   cmp   delaypr,0
        je    @@41
        mov   ax,delaysto
        mov   delay,ax
@@41:

@@9:    mov   ax,3            ;⪠  (᫨  몫稫)
@@29:   push  ax
        mov   bx,20
        mov   ch,0
        mov   cl,' '
        call  char_output
        pop   ax
        inc   ax
        cmp   ax,8
        jne   @@29
        call  video_init3      ; ࠭ (᫨  "梥⭮")
        cmp   mode,0
        jne   @@26
        call  bwmode
        jmp   short @@27
@@26:   call  colormode
@@27:   call  redraw
        mov   ax,bkseg
        mov   es,ax
        or     byte ptr es:[177716q],100q
        call  keyson
        ret
   P8086
    setup       endp

;******************* 砫 ணࠬ ******************

start:  mov   ax,dat
        mov   ds,ax
        mov   psp,es
        call  load_pzu
        call  load_cfg
        call  init
        call  video_init
        call  timeron
        call  keyson
next:   mov   ax,bkseg
        mov   es,ax
        mov   si,r7
        cmp   si,120000q
        jne   sc8
        call  command_line
sc8:    mov   dx,si
        and   si,177776q
        mov   bx,es:[si]
        mov   si,dx
        add   r7,2
        mov   di,bx
        xor   bl,bl
        mov   cl,7
        shr   bx,cl
        mov   cl,pswb
        mov   trace,cl
        call  commands[bx]
        call  extra_keys
        call  keyswork

        cmp   scou,0
        je    sc1
        dec   scou
sc1:    cmp   scou2,0
        je    sc6
        dec   scou2
sc6:
        test  trace,20q
        je    met3
        test  psw,20q
        je    met3
        call  bit_t
met3:
        dec   tcou
        jne   met4
        call  bktimer
met4:
        dec   tcou3
        jne   met2
        mov   tcou3,100
        call  scroll
        call  power

met2:   inc   command
        mov   cx,delay
met1:   loop  met1
        jmp   next

exit:   call  keysoff
        call  timeroff
        call  save_cfg
        mov   ax,3h
        int   10h
        mov   ah,2
        mov   dl,0dh
        int   21h
        mov   ah,2
        mov   dl,0ah
        int   21h
        mov   dx,offset text
        mov   ah,9
        int   21h
        mov   ah,2
        mov   dl,0dh
        int   21h
        mov   ah,2
        mov   dl,0ah
        int   21h
fireex: mov   ax,4c00h
        int   21h
   cod            ends

   adr            segment para
          db 32768 dup (0)
   adr            ends

   bkseg          segment para
        db    65535 dup (0)
   bkseg          ends
   end start
