; **************************************************************************
;
;        ASM module v1.0: *.PSG player for PSG.TPU (c) Vicious Fuck
;
; **************************************************************************
;
;
; 1. Starting/Stopping PSG Music
; ==============================
;
; Function  Start_PSG_Play (StartArea : pointer; AreaSize : longint) : WORD
;                          returns 0 if song playback initiated successfully
;                          returns 1 if playback initiation failed (music
;                           file may be corrupted, too short, or playback
;                           may be already started);
;
; Function  Stop_PSG_Play : word;
;                         always returns zero (success)
;
; 2. Detect Sound Card
; ====================
;
; Function  Adlib_Detect : word;
;                        returns 0 if Adlib card found (okay)
;                        returns 1 if no sound card found (failure)
;
; 3. Check PSG Music Playback Status
; ==================================
;
; Function  Check_Status : word;
;                       returns 0 if music is being played
;                       returns 1 if music is stopped (end of song reached)
;                       returns 2 if music playback not yet initiated
;                       returns 3 if music playback temporary paused
;
; Function  Get_Volume : word;
;                       returns a word describing current volume levels of
;                       PSG channels A, B and C:
;                       bit 3-0  Channel A volume (0=min, 15=max)
;                       bit 7-4  Channel B volume (0=min, 15=max)
;                       bit 11-8 Channel C volume (0=min, 15=max)
;
; 4. Playback Control
; ==================
;
; Procedure Enable_Loop;   Enable PSG melody looping
; Procedure Disalbe_Loop;  Disalbe PSG meolody looping (default)
; Function  Pause_Playback  : word;    { returns 0 if okay }
; Function  Resume_Playback : word;    { returns 0 if okay }
;
; ============================================================================


CODE		SEGMENT	BYTE PUBLIC
		ASSUME	DS:CODE, CS:CODE

                PUBLIC  ADLIB_DETECT, PAUSE_PLAYBACK, RESUME_PLAYBACK
                PUBLIC  START_PSG_PLAY, STOP_PSG_PLAY, CHECK_STATUS
                PUBLIC  ENABLE_LOOP, DISABLE_LOOP, GET_VOLUME

		LOCALS	@@

                INCLUDE         sblaster.inc 		; Adlib i/o
		.8086					; run even on XT hehe

; AY-3-8910 Emulator constants

                ch_a_volume     equ     43h             ; ch.A carrier volume
		ch_b_volume	equ	44h		; ch.B carrier volume
		ch_c_volume	equ	45h		; ch.C carrier volume
		snare_volume	equ	54h		; ch.8 used for noise
		ch_a_freq_lsb	equ	0A0h		; ch.A frequency LSB
		ch_a_freq_msb	equ	0B0h		; ch.A freq high bits/K
		ch_b_freq_lsb	equ	0A1h		; ch.B frequency LSB
		ch_b_freq_msb	equ	0B1h		; ch.B freq high bits/K
		ch_c_freq_lsb	equ	0A2h		; ch.C frequency LSB
		ch_c_freq_msb	equ	0B2h		; ch.C freq high bits/K
		psg_const	equ	61384


; -------------------------------- DATA ------------------------------------

INT70_HAND_OLD_OFS      DW      ?       ; RTC Intr (IRQ8) Previous Offset
INT70_HAND_OLD_SEG      DW      ?       ; RTC Intr (IRQ8) Previous Segment
RTC_TICK                DW      0       ; RTC Tick Counter
PORT_A1                 DB      ?
RTC_REG_0B              DB      ?
RTC_REG_0A              DB      ?
NEW_SPEED               DB      ?
LOW_WORD                DW      ?
HIGH_WORD               DW      ?
MUSIC_OFFSET            DW      ?
MUSIC_SEGMENT           DW      ?
MUSIC_DONE_FLAG         DB      2       ; 0 - play, 1 - stop, 2 - not started
MUSIC_STATUS_OLD        DB      ?
CURRENT_TIME            DW      ?	; Current delay word count
S_TIME                  DW      ?	; \
S_MUSIC_OFF             DW      ?	;  \
S_MUSIC_SEG             DW      ?	;   | Used for looped playback
S_LOW_WORD		DW	?	;  /
S_HIGH_WORD		DW	?	; /
LOOP_ENABLED            DB      0       ; 1 = LOOP ENABLE, 0 = LOOP DISABLE

VOLUME_A		DB	0
VOLUME_B		DB	0
VOLUME_C		DB	0
NOISE_MASK		DB	0	; 1 = CHANNEL VOICED
MELODIC_MASK		DB	0FFH	; 0 = CHANNEL VOICED

; -------------------------------- CODE ------------------------------------


; Returns: AX - volume levels of channels A,B,C:
;
; bits 3-0  Volume level of channel A (0-min, 15-max)
; bits 7-4  Volume level of channel B (0-min, 15-max)
; bits 8-11 Volume level of channel C (0-min, 15-max)
;
GET_VOLUME	PROC	FAR		; Public

		MOV	AL, BYTE PTR CS: [VOLUME_A]
		AND	AL, 0FH
		MOV	AH, BYTE PTR CS: [VOLUME_B]
		MOV	CL, 4
		SHL	AH, CL
		AND	AH, 0F0H
		OR	AL, AH
		MOV	AH, BYTE PTR CS: [VOLUME_C]
		AND	AH, 0FH

		MOV	BL, BYTE PTR CS: [NOISE_MASK]
		MOV	BH, BYTE PTR CS: [MELODIC_MASK]

; CHANNEL A TESTING

		TEST	BL, 1		; CHANNEL A NOISE IS ON?
		JNE	@@A_OKAY
		TEST	BH, 4		; CHANNEL A MELODIC IS ON?
		JE	@@A_OKAY
		AND	AX, 0FFF0H	; CHANNEL A SILENCED

; CHANNEL B TESTING

@@A_OKAY:	TEST	BL, 2		; CHANNEL B NOISE IS ON?
		JNE	@@B_OKAY
		TEST	BH, 2		; CHANNEL B MELODIC IS ON?
		JE	@@B_OKAY
		AND	AX, 0FF0FH	; CHANNEL B SILENCED

; CHANNEL C TESTING

@@B_OKAY:	TEST	BL, 4		; CHANNEL C NOISE IS ON?
		JNE	@@C_OKAY
		TEST	BH, 1		; CHANNEL C MELODIC IS ON?
		JE	@@C_OKAY
		AND	AX, 0F0FFH	; CHANNEL C SILENCED

@@C_OKAY:	RETF

GET_VOLUME	ENDP


ENABLE_LOOP     PROC    FAR             ; Public
                MOV     BYTE PTR CS: [LOOP_ENABLED], 1
                RETF
ENABLE_LOOP     ENDP


DISABLE_LOOP    PROC    FAR             ; Public
                MOV     BYTE PTR CS: [LOOP_ENABLED], 0
                RETF
DISABLE_LOOP    ENDP


CHECK_STATUS    PROC    FAR             ; Public
                MOV     AL, BYTE PTR CS: [MUSIC_DONE_FLAG]
                XOR     AH, AH
                RETF
CHECK_STATUS    ENDP


ADLIB_DETECT    PROC    FAR             ; Public
		PUSH	BP
		PUSH	DS

		PUSH	CS
		POP	DS
		CALL	DETECT_ADLIB
		JC	@@1
		CALL	INIT_ADLIB
		LEA	SI, PROPER_INIT
		CALL	SYNT_INIT
		CALL	PSG_INIT
                XOR     AX, AX
		JMP	SHORT @@2
@@1:            MOV     AX, 1

@@2:		POP	DS
		POP	BP
		RETF

ADLIB_DETECT	ENDP


; ----------------------- INT 70H HANDLER (IRQ8) -----------------------------

INT70_HAND	PROC	NEAR		; Main player loop
		CLI
                PUSH    AX BX CX DX SI DI BP DS 

		PUSH	CS
                POP	DS

                CMP     BYTE PTR CS: [MUSIC_DONE_FLAG], 0
                JNE     IRQ8_QUIT_NEAR

		INC	WORD PTR CS: [RTC_TICK]
                MOV     AX, WORD PTR CS: [CURRENT_TIME]
                CMP     WORD PTR CS: [RTC_TICK], AX
                JB      IRQ8_QUIT_NEAR

                MOV     SI, WORD PTR CS: [MUSIC_OFFSET]
                MOV     AX, WORD PTR CS: [MUSIC_SEGMENT]
                MOV     DS, AX
                
                MOV     AH, BYTE PTR DS:[SI]
                CALL    INCREMENT_PTR
                MOV     AL, BYTE PTR DS:[SI]
		CALL	INCREMENT_PTR

                MOV     BYTE PTR CS: [PSG_REGNUM], AH
                MOV     CL, AL
                CALL    WRITE_PSG

                MOV     AX, WORD PTR DS: [SI]
                CALL    INCREMENT_PTR
                CALL    INCREMENT_PTR
                MOV     WORD PTR CS: [CURRENT_TIME], AX
                MOV     WORD PTR CS: [RTC_TICK], 0

		MOV	WORD PTR CS: [MUSIC_OFFSET], SI
		MOV	WORD PTR CS: [MUSIC_SEGMENT], DS
		JMP	SHORT MORE_CODE

IRQ8_QUIT_NEAR: JMP	INT70_QUIT

MORE_CODE:      MOV     CX, 4
		CALL    CHECK_CX_TIMES
                JNC     INT70_QUIT

		CMP	BYTE PTR CS: [LOOP_ENABLED], 0
		JE	NO_MORE_MUSIC

		MOV	SI, WORD PTR CS: [S_MUSIC_OFF]
		MOV	WORD PTR CS: [MUSIC_OFFSET], SI
		MOV	AX, WORD PTR CS: [S_MUSIC_SEG]
		MOV	WORD PTR CS: [MUSIC_SEGMENT], AX
		MOV	AX, WORD PTR CS: [S_TIME]
		MOV	WORD PTR CS: [CURRENT_TIME], AX
		MOV	AX, WORD PTR CS: [S_LOW_WORD]
		MOV	WORD PTR CS: [LOW_WORD], AX
		MOV	AX, WORD PTR CS: [S_HIGH_WORD]
		MOV	WORD PTR CS: [HIGH_WORD], AX
		JMP	SHORT INT70_QUIT

NO_MORE_MUSIC:	MOV     BYTE PTR CS: [MUSIC_DONE_FLAG], 1 ; REACH END OF SONG

INT70_QUIT:     POP     DS BP DI SI DX CX BX AX
		STI

		PUSH	AX

INT70_4:        MOV	AL,0CH
		OUT	70H,AL
		IN	AL,71H
		TEST	AL,40H
		JNZ	INT70_4
		MOV	AL,20H
		OUT	0A0H,AL
		OUT	20H,AL
		POP	AX
		IRET

INT70_HAND      ENDP


SETUP_RTC       PROC    NEAR

		CLI
		IN	AL,0A1H
                MOV     BYTE PTR CS: [PORT_A1], AL
		AND	AL,0FEH
		OUT	0A1H,AL                 ; ENABLE IRQ8

		MOV	AL,0BH                  ; SET RTC ACTIVE
		OUT	70H,AL
		IN	AL,71H
                MOV     BYTE PTR CS: [RTC_REG_0B], AL
		AND	AL,7FH
		OR	AL,40H
		PUSH	AX
		MOV	AL,0BH
		OUT	70H,AL
		POP	AX
		OUT	71H,AL

		MOV	AL,0AH                  ; SET RTC FREQUENCY
		OUT	70H,AL
		IN	AL,71H
                MOV     BYTE PTR CS: [RTC_REG_0A], AL

		AND	AL,80H
		MOV	BL, BYTE PTR CS: [NEW_SPEED]
		OR	AL, BL
		PUSH	AX
		MOV	AL,0AH
		OUT	70H,AL
		POP	AX
		OUT	71H,AL

		STI

                RETN
SETUP_RTC       ENDP


RELEASE_RTC     PROC    NEAR

                CLI
                MOV     AL, BYTE PTR CS: [PORT_A1]
		OUT	0A1H,AL                 ; RESTORE PORT A1h

		MOV	AL,0BH
		OUT	70H,AL
		IN	AL,71H
                MOV     AL, BYTE PTR CS: [RTC_REG_0B]

		PUSH	AX
		MOV	AL,0BH
		OUT	70H,AL
		POP	AX
		OUT	71H,AL                  ; RESTORE PORT 70H/INDEX 0Bh

		MOV	AL,0AH
		OUT	70H,AL
		IN	AL,71H

                MOV     AL, BYTE PTR CS: [RTC_REG_0A]

		PUSH	AX
		MOV	AL,0AH
		OUT	70H,AL
		POP	AX
		OUT	71H,AL                  ; RESTORE PORT 70H/INDEX 0Ah
		STI

                RETN
RELEASE_RTC     ENDP


;-INCREMENT DS:SI-----------------
INCREMENT_PTR	PROC	NEAR
		INC	SI
		OR	SI, SI			; SI = 0?
		JNE	INC_OK
		PUSH	DI
		MOV	DI, DS
		ADD	DI, 1000H
		MOV	DS, DI			; POINT TO NEXT SEGMENT
		POP	DI
INC_OK:		RETN
INCREMENT_PTR	ENDP


;-ADD VALUE TO DS:SI--------------
;-CX = HOW MUCH
ADD_TOPTR	PROC	NEAR
AT_0:		CALL	INCREMENT_PTR
		LOOP	AT_0
		RETN
ADD_TOPTR	ENDP


;-CHECK IF END OF SONG IS REACHED----
CHECK_END	PROC	NEAR
		PUSH	AX
		PUSH	BX
		PUSH	DS

		PUSH	CS
		POP	DS
		MOV	AX, 1
		XOR	BX, BX
		CLC
		SUB	WORD PTR CS: [LOW_WORD], AX
		SBB	WORD PTR CS: [HIGH_WORD], BX
		MOV	AX, WORD PTR CS: [LOW_WORD]
		MOV	BX, WORD PTR CS: [HIGH_WORD]
		OR	AX, AX
		JNE	STILL_HERE
		OR	BX, BX
		JE	END_OF_SONG
STILL_HERE:	POP	DS
		POP	BX
		POP	AX
		CLC			; SET C=0 (OK)
		RETN

END_OF_SONG:	POP	DS
		POP	BX
		POP	AX
		STC			; SET C=1 (END REACHED)
		RETN
CHECK_END	ENDP


;-CHECK END OF SONG CX TIMES--------
CHECK_CX_TIMES	PROC	NEAR
CCT_0:		CALL	CHECK_END
		JC	END_FOUND
		LOOP	CCT_0
		CLC
END_FOUND:	RETN
CHECK_CX_TIMES	ENDP



; ----------------------- BEGIN OF THE MAIN CODE ------------------------------

START_PSG_PLAY  PROC    FAR                     ; Public
		PUSH	BP
		MOV	BP, SP
		PUSH	BP
		PUSH	DS

		CMP	BYTE PTR CS: [MUSIC_DONE_FLAG], 2
		JNE	QUIT_NEAR_2

		MOV	BYTE PTR CS: [VOLUME_A], 0
		MOV	BYTE PTR CS: [VOLUME_B], 0
		MOV	BYTE PTR CS: [VOLUME_C], 0
		MOV	BYTE PTR CS: [NOISE_MASK], 0
		MOV	BYTE PTR CS: [MELODIC_MASK], 0FFH
		JMP	SHORT GO_LDS

QUIT_NEAR_2:	JMP	QUIT_NEAR

GO_LDS:		LDS	SI, DWORD PTR SS:[BP+10]; DS:SI = DATA BEGIN

		MOV	AX ,WORD PTR SS:[BP+6]	; DATA LENGTH - LOW WORD
		MOV	BX, WORD PTR SS:[BP+8]	; DATA LENGTH - HIGH WORD
		MOV	WORD PTR CS:[LOW_WORD], AX
		MOV	WORD PTR CS:[HIGH_WORD], BX

                PUSH    DS
                PUSH    SI
                MOV     AX, 3570H
		INT	21H
                MOV     WORD PTR CS:[INT70_HAND_OLD_OFS], BX
                MOV     WORD PTR CS:[INT70_HAND_OLD_SEG], ES
                POP     SI
                POP     DS

		MOV	CX, 3
		CALL	ADD_TOPTR
		MOV	CX, 3
		CALL	CHECK_CX_TIMES
                JC      QUIT_NEAR

		MOV	AL, BYTE PTR DS: [SI]	; RTC_SPEED
		MOV	BYTE PTR CS: [NEW_SPEED], AL

		MOV	CX, 47
		CALL	ADD_TOPTR		; SKIP HDR & FIRST TIMING WORD
                MOV     CX, 47
                CALL    CHECK_CX_TIMES
                JC      QUIT_NEAR

                MOV     AH, BYTE PTR DS:[SI]
                CALL    INCREMENT_PTR
		MOV	AL, BYTE PTR DS:[SI]
		CALL	INCREMENT_PTR

                MOV     BYTE PTR CS: [PSG_REGNUM], AH
                MOV     CL, AL
                CALL    WRITE_PSG

                MOV     CX, 2
                CALL    CHECK_CX_TIMES
                JC      QUIT_NEAR
		JMP	SHORT HOOK_RTC

QUIT_NEAR:      JMP     QUIT

;-HOOK INT 70H-------------------
HOOK_RTC:       PUSH    DS
		PUSH	SI

                LEA     DX, INT70_HAND
		PUSH	CS
		POP	DS
                MOV     AX, 2570H
		INT	21H

		CLI
		POP	SI
		POP	DS
		XOR	AX, AX
		MOV	DX, 21H
		OUT	DX, AL

		MOV	BYTE PTR CS: [MUSIC_DONE_FLAG], 0
		MOV	AX, WORD PTR DS: [SI]
                CALL    INCREMENT_PTR
                CALL    INCREMENT_PTR

		MOV	WORD PTR CS: [MUSIC_OFFSET], SI
		MOV	WORD PTR CS: [MUSIC_SEGMENT], DS

                MOV     WORD PTR CS: [CURRENT_TIME], AX

		MOV	WORD PTR CS: [S_TIME], AX
		MOV	WORD PTR CS: [S_MUSIC_OFF], SI
		MOV	WORD PTR CS: [S_MUSIC_SEG], DS

                MOV     CX, 2
                CALL    CHECK_CX_TIMES
                JC      QUIT

		MOV	AX, WORD PTR CS: [LOW_WORD]
		MOV	WORD PTR CS: [S_LOW_WORD], AX
		MOV	AX, WORD PTR CS: [HIGH_WORD]
		MOV	WORD PTR CS: [S_HIGH_WORD], AX

                MOV     WORD PTR CS: [RTC_TICK], 0
                CALL    SETUP_RTC
		STI

                XOR     AX, AX                  ; OKAY

QUIT_MODULE:    POP     DS
		POP	BP
		MOV	SP, BP
		POP	BP
		RETF	8

QUIT:           MOV     AX, 1                   ; ERROR
                JMP     SHORT QUIT_MODULE

START_PSG_PLAY  ENDP


STOP_PSG_PLAY   PROC    FAR                     ; Public
		XOR	AX, AX
		CMP	BYTE PTR CS: [MUSIC_DONE_FLAG], 2
		JE	CANT_DO_IT

                PUSH    DS
                PUSH    BP

                PUSH    CS
                POP     DS
                MOV     AX, 2570H
                MOV     DX, WORD PTR CS: [INT70_HAND_OLD_OFS]
                MOV     BX, WORD PTR CS: [INT70_HAND_OLD_SEG]
		MOV	DS, BX
		INT	21H
                CALL    RELEASE_RTC
		CALL    INIT_ADLIB
                MOV     BYTE PTR CS: [MUSIC_DONE_FLAG], 2
		POP	BP
                POP     DS
                XOR     AX, AX
CANT_DO_IT:     RETF
STOP_PSG_PLAY   ENDP


PAUSE_PLAYBACK  PROC    FAR                                     ; Public
                MOV     AX, 1
                CMP     BYTE PTR CS: [MUSIC_DONE_FLAG], 2       ; NOT STARTED?
                JE      @@1
                CMP     BYTE PTR CS: [MUSIC_DONE_FLAG], 3       ; PAUSED?
                JE      @@1

                MOV     AL, BYTE PTR CS: [MUSIC_DONE_FLAG]
                MOV     BYTE PTR CS: [MUSIC_STATUS_OLD], AL

                PUSH    DS
                PUSH    BP

                PUSH    CS
                POP     DS
                MOV     AX, 2570H
                MOV     DX, WORD PTR CS: [INT70_HAND_OLD_OFS]
                MOV     BX, WORD PTR CS: [INT70_HAND_OLD_SEG]
		MOV	DS, BX
		INT	21H

                CALL    RELEASE_RTC
		CALL    INIT_ADLIB

                MOV     BYTE PTR CS: [MUSIC_DONE_FLAG], 3
		POP	BP
                POP     DS
                XOR     AX, AX

@@1:            RETF

PAUSE_PLAYBACK  ENDP


RESUME_PLAYBACK PROC    FAR                                     ; Public
                MOV     AX, 1
                CMP     BYTE PTR CS: [MUSIC_DONE_FLAG], 3       ; Paused?
                JNE     @@1

                PUSH    DS
                PUSH    BP

                MOV     AL, BYTE PTR CS: [MUSIC_STATUS_OLD]
                MOV     BYTE PTR CS: [MUSIC_DONE_FLAG], AL

                CALL    ADLIB_DETECT

                LEA     DX, INT70_HAND
		PUSH	CS
		POP	DS
                MOV     AX, 2570H
		INT	21H

                CALL    SETUP_RTC

		POP	BP
                POP     DS
                XOR     AX, AX

@@1:            RETF

RESUME_PLAYBACK ENDP

; ------------------------ AY-3-8910 EMULATOR MODULE ----------------------

                .386            ; 386+ required to use this emulator

;
; Write_PSG /near, private/
;
; On entry: CL               - data byte (not inverted)
;           cs: [PSG_RegNum] - register address (already inverted, 0-15d).
;

Write_PSG	proc	near
		pusha

                not     cl                              ; invert databyte
		mov	al, byte ptr cs: [PSG_RegNum]
		cmp	al, 11
		jae	@@1				; cannot handle 11+

		or	al, al
		je	@@flow_cha
		cmp	al, 1
		je	@@fhigh_cha
		cmp	al, 2
		je	@@flow_chb
		cmp	al, 3
		je	@@fhigh_chb
		cmp	al, 4
		je	@@flow_chc
		cmp	al, 5
		je	@@fhigh_chc

		cmp	al, 8				; volume for ch. A
		je	@@vol_ch_a
		cmp	al, 9
		je	@@vol_ch_b
		cmp	al, 10
		je	@@vol_ch_c

		cmp	al, 7
		je	@@mixer

                jmp     @@1


@@vol_ch_a:	mov	al, ch_a_volume			; Adlib Reg# (CH #0 vol)
		mov	ah, cl				; Data

		and	ah, 1Fh

		cmp	ah, 16
		jne	@@no_env_a
		mov	ah, 0Bh				; 0Ch = 1100

@@no_env_a:	mov	byte ptr cs: [volume_a], ah
		not	ah
		shl	ah, 2				; shl ah, 2
		and	ah, 00111100b
;		or	ah, 3
		mov	byte ptr cs: [adlib_a_vol], ah
		call	Wrt_Adlib
		jmp	@@1

@@vol_ch_b:	mov	al, ch_b_volume
		mov	ah, cl

		and	ah, 1Fh
		cmp	ah, 16
		jne	@@no_env_b
		mov	ah, 0Bh

@@no_env_b:	mov	byte ptr cs: [volume_b], ah
		not	ah
		shl	ah, 2
		and	ah, 00111100b
;		or	ah, 3
		mov	byte ptr cs: [adlib_b_vol], ah
		call	Wrt_Adlib
		jmp	@@1

@@vol_ch_c:	mov	al, ch_c_volume
		mov	ah, cl

		and	ah, 1Fh
		cmp	ah, 16
		jne	@@no_env_c
		mov	ah, 0Bh

@@no_env_c:	mov	byte ptr cs: [volume_c], ah
		not	ah
		shl	ah, 2
		and	ah, 00111100b
;		or	ah, 3
		mov	byte ptr cs: [adlib_c_vol], ah
		call	Wrt_Adlib
		jmp	@@1


@@fhigh_cha:    and	cl, 0Fh
		mov	byte ptr cs: [ch_a_freq+1], cl	; change MSB
		jmp	short @@freq_calc_a

@@flow_cha:     mov	byte ptr cs: [ch_a_freq], cl	; change LSB

@@freq_calc_a:  mov     ax, word ptr cs: [ch_a_freq]    ; get all word to BX

;               call    rdc_xlat                        ; convert to note/oct
		call	marat_xlat

                mov     byte ptr cs: [ch_a_flsb], al    ; store low byte

                mov     al, byte ptr cs: [ch_a_fmsb]
                and     al, 40o                         ; Clear all but bit#5
                or      ah, al
                mov     byte ptr cs: [ch_a_fmsb], ah    ; store high byte

                mov     al, ch_a_freq_lsb               ; ch A. LSB freq reg#
		mov	ah, byte ptr cs: [ch_a_flsb]
		call	Wrt_Adlib			; write LSB to Adlib

		mov	al, ch_a_freq_msb
		mov	ah, byte ptr cs: [ch_a_fmsb]
		call	Wrt_Adlib			; Write MSB to Adlib
		jmp	@@1


@@fhigh_chb:    and	cl, 0Fh
                mov     byte ptr cs: [ch_b_freq+1], cl  ; change MSB
                jmp     short @@freq_calc_b

@@flow_chb:     mov     byte ptr cs: [ch_b_freq], cl    ; change LSB

@@freq_calc_b:  mov     ax, word ptr cs: [ch_b_freq]    ; get all word to BX

;               call    rdc_xlat                        ; convert to note/oct
		call	marat_xlat

                mov     byte ptr cs: [ch_b_flsb], al    ; store low byte

                mov     al, byte ptr cs: [ch_b_fmsb]
                and     al, 40o                         ; Clear all but bit#5
                or      ah, al
                mov     byte ptr cs: [ch_b_fmsb], ah    ; store high byte

                mov     al, ch_b_freq_lsb               ; ch B. LSB freq reg#
                mov     ah, byte ptr cs: [ch_b_flsb]
		call	Wrt_Adlib			; write LSB to Adlib
                mov     al, ch_b_freq_msb
                mov     ah, byte ptr cs: [ch_b_fmsb]
		call	Wrt_Adlib			; Write MSB to Adlib
		jmp	@@1


@@fhigh_chc:    and	cl, 0Fh
                mov     byte ptr cs: [ch_c_freq+1], cl  ; change MSB
                jmp     short @@freq_calc_c

@@flow_chc:     mov     byte ptr cs: [ch_c_freq], cl    ; change LSB

@@freq_calc_c:  mov     ax, word ptr cs: [ch_c_freq]    ; get all word to BX

;               call    rdc_xlat                        ; convert to note/oct
		call	marat_xlat

                mov     byte ptr cs: [ch_c_flsb], al    ; store low byte

                mov     al, byte ptr cs: [ch_c_fmsb]
                and     al, 40o                         ; Clear all but bit#5
                or      ah, al
                mov     byte ptr cs: [ch_c_fmsb], ah    ; store high byte

                mov     al, ch_c_freq_lsb               ; ch C. LSB freq reg#
                mov     ah, byte ptr cs: [ch_c_flsb]
		call	Wrt_Adlib			; write LSB to Adlib
                mov     al, ch_c_freq_msb
                mov     ah, byte ptr cs: [ch_c_fmsb]
		call	Wrt_Adlib			; Write MSB to Adlib
		jmp	@@1

@@mixer:        mov	al, cl
		not	al

		shr	al, 3
		and	al, 7o

		mov	byte ptr cs: [noise_mask], al

		or	al, al				; noise is on?
		je	@@no_noise

		test	al, 4				; at ch.C ? (bit 5)
		jne	@@noise_c
		test	al, 2				; at ch.B ? (bit 4)
		jne	@@noise_b

@@noise_a:

;		test	cl, 4				; melodic ch.A is on?
;		je	@@no_noise
		mov	al, byte ptr cs: [adlib_a_vol]
		jmp	short @@noise_done

@@noise_c:

;		test	cl, 1				; melodic ch.C is on?
;		je	@@no_noise

		mov	al, byte ptr cs: [adlib_c_vol]
		jmp	short @@noise_done

@@noise_b:

;		test	cl, 2				; melodic ch.B is on?
;		je	@@no_noise

		mov	al, byte ptr cs: [adlib_b_vol]



@@noise_done:	mov	byte ptr cs: [noise_vol], al
		mov	al, 1
		jmp	short @@noise

@@no_noise:	xor	al, al
@@noise:	mov	byte ptr cs: [noise_enabled], al

		mov	byte ptr cs: [melodic_mask], cl

		test    cl, 4		                        ; check bit 2
		je	@@ch_a_on
@@ch_a_off:     and     byte ptr cs: [ch_a_fmsb], 11011111b     ; clr bit 5
                jmp     short @@ch_b_next
@@ch_a_on:      or      byte ptr cs: [ch_a_fmsb], 00100000b     ; set bit 5

@@ch_b_next:    test    cl, 2					; check bit 1
                je      @@ch_b_on
@@ch_b_off:     and     byte ptr cs: [ch_b_fmsb], 11011111b
                jmp     short @@ch_c_next
@@ch_b_on:      or      byte ptr cs: [ch_b_fmsb], 00100000b

@@ch_c_next:    test    cx, 1					; check bit 0
                je      @@ch_c_on
@@ch_c_off:     and     byte ptr cs: [ch_c_fmsb], 11011111b
                jmp     short @@ch_write
@@ch_c_on:      or      byte ptr cs: [ch_c_fmsb], 00100000b

@@ch_write:     call    psg_write_all

@@1:           
                popa
		retn
Write_PSG	endp


noise_enabled	db	0			; no noise
noise_vol	db	3fh			; minimum noise
psg_regnum	db	?
adlib_a_vol	db	3fh			; minimum volumes
adlib_b_vol	db	3fh
adlib_c_vol	db	3fh

ch_a_freq	dw	0310o			; decoded periods
ch_b_freq	dw	0310o			;, LSB - MSB
ch_c_freq	dw	0310o

ch_a_flsb	db	0			; send to A0
ch_a_fmsb	db	21o			; Octave=4,silence (send to B0)

ch_b_flsb	db	0			; send to A1
ch_b_fmsb	db	21o			; send to B1

ch_c_flsb	db	0			; send to A2
ch_c_fmsb	db	21o			; send to B2


psg_init	proc	near

		pusha

		xor	al, al
		mov	byte ptr cs: [noise_enabled], al

		mov	al, 3fh
		mov	byte ptr cs: [adlib_a_vol], al
		mov	byte ptr cs: [adlib_b_vol], al
		mov	byte ptr cs: [adlib_c_vol], al
		mov	byte ptr cs: [noise_vol], al

		mov	ax, 0310o
		mov	word ptr cs: [ch_a_freq], ax
		mov	word ptr cs: [ch_b_freq], ax
		mov	word ptr cs: [ch_c_freq], ax

		mov	al, 98h				; freq = 198h
                mov     ah, 21o				; silence

		mov	byte ptr cs: [ch_a_flsb], al
		mov	byte ptr cs: [ch_a_fmsb], ah
		mov	byte ptr cs: [ch_b_flsb], al
		mov	byte ptr cs: [ch_b_fmsb], ah
		mov	byte ptr cs: [ch_c_flsb], al
		mov	byte ptr cs: [ch_c_fmsb], ah

                call    psg_write_all
		popa
		clc
		retn
psg_init	endp



psg_write_all   proc    near

                mov     al, ch_a_freq_lsb               ; ch A. LSB freq reg#
		mov	ah, byte ptr cs: [ch_a_flsb]
		call	Wrt_Adlib			; write LSB to Adlib

		mov	al, ch_a_freq_msb
		mov	ah, byte ptr cs: [ch_a_fmsb]
		call	Wrt_Adlib			; Write MSB to Adlib

                mov     al, ch_b_freq_lsb               ; ch B. LSB freq reg#
                mov     ah, byte ptr cs: [ch_b_flsb]
		call	Wrt_Adlib			; write LSB to Adlib
                mov     al, ch_b_freq_msb
                mov     ah, byte ptr cs: [ch_b_fmsb]
		call	Wrt_Adlib			; Write MSB to Adlib

                mov     al, ch_c_freq_lsb               ; ch C. LSB freq reg#
                mov     ah, byte ptr cs: [ch_c_flsb]
		call	Wrt_Adlib			; write LSB to Adlib
                mov     al, ch_c_freq_msb
                mov     ah, byte ptr cs: [ch_c_fmsb]
		call	Wrt_Adlib			; Write MSB to Adlib

		cmp	byte ptr cs: [noise_enabled], 0
		je	@@1

		mov	ah, byte ptr cs: [noise_vol]
		cmp	ah, 1Fh
		jae	@@2

		mov	ah, 1Fh				; limit noise volume

@@2:		mov	al, snare_volume
		call	Wrt_Adlib

		xor	al,al
		mov	byte ptr cs: [noise_enabled], al

@@3:		retn

@@1:		mov	ah, 3fh				; minimum volume
		jmp	short @@2

psg_write_all   endp


                ay_table        label   near

dw     007370o,007020o,006540o,006200o,005730o,005450o,005210o,004760o
dw     004540o,004340o,004130o,003740o                 ; Octave 0 - lowest

dw     003574o,003410o,003260o,003100o,002754o,002624o,002504o,002370o
dw     002260o,002160o,002054o,001760o                 ; Octave 1

dw     001676o,001604o,001530o,001440o,001366o,001312o,001242o,001174o
dw     001130o,001070o,001026o,000770o                 ; Octave 2

dw     000737o,000702o,000654o,000620o,000573o,000545o,000521o,000476o
dw     000454o,000434o,000413o,000374o                 ; Octave 3

dw     000357o,000341o,000326o,000310o,000275o,000262o,000250o,000237o
dw     000226o,000216o,000205o,000176o                 ; Octave 4

dw     000167o,000160o,000153o,000144o,000136o,000131o,000124o,000117o
dw     000113o,000107o,000102o,000077o                 ; Octave 5

dw     000073o,000070o,000065o,000062o,000057o,000054o,000052o,000047o
dw     000045o,000043o,000041o,000037o                 ; Octave 6

dw     000035o,000034o,000032o,000031o,000027o,000026o,000025o,000023o
dw     000022o,000021o,000020o,000017o                 ; Octave 7 - highest


                adlib_table     label   near

                dw              16Bh            ; C#
                dw              181h            ; D
                dw              198h            ; D#
                dw              1B0h            ; E
                dw              1CAh            ; F
                dw              1E5h            ; F#
                dw              202h            ; G
                dw              220h            ; G#
                dw              241h            ; A
                dw              263h            ; A#
                dw              287h            ; B
                dw              2AEh            ; C

; On entry: BL - Octave # (0-7)
;           BH - Note # (0-11)
;
; Returns:  AL - LSB of Adlib freq
;           AH - MSB of ADlib freq (with octave)
;
make_bytes      proc    near
                mov     al, bh                  ; note#
                xor     ah, ah                  ; zero high byte
                shl     ax, 1                   ; AX := AX * 2
                lea     si, adlib_table
                add     si, ax                  ; calc offset in memory
                mov     ax, word ptr cs: [si]   ; get Adlib note freq

		shl	bl, 2
		and	bl, 00011100b
                or      ah, bl

                retn
make_bytes      endp


; Entry:   AX - BK AY freq (0-7777o)
;
; Returns: AL - LSB of Adlib freq
;          AH - MSB of Adlib freq (with octave)
;
marat_xlat	proc	near
		mov	bx, ax			; AY freq
		or	bx, bx
		je	@@1

		cmp	bx, 17
		jbe	@@6

		cmp	bx, 35
		jbe	@@5

		mov	ax, 0CACEh		; DX.AX := 2345678
		mov	dx, 00023h
		div	bx			; AX := DX.AX / BX
		jmp	short @@3

@@6:		mov	ax, 3ffh
		mov	bl, 7
		jmp	short @@2

@@1:		mov	ax, 1

@@3:		xor	bl, bl			; octave #
@@4:		cmp	ax, 400h
		jbe	@@2
		shr	ax, 1
		inc	bl
		jmp	short @@4

@@2:		and	ah, 3o
		and	bl, 7o
		shl	bl, 2
		or	ah, bl
		retn

; entry: bl = ay freq = 18..35
; out:   bl = 7 (octave), ax = proper adlib freq
;
@@5:		lea	si, hfreq_table

@@8:		cmp	bx, word ptr cs: [si]
		je	@@7
		add	si, 4
		jmp	short @@8
@@7:		add	si, 2
		mov	ax, word ptr cs: [si]
		mov	bl, 7
		xor	bh, bh
		jmp	short @@2

marat_xlat	endp


hfreq_table     label   near
		dw	18, 1018	; 18 dword values
		dw	19, 964
		dw	20, 916
		dw	21, 872
		dw	22, 832
		dw	23, 796
		dw	24, 763
		dw	25, 733
		dw	26, 704
		dw	27, 678
		dw	28, 654
		dw	29, 631
		dw	30, 610
		dw	31, 591
		dw	32, 572
		dw	33, 555
		dw	34, 538
		dw	35, 523


; On Entry:   AX - BK AY Freq (0-7777o)
;
;  Returns:   BL - Adlib Octave # (0-7)
;             BH - Adlib note # (0-11)              [phase 1]
;
;             AL - lsb of adlib freq
;             AH - msb of adlib freq with octave    [phase 2]
;
rdc_xlat        proc    near
                xor     bl, bl                  ; Octave # (0-7)
                lea     si, ay_table
@@3:            xor     bh, bh                  ; Adlib note # (0-11)

@@2:            cmp     ax, word ptr cs: [si]
                jae     @@1
                inc     bh
                add     si, 2
                cmp     bh, 12
                jne     @@2

                inc     bl
                cmp     bl, 8
                jne     @@3

                mov     bl, 7                   ; Highest octave
                mov     bh, 11                  ; note C

@@1:            call	make_bytes
		retn

rdc_xlat        endp


CODE		ENDS
		END
