
{                         *.PSG player version 1.0                          }
{      (c) Copyright 1995 by Alex Savelev / Digital Wizards Group           }


Program PSG_Player;
{$M 16384, 0, 420000}
uses Crt, Dos, PSG, VGA_Play;
label 1,2,3,4,5,6;
const    MaxParameters = 20;
         PauseStr : string [32] = 'PAUSED, Press any key to resume';
         hexchar : array [0..15] of char = ('0', '1', '2', '3',
                                            '4', '5', '6', '7',
                                            '8', '9', 'A', 'B',
                                            'C', 'D', 'E', 'F');
var Size          : longint;
    Address       : pointer;
    Param         : array [1..MaxParameters] of string;
    Title         : string;
    ch            : char;
    r             : registers;
    SingleMode    : boolean;
    track_number  : byte;

procedure PrintHexByte (value : byte; LeadingZeros : boolean);
var v1, v2 : byte;
begin
  v1 := (value shr 4) and ( not($f0) );
  v2 := value and not($fff0);
  if (LeadingZeros = false) and (v1 = 0) then write (hexchar[v2]) else
  write (hexchar[v1], hexchar[v2]);
end;


procedure PrintHexWord (value : word; LeadingZeros : boolean);
begin
  PrintHexByte ( Hi(value), LeadingZeros);
  PrintHexByte ( Lo(value), true);
end;


Procedure ShowHeap;
begin
  writeln;
  writeln ('PSG sound file player version 1.0, 11-Jul-96');
  writeln ('(c) Copyright VF;  Created  by Alex  Savelev');
  writeln;
end;


Procedure Help;
begin
  ShowHeap;
  writeln ('Usage: PLAYPSG filename.PSG');
  writeln;
  Halt (1);
end;


Procedure FileError;
begin
  ShowHeap;
  writeln ('Error #01 - Cannot handle file ', Param[1]);
  writeln;
  Stop_Psg_Play;
  halt (1);
end;


Procedure NotEnoughMemory;
begin
  ShowHeap;
  writeln ('Error #02 - Not enough memory to load file ', Param[1]);
  writeln;
  halt(1);
end;


Procedure WrongFormat;
begin
  ShowHeap;
  writeln ('Error #03 - Invalid or corrupted PSG, cannot play file ',Param[1]);
  writeln;
  halt (1);
end;


Procedure NoSoundCard;
begin
  ShowHeap;
  writeln ('Error #04 - Adlib/Sound Blaster hardware not detected');
  writeln;
  halt (1);
end;


Procedure ConvertToBig;
var i, j : integer;
    ts   : string;
begin
  for i := 1 to ParamCount do begin
    ts := ParamStr (i);
    for j := 1 to Length (ParamStr(i)) do begin
      if (byte (ts[j]) >= 97) and (byte (ts[j]) <= 122) then
      ts [j] := char ( byte(ts[j]) - 32);
    end;
    Param [i] := ts;
  end;
end;


Procedure CheckFormat (var SongName : string);
var tempo : string;
    i,j,k : word;
    Buf   : array [1..255] of byte;

begin
  i := Seg (Address^);
  j := Ofs (Address^);

  for k := 1 to 255 do
  begin
    Buf [k] := (Mem [i:j]);
    j := j + 1;
  end;

  if (Buf [1] <> byte('P')) or (Buf [2] <> byte('S')) then WrongFormat;
  tempo := '';
  for i := 7 to 48 do tempo := tempo + char(Buf[i]);
  SongName := tempo;
end;


Procedure WaitKey (Wchar : char);
begin
  ch := #00;
  while ch <> Wchar do ch := ReadKey;
  if ch = #00 then ch := ReadKey;
end;


Procedure CursorON;
begin
  with r do
    begin
      AH := 1;
      CH := 6;
      CL := 7;
    end;
  Intr ($10, r);
end;


Procedure CursorOff;
begin
  with r do
    begin
      AH := 1;
      CH := $20;
    end;
  Intr ($10, r);
end;


begin
  ClrScr;
  if (ParamCount = 0) or (ParamCount > MaxParameters) then Help;
  ConvertToBig;
  if (Param [1] = '/H') or (Param[1] = '/?') then Help;

  SingleMode := true;
  if ParamCount <> 1 then SingleMode := false;
  track_number := 1;

4:if Adlib_Detect <> 0 then NoSoundCard;
  case ReadFile (ParamStr(track_number),Address, Size) of
    1 : FileError;
    2 : NotEnoughMemory;
  end;
  CheckFormat (Title);

  if SingleMode = true then Enable_Loop else Disable_Loop;

  ch := #00;

  if Start_PSG_Play (Address, Size) = 0 then begin

2:  Vga_Play_Init_Screen (Param[1], Size, Copy(Title,1,40));

3:  if SingleMode = true then
    repeat DrawVolumeBars until KeyPressed else
    repeat DrawVolumeBars until (KeyPressed) or (Check_Status = 1);

    if (Check_Status = 1) and (SingleMode = false) then goto 5;

    ch := ReadKey; if ch = #00 then ch := ReadKey;

    if ch = #27 then goto 1;                            { esc }

    if (ch = 'p') or (ch = 'P') then begin
      Set_Cursor_Pos (4, 20);
      Put_String (PauseStr, 15);
      Pause_Playback;
      ch := ReadKey; if ch = #00 then ch := ReadKey;
      Resume_Playback;
      Set_Cursor_Pos (4,20);
      Put_String (PauseStr, 0);
    end;

    if (ch = 'd') or (ch = 'D') then begin              { dos-shell }
      TextMode (3);
      writeln ('Type EXIT at command prompt to return to PSG player!');
      Enable_Loop;
      SwapVectors;
      Exec (GetEnv('COMSPEC'),'');
      SwapVectors;
      if SingleMode = false then Disable_Loop;
    end;
    if (ch = 'd') or (ch = 'D') then goto 2 else goto 3;

  end else FileError;
  goto 1;

5:ShutDown;
  track_number := track_number + 1;
  if track_number > ParamCount then track_number := 1;
  goto 4;

1:ShutDown;
6:TextMode (3);
  ClrScr;

end.  { Main }
