
; SBLASTER.INC
;
;==============================================================================
; Init_Adlib	Initializates Adlib Sound Card                                =
; Wrt_Adlib     Writes data byte in AH to register # in AL (01h-F5h)          =
; Write_DSP     Writes command byte in AL to DSP                              =
; Read_DSP      Reads data byte from DSP to AL                                =
; Synt_Init     Initialize Adlib with desired values                          =
; Detect_Adlib	Detect presence of Adlib card. AX=0/BIT C is CLEAR is present =
; Detect_SB     Detect presence of SB card. AX=0000/BIT C is CLEAR if present =
; SB_Spkr       Speaker control. AL=1 : turn on; AL=0 turn off                =
; Wrt_2DAC      Write byte in AL to Sound Blaster DAC                         =
;==============================================================================
;

                LOCALS  @@

        SBPort  dw  220h                    ; Default SB base port

        SB_Start_Search_Port    equ 210h    ; Start search address
        SB_End_Search_Port      equ 280h    ; End search address

;Initializates Adlib Sound Card
;
Init_Adlib      proc  near
                mov    cx, 244
                mov    al, 1                   ; REG #
@@0:            xor    ah,ah                   ; Zero
                push   ax
                call   Wrt_Adlib
                pop    ax
                inc    al                      ; Next OPL register
                loop   @@0
                retn
Init_Adlib      endp


sbfm_init   label   near            ; Init string from SBFMDRV/SBMIDI
            dw  128                 ; Regs to setup

            db  1                   ; Reg#, Data
            db  0
            db  4
            db  96
            db  4
            db  128
            db  2
            db  255
            db  4
            db  33
            db  4
            db  96
            db  4
            db  128
            db  1
            db  32
            db  8
            db  0
            db  189
            db  192
            db  189
            db  192
            db  8
            db  0
            db  32
            db  1
            db  35
            db  17
            db  64
            db  79
            db  67
            db  0
            db  96
            db  241
            db  99
            db  242
            db  128
            db  83
            db  131
            db  116
            db  224
            db  0
            db  227
            db  0
            db  0
            db  8
            db  189
            db  192
            db  8
            db  0
            db  33
            db  1
            db  36
            db  17
            db  65
            db  79
            db  68
            db  0
            db  97
            db  241
            db  100
            db  242
            db  129
            db  83
            db  132
            db  116
            db  225
            db  0
            db  228
            db  0
            db  2
            db  8
            db  189
            db  192
            db  8
            db  0
            db  34
            db  1
            db  37
            db  17
            db  66
            db  79
            db  69
            db  0
            db  98
            db  241
            db  101
            db  242
            db  130
            db  83
            db  133
            db  116
            db  226
            db  0
            db  229
            db  0
            db  4
            db  8
            db  189
            db  192
            db  8
            db  0
            db  40
            db  1
            db  43
            db  17
            db  72
            db  79
            db  75
            db  0
            db  104
            db  241
            db  107
            db  242
            db  136
            db  83
            db  139
            db  116
            db  232
            db  0
            db  235
            db  0
            db  11
            db  8
            db  189
            db  192
            db  8
            db  0
            db  41
            db  1
            db  44
            db  17
            db  73
            db  79
            db  76
            db  0
            db  105
            db  241
            db  108
            db  242
            db  137
            db  83
            db  140
            db  116
            db  233
            db  0
            db  236
            db  0
            db  13
            db  8
            db  189
            db  192
            db  8
            db  0
            db  42
            db  1
            db  45
            db  17
            db  74
            db  79
            db  77
            db  0
            db  106
            db  241
            db  109
            db  242
            db  138
            db  83
            db  141
            db  116
            db  234
            db  0
            db  237
            db  0
            db  15
            db  8
            db  189
            db  192
            db  8
            db  0
            db  48
            db  1
            db  51
            db  17
            db  80
            db  79
            db  83
            db  0
            db  112
            db  241
            db  115
            db  242
            db  144
            db  83
            db  147
            db  116
            db  240
            db  0
            db  243
            db  0
            db  22
            db  8
            db  189
            db  192
            db  8
            db  0
            db  49
            db  1
            db  52
            db  17
            db  81
            db  79
            db  84
            db  0
            db  113
            db  241
            db  116
            db  242
            db  145
            db  83
            db  148
            db  116
            db  241
            db  0
            db  244
            db  0
            db  24
            db  8
            db  189
            db  192
            db  8
            db  0
            db  50
            db  1
            db  53
            db  17
            db  82
            db  79
            db  85
            db  0
            db  114
            db  241
            db  117
            db  242
            db  146
            db  83
            db  149
            db  116
            db  242
            db  0
            db  245
            db  0
            db  26
            db  8

z80_init    label   near	; Init string from Z80 Emulator
            dw      331     	; Regs to setup

        db 4                ; Reg#, Data
        db 96
        db 4
        db 128
        db 2
        db 255
        db 4
        db 33
        db 4
        db 0
        db 0
        db 0
        db 1
        db 0
        db 2
        db 0
        db 3
        db 0
        db 4
        db 0
        db 5
        db 0
        db 6
        db 0
        db 7
        db 0
        db 8
        db 0
        db 9
        db 0
        db 10
        db 0
        db 11
        db 0
        db 12
        db 0
        db 13
        db 0
        db 14
        db 0
        db 15
        db 0
        db 16
        db 0
        db 17
        db 0
        db 18
        db 0
        db 19
        db 0
        db 20
        db 0
        db 21
        db 0
        db 22
        db 0
        db 23
        db 0
        db 24
        db 0
        db 25
        db 0
        db 26
        db 0
        db 27
        db 0
        db 28
        db 0
        db 29
        db 0
        db 30
        db 0
        db 31
        db 0
        db 32
        db 0
        db 33
        db 0
        db 34
        db 0
        db 35
        db 0
        db 36
        db 0
        db 37
        db 0
        db 38
        db 0
        db 39
        db 0
        db 40
        db 0
        db 41
        db 0
        db 42
        db 0
        db 43
        db 0
        db 44
        db 0
        db 45
        db 0
        db 46
        db 0
        db 47
        db 0
        db 48
        db 0
        db 49
        db 0
        db 50
        db 0
        db 51
        db 0
        db 52
        db 0
        db 53
        db 0
        db 54
        db 0
        db 55
        db 0
        db 56
        db 0
        db 57
        db 0
        db 58
        db 0
        db 59
        db 0
        db 60
        db 0
        db 61
        db 0
        db 62
        db 0
        db 63
        db 0
        db 64
        db 0
        db 65
        db 0
        db 66
        db 0
        db 67
        db 0
        db 68
        db 0
        db 69
        db 0
        db 70
        db 0
        db 71
        db 0
        db 72
        db 0
        db 73
        db 0
        db 74
        db 0
        db 75
        db 0
        db 76
        db 0
        db 77
        db 0
        db 78
        db 0
        db 79
        db 0
        db 80
        db 0
        db 81
        db 0
        db 82
        db 0
        db 83
        db 0
        db 84
        db 0
        db 85
        db 0
        db 86
        db 0
        db 87
        db 0
        db 88
        db 0
        db 89
        db 0
        db 90
        db 0
        db 91
        db 0
        db 92
        db 0
        db 93
        db 0
        db 94
        db 0
        db 95
        db 0
        db 96
        db 0
        db 97
        db 0
        db 98
        db 0
        db 99
        db 0
        db 100
        db 0
        db 101
        db 0
        db 102
        db 0
        db 103
        db 0
        db 104
        db 0
        db 105
        db 0
        db 106
        db 0
        db 107
        db 0
        db 108
        db 0
        db 109
        db 0
        db 110
        db 0
        db 111
        db 0
        db 112
        db 0
        db 113
        db 0
        db 114
        db 0
        db 115
        db 0
        db 116
        db 0
        db 117
        db 0
        db 118
        db 0
        db 119
        db 0
        db 120
        db 0
        db 121
        db 0
        db 122
        db 0
        db 123
        db 0
        db 124
        db 0
        db 125
        db 0
        db 126
        db 0
        db 127
        db 0
        db 128
        db 0
        db 129
        db 0
        db 130
        db 0
        db 131
        db 0
        db 132
        db 0
        db 133
        db 0
        db 134
        db 0
        db 135
        db 0
        db 136
        db 0
        db 137
        db 0
        db 138
        db 0
        db 139
        db 0
        db 140
        db 0
        db 141
        db 0
        db 142
        db 0
        db 143
        db 0
        db 144
        db 0
        db 145
        db 0
        db 146
        db 0
        db 147
        db 0
        db 148
        db 0
        db 149
        db 0
        db 150
        db 0
        db 151
        db 0
        db 152
        db 0
        db 153
        db 0
        db 154
        db 0
        db 155
        db 0
        db 156
        db 0
        db 157
        db 0
        db 158
        db 0
        db 159
        db 0
        db 160
        db 0
        db 161
        db 0
        db 162
        db 0
        db 163
        db 0
        db 164
        db 0
        db 165
        db 0
        db 166
        db 0
        db 167
        db 0
        db 168
        db 0
        db 169
        db 0
        db 170
        db 0
        db 171
        db 0
        db 172
        db 0
        db 173
        db 0
        db 174
        db 0
        db 175
        db 0
        db 176
        db 0
        db 177
        db 0
        db 178
        db 0
        db 179
        db 0
        db 180
        db 0
        db 181
        db 0
        db 182
        db 0
        db 183
        db 0
        db 184
        db 0
        db 185
        db 0
        db 186
        db 0
        db 187
        db 0
        db 188
        db 0
        db 189
        db 0
        db 190
        db 0
        db 191
        db 0
        db 192
        db 0
        db 193
        db 0
        db 194
        db 0
        db 195
        db 0
        db 196
        db 0
        db 197
        db 0
        db 198
        db 0
        db 199
        db 0
        db 200
        db 0
        db 201
        db 0
        db 202
        db 0
        db 203
        db 0
        db 204
        db 0
        db 205
        db 0
        db 206
        db 0
        db 207
        db 0
        db 208
        db 0
        db 209
        db 0
        db 210
        db 0
        db 211
        db 0
        db 212
        db 0
        db 213
        db 0
        db 214
        db 0
        db 215
        db 0
        db 216
        db 0
        db 217
        db 0
        db 218
        db 0
        db 219
        db 0
        db 220
        db 0
        db 221
        db 0
        db 222
        db 0
        db 223
        db 0
        db 224
        db 0
        db 225
        db 0
        db 226
        db 0
        db 227
        db 0
        db 228
        db 0
        db 229
        db 0
        db 230
        db 0
        db 231
        db 0
        db 232
        db 0
        db 233
        db 0
        db 234
        db 0
        db 235
        db 0
        db 236
        db 0
        db 237
        db 0
        db 238
        db 0
        db 239
        db 0
        db 240
        db 0
        db 241
        db 0
        db 242
        db 0
        db 243
        db 0
        db 244
        db 0
        db 245
        db 0
        db 246
        db 0
        db 247
        db 0
        db 248
        db 0
        db 249
        db 0
        db 250
        db 0
        db 251
        db 0
        db 252
        db 0
        db 253
        db 0
        db 254
        db 0
        db 255
        db 0
        db 1
        db 32
        db 32
        db 33
        db 224
        db 1
        db 96
        db 255
        db 128
        db 15
        db 33
        db 33
        db 225
        db 1
        db 97
        db 255
        db 129
        db 15
        db 34
        db 33
        db 226
        db 1
        db 98
        db 255
        db 130
        db 15
        db 35
        db 33
        db 227
        db 1
        db 99
        db 255
        db 131
        db 15
        db 36
        db 33
        db 228
        db 1
        db 100
        db 255
        db 132
        db 15
        db 37
        db 33
        db 229
        db 1
        db 101
        db 255
        db 133
        db 15
        db 192
        db 0
        db 64
        db 16
        db 193
        db 0
        db 65
        db 16
        db 194
        db 0
        db 66
        db 16
        db 52
        db 33
        db 116
        db 240
        db 148
        db 15
        db 189
        db 40
        db 67
        db 63
        db 68
        db 63
        db 69
        db 63
        db 84
        db 63
        db 160
        db 240
        db 176
        db 63
        db 160
        db 240
        db 176
        db 63
        db 161
        db 240
        db 177
        db 63
        db 161
        db 240
        db 177
        db 63
        db 162
        db 240
        db 178
        db 63
        db 162
        db 240
        db 178
        db 63
        db 67
        db 63
        db 68
        db 63
        db 69
        db 63
        db 84
        db 63
        db 67
        db 63
        db 84
        db 63
        db 68
        db 63
        db 84
        db 63
        db 69
        db 63
        db 84
        db 63
        db 84
        db 63
        db 67
        db 63
        db 68
        db 63
        db 69
        db 63
        db 84
        db 63
        db 67
        db 63
        db 68
        db 63
        db 69
        db 63
        db 84
        db 63

proper_init	label	near		; Adlib init string from SB programing
					; guide databook
		dw	36		; Regs to setup

		db	20h, 01h	; Channel A, modulator (01)
		db	40h, 10h
		db	60h,0F0h
		db	80h, 77h

		db	23h, 01h	; Channel A, carrier
		db	43h, 00h
		db	63h,0F0h
		db	83h, 77h

		db	21h, 01h	; Channel B, modulator
		db	41h, 10h
		db	61h,0F0h
		db	81h, 77h

		db	24h, 01h	; Channel B, carrier
		db	44h, 00h
		db	64h,0F0h
		db	84h, 77h

		db	22h, 01h	; Channel C, modulator (OP1)
		db	42h, 10h
		db	62h,0F0h
		db	82h, 77h

		db	25h, 01h	; Channel C, carrier (OP2)
		db	45h, 00h
		db	65h,0F0h
		db	85h, 77h	; 24

		db	01h, 20h	; distortion enabled
		db	0e0h,01h	; dist. type for ch.a - c = 01
		db	0e1h,01h
		db	0e2h,01h
		db	0e3h,01h
		db	0e4h,01h
		db	0e5h,01h	; 31

		db	34h, 21h	; noise channel setup
		db	74h, 0F0h	; use channel 8 for noise (vol reg=54h)
		db	94h, 0Fh
		db	34h, 21h
		db	0bdh,28h	; Snare drum on	(36)

; 㧪 Adlib' 祭ﬨ.
; SI - pointer to init string (in the CS segment).
; First word - regs to setup (128, 331, etc)
;
Synt_Init       proc    near
                mov     cx, word ptr cs: [si]
                add	si, 2

@@0:            mov     al, byte ptr cs: [si]
                inc     si
                mov     ah, byte ptr cs: [si]
                inc     si
                call    Wrt_Adlib
                loop    @@0
                retn
Synt_init       endp


Wrt_Reg		proc	near
            	push    cx
		push    dx

		mov	dx, 388h        ; write to reg port
		out	dx, al

		push    ax          ; delay AFTER write
		mov	cx, 6
@@0:		in	al, dx
		loop    @@0
		pop	ax

		pop dx
		pop cx
		retn
Wrt_Reg		endp


Wrt_Data	proc	near
		push    cx
		push    dx

		mov	dx, 389h
		out	dx, al		; write to data port

		dec	dx		; 388
		push    ax
		mov	cx, 35
@@0:		in	al, dx		; delay AFTER write
		loop    @@0
		pop	ax

		pop	dx
		pop	cx
		retn
Wrt_Data	endp


;Write Adlib register #AL; Data byte in AH
;
Wrt_Adlib       proc	near

                push    dx		; save registers used
                push    cx
                push	ax		; save original value of AL/AH to stack

                mov	dx, 388h
                out	dx, al		; write reg# in AL to address port (388)

                mov	cx, 6		; delay after write
@@0:            in	al, dx
                loop	@@0

                pop	ax		; restore original value of AL/AH
                inc	dx		; = 389
                push    ax

                xchg    al, ah
                out	dx, al		; write data byte to data port (389)

                dec	dx		; =388
                mov     cx, 35
@@1:            in      al, dx		; delay AFTER write
                loop    @@1

                pop	ax
                pop	cx
                pop	dx
                retn
Wrt_Adlib       endp


;AL - DELAY VALUE (1 AL = 55 MILLISECONDS)
DELAY_MSEC      PROC    NEAR
                PUSH    AX
                MOV     AX, 3508H
                INT	21H
                MOV     WORD PTR CS:[OLD_08HAND_OFF], BX
                MOV     WORD PTR CS:[OLD_08HAND_SEG], ES
                LEA     DX, NEW_08HAND_OFF
                PUSH    CS
                POP	DS
                MOV	AX, 2508H
                INT	21H
                XOR     BX, BX
                MOV     BYTE PTR CS:[TICKER_MSEC], BL
                POP     AX
@@1:            MOV     BH, BYTE PTR CS:[TICKER_MSEC]
                CMP BH, AL
                JB      @@1
                MOV     AX, 2508H
                MOV	DX, WORD PTR CS:[OLD_08HAND_OFF]
                MOV	BX, WORD PTR CS:[OLD_08HAND_SEG]
                MOV	DS, BX
                INT	21H
                RETN
DELAY_MSEC      ENDP


NEW_08HAND_OFF  LABEL   WORD
                INC     BYTE PTR CS:[TICKER_MSEC]
                DB  0EAH
OLD_08HAND_OFF  DW      ?
OLD_08HAND_SEG  DW      ?
TICKER_MSEC     DB      ?

result1         DB      ?
result2         db  ?
                db  0

; Returns AX=0000h, BIT C is CLEAR if Adlib card present
; Returns AX=0001h, BIT C is SET if no sound card found

Detect_Adlib    proc near

                push    ds

                mov     ax, 6004h
                call    Wrt_Adlib
                mov     ax, 8004h
                call    Wrt_Adlib
                mov     dx, 0388h
                in      al, dx
                mov     byte ptr cs:[result1], al
                mov     ax, 0ff02h
                call    Wrt_Adlib
                mov     ax, 2104h
                call    Wrt_Adlib
                mov     al, 1           ; Delay for 55.000 microseconds :)
                call    DELAY_MSEC
                mov     dx, 388h
                in      al, dx
                mov     byte ptr cs:[result2], al
                mov     ax, 6004h
                call    Wrt_Adlib
                mov     ax, 8004h
                call    Wrt_Adlib
                mov     al, byte ptr cs:[result1]
                and     al, 0e0h
                or      al, al
                jne     @@0
                mov     al, byte ptr cs:[result2]
                and     al, 0e0h
                cmp     al, 0c0h
                jne     @@0

                xor     ax, ax
                pop ds
                clc
                retn

@@0:            mov     ax, 1
                pop ds
                stc
                retn

Detect_Adlib    endp


;Write command byte in AL to DSP
;
Write_DSP       proc   near
                cli
                mov       AH,AL                     ;Save AL
                mov       DX,word ptr cs: [SBPort]  ;Load DX with
                add       DL,0Ch                    ;[+C] address
@@0:            in        AL,DX                     ;Read status
                test      AL,80h                    ;Busy?
                jnz       @@0                       ;Wait until ready
                mov       AL,AH                     ;Restore AL
                out       DX,AL                     ;Write Command
                sti
                retn
Write_DSP       endp


;Read data byte from DSP to ->AL
;
Read_DSP    proc    near
            cli
@@1:        mov     dx, word ptr cs: [SBPort]
            add     dl, 0eh
@@0:        in      al, dx                  ;Read status
            test    al, 80h                 ;Ready?
            jz      @@0                     ;not yet...
            mov     dx, SBPort
            add     dl, 0ah                 ;Data port
            in      al, dx                  ;Read it!
            cmp     al, 0AAh
            je      @@1
            sti
            retn
Read_DSP    endp


; Detect SoundBlaster Card
; AX=0000h, bit C is CLEAR: SB found
; AX=0001h, bit C is SET: SB not found
;
Detect_SB    proc   near
             push   ds
             jmp    short @@InitSB_2

@@InitSBPrm:add       DL,0Ch     ;Load [+C]
            xor       CX,CX
@@loop39:   in        AL,DX
            test      AL,80h     ;Busy?
            jz        @@loc40    ;No, go on
            loop      @@loop39   ;Loop 10000h times
            xor       AL,AL      ;NO CARD
            jmp       @@loc46
@@loc40:    mov       AL,0D3h    ;Turn the speaker off
            out       DX,AL
            xor       CX,CX
@@loop41:   loop      @@loop41   ;Wait for a while
            sub       DL,6       ;Load [+6]
            mov       AL,1       ;Reset command 1/2
            out       DX,AL
            xor       CX,CX
@@loop42:   loop      @@loop42   ;Wait
            dec       AX
            out       DX,AL      ;Reset command 2/2
            add       DL,8       ;Load [+E]
            xor       CX,CX
@@loop43:   in        AL,DX
            test      AL,80h     ;Data Ready?
            jnz       @@loc44    ;Yes, go on
            loop      @@loop43   ;Loop 10000h times
            xor       AL,AL      ;NO CARD
            jmp       @@loc48
@@loc44:    sub       DL,4       ;Load [+A]
            xor       CX,CX
@@loop45:   in        AL,DX      ;Read Data
            cmp       AL,0AAh    ;Magic Number
            je        @@loc47    ;Ok, SB detected
            loop      @@loop45   ;Loop
            xor       AL,AL      ;NO CARD
@@loc46:    jmp       @@loc48
@@loc47:    mov       AL,1
@@loc48:    retn


@@InitSB_2: mov       DX, SB_Start_Search_Port   ;Start from 210h
@@Lab0:     push      DX
            call      @@InitSBPrm
            pop       DX
            or        AL,AL                     ;Found an SB?
            jnz       @@Lab1                    ;Yes, jump there
            cmp       DX,SB_End_Search_Port     ;Check range
            jae       @@Lab2                    ;Too high - no SB
            add       DX,10h                    ;Next attempt
            jmp       @@Lab0

@@Lab1:     mov       word ptr cs: [SBPort],DX  ;Store address
            add       DL,6                      ;Load [+6]
            mov       AL,1                      ;Reset...
            out       DX,AL
            in        AL,DX
            xor       AL,AL
            out       DX,AL                     ;...Reset
            add       DL,6                      ;Load [+C] if you need

            xor       ax, ax
            pop       ds
            clc                                 ;Flag: 'SB FOUND'
            retn

@@Lab2:     mov     ax, 1                       ;Flag: 'SB NOT FOUND'
            pop     ds
            stc
            retn

Detect_SB   endp


;    SB SPEAKER CONTROL.  Sound Blaster uses commands 0D1h and
;0D3h to switch its output channel  on  and  off.  The  following
;routine may be used to control the speaker
;
;Entry: AL=1 turn speaker on
;       AL=0 turn speker off

SB_Spkr  proc   near
	 or	   al, al
	 je	   @@1
	 mov	   al, 0D1h
	 jmp	   short @@2

@@1:	 mov	   al, 0D3h

@@2:     call      Write_DSP  ;Write command (see above)
         retn
SB_Spkr  endp


;    8-BIT  INPUT/OUTPUT  IN NON-DMA MODE.  To write a byte to
;the SB's DAC,  a command 10h followed by the byte itself must be
;issued. The following fragment writes a byte from AL:

Wrt_2DAC    proc      near
            mov       BH,AL      ;Save byte
            mov       AL,10h     ;CMD=OUTPUT
            call      Write_DSP  ;Write it
            mov       AL,BH      ;Get data byte
            call      Write_DSP  ;Write it
            retn
Wrt_2DAC    endp

